package Error;
use strict;
use Labels;

# static
# CREATE A [info/warning/error] object
# object can be serialized to string or html

# print Error->new('t3.101')->toHtml();
# print Error->error('t3.101')->toHtml();
#

sub base {'ERRORS'}

sub new {
  my($class, $errcode, $sev, @args) = @_;
  return $class->new_($errcode, $sev, @args);
}

sub info {
  my($class, $errcode, @args) = @_;
  return $class->new_($errcode, 0, @args);
}

sub warning {
  my($class, $errcode, @args) = @_;
  return $class->new_($errcode, 1, @args);
}

sub error {
  my($class, $errcode, @args) = @_;
  return $class->new_($errcode, 2, @args);
}


sub new_ {
  my($class, $errcode, $sev, @args) = @_;

  my $err = {code => $errcode, sev => $sev, args => \@args};
  bless $err, $class;
  return $err;
}

sub serialize {
  my($obj) = @_;
  require Data::Dumper;
  $Data::Dumper::Indent = 0;
  my $V = Data::Dumper::Dumper($obj);
  my $ix = index($V, "{");
  my $ix2 = index($V, "}");
  return substr($V, $ix, $ix2-$ix+1);
}

sub readLabels {
  my($class, $code) = @_;
  my $file;
  my $base = $class->base();
  return Labels->read($base);

}
 

  

# dynamic

sub toString {
  my($info) = @_;
  my $L = Error->readLabels();
  my $code = $info->{code};
  my $pre;
  my $G = Labels->read();

  if ($info->{sev} == 1) {
    $pre = "$G->{warning}: ";
  } elsif ($info->{sev} == 2) {
    $pre = "$G->{error}: ";
  }
  my $args = $info->{args};
  my $s;
  if (exists $L->{$code}) {
    $s = $L->expand($code, @$args);
  } else {
    $s = "Error $code not found!";
  }
  return "$pre$s";
}

sub toHtml {
  my($info) = @_;
  require Html;

  my $code = $info->{code};
  my $L = Error->readLabels();

  my ($s, $color);
  my $args = $info->{args};
  if (exists $L->{$code}) {
    $s = $L->expand($code, @$args);
  } else {
    $s = "Error $code not found!";
  }
  return Html->error($s, $info->{sev});
}

1;

