/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.AdminUserWizard;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdminUserHomeDirStep
extends VWizardCard {
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private AdminUserWizard wiz;
    private ISOLatinField serverField;
    private ISOLatinField pathnameField;
    private JLabel serverLabel;
    private GenInfoPanel infoPanel;
    private UMgrContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 3;

    public AdminUserHomeDirStep(VUserMgr vUserMgr, AdminUserWizard adminUserWizard) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.wiz = adminUserWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_homedir"));
        this.constructStep();
    }

    public void constructStep() {
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "au_wiz_home_dir");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        jLabel = new JLabel();
        this.setUpLabel(jLabel, "au_wiz_user_server");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)30, (int)0, (int)0);
        if (this.wiz.isLocalScope()) {
            this.serverLabel = new JLabel(this.wiz.getMailServer());
            this.serverLabel.setForeground(Color.black);
            this.serverLabel.setMinimumSize(this.serverLabel.getPreferredSize());
            Constraints.constrain((Container)((Object)this), (Component)this.serverLabel, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)5, (int)0, (int)0);
        } else {
            this.serverField = new ISOLatinField(-1, "", 15);
            this.serverField.setMinimumSize(this.serverField.getPreferredSize());
            jLabel.setLabelFor((Component)this.serverField);
            Constraints.constrain((Container)((Object)this), (Component)this.serverField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)5, (int)0, (int)0);
        }
        jLabel = new JLabel();
        this.setUpLabel(jLabel, "au_wiz_user_pathname");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)30, (int)0, (int)0);
        this.pathnameField = new ISOLatinField(-1, this.wiz.getPathname(), 15);
        this.pathnameField.setMinimumSize(this.pathnameField.getPreferredSize());
        jLabel.setLabelFor((Component)this.pathnameField);
        Constraints.constrain((Container)((Object)this), (Component)this.pathnameField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)5, (int)5, (int)0, (int)0);
        if (this.wiz.isLocalScope()) {
            this.pathnameField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    AdminUserHomeDirStep.this.updateStatus(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        } else {
            this.serverField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    AdminUserHomeDirStep.this.updateStatus(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        }
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.pathnameField.setText(this.wiz.getPathname());
        if (this.wiz.isLocalScope()) {
            this.serverLabel.setText(this.wiz.getMailServer());
        } else {
            this.serverField.setText(this.wiz.getServer());
        }
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), false);
    }

    public boolean stop(boolean bl) {
        if (bl) {
            if (!this.wiz.isLocalScope() && !CheckSyntax.isHomeDirServerOK((String)this.serverField.getText())) {
                String string = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
                return false;
            }
            if (!CheckSyntax.isHomeDirPathnameOK((String)this.pathnameField.getText())) {
                String string = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
                return false;
            }
        }
        this.wiz.setPathname(this.pathnameField.getText());
        if (this.wiz.isLocalScope()) {
            this.wiz.setServer(this.serverLabel.getText());
        } else {
            this.wiz.setServer(this.serverField.getText());
        }
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    public void loadHelp() {
        Vector vector = new Vector(3);
        this.infoPanel = this.wiz.getInfoPanel();
        this.pathnameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_homedir_path")));
        if (!this.wiz.isLocalScope()) {
            this.serverField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_server")));
        }
        this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_homedir_step");
        ContextHelpListener.loadHelp(vector);
    }

    public String getDescription() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_homedir");
    }

    private void updateStatus(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() != 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    private void setUpLabel(JLabel jLabel, String string) {
        ActionString actionString = new ActionString(this.bundle, string);
        jLabel.setText(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
    }
}

