/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.AdminUserWizard;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdminUserGroupStep
extends VWizardCard {
    VUserMgr theApp;
    ResourceBundle bundle;
    private AdminUserWizard wiz;
    private ServiceWrapper userMgrClient;
    private boolean offerPrimaryGroupChoice = true;
    private JComboBox groupCombo;
    private GenInfoPanel infoPanel;
    private UMgrContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 2;

    public AdminUserGroupStep(VUserMgr vUserMgr, AdminUserWizard adminUserWizard) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.wiz = adminUserWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_group"));
        this.userMgrClient = vUserMgr.getUserMgr();
        this.constructStep();
    }

    public void constructStep() {
        Vector vector = null;
        try {
            vector = this.userMgrClient.getAllGroups();
        }
        catch (AdminException adminException) {
            this.offerPrimaryGroupChoice = false;
        }
        if (vector == null) {
            this.offerPrimaryGroupChoice = false;
        }
        if (this.offerPrimaryGroupChoice) {
            this.createGUIWithChoice(vector);
        } else {
            this.createGUIWithNoChoice();
        }
    }

    private void createGUIWithChoice(Vector vector) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "au_wiz_user_group");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)29, (int)12, (int)0, (int)0);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            GroupObj groupObj = (GroupObj)vector.elementAt(n);
            stringArray[n] = new String(groupObj.getGroupName());
            ++n;
        }
        Sort.sort((String[])stringArray);
        this.groupCombo = new JComboBox<String>(stringArray);
        this.groupCombo.setSelectedItem("staff");
        jLabel.setLabelFor(this.groupCombo);
        Constraints.constrain((Container)((Object)this), (Component)this.groupCombo, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
    }

    private void createGUIWithNoChoice() {
        this.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_user_group_no_groups"));
        Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (int)29, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), false);
    }

    public boolean stop(boolean bl) {
        if (this.offerPrimaryGroupChoice) {
            this.wiz.setGroup((String)this.groupCombo.getSelectedItem());
        } else {
            this.wiz.setGroup("10");
        }
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        if (this.offerPrimaryGroupChoice) {
            UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_group_primary");
            this.theApp.addHelpListener(this.groupCombo, uMgrContextHelpListener);
            this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_group_step");
        } else {
            this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_wiz_group_step_no_groups");
        }
        ContextHelpListener.loadHelp(vector);
    }

    private void setUpLabel(JLabel jLabel, String string) {
        ActionString actionString = new ActionString(this.bundle, string);
        jLabel.setText(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
    }
}

