/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli.mail;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrCliArgParsingException;
import com.sun.admin.usermgr.common.UserMgrCliHelpException;
import com.sun.admin.usermgr.common.cli.UMgrCliTool;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserMgrMailCli
extends UMgrCliTool {
    private Vector vObjs = new Vector();
    private boolean bListAll = false;
    private String strOldAliasName = "";
    private CommandLineOption coAliasName;
    private CommandLineOption coAliasExpansion;
    private CommandLineOption coComment;
    private CommandLineOption coTaskFile;
    private CommandLineOption coNewName;
    private CommandLineOption coHelp;
    ResourceBundle bundle = null;

    public UserMgrMailCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.usermgr.cli.mail.resources.Resources", ((Object)((Object)this)).getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.usermgr.cli.mail.resources.Resources", Locale.getDefault(), ((Object)((Object)this)).getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray2 = new String[]{};
        int n = 0;
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            return 0;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            String string = userMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (UserException userException) {
            this.trace("runCommandLine, UserException:  " + userException.getLocalizedMessage());
            this.handleErrors(userException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        boolean bl = false;
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block7: {
            EmailAliasObj emailAliasObj = new EmailAliasObj();
            String string = "";
            CommandParser commandParser = new CommandParser("UserMgrMailCli", "main tool for users related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string2 = (String)this.coTaskFile.getValue();
                        this.trace("Task = " + string2);
                        this.setTaskOperation(string2.charAt(0));
                    }
                    if (this.coHelp.wasSet()) {
                        // empty if block
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new UserException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block7;
                throwable.printStackTrace();
            }
        }
    }

    private void checkForViewOptions(String[] stringArray) throws Exception {
        EmailAliasObj emailAliasObj = new EmailAliasObj();
        boolean bl = false;
        String string = "";
        if (this.getDebugStatus()) {
            this.trace("parseMailArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandLineOption commandLineOption = new CommandLineOption("alias_name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_aliasname_desc"), "n", 1, true, true, null, true);
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmaills_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"admaliasls_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    stringArray2 = (String[])commandLineOption.getValue();
                    this.trace("aliasname :  " + (String)stringArray2);
                    emailAliasObj.setAliasName((String)stringArray2);
                    bl = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            if (bl) {
                this.vObjs.addElement(emailAliasObj);
            } else if (this.getOperation() == 3) {
                this.bListAll = true;
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        EmailAliasObj emailAliasObj = new EmailAliasObj();
        String string = "";
        if (this.getDebugStatus()) {
            this.trace("parseMailArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmaildel_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"admaliasdel_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coAliasName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coAliasName.wasSet()) {
                    stringArray2 = (String[])this.coAliasName.getValue();
                    this.trace("aliasname :  " + (String)stringArray2);
                    emailAliasObj.setAliasName((String)stringArray2);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(emailAliasObj);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        EmailAliasObj emailAliasObj = new EmailAliasObj();
        String string = "";
        if (this.getDebugStatus()) {
            this.trace("parseMailArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmailadd_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"admaliasadd_desc"), true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coAliasName);
            commandParser.addOption((CommandOption)this.coAliasExpansion);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coAliasName.wasSet()) {
                    stringArray2 = (String)this.coAliasName.getValue();
                    this.trace("aliasname :  " + (String)stringArray2);
                    emailAliasObj.setAliasName((String)stringArray2);
                }
                if (this.coAliasExpansion.wasSet()) {
                    stringArray2 = this.coAliasExpansion.getValues();
                    String string2 = null;
                    this.trace("strAliasExpansion = " + (String)stringArray2.elementAt(0));
                    Enumeration enumeration = stringArray2.elements();
                    while (enumeration.hasMoreElements()) {
                        string2 = string2 == null ? (String)enumeration.nextElement() : string2 + (String)enumeration.nextElement();
                        if (!enumeration.hasMoreElements()) continue;
                        string2 = string2 + ", ";
                    }
                    this.trace("setting:  " + string2);
                    emailAliasObj.setAliasExpansion(string2);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            this.vObjs.addElement(emailAliasObj);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        EmailAliasObj emailAliasObj = new EmailAliasObj();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.getDebugStatus()) {
            this.trace("parseMailArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandParser commandParser = new CommandParser(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smmailmod_name"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"admaliasmod_desc"), true, null, null);
        try {
            int n;
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coAliasName);
            commandParser.addOption((CommandOption)this.coAliasExpansion);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coNewName);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coAliasName.wasSet()) {
                    string2 = (String)this.coAliasName.getValue();
                    this.setOldAliasName(string2);
                    this.trace("aliasname :  " + string2);
                }
                if (this.coAliasExpansion.wasSet()) {
                    stringArray2 = this.coAliasExpansion.getValues();
                    string3 = (String)stringArray2.elementAt(0);
                    this.trace("strAliasExpansion = " + string3);
                    n = 1;
                    while (n < stringArray2.size()) {
                        string3 = string3 + "," + stringArray2.elementAt(n);
                        ++n;
                    }
                }
                if (this.coNewName.wasSet()) {
                    string = (String)this.coNewName.getValue();
                    this.trace("Old Name = " + string);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed.");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        try {
            emailAliasObj = this.getObjectProps(string2);
        }
        catch (Exception exception) {
            this.trace("Got Except. getting obj props in checkForModifyOptions: \n" + exception.getLocalizedMessage());
            throw exception;
        }
        if (string != null) {
            emailAliasObj.setAliasName(string);
        }
        if (string3 != null) {
            emailAliasObj.setAliasExpansion(string3);
        }
        this.vObjs.addElement(emailAliasObj);
    }

    public void deleteObject() throws Exception {
        this.trace("in UserMgrMailCli->deleteObject()");
        try {
            this.trace("vObjs.size() = " + this.vObjs.size());
            Enumeration enumeration = this.vObjs.elements();
            while (enumeration.hasMoreElements()) {
                EmailAliasObj emailAliasObj = (EmailAliasObj)enumeration.nextElement();
                if (this.getUserMgr() == null) {
                    this.trace("usermgr is null!");
                    throw new UserException("EXM_CLI_NO_SERVICE");
                }
                this.trace("calling getUserMgr().deleteEmailAlias()");
                this.getUserMgr().deleteEmailAlias(emailAliasObj);
            }
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void addObject() throws Exception {
        try {
            EmailAliasObj emailAliasObj = (EmailAliasObj)this.vObjs.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in addObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.trace("in addObject:  calling getUserMgr().addEmailAlias()");
            this.getUserMgr().addEmailAlias(emailAliasObj);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void modifyObject() throws Exception {
        try {
            this.trace("in modifyObject()");
            EmailAliasObj emailAliasObj = (EmailAliasObj)this.vObjs.elementAt(0);
            String string = this.getOldAliasName();
            EmailAliasObj emailAliasObj2 = new EmailAliasObj(string);
            this.trace("old aliasname:  " + emailAliasObj2.getAliasName());
            this.trace("old expansion:  " + emailAliasObj2.getAliasExpansion());
            this.trace("new aliasname:  " + emailAliasObj.getAliasName());
            this.trace("new expansion:  " + emailAliasObj.getAliasExpansion());
            if (this.getUserMgr() == null) {
                this.trace("in modifyObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.trace("calling getUserMgr().modifyEmailAlias()");
            this.getUserMgr().modifyEmailAlias(emailAliasObj, emailAliasObj2);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewObjectProps() throws Exception {
        EmailAliasObj emailAliasObj = null;
        try {
            if (this.getUserMgr() == null) {
                this.trace("in viewObjectProps:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            if (this.bListAll) {
                this.trace("in viewObjectProps:  calling getAllEmailAliases()");
                this.vObjs = this.getUserMgr().getAllEmailAliases();
                if (this.vObjs == null || this.vObjs.isEmpty()) {
                    this.trace("There are no mailing lists");
                    String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"no_mailing_lists");
                    System.out.println(string);
                    return;
                }
                Enumeration enumeration = this.vObjs.elements();
                while (enumeration.hasMoreElements()) {
                    emailAliasObj = (EmailAliasObj)enumeration.nextElement();
                    this.viewUserOutput(emailAliasObj);
                }
            } else if (this.vObjs != null) {
                this.trace("in viewObjectProps:  calling getEmailAliasAttributes()");
                emailAliasObj = (EmailAliasObj)this.vObjs.elementAt(0);
                emailAliasObj = this.getUserMgr().getEmailAliasAttributes(emailAliasObj);
                this.viewUserOutput(emailAliasObj);
            }
        }
        catch (Exception exception) {
            this.trace("exception in viewObjectProps(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewUserOutput(EmailAliasObj emailAliasObj) {
        System.out.println(emailAliasObj.getAliasName() + " : " + emailAliasObj.getAliasExpansion());
        System.out.println("");
    }

    public void setOldAliasName(String string) {
        this.strOldAliasName = string;
    }

    public String getOldAliasName() {
        return this.strOldAliasName;
    }

    public boolean isNameSpecialCase(String string) {
        return string.equals("Postmaster") || string.equals("MAILER-DAEMON");
    }

    private EmailAliasObj getObjectProps(String string) throws Exception {
        EmailAliasObj emailAliasObj = new EmailAliasObj(string);
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr svc wrapper` is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            emailAliasObj = this.getUserMgr().getEmailAliasAttributes(emailAliasObj);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return emailAliasObj;
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, false, false, (Object)"V", true, true);
        this.coAliasName = new CommandLineOption("alias_name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_aliasname_desc"), "n", 1, false, false, null, true);
        this.coAliasExpansion = new CommandLineOption("address", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_address_desc"), "a", 1, true, true, (Object)"", true);
        this.coNewName = new CommandLineOption("new_alias_name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_oldname_desc"), "N", 1, true, false, null, true);
        this.coHelp = new CommandLineOption("help", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }
}

