/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.JListEditor;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.RightsPanel;
import com.sun.admin.usermgr.client.rbac.RoleContent;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.Permissions;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizard;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class AddRoleWizard
extends VWizard {
    private ServiceWrapper userMgrClient;
    private String description = "";
    private String userName = "";
    private String fullName = "";
    private String uid = "";
    private String shell = "";
    private String shellString = "";
    private String password1 = "";
    private String password2 = "";
    private String group = "";
    private String server = "";
    private String mailServer = "";
    private String pathname = SolHomedirAttr.DEFAULT_HOME_DIRECTORY_PREFIX;
    private Vector roleMembersVector;
    private Vector assignedProfsVector;
    private boolean automountHomeDir = true;
    private boolean isLocalScope = false;
    private boolean createMailAlias = true;
    private GenInfoPanel infoPanel;
    private Vector helpCache;
    protected boolean userCancel = false;
    public AddRoleWizard wiz;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private RoleContent rContent;
    private UserAttrObj uao;

    public AddRoleWizard(VUserMgr vUserMgr, RoleContent roleContent, String string) {
        super(string);
        this.userMgrClient = vUserMgr.getUserMgr();
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.rContent = roleContent;
        this.wiz = this;
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.helpCache = new Vector(22);
        this.setUpMailContext();
        this.addCard("nameStep", new NameStep());
        this.addCard("passwordStep", new PassWordStep());
        this.addCard("rightsStep", new RightsStep());
        this.addCard("homedirStep", new HomeDirStep());
        if (vUserMgr.getUserMgr().hasRoleMgrAssignAuth()) {
            this.addCard("addUsersStep", new AddUsersStep());
        }
        this.addCard("reviewStep", new ReviewStep());
        ContextHelpListener.loadHelp((Vector)this.helpCache);
        this.setFirst("nameStep");
    }

    public void cancelWizard() {
        this.userCancel = true;
        super.cancelWizard();
    }

    public boolean userCanceled() {
        return this.userCancel;
    }

    public void resetCancel() {
        this.userCancel = false;
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private void setUpButton(AbstractButton abstractButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        abstractButton.setText(this.actionString.getString());
        abstractButton.setMnemonic(this.actionString.getMnemonic());
    }

    private void setUpMailContext() {
        this.isLocalScope = this.theApp.getApplicationContext().isLocalScope();
        this.mailServer = this.theApp.getApplicationContext().getMgmtServer();
    }

    public void setHelp(String string) {
        String string2 = new String("html/");
        String string3 = string2 + string + ".html";
        String string4 = ResourceManager.getLocalizedTextFile((String)string3, this.theApp.getClass());
        this.setHelpHTML(string4);
    }

    public void doClose() {
        this.cancelWizard();
    }

    private void createMailAliasForRole(UserObj userObj) throws Exception {
        String string = userObj.getUserName();
        Vector vector = null;
        if (userObj.getSolAuthAttrs() != null) {
            vector = userObj.getSolAuthAttrs().getAttribute("members");
        }
        EmailAliasObj emailAliasObj = new EmailAliasObj(string);
        if (vector != null && !vector.isEmpty()) {
            String string2 = new String("");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + enumeration.nextElement();
                if (!enumeration.hasMoreElements()) continue;
                string2 = string2 + ", ";
            }
            emailAliasObj.setAliasExpansion(string2);
        }
        this.theApp.getUserMgr().addEmailAlias(emailAliasObj);
    }

    public void doFinish() {
        block17: {
            UserObj userObj = new UserObj(this.userName);
            userObj.setUserFullName(this.fullName);
            userObj.setUserDescription(this.description);
            userObj.setUserID(this.uid);
            userObj.setUserType("role");
            SolPasswordAttr solPasswordAttr = new SolPasswordAttr();
            solPasswordAttr.setMustChangeDays("");
            solPasswordAttr.setCannotChangeDays("");
            solPasswordAttr.setAlertChangeDays("");
            solPasswordAttr.setInactiveDays("");
            userObj.setSolPasswordAttr(solPasswordAttr);
            userObj = this.userMgrClient.setUpPassword(this.password1, userObj);
            SolGroupAttr solGroupAttr = new SolGroupAttr();
            solGroupAttr.setPrimaryGroup("sysadmin");
            solGroupAttr.setNumberSecondaryGroups(0);
            userObj.setSolGroupAttr(solGroupAttr);
            SolServicesAttr solServicesAttr = new SolServicesAttr();
            solServicesAttr.setInitialShell(this.shell);
            solServicesAttr.setMailServer(this.mailServer);
            userObj.setSolServicesAttr(solServicesAttr);
            SolHomedirAttr solHomedirAttr = new SolHomedirAttr();
            String string = new String(this.pathname);
            if (!string.endsWith("/")) {
                string = string.concat("/");
            }
            string = string.concat(this.userName);
            solHomedirAttr.setPathname(string);
            solHomedirAttr.setServer(this.server);
            Permissions permissions = new Permissions();
            permissions.setOwner(7);
            permissions.setGroup(5);
            permissions.setWorld(0);
            solHomedirAttr.setPerms(permissions);
            solHomedirAttr.setAutomount(this.automountHomeDir);
            userObj.setSolHomedirAttr(solHomedirAttr);
            this.uao = new UserAttrObj(this.userName, "role");
            this.uao.setProfNamesVector(this.assignedProfsVector);
            if (this.roleMembersVector != null || !this.roleMembersVector.isEmpty()) {
                this.uao.setAttribute("members", this.roleMembersVector);
            }
            userObj.setSolAuthAttrs(this.uao);
            try {
                this.theApp.getUserMgr().addUser(userObj);
                this.theApp.setAllRolesCache(null);
                Vector<UserObj> vector = new Vector<UserObj>();
                vector.addElement(userObj);
                this.rContent.appendToResultsPane(vector);
                if (this.createMailAlias) {
                    this.createMailAliasForRole(userObj);
                }
            }
            catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                Object object;
                PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                if (partialSuccessObject != null) {
                    if (partialSuccessObject.getHomedirFailed()) {
                        object = partialSuccessObject.getHomedirException();
                        if (object != null) {
                            new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                        }
                    } else if (partialSuccessObject.getMailboxFailed()) {
                        object = partialSuccessObject.getMailboxException();
                        if (object != null) {
                            new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                        }
                    } else {
                        object = solServerPartialSuccessException.getLocalizedMessage();
                        if (object != null && !((String)object).equals("")) {
                            new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), (String)object, true);
                        }
                    }
                }
                this.theApp.setAllRolesCache(null);
                object = new Vector();
                ((Vector)object).addElement(userObj);
                this.rContent.appendToResultsPane((Vector)object);
                if (this.createMailAlias) {
                    try {
                        this.createMailAliasForRole(userObj);
                    }
                    catch (Exception exception) {
                        this.theApp.reportErrorException(exception);
                    }
                }
            }
            catch (Exception exception) {
                String string2 = exception.getLocalizedMessage();
                if (string2 == null || string2.equals("")) break block17;
                new ErrorDialog(this.theApp.getFrame(), string2);
            }
        }
    }

    class ReviewStep
    extends VWizardCard {
        SelectableLabel roleNameTF;
        SelectableLabel fullNameTF;
        SelectableLabel uidTF;
        SelectableLabel shellTF;
        SelectableLabel serverTF;
        SelectableLabel pathTF;

        public ReviewStep() {
            int n = 0;
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_name_rev"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
            this.roleNameTF = new SelectableLabel(AddRoleWizard.this.userName, 13);
            this.roleNameTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.roleNameTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_full_name_rev"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            this.fullNameTF = new SelectableLabel(AddRoleWizard.this.fullName, 13);
            this.fullNameTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.fullNameTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_id_r"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            this.uidTF = new SelectableLabel(AddRoleWizard.this.uid, 13);
            this.uidTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.uidTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_props_shell_rev"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            this.shellTF = new SelectableLabel(AddRoleWizard.this.userName, 13);
            this.shellTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.shellTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_homedir"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_server_rev"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)36, (int)0, (int)0);
            this.serverTF = new SelectableLabel(AddRoleWizard.this.server, 13);
            this.serverTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.serverTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_path_rev"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)11, (int)36, (int)0, (int)0);
            this.pathTF = new SelectableLabel(AddRoleWizard.this.pathname, 13);
            this.pathTF.removeFocusBorder();
            Constraints.constrain((Container)((Object)this), (Component)this.pathTF, (int)1, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        }

        public void start() {
            super.start();
            AddRoleWizard.this.wiz.setHelp("radd_review_gen");
            this.roleNameTF.setText(AddRoleWizard.this.userName);
            this.fullNameTF.setText(AddRoleWizard.this.fullName);
            this.uidTF.setText(AddRoleWizard.this.uid);
            this.shellTF.setText(AddRoleWizard.this.shellString);
            this.serverTF.setText(AddRoleWizard.this.server);
            String string = new String(AddRoleWizard.this.pathname);
            if (!string.endsWith("/")) {
                string = string.concat("/");
            }
            string = string.concat(AddRoleWizard.this.userName);
            this.pathTF.setText(string);
            this.setProperty("vwp.canmoveforward", "vwp.true");
            this.setProperty("vwp.canmovebackward", "vwp.true");
            this.setProperty("vwp.finishstate", "vwp.true");
        }

        public boolean stop(boolean bl) {
            if (!bl) {
                this.setProperty("vwp.finishstate", "vwp.false");
            } else {
                AddRoleWizard.this.doFinish();
                AddRoleWizard.this.doClose();
            }
            return true;
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }
    }

    class AddUsersStep
    extends VWizardCard {
        public static final int HELP_CACHE_SIZE = 2;
        JListEditor userAddDelPanel;

        public AddUsersStep() {
            UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_users_name");
            UMgrContextHelpListener uMgrContextHelpListener2 = new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_users_list");
            super.setTitle(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_addusers_step"));
            int n = 0;
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_add_user"));
            Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)n, (int)2, (int)1, (int)1, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
            ++n;
            this.userAddDelPanel = new JListEditor(new Vector(), false);
            this.userAddDelPanel.setVerifyListener(new ActionListener(this){
                private final /* synthetic */ AddUsersStep this$1;
                {
                    this.this$1 = addUsersStep;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (!CheckSyntax.isNameOK((String)string)) {
                        String string2 = CheckSyntax.getErrorString();
                        ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.access$200(AddUsersStep.access$2100(this.this$1)).getFrame(), string2);
                        this.this$1.userAddDelPanel.acceptInput(false);
                    } else {
                        this.this$1.userAddDelPanel.acceptInput(true);
                    }
                }
            });
            this.userAddDelPanel.setFocusListeners((FocusListener)((Object)uMgrContextHelpListener), (FocusListener)((Object)uMgrContextHelpListener2), (FocusListener)((Object)uMgrContextHelpListener), (FocusListener)((Object)uMgrContextHelpListener2), null, null);
            this.userAddDelPanel.setColumns(15);
            this.userAddDelPanel.setVisibleRows(8);
            this.userAddDelPanel.setUpAddShortcut();
            Constraints.constrain((Container)((Object)this), (Component)this.userAddDelPanel, (int)0, (int)n, (int)1, (int)1, (int)1, (int)17, (double)0.0, (double)0.0, (int)24, (int)36, (int)0, (int)0);
            flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_del_user"));
            Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)(++n), (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (int)24, (int)24, (int)0, (int)0);
        }

        public void start() {
            super.start();
            AddRoleWizard.this.wiz.setHelp("radd_users_gen");
            this.setProperty("vwp.canmoveforward", "vwp.true");
            this.setProperty("vwp.canmovebackward", "vwp.true");
        }

        public boolean stop(boolean bl) {
            AddRoleWizard.this.roleMembersVector = this.userAddDelPanel.getOutItems();
            return true;
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }

        static /* synthetic */ AddRoleWizard access$2100(AddUsersStep addUsersStep) {
            return addUsersStep.AddRoleWizard.this;
        }
    }

    class HomeDirStep
    extends VWizardCard {
        public static final int HELP_CACHE_SIZE = 2;
        ISOLatinField serverField;
        ISOLatinField pathnameField;
        SelectableLabel serverLabel;

        public HomeDirStep() {
            super.setTitle(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_homedir_step"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int n = 0;
            JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_homedir"));
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)n, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_server");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)36, (int)0, (int)0);
            if (AddRoleWizard.this.isLocalScope) {
                this.serverLabel = new SelectableLabel(AddRoleWizard.this.mailServer);
                jLabel.setLabelFor((Component)this.serverLabel);
                Constraints.constrain((Container)((Object)this), (Component)this.serverLabel, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            } else {
                this.serverField = new ISOLatinField(-1, "", 15);
                this.serverField.addKeyListener((KeyListener)new KeyAdapter(this){
                    private final /* synthetic */ HomeDirStep this$1;
                    {
                        this.this$1 = homeDirStep;
                    }

                    public void keyPressed(KeyEvent keyEvent) {
                        this.this$1.updateStatus();
                    }
                });
                this.serverField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_homedir_server")));
                this.serverField.setMinimumSize(this.serverField.getPreferredSize());
                Constraints.constrain((Container)((Object)this), (Component)this.serverField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
                jLabel.setLabelFor((Component)this.serverField);
            }
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_path");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)36, (int)0, (int)0);
            this.pathnameField = new ISOLatinField(-1, AddRoleWizard.this.pathname, 15);
            this.pathnameField.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ HomeDirStep this$1;
                {
                    this.this$1 = homeDirStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            this.pathnameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_homedir_path")));
            this.pathnameField.setMinimumSize(this.pathnameField.getPreferredSize());
            jLabel.setLabelFor((Component)this.pathnameField);
            Constraints.constrain((Container)((Object)this), (Component)this.pathnameField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_homedir_explain"));
            Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)(++n), (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
            this.validate();
            this.repaint();
        }

        public void start() {
            super.start();
            AddRoleWizard.this.wiz.setHelp("radd_homedir_gen");
            this.updateStatus();
            this.setProperty("vwp.canmovebackward", "vwp.true");
        }

        public boolean stop(boolean bl) {
            if (bl) {
                AddRoleWizard.this.pathname = this.pathnameField.getText();
                if (AddRoleWizard.this.isLocalScope) {
                    AddRoleWizard.this.server = this.serverLabel.getText();
                } else {
                    AddRoleWizard.this.server = this.serverField.getText();
                    if (!CheckSyntax.isHomeDirServerOK((String)AddRoleWizard.this.server)) {
                        String string = CheckSyntax.getErrorString();
                        ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                        return false;
                    }
                }
                if (!CheckSyntax.isHomeDirPathnameOK((String)AddRoleWizard.this.pathname)) {
                    String string = CheckSyntax.getErrorString();
                    ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                    return false;
                }
            }
            return true;
        }

        protected void updateStatus() {
            if (!AddRoleWizard.this.isLocalScope) {
                if (this.serverField.getText().equals("") || this.pathnameField.getText().equals("")) {
                    this.setProperty("vwp.canmoveforward", "vwp.false");
                } else {
                    this.setProperty("vwp.canmoveforward", "vwp.true");
                }
            } else if (this.pathnameField.getText().equals("")) {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            }
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }
    }

    class RightsStep
    extends VWizardCard {
        public static final int HELP_CACHE_SIZE = 0;
        UserObj userObj = new UserObj();
        RightsPanel rightsPanel = new RightsPanel(AddRoleWizard.access$200(AddRoleWizard.this), AddRoleWizard.access$400(AddRoleWizard.this), false, this.userObj);

        public RightsStep() {
            super.setTitle(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_rights_step"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int n = 0;
            this.rightsPanel.setMinimumSize(new Dimension(550, 380));
            this.rightsPanel.setPreferredSize(new Dimension(550, 380));
            Constraints.constrain((Container)((Object)this), (Component)this.rightsPanel, (int)0, (int)n, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)24, (int)24, (int)0, (int)0);
        }

        public void start() {
            super.start();
            AddRoleWizard.this.wiz.setHelp("radd_rr_gen");
            this.updateStatus();
            this.setProperty("vwp.canmovebackward", "vwp.true");
        }

        public boolean stop(boolean bl) {
            if (bl) {
                AddRoleWizard.this.assignedProfsVector = this.rightsPanel.getAssignedProfs();
            }
            return true;
        }

        protected void updateStatus() {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }
    }

    class PassWordStep
    extends VWizardCard {
        public static final int HELP_CACHE_SIZE = 2;
        JPasswordField pw1Field;
        JPasswordField pw2Field;
        JLabel pw1Label;
        JLabel pw2Label;

        public PassWordStep() {
            super.setTitle(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_password_step"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int n = 0;
            this.pw1Label = new JLabel();
            AddRoleWizard.this.setUpLabel(this.pw1Label, "role_password");
            Constraints.constrain((Container)((Object)this), (Component)this.pw1Label, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
            this.pw1Field = new JPasswordField("", 13);
            this.pw1Field.setEchoChar(' ');
            this.pw1Field.setMinimumSize(this.pw1Field.getPreferredSize());
            this.pw1Field.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_p_passwd")));
            this.pw1Field.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ PassWordStep this$1;
                {
                    this.this$1 = passWordStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            this.pw1Label.setLabelFor(this.pw1Field);
            Constraints.constrain((Container)((Object)this), (Component)this.pw1Field, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
            this.pw2Label = new JLabel();
            AddRoleWizard.this.setUpLabel(this.pw2Label, "role_conf_password");
            Constraints.constrain((Container)((Object)this), (Component)this.pw2Label, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)11, (int)24, (int)0, (int)0);
            this.pw2Field = new JPasswordField("", 13);
            this.pw2Field.setEchoChar(' ');
            this.pw2Field.setMinimumSize(this.pw2Field.getPreferredSize());
            this.pw2Field.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_p_conf")));
            this.pw2Field.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ PassWordStep this$1;
                {
                    this.this$1 = passWordStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            this.pw2Label.setLabelFor(this.pw2Field);
            Constraints.constrain((Container)((Object)this), (Component)this.pw2Field, (int)1, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)11, (int)12, (int)0, (int)0);
            this.pw1Field.requestFocus();
            this.validate();
            this.repaint();
        }

        public void start() {
            super.start();
            this.updateStatus();
            AddRoleWizard.this.wiz.setHelp("radd_p_gen");
            this.pw1Field.requestFocus();
            this.setProperty("vwp.canmovebackward", "vwp.true");
        }

        public boolean stop(boolean bl) {
            if (bl) {
                char[] cArray = this.pw1Field.getPassword();
                AddRoleWizard.this.password1 = new String(cArray);
                char[] cArray2 = this.pw2Field.getPassword();
                AddRoleWizard.this.password2 = new String(cArray2);
                if (AddRoleWizard.this.password1.equals("")) {
                    ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), ResourceStrings.getString((String)"cs_passwd_len"));
                    return false;
                }
                if (!CheckSyntax.isPasswordConf((String)AddRoleWizard.this.password1, (String)AddRoleWizard.this.password2)) {
                    String string = CheckSyntax.getErrorString();
                    ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                    return false;
                }
            }
            return true;
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }

        protected void updateStatus() {
            char[] cArray = this.pw1Field.getPassword();
            AddRoleWizard.this.password1 = new String(cArray);
            char[] cArray2 = this.pw2Field.getPassword();
            AddRoleWizard.this.password2 = new String(cArray2);
            if (!AddRoleWizard.this.password1.equals("") && !AddRoleWizard.this.password2.equals("")) {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }
    }

    class NameStep
    extends VWizardCard {
        public static final int HELP_CACHE_SIZE = 16;
        ISOLatinField roleNameField;
        ISOLatinField fullNameField;
        ISOLatinField descriptionField;
        JIntSpinBox uidField;
        JComboBox shellCombo;
        JCheckBox mailListCheckBox;

        public NameStep() {
            super.setTitle(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_name_step"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int n = 0;
            JLabel jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_name");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
            this.roleNameField = new ISOLatinField(32, "", 15);
            this.roleNameField.setMinimumSize(this.roleNameField.getPreferredSize());
            this.roleNameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_rname")));
            this.roleNameField.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ NameStep this$1;
                {
                    this.this$1 = nameStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            jLabel.setLabelFor((Component)this.roleNameField);
            Constraints.constrain((Container)((Object)this), (Component)this.roleNameField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_full_name");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            this.fullNameField = new ISOLatinField(-1, "", 15);
            this.fullNameField.setMinimumSize(this.fullNameField.getPreferredSize());
            this.fullNameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_name")));
            this.fullNameField.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ NameStep this$1;
                {
                    this.this$1 = nameStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }

                public void keyTyped(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            jLabel.setLabelFor((Component)this.fullNameField);
            Constraints.constrain((Container)((Object)this), (Component)this.fullNameField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_description");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            this.descriptionField = new ISOLatinField(256, "", 15);
            this.descriptionField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_descript")));
            this.descriptionField.setMinimumSize(this.descriptionField.getPreferredSize());
            this.descriptionField.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ NameStep this$1;
                {
                    this.this$1 = nameStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            jLabel.setLabelFor((Component)this.descriptionField);
            Constraints.constrain((Container)((Object)this), (Component)this.descriptionField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_id");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            try {
                AddRoleWizard.this.uid = AddRoleWizard.this.userMgrClient.getNextAvailableUID();
            }
            catch (AdminException adminException) {
                int n2 = 100;
                AddRoleWizard.this.uid = String.valueOf(n2);
            }
            this.uidField = new JIntSpinBox(10, 100, Integer.MAX_VALUE);
            this.uidField.getTextField().setText(AddRoleWizard.this.uid);
            this.uidField.getTextField().setHorizontalAlignment(4);
            this.uidField.getTextField().addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_rid")));
            this.uidField.getTextField().addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ NameStep this$1;
                {
                    this.this$1 = nameStep;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    this.this$1.updateStatus();
                }
            });
            jLabel.setLabelFor(this.uidField.getTextField());
            Constraints.constrain((Container)((Object)this), (Component)this.uidField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            jLabel = new JLabel();
            AddRoleWizard.this.setUpLabel(jLabel, "role_props_shell");
            Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)24, (int)0, (int)0);
            String[] stringArray = new String[]{ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_bourne"), ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_c"), ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_korn")};
            this.shellCombo = new JComboBox<String>(stringArray);
            AddRoleWizard.this.theApp.addHelpListener(this.shellCombo, new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_shell"));
            jLabel.setLabelFor(this.shellCombo);
            Constraints.constrain((Container)((Object)this), (Component)this.shellCombo, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
            this.mailListCheckBox = new JCheckBox(ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_create_mail_list"), true);
            AddRoleWizard.this.setUpButton(this.mailListCheckBox, "role_create_mail_list");
            this.mailListCheckBox.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(AddRoleWizard.this.theApp, AddRoleWizard.this.helpCache, AddRoleWizard.this.infoPanel, "radd_n_mail")));
            Constraints.constrain((Container)((Object)this), (Component)this.mailListCheckBox, (int)0, (int)(++n), (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)11, (int)24, (int)0, (int)0);
            this.validate();
            this.repaint();
        }

        protected void updateStatus() {
            if (!this.roleNameField.getText().equals("") && !this.uidField.getTextField().getText().equals("")) {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }

        public void start() {
            super.start();
            AddRoleWizard.this.wiz.setHelp("radd_n_gen");
            this.updateStatus();
            this.setProperty("vwp.canmovebackward", "vwp.false");
            this.setProperty("vwp.finishstate", "vwp.false");
        }

        public boolean stop(boolean bl) {
            AddRoleWizard.this.userName = this.roleNameField.getText();
            AddRoleWizard.this.fullName = this.fullNameField.getText();
            AddRoleWizard.this.description = this.descriptionField.getText();
            AddRoleWizard.this.uid = this.uidField.getStringValue();
            if (this.mailListCheckBox.isSelected()) {
                AddRoleWizard.this.createMailAlias = true;
            } else {
                AddRoleWizard.this.createMailAlias = false;
            }
            if (this.shellCombo.getSelectedIndex() == 0) {
                AddRoleWizard.this.shell = "/bin/pfsh";
                AddRoleWizard.this.shellString = ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_bourne");
            } else if (this.shellCombo.getSelectedIndex() == 1) {
                AddRoleWizard.this.shell = "/bin/pfcsh";
                AddRoleWizard.this.shellString = ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_c");
            } else {
                AddRoleWizard.this.shell = "/bin/pfksh";
                AddRoleWizard.this.shellString = ResourceStrings.getString((ResourceBundle)AddRoleWizard.this.bundle, (String)"role_korn");
            }
            if (!CheckSyntax.isNameOK((String)AddRoleWizard.this.userName)) {
                String string = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                return false;
            }
            if (!CheckSyntax.isDescLenOK((String)AddRoleWizard.this.description)) {
                String string = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                return false;
            }
            if (!CheckSyntax.isUIDOK((String)AddRoleWizard.this.uid)) {
                String string = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(AddRoleWizard.this.theApp.getFrame(), string);
                return false;
            }
            return true;
        }

        public void reset() {
        }

        public boolean isSubStep() {
            return false;
        }
    }
}

