/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.templates;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UserActionsListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.templates.AddTemplTabs;
import com.sun.admin.usermgr.client.templates.TemplContent;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.TemplateObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AddTemplDlg
extends AdminDialog {
    private AddTemplTabs addTemplTabs;
    private ISOLatinField templNameTextField;
    private ISOLatinField descrTextField;
    private TemplateObj templObj;
    private GenInfoPanel infoPanel;
    private JPanel blankPanel;
    private JButton propOKBtn;
    private JButton propCancelBtn;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private TemplContent templContent;
    private boolean isNew;
    private boolean isClone;
    private boolean isRename;
    private String oldTemplateName;
    private String newTemplateName;
    private Boolean applyInProgress = new Boolean(false);
    private ServiceWrapper userMgr;

    public AddTemplDlg(VUserMgr vUserMgr, TemplateObj templateObj, TemplContent templContent, boolean bl) {
        super((Frame)vUserMgr.getFrame(), "", false);
        Object object;
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.templContent = templContent;
        this.isClone = bl;
        this.userMgr = vUserMgr.getUserMgr();
        this.templObj = templateObj;
        if (this.templObj == null) {
            this.isNew = true;
        }
        if (this.isNew) {
            this.templObj = new TemplateObj();
        } else {
            this.templObj = templateObj;
            this.oldTemplateName = this.templObj.getTName();
            if (bl) {
                this.templObj.setTName("");
                this.templObj.setTDescription("");
            }
        }
        this.setTemplObj(this.templObj);
        if (this.isNew) {
            this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"add_templ_title"));
        } else if (bl) {
            object = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"clone_templ_title") + " " + this.getTemplObj().getTName());
            this.setTitle((String)object);
        } else {
            object = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mod_templ_title") + " " + this.getTemplObj().getTName());
            this.setTitle((String)object);
        }
        this.infoPanel = this.getInfoPanel();
        this.propOKBtn = this.getOKBtn();
        this.propOKBtn.addActionListener(new OKCancelButtonListener());
        this.propOKBtn.setEnabled(false);
        if (this.userMgr.hasUserMgrWriteAuth()) {
            this.propOKBtn.setEnabled(true);
        }
        this.propCancelBtn = this.getCancelBtn();
        this.propCancelBtn.addActionListener(new OKCancelButtonListener());
        this.blankPanel = this.getRightPanel();
        this.blankPanel.add(this.createMainPanel());
        this.pack();
        object = new Vector(40);
        this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_add")), true);
        this.templNameTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_add_name")));
        this.descrTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_add_desc")));
        if (this.isNew) {
            this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_add")), true);
        } else if (bl) {
            this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_clone")), true);
        } else {
            this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, (Vector)object, this.infoPanel, "utemp_prop")), true);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "templ_name");
        this.templNameTextField = new ISOLatinField(-1, "", 15);
        jLabel.setLabelFor((Component)this.templNameTextField);
        this.templNameTextField.setMinimumSize(this.templNameTextField.getPreferredSize());
        if (!this.isNew || this.isClone) {
            this.templNameTextField.setText(this.getTemplObj().getTName());
        }
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(jLabel2, "templ_descr");
        this.descrTextField = new ISOLatinField(-1, "", 15);
        this.descrTextField.setMinimumSize(this.descrTextField.getPreferredSize());
        jLabel2.setLabelFor((Component)this.descrTextField);
        if (!this.isNew || this.isClone) {
            this.descrTextField.setText(this.getTemplObj().getTDescription());
        }
        this.addTemplTabs = this.isNew ? new AddTemplTabs(this.theApp, this.templObj, this.infoPanel, (JDialog)((Object)this), true) : new AddTemplTabs(this.theApp, this.templObj, this.infoPanel, (JDialog)((Object)this), false);
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)20, (int)24, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.templNameTextField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)20, (int)8, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)24, (int)3, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.descrTextField, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)1.0, (int)3, (int)8, (int)3, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.addTemplTabs, (int)0, (int)2, (int)2, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)3, (int)16, (int)3, (int)16);
        return jPanel;
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public boolean isUpdateOK() {
        TemplateObj templateObj = this.getTemplObj();
        String string = this.templNameTextField.getText();
        String string2 = this.descrTextField.getText();
        if (this.isNew || this.isClone) {
            this.isRename = false;
        } else if (this.oldTemplateName.equals(string)) {
            this.isRename = false;
        } else {
            this.newTemplateName = string;
            this.isRename = true;
        }
        if (string.equals("")) {
            String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_templ_must_have_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3);
            return false;
        }
        if (string.length() > 32) {
            String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_templ_name_len");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string4);
            return false;
        }
        templateObj.setTName(string);
        if (!CheckSyntax.isDescLenOK((String)string2)) {
            String string5 = CheckSyntax.getErrorString();
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string5);
            return false;
        }
        templateObj.setTDescription(string2);
        return this.addTemplTabs.isUpdateOK();
    }

    public void setTemplObj(TemplateObj templateObj) {
        this.templObj = templateObj;
    }

    public TemplateObj getTemplObj() {
        return this.templObj;
    }

    private void doUpdate() throws AdminException {
        TemplateObj templateObj = this.getTemplObj();
        this.userMgr.modifyTemplate(templateObj);
        Content content = this.theApp.getTree().getCurrentContent();
        final VScopeNode vScopeNode = content.getTreeNode();
        Vector vector = content.getSelected();
        VScopeNode vScopeNode2 = (VScopeNode)vector.elementAt(0);
        templateObj.setModDateTime(null);
        vScopeNode2.setDescription(templateObj.getTDescription());
        vScopeNode2.setColumnValues(TemplContent.getColumnValues(this.bundle, templateObj));
        vScopeNode2.setPayload((Object)templateObj);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)AddTemplDlg.this.theApp, "vconsole.updatescope", (Object)vScopeNode);
                        AddTemplDlg.this.theApp.fireConsoleAction(vConsoleEvent);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)vScopeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
    }

    private void doAdd() {
        this.theApp.setAllTemplsCache(null);
        TemplateObj templateObj = this.getTemplObj();
        try {
            this.userMgr.addTemplate(templateObj);
            final Vector<TemplateObj> vector = new Vector<TemplateObj>();
            vector.addElement(this.getTemplObj());
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            AddTemplDlg.this.templContent.appendToResultsPane(vector);
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.templContent.appendToResultsPane(vector);
            }
            this.dispose();
        }
        catch (AdminException adminException) {
            this.theApp.reportErrorException((Exception)((Object)adminException));
        }
    }

    private void doRefresh() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ActionEvent actionEvent = new ActionEvent(AddTemplDlg.this.theApp, 1001, "Refresh");
                        UserActionsListener userActionsListener = new UserActionsListener(AddTemplDlg.this.theApp, false);
                        userActionsListener.actionPerformed(actionEvent);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            ActionEvent actionEvent = new ActionEvent(this.theApp, 1001, "Refresh");
            UserActionsListener userActionsListener = new UserActionsListener(this.theApp, false);
            userActionsListener.actionPerformed(actionEvent);
        }
    }

    static /* synthetic */ boolean access$500(AddTemplDlg addTemplDlg) {
        return addTemplDlg.isNew;
    }

    static /* synthetic */ boolean access$600(AddTemplDlg addTemplDlg) {
        return addTemplDlg.isClone;
    }

    static /* synthetic */ void access$700(AddTemplDlg addTemplDlg) {
        addTemplDlg.doAdd();
    }

    static /* synthetic */ boolean access$800(AddTemplDlg addTemplDlg) {
        return addTemplDlg.isRename;
    }

    static /* synthetic */ String access$900(AddTemplDlg addTemplDlg) {
        return addTemplDlg.oldTemplateName;
    }

    static /* synthetic */ ServiceWrapper access$1000(AddTemplDlg addTemplDlg) {
        return addTemplDlg.userMgr;
    }

    static /* synthetic */ String access$1100(AddTemplDlg addTemplDlg) {
        return addTemplDlg.newTemplateName;
    }

    static /* synthetic */ void access$1200(AddTemplDlg addTemplDlg) {
        addTemplDlg.doRefresh();
    }

    static /* synthetic */ void access$1300(AddTemplDlg addTemplDlg) throws AdminException {
        addTemplDlg.doUpdate();
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddTemplDlg.this.propOKBtn) {
                String string = AddTemplDlg.this.theApp.getAuthenticatedUser();
                AddTemplDlg.this.getTemplObj().setTUserName(string);
                Boolean bl = AddTemplDlg.this.applyInProgress;
                synchronized (bl) {
                    if (AddTemplDlg.this.applyInProgress.booleanValue()) {
                        return;
                    }
                    AddTemplDlg.this.applyInProgress = Boolean.TRUE;
                }
                Thread thread = new Thread(this){
                    private final /* synthetic */ OKCancelButtonListener this$1;
                    {
                        this.this$1 = oKCancelButtonListener;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        AddTemplDlg.access$000(OKCancelButtonListener.access$400(this.this$1)).waitOn();
                        if (OKCancelButtonListener.access$400(this.this$1).isUpdateOK()) {
                            if (AddTemplDlg.access$500(OKCancelButtonListener.access$400(this.this$1)) || AddTemplDlg.access$600(OKCancelButtonListener.access$400(this.this$1))) {
                                AddTemplDlg.access$700(OKCancelButtonListener.access$400(this.this$1));
                            } else {
                                try {
                                    if (AddTemplDlg.access$800(OKCancelButtonListener.access$400(this.this$1))) {
                                        object = AddTemplDlg.access$000(OKCancelButtonListener.access$400(this.this$1)).getAuthenticatedUser();
                                        OKCancelButtonListener.access$400(this.this$1).getTemplObj().setTName(AddTemplDlg.access$900(OKCancelButtonListener.access$400(this.this$1)));
                                        AddTemplDlg.access$1000(OKCancelButtonListener.access$400(this.this$1)).modifyTemplate(OKCancelButtonListener.access$400(this.this$1).getTemplObj());
                                        AddTemplDlg.access$1000(OKCancelButtonListener.access$400(this.this$1)).copyTemplate(AddTemplDlg.access$900(OKCancelButtonListener.access$400(this.this$1)), AddTemplDlg.access$1100(OKCancelButtonListener.access$400(this.this$1)), (String)object);
                                        AddTemplDlg.access$1000(OKCancelButtonListener.access$400(this.this$1)).deleteTemplate(AddTemplDlg.access$900(OKCancelButtonListener.access$400(this.this$1)));
                                        AddTemplDlg.access$1200(OKCancelButtonListener.access$400(this.this$1));
                                    } else {
                                        AddTemplDlg.access$1300(OKCancelButtonListener.access$400(this.this$1));
                                    }
                                    OKCancelButtonListener.access$400(this.this$1).dispose();
                                }
                                catch (AdminException adminException) {
                                    AddTemplDlg.access$000(OKCancelButtonListener.access$400(this.this$1)).reportErrorException((Exception)((Object)adminException));
                                }
                            }
                        }
                        object = AddTemplDlg.access$300(OKCancelButtonListener.access$400(this.this$1));
                        synchronized (object) {
                            AddTemplDlg.access$302(OKCancelButtonListener.access$400(this.this$1), Boolean.FALSE);
                        }
                        AddTemplDlg.access$000(OKCancelButtonListener.access$400(this.this$1)).waitOff();
                    }
                };
                thread.start();
            } else {
                Boolean bl = AddTemplDlg.this.applyInProgress;
                synchronized (bl) {
                    if (AddTemplDlg.this.applyInProgress.booleanValue()) {
                        return;
                    }
                }
                AddTemplDlg.this.dispose();
            }
        }

        static /* synthetic */ AddTemplDlg access$400(OKCancelButtonListener oKCancelButtonListener) {
            return oKCancelButtonListener.AddTemplDlg.this;
        }
    }
}

