/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.groups;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.FilterPanel;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.groups.ConfDelGroupPanel;
import com.sun.admin.usermgr.client.groups.GroupPropsDlg;
import com.sun.admin.usermgr.client.groups.UMgrGroupMenuBar;
import com.sun.admin.usermgr.client.groups.UMgrGroupTBar;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class GroupContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ListProperties listProperties;
    private ImageIcon smallGroupIcon;
    private ImageIcon largeGroupIcon;
    private UMgrGroupMenuBar groupMenuBar;
    private UMgrGroupTBar groupToolBar;
    private ListProperties lp;
    private VFilter filterControl = null;
    private GroupContent groupContent;
    private VUserMgr theApp;

    public GroupContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.groupContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.groupMenuBar = new UMgrGroupMenuBar(vUserMgr, this);
        this.groupToolBar = new UMgrGroupTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.groupMenuBar);
        this.rootNode.setToolBar((JToolBar)this.groupToolBar);
        this.smallGroupIcon = vUserMgr.loadImageIcon("group_16.gif", "");
        this.largeGroupIcon = vUserMgr.loadImageIcon("group_32.gif", "");
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            vUserMgr.reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_group_id"), new Integer(20016)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, GroupObj groupObj) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        String string = columnHeaders[n++][0];
        try {
            Integer n2 = new Integer(groupObj.getGroupID());
            hashtable.put(string, n2);
        }
        catch (Exception exception) {
            hashtable.put(string, groupObj.getGroupID());
        }
        return hashtable;
    }

    public UMgrGroupMenuBar getMenuBar() {
        return this.groupMenuBar;
    }

    public UMgrGroupTBar getToolBar() {
        return this.groupToolBar;
    }

    public void refresh() {
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    GroupContent.this.updateStatusBar();
                    GroupContent.this.showFilteredStatus();
                    GroupContent.this.theApp.waitOff();
                    return;
                }
                GroupContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                GroupContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    public void createProperties() {
        this.theApp.waitOn();
        GroupPropsDlg groupPropsDlg = new GroupPropsDlg(this.theApp, null, this.groupContent, true);
        groupPropsDlg.show();
        this.theApp.waitOff();
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        this.theApp.waitOn();
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        GroupObj groupObj = (GroupObj)vScopeNode.getPayload();
        try {
            groupObj = this.theApp.getUserMgr().getGroupAttributes(groupObj);
        }
        catch (AdminException adminException) {
            this.theApp.reportErrorException((Exception)((Object)adminException));
            return;
        }
        GroupPropsDlg groupPropsDlg = new GroupPropsDlg(this.theApp, groupObj, this.groupContent, false);
        groupPropsDlg.setVisible(true);
        this.theApp.waitOff();
    }

    public void deleteSelected() {
        ConfDelGroupPanel confDelGroupPanel = new ConfDelGroupPanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_group"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                        GroupObj groupObj = (GroupObj)vScopeNode.getPayload();
                        GroupContent.this.theApp.getUserMgr().deleteGroup(groupObj);
                        GroupContent.this.theApp.setAllGroupsCache(null);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, groupObj){
                                    private final /* synthetic */ GroupObj val$groupObj;
                                    private final /* synthetic */ 2 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$groupObj = groupObj;
                                    }

                                    public void run() {
                                        2.access$100(this.this$1).removeFromResultsPane(this.val$groupObj);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        } else {
                            GroupContent.this.removeFromResultsPane(groupObj);
                        }
                    }
                    catch (Exception exception) {
                        GroupContent.this.theApp.reportErrorException(exception);
                    }
                    ++n;
                }
            }

            static /* synthetic */ GroupContent access$100(2 var0) {
                return var0.GroupContent.this;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelGroupPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public void renameSelected() {
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"groups");
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"GroupListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public ListProperties getListProperties() {
        return this.listProperties;
    }

    public void setListProperties(ListProperties listProperties) {
        this.listProperties = listProperties;
    }

    public String[] getFilterAttributes() {
        String[] stringArray = new String[]{"filter_group_name", "filter_group_id"};
        return stringArray;
    }

    public Vector getFilters() {
        if (this.listProperties != null) {
            return this.listProperties.getFilters();
        }
        return null;
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public void setFilters(Vector vector) {
        try {
            if (this.listProperties != null) {
                this.listProperties.setFilters(vector);
            } else {
                this.listProperties = new ListProperties();
                this.listProperties.setFilters(vector);
            }
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    public VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new FilterControl();
        }
        return this.filterControl;
    }

    public ListProperties getGroupPropsListProperties() {
        return this.lp;
    }

    public void setGroupPropsListProperties(ListProperties listProperties) {
        this.lp = listProperties;
    }

    public void pasteUsers() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        GroupObj groupObj = (GroupObj)vScopeNode.getPayload();
        if (groupObj == null) {
            AdminCommonTools.CMN_HandleOutput((String)"&&&&&&& getGroupObjFromName = null");
            return;
        }
        String string = groupObj.getGroupName();
        if (string.equals(null)) {
            return;
        }
        try {
            groupObj = this.theApp.getUserMgr().getGroupAttributes(groupObj);
        }
        catch (AdminException adminException) {
            this.theApp.reportErrorException((Exception)((Object)adminException));
        }
        GroupObj groupObj2 = (GroupObj)groupObj.clone();
        String[] stringArray = groupObj.getGroupUsers();
        Transferable transferable = this.theApp.getClipBoard().getContents(this);
        String string2 = null;
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack((int)1, (Exception)exception);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            int n = stringTokenizer.countTokens();
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                String string3;
                if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != "") {
                    AdminCommonTools.CMN_HandleOutput((String)("Token = " + string3));
                    AdminCommonTools.CMN_HandleOutput((String)("Token count = " + n2));
                    stringArray2[n2] = string3;
                }
                ++n2;
            }
            int n3 = stringArray.length;
            int n4 = stringArray2.length;
            int n5 = n3 + n4;
            String[] stringArray3 = new String[n5];
            int n6 = 0;
            while (n6 < n3) {
                stringArray3[n6] = stringArray[n6];
                ++n6;
            }
            int n7 = 0;
            int n8 = n3;
            while (n8 < n5) {
                stringArray3[n8] = stringArray2[n7];
                ++n7;
                ++n8;
            }
            groupObj2.setGroupUsers(stringArray3);
            try {
                this.theApp.getUserMgr().modifyGroup(groupObj2, groupObj);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
    }

    public void appendToResultsPane(Vector vector) {
        GroupObj groupObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/groups.html", this.theApp.getClass());
        int n = 0;
        while (n < vector.size()) {
            groupObj = (GroupObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.groupMenuBar.getPopupMenu(), this.smallGroupIcon, this.largeGroupIcon, groupObj.getGroupName(), null, null, -1, (Object)groupObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(GroupContent.getColumnValues(this.bundle, groupObj));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(groupObj);
            ++n;
        }
        groupObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)groupObj);
    }

    public void removeFromResultsPane(GroupObj groupObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            GroupObj groupObj2 = (GroupObj)vScopeNode.getPayload();
            if (groupObj2 == groupObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.groupMenuBar);
        this.rootNode.setToolBar((JToolBar)this.groupToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            this.userMgr = GroupContent.this.theApp.getUserMgr();
        }

        public Vector listAll() throws AdminException {
            if (GroupContent.this.getListProperties() == null) {
                return new Vector();
            }
            Vector vector = new Vector();
            ListProperties listProperties = GroupContent.this.getListProperties();
            Vector vector2 = listProperties.getFilters();
            if (!vector2.isEmpty()) {
                vector = this.userMgr.getAllGroups(GroupContent.this.getListProperties());
            } else {
                vector = this.userMgr.getAllGroups();
                GroupContent.this.theApp.setAllGroupsCache(vector);
            }
            return vector;
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)GroupContent.this.bundle, (String)"groups");
        }
    }

    private class FilterControl
    implements VFilter {
        private Vector helpCache = new Vector(12);
        private FilterPanel filterPanel = null;
        private Action filterAction = null;
        private VConsoleProperties properties = null;

        public boolean getFilterEnabled() {
            if (this.filterPanel != null) {
                this.filterPanel.setFilterItems(GroupContent.this.getFilters());
            }
            if (this.filterAction != null) {
                Vector vector = GroupContent.this.getFilters();
                int n = 0;
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                    n += filterItem.getValue().length();
                    ++n2;
                }
                this.filterAction.setEnabled(n > 0);
            }
            return false;
        }

        public Vector applyFilter(VScopeNode vScopeNode) {
            return null;
        }

        public void clearFilter() {
            this.filterPanel.setDefaultState();
            this.filterAction.setEnabled(false);
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            this.properties = vConsoleProperties;
        }

        public void setFilterEnabled(boolean bl) {
            GroupContent.this.setFilters(bl ? this.filterPanel.getFilterItems() : new Vector());
            GroupContent.this.refresh();
        }

        public void setOptionPane(VOptionPane vOptionPane) {
            if (vOptionPane == null) {
                return;
            }
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FilterControl this$1;
                {
                    this.this$1 = filterControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterControl.access$200(this.this$1).setEnabled(actionEvent.getID() > 0);
                }
            };
            GenInfoPanel genInfoPanel = new GenInfoPanel(vOptionPane);
            this.filterPanel = new FilterPanel(GroupContent.this.getFilterAttributes(), "com.sun.admin.usermgr.client.resources.Resources", this.helpCache, genInfoPanel, actionListener);
            this.filterPanel.setFilterItems(GroupContent.this.getFilters());
            vOptionPane.getContentPane().setLayout(new BorderLayout());
            vOptionPane.getContentPane().add((Component)this.filterPanel, "Center");
            vOptionPane.repaint();
        }

        public void setFilterAction(Action action) {
            this.filterAction = action;
        }

        public boolean getFindMode() {
            return false;
        }

        public void setFindMode(boolean bl) {
        }

        static /* synthetic */ Action access$200(FilterControl filterControl) {
            return filterControl.filterAction;
        }
    }
}

