/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.UserContent;
import com.sun.admin.usermgr.client.users.UserPoliciesDlg;
import com.sun.admin.usermgr.client.users.UserPoliciesObj;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.TemplateObj;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AddUserWithTemplDlg
extends AdminDialog {
    private JButton okButton;
    private JButton cancelButton;
    private ISOLatinField userNameTextField;
    private ISOLatinField fullNameTextField;
    private ISOLatinField descTextField;
    private JIntSpinBox userIDSpinBox;
    private JLabel pwdLabel;
    private JLabel confLabel;
    private JPasswordField pwdField;
    private JPasswordField confField;
    private JRadioButton mustChange;
    private JRadioButton mustUse;
    private JComboBox templateCombo;
    private GenInfoPanel infoPanel;
    private JPanel blankPanel;
    private VUserMgr theApp;
    private UserContent uContent;
    private ServiceWrapper userMgr;
    private ResourceBundle bundle;
    private ActionString actionString;
    private String userName;
    private String userDesc;
    private String userFullName;
    private String userID;
    private String userTempl;
    private String userPasswd;
    private String userConf;
    private boolean usePassword;
    private boolean agreeToCreateUser = false;
    private boolean isLocalScope = true;
    private Boolean applyInProgress = new Boolean(false);

    public AddUserWithTemplDlg(VUserMgr vUserMgr, UserContent userContent) {
        super((Frame)vUserMgr.getFrame(), " ", false);
        this.setModal(false);
        this.theApp = vUserMgr;
        this.userMgr = vUserMgr.getUserMgr();
        this.bundle = vUserMgr.getResourceBundle();
        this.uContent = userContent;
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"add_user_with_temp"));
        this.infoPanel = this.getInfoPanel();
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.okButton.setEnabled(true);
        if (this.userMgr.hasUserMgrWriteAuth()) {
            this.okButton.setEnabled(true);
        }
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createUserPanel());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        Vector vector = new Vector(10 + this.templateCombo.getItemCount());
        this.userNameTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_uname")));
        this.fullNameTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_name")));
        this.descTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_descript")));
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_uid");
        this.userIDSpinBox.getTextField().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.userIDSpinBox.getUpButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.userIDSpinBox.getDownButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.pwdField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_passwd")));
        this.confField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_passwd_confirm")));
        uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_passwd_first");
        this.mustChange.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.mustUse.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        vUserMgr.addHelpListener(this.templateCombo, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp_temp"));
        this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uadd_temp")), true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddUserWithTemplDlg.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private JPanel createUserPanel() {
        Object object;
        Object object2;
        String[] stringArray;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "user_templ");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)24, (int)0, (int)0);
        Vector vector = this.theApp.getAllTemplsCache();
        if (vector == null) {
            try {
                vector = this.userMgr.getAllTemplates();
                this.theApp.setAllTemplsCache(vector);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        if (vector == null || vector.isEmpty()) {
            stringArray = new String[]{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_none")};
            this.okButton.setEnabled(false);
        } else {
            object2 = vector.toArray();
            stringArray = new String[((Object[])object2).length];
            int n = 0;
            while (n < stringArray.length) {
                object = (TemplateObj)object2[n];
                stringArray[n] = object.getTName();
                ++n;
            }
        }
        this.templateCombo = new JComboBox<String>(stringArray);
        object2 = new UserPoliciesDlg(this.theApp);
        UserPoliciesObj userPoliciesObj = UserPoliciesDlg.getUserPoliciesObj();
        if (userPoliciesObj != null && (object = userPoliciesObj.getDefaultUserTemplateName()) != null) {
            this.templateCombo.setSelectedItem(object);
        }
        this.templateCombo.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setLabelFor(this.templateCombo);
        Constraints.constrain((Container)jPanel, (Component)this.templateCombo, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        object = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"acct_info"));
        ((JComponent)object).setBorder(titledBorder);
        ((Container)object).setLayout(new GridBagLayout());
        Constraints.constrain((Container)jPanel, (Component)object, (int)0, (int)1, (int)2, (int)1, (int)1, (int)10, (double)0.0, (double)1.0, (int)24, (int)12, (int)24, (int)12);
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(jLabel2, "au_wiz_username");
        Constraints.constrain((Container)object, (Component)jLabel2, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        this.userNameTextField = new ISOLatinField(32, "", 12);
        this.userNameTextField.setMinimumSize(this.userNameTextField.getPreferredSize());
        jLabel2.setLabelFor((Component)this.userNameTextField);
        Constraints.constrain((Container)object, (Component)this.userNameTextField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        this.setUpLabel(jLabel3, "au_wiz_full_name");
        Constraints.constrain((Container)object, (Component)jLabel3, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        this.fullNameTextField = new ISOLatinField(-1, "", 12);
        this.fullNameTextField.setMinimumSize(this.fullNameTextField.getPreferredSize());
        jLabel3.setLabelFor((Component)this.fullNameTextField);
        Constraints.constrain((Container)object, (Component)this.fullNameTextField, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        this.setUpLabel(jLabel4, "au_wiz_description");
        Constraints.constrain((Container)object, (Component)jLabel4, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        this.descTextField = new ISOLatinField(256, "", 12);
        this.descTextField.setMinimumSize(this.descTextField.getPreferredSize());
        jLabel4.setLabelFor((Component)this.descTextField);
        Constraints.constrain((Container)object, (Component)this.descTextField, (int)1, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)11, (int)11, (int)0, (int)0);
        JLabel jLabel5 = new JLabel();
        this.setUpLabel(jLabel5, "au_wiz_user_uid");
        Constraints.constrain((Container)object, (Component)jLabel5, (int)0, (int)3, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        String string = "";
        try {
            string = this.userMgr.getNextAvailableUID();
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        this.userIDSpinBox = new JIntSpinBox(10, 100, Integer.MAX_VALUE);
        this.userIDSpinBox.getTextField().setText(string);
        this.userIDSpinBox.getTextField().setHorizontalAlignment(4);
        this.userIDSpinBox.getTextField().setMinimumSize(this.userIDSpinBox.getTextField().getPreferredSize());
        jLabel5.setLabelFor(this.userIDSpinBox.getTextField());
        Constraints.constrain((Container)object, (Component)this.userIDSpinBox, (int)1, (int)3, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        JLabel jLabel6 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_user_pw1_lbl"));
        Constraints.constrain((Container)object, (Component)jLabel6, (int)0, (int)4, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)11, (int)12, (int)0, (int)0);
        this.mustChange = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_pwd_change"), true);
        this.setUpToggle(this.mustChange, "templ_pwd_change");
        this.mustUse = new JRadioButton(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_pwd_use"), false);
        this.setUpToggle(this.mustUse, "templ_pwd_use");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mustChange);
        buttonGroup.add(this.mustUse);
        Constraints.constrain((Container)object, (Component)this.mustChange, (int)1, (int)4, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)object, (Component)this.mustUse, (int)1, (int)5, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        this.pwdLabel = new JLabel();
        this.setUpLabel(this.pwdLabel, "au_wiz_user_pw1");
        Constraints.constrain((Container)object, (Component)this.pwdLabel, (int)1, (int)6, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.pwdField = new JPasswordField(10);
        this.pwdField.setMinimumSize(this.pwdField.getPreferredSize());
        this.pwdLabel.setLabelFor(this.pwdField);
        Constraints.constrain((Container)object, (Component)this.pwdField, (int)1, (int)7, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.confLabel = new JLabel();
        this.setUpLabel(this.confLabel, "templ_pwd_conf");
        Constraints.constrain((Container)object, (Component)this.confLabel, (int)1, (int)8, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.confField = new JPasswordField(10);
        this.confField.setMinimumSize(this.confField.getPreferredSize());
        this.confLabel.setLabelFor(this.confField);
        Constraints.constrain((Container)object, (Component)this.confField, (int)1, (int)9, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.mustChange.addActionListener(new PasswdActionListener());
        this.mustUse.addActionListener(new PasswdActionListener());
        this.mustChange.doClick();
        if (this.theApp.getApplicationContext().isScopeNISplus()) {
            this.mustUse.doClick();
            this.mustChange.setEnabled(false);
        }
        return jPanel;
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private void setUpToggle(JToggleButton jToggleButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jToggleButton.setText(this.actionString.getString());
        jToggleButton.setMnemonic(this.actionString.getMnemonic());
    }

    private void getUserValues() {
        this.userName = this.userNameTextField.getText();
        this.userFullName = this.fullNameTextField.getText();
        this.userDesc = this.descTextField.getText();
        this.userID = this.userIDSpinBox.getStringValue();
        this.usePassword = this.mustUse.isSelected();
        this.userTempl = (String)this.templateCombo.getSelectedItem();
        this.userPasswd = "";
        this.userConf = "";
        if (this.usePassword) {
            char[] cArray = this.pwdField.getPassword();
            this.userPasswd = new String(cArray);
            char[] cArray2 = this.confField.getPassword();
            this.userConf = new String(cArray2);
        }
    }

    private boolean isCreateOK() {
        String string;
        if (!CheckSyntax.isNameOK((String)this.userName)) {
            String string2 = CheckSyntax.getErrorString();
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string2);
            return false;
        }
        if (this.theApp.getApplicationContext().isScopeLDAP() && this.userFullName.equals("")) {
            String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_full_name_required");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3);
            return false;
        }
        if (!CheckSyntax.isDescLenOK((String)this.userDesc)) {
            String string4 = CheckSyntax.getErrorString();
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string4);
            return false;
        }
        if (this.usePassword) {
            if (this.userPasswd.equals("")) {
                string = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((String)"cs_passwd_len"));
            } else if (!CheckSyntax.isPasswordConf((String)this.userPasswd, (String)this.userConf)) {
                String string5 = CheckSyntax.getErrorString();
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string5);
                return false;
            }
        }
        if (this.userID.equals("")) {
            string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_user_noUID_create");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
            return false;
        }
        if (!CheckSyntax.isUIDOK((String)this.userID)) {
            string = CheckSyntax.getErrorString();
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
            return false;
        }
        return true;
    }

    private UserObj setUpUser() {
        UserObj userObj = new UserObj();
        SolPasswordAttr solPasswordAttr = new SolPasswordAttr();
        userObj.setUserName(this.userName);
        userObj.setUserType("normal");
        userObj.setUserFullName(this.userFullName);
        userObj.setUserDescription(this.userDesc);
        userObj.setUserID(this.userID);
        userObj = this.theApp.getUserMgr().setUpPassword(this.userPasswd, userObj);
        userObj.setTemplateName(this.userTempl);
        return userObj;
    }

    private void checkForScope() {
        block5: {
            this.isLocalScope = this.theApp.getApplicationContext().isLocalScope();
            if (this.isLocalScope) {
                String string = this.theApp.getApplicationContext().getMgmtServer();
                try {
                    TemplateObj templateObj = this.theApp.getUserMgr().getTemplate(this.userTempl);
                    String string2 = templateObj.getHomeDirServer();
                    String string3 = templateObj.getMailServer();
                    if (string2.equals(string) && string3.equals(string)) {
                        this.agreeToCreateUser = true;
                        break block5;
                    }
                    WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"server_warning"), (ActionListener)new LocalServerWarningListener(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_OK"));
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                }
            } else {
                this.agreeToCreateUser = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOK() {
        Boolean bl = this.applyInProgress;
        synchronized (bl) {
            if (this.applyInProgress.booleanValue()) {
                return;
            }
            this.applyInProgress = Boolean.TRUE;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                AddUserWithTemplDlg.this.theApp.waitOn();
                try {
                    object = AddUserWithTemplDlg.this.setUpUser();
                    AddUserWithTemplDlg.this.userMgr.addUser(object);
                    AddUserWithTemplDlg.this.dispose();
                    AddUserWithTemplDlg.this.theApp.setAllUsersCache(null);
                    Vector<UserObj> vector = new Vector<UserObj>(1);
                    vector.addElement((UserObj)object);
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this, vector){
                                private final /* synthetic */ Vector val$v;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$v = vector;
                                }

                                public void run() {
                                    AddUserWithTemplDlg.access$1000(2.access$900(this.this$1)).appendToResultsPane(this.val$v);
                                }
                            });
                        }
                        catch (Exception exception) {}
                    } else {
                        AddUserWithTemplDlg.this.uContent.appendToResultsPane(vector);
                    }
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                    if (partialSuccessObject != null) {
                        if (partialSuccessObject.getHomedirFailed()) {
                            Exception exception = partialSuccessObject.getHomedirException();
                            if (exception != null) {
                                new ErrorDialog(AddUserWithTemplDlg.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AddUserWithTemplDlg.this.bundle, (String)"er_information"), exception.getLocalizedMessage(), true);
                            }
                        } else if (partialSuccessObject.getMailboxFailed()) {
                            Exception exception = partialSuccessObject.getMailboxException();
                            if (exception != null) {
                                new ErrorDialog(AddUserWithTemplDlg.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AddUserWithTemplDlg.this.bundle, (String)"er_information"), exception.getLocalizedMessage(), true);
                            }
                        } else {
                            String string = solServerPartialSuccessException.getLocalizedMessage();
                            if (string != null && !string.equals("")) {
                                new ErrorDialog(AddUserWithTemplDlg.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AddUserWithTemplDlg.this.bundle, (String)"er_information"), string, true);
                            }
                        }
                    }
                }
                catch (AdminException adminException) {
                    AddUserWithTemplDlg.this.theApp.reportErrorException((Exception)((Object)adminException));
                }
                object = AddUserWithTemplDlg.this.applyInProgress;
                synchronized (object) {
                    AddUserWithTemplDlg.this.applyInProgress = Boolean.FALSE;
                }
                AddUserWithTemplDlg.this.theApp.waitOff();
            }

            static /* synthetic */ AddUserWithTemplDlg access$900(2 var0) {
                return var0.AddUserWithTemplDlg.this;
            }
        };
        thread.start();
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                try {
                    if (actionEvent.getSource() == AddUserWithTemplDlg.this.okButton) {
                        AddUserWithTemplDlg.this.getUserValues();
                        if (AddUserWithTemplDlg.this.isCreateOK()) {
                            AddUserWithTemplDlg.this.checkForScope();
                            if (AddUserWithTemplDlg.this.agreeToCreateUser) {
                                AddUserWithTemplDlg.this.doOK();
                            }
                        }
                        break block9;
                    }
                    Boolean bl = AddUserWithTemplDlg.this.applyInProgress;
                    synchronized (bl) {
                        if (AddUserWithTemplDlg.this.applyInProgress.booleanValue()) {
                            return;
                        }
                    }
                    AddUserWithTemplDlg.this.dispose();
                }
                catch (Exception exception) {
                    AdminCommonTools.CMN_TraceStack((int)1, (Exception)exception);
                    ErrorDialog errorDialog = new ErrorDialog(AddUserWithTemplDlg.this.theApp.getFrame(), exception.getLocalizedMessage());
                }
            }
        }
    }

    class LocalServerWarningListener
    implements ActionListener {
        LocalServerWarningListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddUserWithTemplDlg.this.agreeToCreateUser = true;
        }
    }

    class PasswdActionListener
    implements ActionListener {
        PasswdActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddUserWithTemplDlg.this.mustChange) {
                AddUserWithTemplDlg.this.pwdField.setText("");
                AddUserWithTemplDlg.this.pwdField.setEnabled(false);
                AddUserWithTemplDlg.this.pwdField.setEditable(false);
                AddUserWithTemplDlg.this.pwdLabel.setEnabled(false);
                AddUserWithTemplDlg.this.confField.setText("");
                AddUserWithTemplDlg.this.confField.setEnabled(false);
                AddUserWithTemplDlg.this.confField.setEditable(false);
                AddUserWithTemplDlg.this.confLabel.setEnabled(false);
            } else if (actionEvent.getSource() == AddUserWithTemplDlg.this.mustUse) {
                AddUserWithTemplDlg.this.pwdField.setEnabled(true);
                AddUserWithTemplDlg.this.pwdField.setEditable(true);
                AddUserWithTemplDlg.this.pwdLabel.setEnabled(true);
                AddUserWithTemplDlg.this.confField.setEnabled(true);
                AddUserWithTemplDlg.this.confField.setEditable(true);
                AddUserWithTemplDlg.this.confLabel.setEnabled(true);
            }
            AddUserWithTemplDlg.this.pwdLabel.repaint();
            AddUserWithTemplDlg.this.pwdField.repaint();
            AddUserWithTemplDlg.this.confLabel.repaint();
            AddUserWithTemplDlg.this.confField.repaint();
        }
    }
}

