/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.common.Permissions;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyException;
import com.sun.admin.usermgr.common.WBEMClient.ServerConnectException;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.CIMTransportException;

public class HomeDirProxy
implements WbemClientProxy {
    private static final String HOME_DIR_CLASS = "Solaris_UserHomeDirectory";
    private static String SERVERNAME = "CSName";
    private static String PATHNAME = "Name";
    private static String USERNAME = "userName";
    private static String USERID = "uid";
    private static String PRIMARYGROUP = "primaryGroup";
    private static String INITFILES = "initFiles";
    private static String AUTOMOUNTHDIR = "autoMountHomeDir";
    private static String FORCE_MODIFY = "homeDirForceModify";
    private static String ALLOW_MODIFY = "homeDirAllowModifyServer";
    private static String OWNER_PERMS = "ownerPerms";
    private static String GROUP_PERMS = "groupPerms";
    private static String WORLD_PERMS = "worldPerms";
    private static String NEW_PATHNAME = "newPathName";
    private static String INIT_FILEPATH = "initFilePath";
    private static String USE_USER_NAME = "useUserNameInPath";
    private static String SCRIPT_BEFORE = "scriptBefore";
    private static String SCRIPT_AFTER = "scriptAfter";
    private static String CS_CREATION_CLASS_NAME = "CSCreationClassName";
    private static String FS_CREATION_CLASS_NAME = "FSCreationClassName";
    private static String FS_NAME = "FSName";
    private static String CREATION_CLASS_NAME = "CreationClassName";
    private static String FILE_SIZE = "FileSize";
    private static String CREATION_DATE = "CreationDate";
    private static String LAST_MODIFIED = "LastModified";
    private static String LAST_ACCESSED = "LastAccessed";
    private static String READABLE = "Readable";
    private static String WRITEABLE = "Writeable";
    private static String EXECUTABLE = "Executable";
    private static String COMPRESSION_METHOD = "CompressionMethod";
    private static String ENCRYPTION_METHOD = "EncryptionMethod";
    private static String IN_USE_COUNT = "InUseCount";
    private static String INSTALL_DATE = "InstallDate";
    private static String STATUS = "Status";
    private static String CAPTION = "Caption";
    private static String DESCRIPTION = "Description";
    private CIMClient cimClient = null;
    private CIMClass cimClass = null;

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cimClient = cIMClient;
    }

    public void createHomeDir(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (userObj.getSolHomedirAttr() == null) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr.getPathname() == null) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        String string = userObj.getSolHomedirAttr().getPathname();
        if (solHomedirAttr.getPathname().trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj);
            this.cimClient.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_ADD", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            throw new ServerConnectException("EXM_HOMESERVER_ADD_CONTACT_ERR", solHomedirAttr.getPathname(), userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            Object[] objectArray = cIMException.getParams();
            String string3 = (String)objectArray[0];
            throw new ClientProxyException("EXM_HOMEDIR_ADD_UNEXP", string, userObj.getUserName(), string3);
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
    }

    public UserObj getHomeDirAttributes(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (userObj.getSolHomedirAttr() == null) {
            return userObj;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr.getPathname().trim().length() == 0) {
            return userObj;
        }
        String string = solHomedirAttr.getPathname();
        cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = this.cimClient.getInstance(cIMObjectPath, false);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_READATTR", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            throw new ServerConnectException("EXM_HOMESERVER_PERMS_CONTACT_ERR", userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_PERMS_UNEXP", string, userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_PERMS_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new ClientProxyException("EXM_HOMEDIR_GET_PROV_ERR", string, userObj.getUserName());
        }
        Permissions permissions = new Permissions();
        String string3 = null;
        string3 = this.getStringValue(cIMInstance, OWNER_PERMS);
        if (string3 != null) {
            permissions.setOwner(Integer.valueOf(string3));
        }
        if ((string3 = this.getStringValue(cIMInstance, GROUP_PERMS)) != null) {
            permissions.setGroup(Integer.valueOf(string3));
        }
        if ((string3 = this.getStringValue(cIMInstance, WORLD_PERMS)) != null) {
            permissions.setWorld(Integer.valueOf(string3));
        }
        userObj.getSolHomedirAttr().setPerms(permissions);
        return userObj;
    }

    public void deleteHomeDir(String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (string == null || string.trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_DEL_BAD_NAME");
        }
        cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
        try {
            this.cimClient.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_DEL", string);
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_DEL_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_DEL_UNEXP", string, exception.getMessage());
        }
    }

    public void modifyHomeDir(UserObj userObj, String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (string == null) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_BAD_NAME", userObj.getUserName());
        }
        if (string.trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_BAD_NAME", userObj.getUserName());
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj, string);
            this.cimClient.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_DEL");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
            throw new ServerConnectException("EXM_HOMESERVER_MOD_CONTACT_ERR", solHomedirAttr.getPathname(), userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_MOD_UNEXP", string, userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
    }

    public void printInst(CIMInstance cIMInstance) {
        System.out.println("CIMInstance = " + cIMInstance.toString());
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj) {
        CIMInstance cIMInstance = null;
        cIMInstance = this.convertUserObjToInstance(cIMClass, userObj, null);
        return cIMInstance;
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj, String string) {
        String[] stringArray;
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (userObj.getUserName() != null) {
            cIMInstance.setProperty(USERNAME, new CIMValue((Object)userObj.getUserName()));
        }
        if (userObj.getUserID() != null) {
            cIMInstance.setProperty(USERID, new CIMValue((Object)userObj.getUserID()));
        }
        if (userObj.getInitFilePath() != null) {
            cIMInstance.setProperty(INIT_FILEPATH, new CIMValue((Object)userObj.getInitFilePath()));
        }
        if (userObj.getSolGroupAttr() != null && userObj.getSolGroupAttr().getPrimaryGroup() != null) {
            cIMInstance.setProperty(PRIMARYGROUP, new CIMValue((Object)userObj.getSolGroupAttr().getPrimaryGroup()));
        }
        if (userObj.getSolHomedirAttr() != null) {
            Object object;
            stringArray = userObj.getSolHomedirAttr();
            cIMInstance.setProperty(SERVERNAME, new CIMValue((Object)stringArray.getServer()));
            if (string != null) {
                cIMInstance.setProperty(PATHNAME, new CIMValue((Object)string));
                if (stringArray.getPathname() != null) {
                    object = new CIMValue((Object)stringArray.getPathname());
                    cIMInstance.setProperty(NEW_PATHNAME, (CIMValue)object);
                }
            } else {
                if (stringArray.getPathname() != null) {
                    cIMInstance.setProperty(PATHNAME, new CIMValue((Object)stringArray.getPathname()));
                }
                cIMInstance.setProperty(NEW_PATHNAME, new CIMValue((Object)""));
            }
            cIMInstance.setProperty(AUTOMOUNTHDIR, new CIMValue((Object)new Boolean(stringArray.getAutomount())));
            cIMInstance.setProperty(INITFILES, new CIMValue((Object)new Boolean(stringArray.getInitFiles())));
            cIMInstance.setProperty(FORCE_MODIFY, new CIMValue((Object)new Boolean(stringArray.requireModify())));
            cIMInstance.setProperty(ALLOW_MODIFY, new CIMValue((Object)new Boolean(stringArray.getModifyServer())));
            if (stringArray.getPerms() != null) {
                object = stringArray.getPerms();
                cIMInstance.setProperty(OWNER_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getOwner())));
                cIMInstance.setProperty(GROUP_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getGroup())));
                cIMInstance.setProperty(WORLD_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getWorld())));
            }
        }
        stringArray = new String[]{SCRIPT_BEFORE, SCRIPT_AFTER, CS_CREATION_CLASS_NAME, FS_CREATION_CLASS_NAME, FS_NAME, CREATION_CLASS_NAME, COMPRESSION_METHOD, ENCRYPTION_METHOD, STATUS, CAPTION, DESCRIPTION};
        int n = 0;
        while (n < stringArray.length) {
            cIMInstance.setProperty(stringArray[n], new CIMValue((Object)""));
            ++n;
        }
        String[] stringArray2 = new String[]{FILE_SIZE, IN_USE_COUNT};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            cIMInstance.setProperty(stringArray2[n2], new CIMValue((Object)Integer.toString(0)));
            ++n2;
        }
        String[] stringArray3 = new String[]{CREATION_DATE, LAST_MODIFIED, LAST_ACCESSED, INSTALL_DATE};
        int n3 = 0;
        while (n3 < stringArray3.length) {
            cIMInstance.setProperty(stringArray3[n3], new CIMValue((Object)new CIMDateTime(new Date())));
            ++n3;
        }
        String[] stringArray4 = new String[]{READABLE, WRITEABLE, EXECUTABLE, USE_USER_NAME};
        int n4 = 0;
        while (n4 < stringArray4.length) {
            cIMInstance.setProperty(stringArray4[n4], new CIMValue((Object)new Boolean(true)));
            ++n4;
        }
        return cIMInstance;
    }

    private String getStringValue(CIMInstance cIMInstance, String string) {
        String string2 = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            string2 = (String)cIMValue.getValue();
        }
        return string2;
    }

    private boolean getbooleanValue(CIMInstance cIMInstance, String string) {
        boolean bl = false;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            bl = (Boolean)cIMValue.getValue();
        }
        return bl;
    }

    private Vector getVectorValue(CIMInstance cIMInstance, String string) {
        Vector vector = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        return vector;
    }
}

