/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class ShellsProxy
implements WbemClientProxy {
    private static final String SHELL_CLASS = "Solaris_ShellSAP";
    private static String SHELL_NAME = "Name";
    private static final String USE_DEFAULT_LIST = "isSystemSuppliedDefault";
    private CIMClient cimClient = null;
    private CIMClass cimClass = null;

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cimClient = cIMClient;
    }

    public boolean doesShellsFileExist() throws AdminException {
        boolean bl = false;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(SHELL_CLASS);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        CIMValue cIMValue = null;
        try {
            ArrayList arrayList;
            cIMValue = this.cimClient.invokeMethod(cIMObjectPath, USE_DEFAULT_LIST, vector, vector2);
            Boolean bl2 = (Boolean)cIMValue.getValue();
            if (bl2 == null) {
                bl2 = new Boolean(true);
            }
            boolean bl3 = bl = bl2 == false;
            if (bl && ((arrayList = this.listEtcShellContents()) == null || arrayList.size() == 0)) {
                return false;
            }
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
        return bl;
    }

    public ArrayList listEtcShellContents() throws AdminException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(SHELL_CLASS);
        Enumeration enumeration = null;
        try {
            enumeration = this.cimClient.enumerateInstanceNames(cIMObjectPath);
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                try {
                    CIMInstance cIMInstance = this.cimClient.getInstance(cIMObjectPath2, false);
                    String string = (String)cIMInstance.getProperty(SHELL_NAME).getValue().getValue();
                    arrayList.add(string);
                }
                catch (Exception exception) {
                    throw this.mapException(exception);
                }
            }
        }
        return arrayList;
    }

    private AdminException mapException(Exception exception) {
        ClientProxyException clientProxyException;
        if (exception instanceof CIMException) {
            CIMException cIMException = (CIMException)((Object)exception);
            String string = cIMException.getID();
            if (string == null || string.trim().length() == 0) {
                clientProxyException = new ClientProxyException("EXM_NO_MESSAGE");
            } else if (string.equals("CIM_ERR_ACCESS_DENIED")) {
                clientProxyException = new ClientProxyException("EXM_AUTH_SEC");
            } else if (string.equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    clientProxyException = new ClientProxyException(string2);
                } else {
                    clientProxyException = new ClientProxyException("EXM_NO_MESSAGE");
                }
            } else {
                clientProxyException = string.equals("CIM_ERR_INVALID_QUERY") ? new ClientProxyException("EXM_AUTH_QUERY") : new ClientProxyException("EXM_AUTH_FAIL", cIMException.getLocalizedMessage());
            }
        } else {
            clientProxyException = new ClientProxyException("EXM_AUTH_FAIL", exception.getLocalizedMessage());
        }
        return clientProxyException;
    }
}

