/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.UserPoliciesObj;
import com.sun.admin.usermgr.common.TemplateObj;
import com.sun.management.viper.services.PersistenceAgent;
import com.sun.management.viper.services.PersistenceException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserPoliciesDlg
extends AdminDialog {
    public static String USER_POLICIES = "Sun.SolarisMgt.4_0.UserPolices.";
    private JPanel userPolPanel;
    private ActionString actionString;
    private JComboBox templateCombo;
    private JCheckBox delHomeDirCheckBox;
    private JCheckBox delMailboxCheckBox;
    private JButton okButton;
    private JButton cancelButton;
    private GenInfoPanel infoPanel;
    private JPanel blankPanel;
    private static VUserMgr theApp;
    private ResourceBundle bundle;
    private static PersistenceAgent pa;
    private static String policyName;

    public UserPoliciesDlg(VUserMgr vUserMgr) {
        super((Frame)vUserMgr.getFrame(), " ", false);
        theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"user_pol_title"));
        this.infoPanel = this.getInfoPanel();
        pa = null;
        try {
            pa = new PersistenceAgent(vUserMgr.getToolInfrastructure());
        }
        catch (PersistenceException persistenceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = vUserMgr.getToolInfrastructure().getIdentity().getName();
        policyName = USER_POLICIES + string;
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createUserPolPanel());
        this.getPolicies();
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        Vector vector = new Vector(6 + this.templateCombo.getItemCount());
        vUserMgr.addHelpListener(this.templateCombo, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprefs_template"));
        this.delHomeDirCheckBox.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprefs_homedir")));
        this.delMailboxCheckBox.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprefs_mailbox")));
        this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprefs")), true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserPoliciesDlg.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private JPanel createUserPolPanel() {
        Object object;
        Object object2;
        String[] stringArray;
        this.userPolPanel = new JPanel();
        this.userPolPanel.setLayout(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"user_pol_acct_creation"));
        Constraints.constrain((Container)this.userPolPanel, (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        this.initLabel(jLabel2, "user_pol_def_templ");
        Constraints.constrain((Container)this.userPolPanel, (Component)jLabel2, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)24, (int)0, (int)0);
        Vector vector = theApp.getAllTemplsCache();
        if (vector == null) {
            try {
                vector = theApp.getUserMgr().getAllTemplates();
                theApp.setAllTemplsCache(vector);
            }
            catch (AdminException adminException) {
                theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        int n2 = 0;
        if (vector.isEmpty()) {
            stringArray = new String[]{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_none")};
        } else {
            stringArray = new String[vector.size()];
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                String string;
                object = (TemplateObj)object2.nextElement();
                stringArray[n2] = string = object.getTName();
                ++n2;
            }
        }
        Sort.sort((String[])stringArray);
        this.templateCombo = new JComboBox<String>(stringArray);
        jLabel2.setLabelFor(this.templateCombo);
        Constraints.constrain((Container)this.userPolPanel, (Component)this.templateCombo, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        object2 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"user_pol_del_userrole"));
        Constraints.constrain((Container)this.userPolPanel, (Component)object2, (int)0, (int)(++n), (int)2, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.actionString = new ActionString(this.bundle, "user_pol_del_homedir");
        this.delHomeDirCheckBox = new JCheckBox(this.actionString.getString(), false);
        this.delHomeDirCheckBox.setMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)this.userPolPanel, (Component)this.delHomeDirCheckBox, (int)0, (int)(++n), (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)24, (int)0, (int)0);
        object = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"user_pol_del_user"));
        Constraints.constrain((Container)this.userPolPanel, (Component)object, (int)0, (int)(++n), (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.actionString = new ActionString(this.bundle, "user_pol_del_mailbox");
        this.delMailboxCheckBox = new JCheckBox(this.actionString.getString(), false);
        this.delMailboxCheckBox.setMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)this.userPolPanel, (Component)this.delMailboxCheckBox, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)1.0, (int)5, (int)24, (int)0, (int)0);
        return this.userPolPanel;
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private void setPolicies() {
        if (pa != null) {
            UserPoliciesObj userPoliciesObj = new UserPoliciesObj();
            String string = (String)this.templateCombo.getSelectedItem();
            userPoliciesObj.setDefaultUserTemplateName(string);
            userPoliciesObj.setRemHomeDir(this.delHomeDirCheckBox.isSelected());
            userPoliciesObj.setRemMailbox(this.delMailboxCheckBox.isSelected());
            try {
                pa.store((Object)userPoliciesObj, "4.0-dev", policyName);
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
        }
    }

    private void getPolicies() {
        try {
            UserPoliciesObj userPoliciesObj = (UserPoliciesObj)pa.restore(policyName);
            if (userPoliciesObj != null) {
                if (userPoliciesObj.getDefaultUserTemplateName() != null) {
                    String string = userPoliciesObj.getDefaultUserTemplateName();
                    this.templateCombo.setSelectedItem(string);
                }
                this.delHomeDirCheckBox.setSelected(userPoliciesObj.getRemHomeDir());
                this.delMailboxCheckBox.setSelected(userPoliciesObj.getRemMailbox());
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    public static UserPoliciesObj getUserPoliciesObj() {
        UserPoliciesObj userPoliciesObj = null;
        try {
            userPoliciesObj = (UserPoliciesObj)pa.restore(policyName);
        }
        catch (PersistenceException persistenceException) {
        }
        catch (Exception exception) {
            theApp.reportErrorException(exception);
        }
        return userPoliciesObj;
    }

    public static void renameUserPolicyKey(String string, String string2) {
        UserPoliciesObj userPoliciesObj = null;
        String string3 = USER_POLICIES + string;
        String string4 = USER_POLICIES + string2;
        try {
            userPoliciesObj = (UserPoliciesObj)pa.restore(policyName);
            if (userPoliciesObj != null) {
                pa.store((Object)userPoliciesObj, "4.0-dev", string4);
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == UserPoliciesDlg.this.okButton) {
                    UserPoliciesDlg.this.setPolicies();
                    UserPoliciesDlg.this.dispose();
                } else {
                    UserPoliciesDlg.this.dispose();
                }
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack((int)1, (Exception)exception);
                ErrorDialog errorDialog = new ErrorDialog(theApp.getFrame(), exception.getLocalizedMessage());
            }
        }
    }
}

