/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.AdminMultiUserWiz;
import com.sun.admin.usermgr.client.users.UserTable;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class AdminMultiUserTypeNamesStep
extends VWizardCard {
    VUserMgr theApp;
    ResourceBundle bundle;
    private AdminMultiUserWiz wiz;
    private FlowArea topExplainFA;
    private FlowArea bottomExplainFA;
    private ISOLatinField userNameField;
    private ISOLatinField fullNameField;
    private ISOLatinField descriptionField;
    private JScrollPane scrollPane;
    private UserTable userTable;
    private JButton addBtn;
    private JButton deleteBtn;
    private TableFocusListener tableFocusListener;
    private TableMouseListener tableMouseListener;
    private ActionString actionString;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final int VISIBLE_ROWS = 4;
    private GenInfoPanel infoPanel;
    private UMgrContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 5;

    public AdminMultiUserTypeNamesStep(VUserMgr vUserMgr, AdminMultiUserWiz adminMultiUserWiz) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.wiz = adminMultiUserWiz;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_typenames_step"));
        this.constructStep();
    }

    public void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.topExplainFA = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_type_name_explain"));
        Constraints.constrain((Container)((Object)this), (Component)this.topExplainFA, (int)0, (int)0, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)5, (int)0, (int)5);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_userinfo"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(titledBorder);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)10, (int)5, (int)0, (int)5);
        JLabel jLabel = new JLabel();
        this.setLabelMnemonic(jLabel, "au_wiz_username");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)10, (int)0, (int)0);
        this.userNameField = new ISOLatinField(32, "", 15);
        this.userNameField.setMinimumSize(this.userNameField.getPreferredSize());
        this.userNameField.addKeyListener((KeyListener)new EnterKeyListener());
        jLabel.setLabelFor((Component)this.userNameField);
        Constraints.constrain((Container)jPanel, (Component)this.userNameField, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)10, (int)0, (int)5);
        jLabel = new JLabel();
        this.setLabelMnemonic(jLabel, "au_wiz_full_name");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)10, (int)0, (int)0);
        this.fullNameField = new ISOLatinField(-1, "", 15);
        this.fullNameField.setMinimumSize(this.fullNameField.getPreferredSize());
        this.fullNameField.addKeyListener((KeyListener)new EnterKeyListener());
        jLabel.setLabelFor((Component)this.fullNameField);
        Constraints.constrain((Container)jPanel, (Component)this.fullNameField, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)10, (int)0, (int)5);
        jLabel = new JLabel();
        this.setLabelMnemonic(jLabel, "mu_wiz_description");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)3, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)10, (int)5, (int)0);
        this.descriptionField = new ISOLatinField(256, "", 15);
        this.descriptionField.setMinimumSize(this.descriptionField.getPreferredSize());
        this.descriptionField.addKeyListener((KeyListener)new EnterKeyListener());
        jLabel.setLabelFor((Component)this.descriptionField);
        Constraints.constrain((Container)jPanel, (Component)this.descriptionField, (int)1, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)10, (int)5, (int)5);
        this.addBtn = new JButton();
        this.setButtonMnemonic(this.addBtn, "mu_wiz_usernames_btn2");
        Constraints.constrain((Container)((Object)this), (Component)this.addBtn, (int)1, (int)1, (int)1, (int)1, (int)2, (int)12, (double)1.0, (double)0.0, (int)17, (int)0, (int)0, (int)5);
        this.addBtn.addActionListener(new AddKeyListener());
        this.addBtn.setActionCommand(ADD);
        jLabel = new JLabel();
        this.setLabelMnemonic(jLabel, "mu_wiz_userstoadd");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)15, (int)5, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.white);
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)5, (int)0, (int)5);
        this.scrollPane = new JScrollPane(20, 31);
        Dimension dimension = new Dimension(100, 80);
        this.scrollPane.setPreferredSize(dimension);
        this.scrollPane.setMinimumSize(dimension);
        Constraints.constrain((Container)jPanel2, (Component)this.scrollPane, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.userTable = new UserTable(this.theApp);
        this.tableMouseListener = new TableMouseListener();
        this.tableFocusListener = new TableFocusListener();
        this.userTable.addFocusListener(this.tableFocusListener);
        this.userTable.addMouseListener(this.tableMouseListener);
        this.userTable.setMinimumSize(this.userTable.getPreferredSize());
        jLabel.setLabelFor(this.userTable);
        this.scrollPane.setViewportView(this.userTable.getUserTable());
        this.deleteBtn = new JButton();
        this.setButtonMnemonic(this.deleteBtn, "mu_wiz_usernames_btn3");
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addActionListener(new DeleteKeyListener());
        this.deleteBtn.setActionCommand(DELETE);
        Constraints.constrain((Container)((Object)this), (Component)this.deleteBtn, (int)1, (int)3, (int)1, (int)1, (int)2, (int)12, (double)1.0, (double)0.0, (int)6, (int)0, (int)0, (int)5);
        this.bottomExplainFA = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_list_explain"));
        Constraints.constrain((Container)((Object)this), (Component)this.bottomExplainFA, (int)0, (int)4, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)5, (int)0, (int)5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel3, (int)0, (int)5, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public void loadHelp() {
        Vector vector = new Vector(5);
        this.infoPanel = this.wiz.getInfoPanel();
        this.userNameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_temp_uname")));
        this.fullNameField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_temp_name")));
        this.descriptionField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_temp_descript")));
        this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_multi_wiz_type_names_step");
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.updateStatus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.getManager().setPrevious(this.getManager().getCurrent(), "selectMethodCard");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), false);
    }

    public boolean stop(boolean bl) {
        this.wiz.setAddType(0);
        Vector vector = this.userTable.getVUsers();
        this.wiz.setNumUsers(vector.size());
        this.wiz.setUserData(vector);
        this.getManager().setNext(this.getManager().getCurrent(), "acctInfoCard");
        return true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight() + (int)this.topExplainFA.getPreferredSize().getHeight() + (int)this.bottomExplainFA.getPreferredSize().getHeight();
        dimension.setSize(new Dimension(n, n2));
        return dimension;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    private void updateStatus() {
        if (this.userTable.getRowCount() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    private void setLabelMnemonic(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private void setButtonMnemonic(AbstractButton abstractButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        abstractButton.setText(this.actionString.getString());
        abstractButton.setMnemonic(this.actionString.getMnemonic());
    }

    private void updateDelete() {
        int n = this.userTable.getSelectedRow();
        if (n >= 0 && this.userTable.getRowCount() > 0 && this.userTable.getValueAt(n, 0) != null && ((String)this.userTable.getValueAt(n, 0)).length() > 0) {
            this.deleteBtn.setEnabled(true);
        } else {
            this.deleteBtn.setEnabled(false);
        }
    }

    class TableMouseListener
    implements MouseListener {
        TableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            AdminMultiUserTypeNamesStep.this.updateDelete();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class TableFocusListener
    implements FocusListener {
        TableFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AdminMultiUserTypeNamesStep.this.updateDelete();
        }

        public void focusLost(FocusEvent focusEvent) {
            AdminMultiUserTypeNamesStep.this.updateDelete();
        }
    }

    class DeleteKeyListener
    implements ActionListener {
        DeleteKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = AdminMultiUserTypeNamesStep.this.userTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                AdminMultiUserTypeNamesStep.this.userTable.removeUser(nArray[n] - n);
                ++n;
            }
            AdminMultiUserTypeNamesStep.this.updateStatus();
            AdminMultiUserTypeNamesStep.this.userTable.clearSelection();
            AdminMultiUserTypeNamesStep.this.deleteBtn.setEnabled(false);
        }
    }

    class AddKeyListener
    implements ActionListener {
        AddKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AdminMultiUserTypeNamesStep.this.userNameField.getText().trim();
            if (string == null || string.length() == 0) {
                return;
            }
            if (Character.getType(string.charAt(0)) == 15) {
                string = string.substring(1);
            }
            if (!CheckSyntax.isNameOK((String)string)) {
                AdminMultiUserTypeNamesStep.this.userNameField.requestFocus();
                new ErrorDialog(null, CheckSyntax.getErrorString());
                return;
            }
            if (AdminMultiUserTypeNamesStep.this.userTable.getUser(string) != null) {
                AdminMultiUserTypeNamesStep.this.userNameField.requestFocus();
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)AdminMultiUserTypeNamesStep.this.bundle, (String)"mu_wiz_uid_exist_err"));
                return;
            }
            String string2 = AdminMultiUserTypeNamesStep.this.fullNameField.getText().trim();
            String string3 = AdminMultiUserTypeNamesStep.this.descriptionField.getText().trim();
            String[] stringArray = new String[]{new String(string), new String(string2), new String(string3)};
            AdminMultiUserTypeNamesStep.this.userTable.addUser(stringArray);
            AdminMultiUserTypeNamesStep.this.updateStatus();
            AdminMultiUserTypeNamesStep.this.userNameField.setText("");
            AdminMultiUserTypeNamesStep.this.fullNameField.setText("");
            AdminMultiUserTypeNamesStep.this.descriptionField.setText("");
        }
    }

    class EnterKeyListener
    extends KeyAdapter {
        EnterKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (AdminMultiUserTypeNamesStep.this.userNameField.hasFocus()) {
                    AdminMultiUserTypeNamesStep.this.fullNameField.requestFocus();
                } else if (AdminMultiUserTypeNamesStep.this.fullNameField.hasFocus()) {
                    AdminMultiUserTypeNamesStep.this.descriptionField.requestFocus();
                } else if (AdminMultiUserTypeNamesStep.this.descriptionField.hasFocus()) {
                    // empty if block
                }
            }
        }
    }
}

