/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.RoleGenProps;
import com.sun.admin.usermgr.client.rbac.RoleGrpProps;
import com.sun.admin.usermgr.client.rbac.RoleHdirProps;
import com.sun.admin.usermgr.client.rbac.RolePassProps;
import com.sun.admin.usermgr.client.rbac.RoleRightsProps;
import com.sun.admin.usermgr.client.rbac.RoleUsersProps;
import com.sun.admin.usermgr.client.users.SolProjProps;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoleTabs
extends JTabbedPane {
    private UserObj userObj = null;
    private GenInfoPanel infoPanel;
    private RoleGenProps roleGenProps;
    private RolePassProps rolePassProps;
    private RoleUsersProps roleUsersProps;
    private RoleGrpProps roleGrpProps;
    private RoleHdirProps roleHdirProps;
    private RoleRightsProps roleRightsProps;
    private SolProjProps solProjProps;
    private boolean isGenVisited = true;
    private boolean isPassVisited = false;
    private boolean isUsersVisited = false;
    private boolean isGrpVisited = false;
    private boolean isHdirVisited = false;
    private boolean isRightsVisited = false;
    private boolean isProjectsVisited = false;
    private boolean showProjectTab = true;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ServiceWrapper userMgrClient;

    public RoleTabs(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.theApp = vUserMgr;
        this.userObj = userObj;
        this.infoPanel = genInfoPanel;
        this.userMgrClient = vUserMgr.getUserMgr();
        this.bundle = vUserMgr.getResourceBundle();
        this.RoleTabsInit();
    }

    private void RoleTabsInit() {
        RoleTabsListener roleTabsListener = new RoleTabsListener();
        this.addChangeListener(roleTabsListener);
        this.addFocusListener(new TabPaneFocusListener(roleTabsListener));
        ServiceWrapper serviceWrapper = this.theApp.getUserMgr();
        this.showProjectTab = serviceWrapper.MOFContainsProject();
        this.setupSolTabs(this.userObj);
    }

    private void setupSolTabs(UserObj userObj) {
        this.roleGenProps = new RoleGenProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_general"), null, this.roleGenProps);
        if (this.userMgrClient.hasUserMgrPasswdAuth()) {
            this.rolePassProps = new RolePassProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_password"), null, this.rolePassProps);
        }
        if (this.canUserAssignThisRole()) {
            this.roleUsersProps = new RoleUsersProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_users"), null, this.roleUsersProps);
        }
        this.roleGrpProps = new RoleGrpProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_grp"), null, this.roleGrpProps);
        if (this.showProjectTab) {
            this.solProjProps = new SolProjProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_tabs_proj"), null, this.solProjProps);
        }
        this.roleHdirProps = new RoleHdirProps(this.theApp, userObj, this.infoPanel);
        this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_hdir"), null, this.roleHdirProps);
        if (this.userMgrClient.hasProfMgrAssignAuth() || this.userMgrClient.hasProfMgrDelegateAuth()) {
            this.roleRightsProps = new RoleRightsProps(this.theApp, userObj, this.infoPanel);
            this.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_tabs_rights"), null, this.roleRightsProps);
        }
    }

    private boolean canUserAssignThisRole() {
        if (this.userMgrClient.hasRoleMgrAssignAuth()) {
            return true;
        }
        if (this.userMgrClient.hasRoleMgrDelegateAuth()) {
            String[] stringArray;
            String string = this.theApp.getAuthenticatedUser();
            if (this.theApp.isRoleAssumed()) {
                stringArray = new String[]{string};
            } else {
                stringArray = this.theApp.getAdminRoleCache();
                if (stringArray == null) {
                    try {
                        stringArray = this.theApp.getUserMgr().getUserRoles(string);
                        this.theApp.setAdminRoleCache(stringArray);
                    }
                    catch (AdminException adminException) {
                        // empty catch block
                    }
                    if (stringArray == null || stringArray.length < 1) {
                        return false;
                    }
                }
            }
            String string2 = this.userObj.getUserName();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public boolean isUpdatePropsOK(UserObj userObj) {
        UserObj userObj2 = userObj;
        UserObj userObj3 = (UserObj)userObj.clone();
        boolean bl = false;
        if (this.isGenVisited) {
            if (this.roleGenProps.isUserNameSyntaxOK() && this.roleGenProps.isDescriptionSyntaxOK()) {
                bl = true;
                userObj3 = this.roleGenProps.updateGenProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isPassVisited) {
            bl = true;
            userObj3 = this.rolePassProps.updatePassProps(userObj3);
            if (!this.rolePassProps.getPasswordGood()) {
                return false;
            }
        }
        if (this.isUsersVisited) {
            bl = true;
            userObj3 = this.roleUsersProps.updateUsersProps(userObj3);
        }
        if (this.isGrpVisited) {
            if (this.roleGrpProps.checkNumberSecondaryGroups()) {
                bl = true;
                userObj3 = this.roleGrpProps.updateGrpProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isHdirVisited) {
            if (this.roleHdirProps.isHdirSyntaxOK()) {
                bl = true;
                userObj3 = this.roleHdirProps.updateHdirProps(userObj3);
            } else {
                return false;
            }
        }
        if (this.isRightsVisited) {
            bl = true;
            userObj3 = this.roleRightsProps.updateRightsProps(userObj3);
        }
        if (this.showProjectTab && this.isProjectsVisited) {
            bl = true;
            userObj3 = this.solProjProps.updateProjProps(userObj3);
        }
        if (bl) {
            block31: {
                boolean bl2 = false;
                String string = userObj2.getUserName();
                String string2 = userObj3.getUserName();
                String string3 = userObj2.getUserDescription();
                String string4 = userObj3.getUserDescription();
                if (!string.equals(string2) || !string3.equals(string4)) {
                    bl2 = true;
                }
                try {
                    if (userObj3.requireModify() || !userObj3.equals(userObj2)) {
                        UserObj userObj4 = this.userMgrClient.modifyUser(userObj3, userObj2);
                        if (bl2) {
                            Content content = this.theApp.getTree().getCurrentContent();
                            Vector vector = content.getSelected();
                            VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                            vScopeNode.setText(string2);
                            vScopeNode.setDescription(string4);
                            vScopeNode.setPayload((Object)userObj4);
                            this.updateResultsView(content);
                        }
                    }
                }
                catch (SolServerPartialSuccessException solServerPartialSuccessException) {
                    Object object;
                    PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
                    if (partialSuccessObject != null) {
                        if (partialSuccessObject.getHomedirFailed()) {
                            object = partialSuccessObject.getHomedirException();
                            if (object != null) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                            }
                        } else if (partialSuccessObject.getMailboxFailed()) {
                            object = partialSuccessObject.getMailboxException();
                            if (object != null) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), ((Throwable)object).getLocalizedMessage(), true);
                            }
                        } else {
                            object = solServerPartialSuccessException.getLocalizedMessage();
                            if (object != null && !((String)object).equals("")) {
                                new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_information"), (String)object, true);
                            }
                        }
                    }
                    if (bl2) {
                        object = this.theApp.getTree().getCurrentContent();
                        Vector vector = ((Content)object).getSelected();
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                        vScopeNode.setText(string2);
                        vScopeNode.setDescription(string4);
                        vScopeNode.setPayload((Object)userObj3);
                        this.updateResultsView((Content)object);
                    }
                }
                catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
                    this.theApp.reportErrorException((Exception)((Object)userMgrNameAlreadyInUseException));
                    return false;
                }
                catch (Exception exception) {
                    String string5 = exception.getLocalizedMessage();
                    if (string5 == null || string5.equals("")) break block31;
                    new ErrorDialog(this.theApp.getFrame(), string5);
                }
            }
            return true;
        }
        return false;
    }

    private void updateResultsView(Content content) {
        final VScopeNode vScopeNode = content.getTreeNode();
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)RoleTabs.this.theApp, "vconsole.updatescope", (Object)vScopeNode);
                        RoleTabs.this.theApp.fireConsoleAction(vConsoleEvent);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)vScopeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
    }

    class TabPaneFocusListener
    implements FocusListener {
        RoleTabsListener cl;

        public TabPaneFocusListener(RoleTabsListener roleTabsListener) {
            this.cl = roleTabsListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.cl.stateChanged(new ChangeEvent(focusEvent.getComponent()));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class RoleTabsListener
    implements ChangeListener {
        RoleTabsListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FocusListener focusListener;
            try {
                if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.roleGenProps) {
                    RoleTabs.this.roleGenProps.requestFocus();
                    RoleTabs.this.isGenVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.rolePassProps) {
                    RoleTabs.this.rolePassProps.requestFocus();
                    RoleTabs.this.isPassVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.roleUsersProps) {
                    RoleTabs.this.roleUsersProps.requestFocus();
                    RoleTabs.this.isUsersVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.roleGrpProps) {
                    RoleTabs.this.roleGrpProps.requestFocus();
                    RoleTabs.this.isGrpVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.roleHdirProps) {
                    RoleTabs.this.roleHdirProps.requestFocus();
                    RoleTabs.this.isHdirVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.roleRightsProps) {
                    RoleTabs.this.roleRightsProps.requestFocus();
                    RoleTabs.this.isRightsVisited = true;
                } else if (RoleTabs.this.getSelectedComponent() == RoleTabs.this.solProjProps) {
                    RoleTabs.this.solProjProps.requestFocus();
                    RoleTabs.this.isProjectsVisited = true;
                }
            }
            catch (Exception exception) {
                RoleTabs.this.theApp.reportErrorException(exception);
            }
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)jTabbedPane.getSelectedComponent();
            if (uMgrPropsPanel != null && (focusListener = uMgrPropsPanel.getFocusListener()) != null) {
                focusListener.focusGained(new FocusEvent(jTabbedPane, 1004));
            }
        }
    }
}

