/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.AddRoleWizard;
import com.sun.admin.usermgr.client.rbac.AssignRightDlg;
import com.sun.admin.usermgr.client.rbac.AssignRoleDlg;
import com.sun.admin.usermgr.client.rbac.ConfDelRolePanel;
import com.sun.admin.usermgr.client.rbac.RolePropsDlg;
import com.sun.admin.usermgr.client.rbac.UMgrRoleMenuBar;
import com.sun.admin.usermgr.client.rbac.UMgrRoleTBar;
import com.sun.admin.usermgr.client.users.UserPoliciesDlg;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.services.PersistenceAgent;
import com.sun.management.viper.services.PersistenceException;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class RoleContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ImageIcon smallRoleIcon;
    private ImageIcon largeRoleIcon;
    private UMgrRoleMenuBar roleMenuBar;
    private UMgrRoleTBar roleToolBar;
    private VUserMgr theApp;
    RoleContent roleContent;

    public RoleContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.roleContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.roleMenuBar = new UMgrRoleMenuBar(vUserMgr, this);
        this.roleToolBar = new UMgrRoleTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.roleMenuBar);
        this.rootNode.setToolBar((JToolBar)this.roleToolBar);
        this.smallRoleIcon = vUserMgr.loadImageIcon("admin_roles_16.gif", "");
        this.largeRoleIcon = vUserMgr.loadImageIcon("admin_roles_32.gif", "");
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_user_desc"), new Integer(32)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    protected void setListProperties(ListProperties listProperties) {
    }

    protected ListProperties getListProperties() {
        return null;
    }

    public UMgrRoleMenuBar getMenuBar() {
        return this.roleMenuBar;
    }

    public UMgrRoleTBar getToolBar() {
        return this.roleToolBar;
    }

    public void refresh() {
        this.theApp.setAdminRoleCache(null);
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    RoleContent.this.theApp.waitOff();
                    return;
                }
                RoleContent.this.updateStatusBar();
                RoleContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                RoleContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    public void assignRole() {
        this.theApp.waitOn();
        AssignRoleDlg assignRoleDlg = new AssignRoleDlg(this.theApp, this.theApp.getFrame());
        if (!assignRoleDlg.canDisplayDialog()) {
            assignRoleDlg.dispose();
            this.theApp.waitOff();
            return;
        }
        assignRoleDlg.setVisible(true);
        this.theApp.waitOff();
    }

    public void assignRight() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        this.theApp.waitOn();
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        UserObj userObj = (UserObj)vScopeNode.getPayload();
        try {
            userObj = this.theApp.getUserMgr().getFullAttributes(userObj);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            return;
        }
        AssignRightDlg assignRightDlg = new AssignRightDlg(this.theApp, this.theApp.getFrame(), userObj, true);
        assignRightDlg.setVisible(true);
        this.theApp.waitOff();
    }

    public void createProperties() {
        this.theApp.waitOn();
        AddRoleWizard addRoleWizard = new AddRoleWizard(this.theApp, this.roleContent, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"role_add_wiz_tile"));
        Container container = null;
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        try {
            String string = vConsoleProperties.getProperty("vconsole.dialogtype");
            if (string == null || string.equals("vconsole.frame")) {
                JFrame jFrame;
                container = jFrame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
                if (jFrame == null) {
                    jFrame = new JFrame();
                }
                VDialog vDialog = new VDialog((Frame)jFrame, true);
                addRoleWizard.setContainer((Component)vDialog);
                vDialog.pack();
            } else if (string.equals("vconsole.internalframe")) {
                JInternalFrame jInternalFrame = new JInternalFrame();
                addRoleWizard.setContainer(jInternalFrame);
                jInternalFrame.setSize(addRoleWizard.getPreferredSize());
                JDesktopPane jDesktopPane = (JDesktopPane)vConsoleProperties.getPropertyObject("vconsole.desktoppane");
                jDesktopPane.add(jInternalFrame);
                container = jDesktopPane;
            }
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
        }
        addRoleWizard.reset();
        addRoleWizard.start();
        if (container != null) {
            addRoleWizard.showCenter(container);
        }
        this.theApp.waitOff();
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        this.theApp.waitOn();
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        UserObj userObj = (UserObj)vScopeNode.getPayload();
        try {
            userObj = this.theApp.getUserMgr().getFullAttributes(userObj);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            return;
        }
        RolePropsDlg rolePropsDlg = new RolePropsDlg(this.theApp, this.theApp.getFrame(), userObj);
        rolePropsDlg.setVisible(true);
        this.theApp.waitOff();
    }

    public void deleteSelected() {
        final ConfDelRolePanel confDelRolePanel = new ConfDelRolePanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_role"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                        UserObj userObj = (UserObj)vScopeNode.getPayload();
                        if (confDelRolePanel.delHomeDir()) {
                            userObj.setDelHomeDir(true);
                        }
                        String string = userObj.getUserName();
                        RoleContent.this.theApp.getUserMgr().deleteUser(userObj);
                        PersistenceAgent persistenceAgent = null;
                        try {
                            persistenceAgent = new PersistenceAgent(RoleContent.this.theApp.getToolInfrastructure());
                            String string2 = UserPoliciesDlg.USER_POLICIES + string;
                            if (persistenceAgent != null) {
                                persistenceAgent.delete(string2);
                            }
                        }
                        catch (PersistenceException persistenceException) {
                            // empty catch block
                        }
                        RoleContent.this.theApp.setAllRolesCache(null);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, userObj){
                                    private final /* synthetic */ UserObj val$userObj;
                                    private final /* synthetic */ 2 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$userObj = userObj;
                                    }

                                    public void run() {
                                        RoleContent.access$200(2.access$100(this.this$1), this.val$userObj);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        } else {
                            RoleContent.this.removeFromResultsPane(userObj);
                        }
                    }
                    catch (AdminException adminException) {
                        RoleContent.this.theApp.reportErrorException((Exception)((Object)adminException));
                    }
                    ++n;
                }
            }

            static /* synthetic */ RoleContent access$100(2 var0) {
                return var0.RoleContent.this;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelRolePanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public void renameSelected() {
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"roles");
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"RoleListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void appendToResultsPane(Vector vector) {
        UserObj userObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/roles.html", this.theApp.getClass());
        int n = 0;
        while (n < vector.size()) {
            userObj = (UserObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.roleMenuBar.getPopupMenu(), this.smallRoleIcon, this.largeRoleIcon, userObj.getUserName(), null, null, -1, (Object)userObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setDescription(userObj.getUserDescription());
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(userObj);
            ++n;
        }
        userObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)userObj);
    }

    private void removeFromResultsPane(UserObj userObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            UserObj userObj2 = (UserObj)vScopeNode.getPayload();
            if (userObj2 == userObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.roleMenuBar);
        this.rootNode.setToolBar((JToolBar)this.roleToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;

        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public Vector listAll() throws AdminException {
            Vector vector = null;
            try {
                vector = RoleContent.this.theApp.getUserMgr().getAllRoles();
                RoleContent.this.theApp.setAllRolesCache(vector);
            }
            catch (Exception exception) {
                RoleContent.this.theApp.reportErrorException(exception);
            }
            if (vector == null) {
                return new Vector();
            }
            return vector;
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)RoleContent.this.bundle, (String)"roles");
        }
    }
}

