/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.DblTreeNode;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelPanel;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.CommandDef;
import com.sun.admin.usermgr.client.rbac.CommandsMethodRenderer;
import com.sun.admin.usermgr.client.rbac.Pathname;
import com.sun.admin.usermgr.client.rbac.RightAddDirDlg;
import com.sun.admin.usermgr.client.rbac.RightCmdAttrDlg;
import com.sun.admin.usermgr.common.ExecAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class RightCmdProps
extends UMgrPropsPanel {
    private RightCmdProps rightCmdProps;
    private GenInfoPanel infoPanel;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private String rightName;
    public static final String type = "cmd";
    private String policy;
    public static SelPanel commandsBox;
    private JButton addDirectoryBtn;
    private JButton setSecurityAttrBtn;
    private JButton findBtn;
    private JTextField findField;
    private String findString;
    private DefaultTreeModel srcModel;
    private DefaultTreeModel dstModel;
    private DblTreeNode srcRoot;
    private DblTreeNode dstRoot;
    private boolean isCmd;
    private String selectDstNodeString;
    private DblTreeNode selectDstNode;
    private ExecAttrObj selectExecAttr;
    private RightCmdAttrDlg cmdAttrDlg = null;
    private boolean isNew;
    private ActionString actionString;
    private ExecAttrObj rootExecAttr;
    private ArrayList saveDiffTypeExecAttrs = new ArrayList();

    public RightCmdProps(VUserMgr vUserMgr, GenInfoPanel genInfoPanel) {
        this.infoPanel = genInfoPanel;
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.policy = vUserMgr.getApplicationContext().getExecPolicy();
        this.rightCmdProps = this;
        this.createGui();
        Vector vector = new Vector(40);
        this.addDirectoryBtn.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_cmds_dir")));
        this.setSecurityAttrBtn.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_cmds_attrib")));
        this.findField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_cmds_path")));
        this.findBtn.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_cmds_find")));
        this.focusListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_cmds");
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)RightCmdProps.this.getFocusListener())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        this.loadCommandTree();
        this.setTreeListeners();
        this.setBtnListeners();
    }

    public void loadRight(RightObj rightObj, boolean bl) {
        this.saveDiffTypeExecAttrs = new ArrayList();
        ArrayList arrayList = new ArrayList();
        this.isNew = bl;
        this.rightName = rightObj.getRightName();
        if (!this.isNew) {
            if (rightObj.getExecAttrs() != null) {
                arrayList = rightObj.getExecAttrs();
            } else {
                try {
                    ExecAttrObj[] execAttrObjArray = this.theApp.getUserMgr().readExecAttrs(this.rightName, null, this.policy);
                    if (execAttrObjArray != null) {
                        int n = 0;
                        while (n < execAttrObjArray.length) {
                            arrayList.add(execAttrObjArray[n]);
                            ++n;
                        }
                    }
                    rightObj.setExecAttrs(arrayList);
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                }
            }
        }
        commandsBox.resetAll();
        if (this.isNew) {
            commandsBox.setInitSelection();
            return;
        }
        if (arrayList == null) {
            commandsBox.setInitSelection();
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(n);
            if (!execAttrObj.getType().equals(type)) {
                this.saveDiffTypeExecAttrs.add(execAttrObj);
            } else {
                String string = execAttrObj.getId();
                if (string.equals("*")) {
                    this.rootExecAttr = (ExecAttrObj)execAttrObj.clone();
                    CommandDef commandDef = (CommandDef)this.dstRoot.getUserObject();
                    commandDef.setExecAttr(this.rootExecAttr);
                    commandsBox.moveAll(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree);
                    break;
                }
                String string2 = "";
                String string3 = "";
                int n2 = string.length();
                int n3 = string.lastIndexOf("/");
                if (n3 > -1) {
                    string2 = string.substring(0, n3);
                    string3 = string.substring(n3 + 1, n2);
                }
                if (string3.equals("*")) {
                    this.movePathToDstTree(string2, execAttrObj);
                } else {
                    this.moveCommandToDstTree(string2, string3, execAttrObj);
                }
            }
            ++n;
        }
        commandsBox.setInitSelection();
    }

    private void createGui() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        commandsBox = new SelPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_command_denied"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_command_permitted"));
        RightCmdProps.commandsBox.srcTree.setCellRenderer(new CommandsMethodRenderer(this.rightCmdProps));
        RightCmdProps.commandsBox.dstTree.setCellRenderer(new CommandsMethodRenderer(this.rightCmdProps));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.addDirectoryBtn = new JButton();
        this.setUpButton(this.addDirectoryBtn, "right_add_directory");
        this.addDirectoryBtn.setEnabled(true);
        this.setSecurityAttrBtn = new JButton();
        this.setUpButton(this.setSecurityAttrBtn, "right_set_security_attr");
        this.setSecurityAttrBtn.setEnabled(false);
        this.findBtn = new JButton();
        this.setUpButton(this.findBtn, "right_find");
        this.findBtn.setEnabled(true);
        this.findField = new JTextField(40);
        this.findField.setMinimumSize(this.findField.getPreferredSize());
        this.findField.setEnabled(true);
        this.findField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdProps.this.findString = RightCmdProps.this.findField.getText();
            }
        });
        Constraints.constrain((Container)jPanel, (Component)this.addDirectoryBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)10, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.setSecurityAttrBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)0, (int)0, (int)10, (int)10);
        Constraints.constrain((Container)jPanel, (Component)this.findField, (int)0, (int)1, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)10, (int)10, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.findBtn, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)10, (int)10);
        Constraints.constrain((Container)this, (Component)commandsBox, (int)0, (int)0, (int)1, (int)1, (int)1, (int)11, (double)1.0, (double)1.0, (int)10, (int)10, (int)0, (int)0);
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)15, (double)0.0, (double)0.0, (int)10, (int)10, (int)0, (int)0);
    }

    private void loadCommandTree() {
        String[] stringArray = new String[]{"/usr/bin", "/usr/sbin"};
        this.srcModel = (DefaultTreeModel)RightCmdProps.commandsBox.srcTree.getModel();
        this.srcRoot = (DblTreeNode)this.srcModel.getRoot();
        this.dstModel = (DefaultTreeModel)RightCmdProps.commandsBox.dstTree.getModel();
        this.dstRoot = (DblTreeNode)this.dstModel.getRoot();
        this.rootExecAttr = new ExecAttrObj(this.rightName);
        this.rootExecAttr.setPolicy(this.policy);
        this.rootExecAttr.setType(type);
        this.rootExecAttr.setId("*");
        CommandDef commandDef = new CommandDef(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"all_cmds"));
        commandDef.path = "";
        commandDef.setExecAttr(this.rootExecAttr);
        this.dstRoot.setUserObject((Object)commandDef);
        DblTreeNode[] dblTreeNodeArray = new DblTreeNode[stringArray.length];
        Pathname[] pathnameArray = new Pathname[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            pathnameArray[n] = new Pathname(stringArray[n]);
            pathnameArray[n].description = "a new path";
            dblTreeNodeArray[n] = new DblTreeNode((Object)pathnameArray[n]);
            String[] stringArray2 = null;
            try {
                stringArray2 = this.theApp.getUserMgr().getExecutables(stringArray[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n2 = 0;
            while (n2 < stringArray2.length) {
                commandDef = new CommandDef(stringArray2[n2]);
                commandDef.description = stringArray2[n2] + " man page";
                commandDef.path = stringArray[n];
                DblTreeNode dblTreeNode = new DblTreeNode((Object)commandDef);
                dblTreeNodeArray[n].add((MutableTreeNode)dblTreeNode);
                ++n2;
            }
            if (stringArray2.length > 0) {
                this.srcModel.insertNodeInto((MutableTreeNode)dblTreeNodeArray[n], (MutableTreeNode)this.srcRoot, n);
                TreePath treePath = new TreePath(dblTreeNodeArray[n].getPath());
                RightCmdProps.commandsBox.srcTree.scrollPathToVisible(treePath);
                RightCmdProps.commandsBox.srcTree.expandPath(treePath);
            }
            ++n;
        }
        commandsBox.setInitSelection();
    }

    private void setTreeListeners() {
        RightCmdProps.commandsBox.dstTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RightCmdProps.this.handleDstNodeSelect(treeSelectionEvent);
            }
        });
        RightCmdProps.commandsBox.srcTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RightCmdProps.this.handleSrcNodeSelect(treeSelectionEvent);
            }
        });
        this.srcModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                RightCmdProps.this.removeExecAttr(treeModelEvent);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                RightCmdProps.this.addExecAttr(treeModelEvent);
            }

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    private void setBtnListeners() {
        this.addDirectoryBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdProps.this.addDirectory();
            }
        });
        this.setSecurityAttrBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdProps.this.setSecurityAttributes();
            }
        });
        this.findBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdProps.this.findString = RightCmdProps.this.findField.getSelectedText();
                if (RightCmdProps.this.findString == null) {
                    RightCmdProps.this.findString = RightCmdProps.this.findField.getText();
                }
                if (!commandsBox.findNode(RightCmdProps.this.findString)) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    String string = RightCmdProps.this.findField.getText();
                    int n = string.indexOf(RightCmdProps.this.findString);
                    RightCmdProps.this.findField.setSelectionStart(n);
                    RightCmdProps.this.findField.setSelectionEnd(n + RightCmdProps.this.findString.length());
                }
            }
        });
    }

    private void movePathToDstTree(String string, ExecAttrObj execAttrObj) {
        DblTreeNode dblTreeNode;
        int n = 0;
        Enumeration enumeration = this.srcRoot.children();
        while (enumeration.hasMoreElements()) {
            dblTreeNode = (DblTreeNode)enumeration.nextElement();
            int n2 = string.compareTo(dblTreeNode.toString());
            if (n2 == 0) {
                Pathname pathname = (Pathname)dblTreeNode.getUserObject();
                pathname.setExecAttr(execAttrObj);
                commandsBox.moveBranch(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree, dblTreeNode, true, false);
                return;
            }
            if (n2 <= 0) break;
            ++n;
        }
        String[] stringArray = null;
        try {
            stringArray = this.theApp.getUserMgr().getExecutables(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length == 0) {
            return;
        }
        Pathname pathname = new Pathname(string);
        dblTreeNode = new DblTreeNode((Object)pathname);
        int n3 = 0;
        while (n3 < stringArray.length) {
            CommandDef commandDef = new CommandDef(stringArray[n3]);
            commandDef.description = stringArray[n3] + " man page";
            commandDef.path = string;
            DblTreeNode dblTreeNode2 = new DblTreeNode((Object)commandDef);
            dblTreeNode.add((MutableTreeNode)dblTreeNode2);
            ++n3;
        }
        this.srcModel.insertNodeInto((MutableTreeNode)dblTreeNode, (MutableTreeNode)this.srcRoot, n);
        pathname.setExecAttr(execAttrObj);
        commandsBox.moveBranch(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree, dblTreeNode, true, false);
    }

    private void moveCommandToDstTree(String string, String string2, ExecAttrObj execAttrObj) {
        CommandDef commandDef;
        Enumeration enumeration = this.srcRoot.children();
        String string3 = string.concat("/");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            DblTreeNode dblTreeNode = (DblTreeNode)enumeration.nextElement();
            String string4 = dblTreeNode.toString();
            int n2 = string4.compareTo(string);
            if (n2 == 0) {
                Enumeration enumeration2 = dblTreeNode.children();
                int n3 = 0;
                while (enumeration2.hasMoreElements()) {
                    DblTreeNode dblTreeNode2 = (DblTreeNode)enumeration2.nextElement();
                    String string5 = dblTreeNode2.toString();
                    int n4 = string5.compareTo(string2);
                    if (n4 == 0) {
                        String string6 = string3.concat(string2);
                        ExecAttrObj execAttrObj2 = (ExecAttrObj)execAttrObj.clone();
                        execAttrObj2.setId(string6);
                        CommandDef commandDef2 = (CommandDef)dblTreeNode2.getUserObject();
                        commandDef2.setExecAttr(execAttrObj2);
                        commandsBox.initLeaf(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree, dblTreeNode2);
                        return;
                    }
                    if (n4 < 0) {
                        ++n3;
                        continue;
                    }
                    CommandDef commandDef3 = new CommandDef(string2);
                    commandDef3.description = string2 + " man page";
                    commandDef3.path = string;
                    DblTreeNode dblTreeNode3 = new DblTreeNode((Object)commandDef3);
                    this.srcModel.insertNodeInto((MutableTreeNode)dblTreeNode3, (MutableTreeNode)dblTreeNode, n3);
                    String string7 = string3.concat(string2);
                    ExecAttrObj execAttrObj3 = (ExecAttrObj)execAttrObj.clone();
                    execAttrObj3.setId(string7);
                    CommandDef commandDef4 = (CommandDef)dblTreeNode2.getUserObject();
                    commandDef4.setExecAttr(execAttrObj3);
                    commandsBox.initLeaf(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree, dblTreeNode3);
                    return;
                }
                continue;
            }
            if (n2 >= 0) break;
            ++n;
        }
        String[] stringArray = null;
        try {
            stringArray = this.theApp.getUserMgr().getExecutables(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Pathname pathname = new Pathname(string);
        DblTreeNode dblTreeNode = new DblTreeNode((Object)pathname);
        DblTreeNode dblTreeNode4 = null;
        int n5 = 0;
        while (n5 < stringArray.length) {
            commandDef = new CommandDef(stringArray[n5]);
            commandDef.description = stringArray[n5] + " man page";
            commandDef.path = string;
            DblTreeNode dblTreeNode5 = new DblTreeNode((Object)commandDef);
            if (stringArray[n5].equals(string2)) {
                dblTreeNode4 = dblTreeNode5;
            }
            dblTreeNode.add((MutableTreeNode)dblTreeNode5);
            ++n5;
        }
        if (dblTreeNode4 == null) {
            commandDef = new CommandDef(string2);
            commandDef.description = string2 + " man page";
            commandDef.path = string;
            dblTreeNode4 = new DblTreeNode((Object)commandDef);
            dblTreeNode.add((MutableTreeNode)dblTreeNode4);
        }
        this.srcModel.insertNodeInto((MutableTreeNode)dblTreeNode, (MutableTreeNode)this.srcRoot, n);
        if (dblTreeNode4 != null) {
            String string8 = string3.concat(string2);
            commandDef = (ExecAttrObj)execAttrObj.clone();
            commandDef.setId(string8);
            CommandDef commandDef5 = (CommandDef)dblTreeNode4.getUserObject();
            commandDef5.setExecAttr((ExecAttrObj)commandDef);
            commandsBox.initLeaf(RightCmdProps.commandsBox.srcTree, RightCmdProps.commandsBox.dstTree, dblTreeNode4);
        }
    }

    public void addPathToSrcTree(String string) {
        String string2;
        Object object;
        int n = 0;
        String[] stringArray = null;
        try {
            stringArray = this.theApp.getUserMgr().getExecutables(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length == 0) {
            System.out.println("Specified directory has no commands");
            return;
        }
        Enumeration enumeration = this.srcRoot.children();
        while (enumeration.hasMoreElements()) {
            object = (DblTreeNode)enumeration.nextElement();
            string2 = object.toString();
            int n2 = string2.compareTo(string);
            if (n2 == 0) {
                System.out.println("Directory already exists");
                return;
            }
            if (n2 >= 0) break;
            ++n;
        }
        object = new Pathname(string);
        string2 = new DblTreeNode(object);
        int n3 = 0;
        while (n3 < stringArray.length) {
            CommandDef commandDef = new CommandDef(stringArray[n3]);
            commandDef.description = stringArray[n3] + " man page";
            commandDef.path = string;
            DblTreeNode dblTreeNode = new DblTreeNode((Object)commandDef);
            string2.add((MutableTreeNode)dblTreeNode);
            ++n3;
        }
        this.srcModel.insertNodeInto((MutableTreeNode)((Object)string2), (MutableTreeNode)this.srcRoot, n);
    }

    private void removeExecAttr(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        DblTreeNode dblTreeNode = (DblTreeNode)objectArray[0];
        if (dblTreeNode.getUserObject() instanceof Pathname) {
            Pathname pathname = (Pathname)dblTreeNode.getUserObject();
            pathname.setExecAttr(null);
        } else {
            CommandDef commandDef = (CommandDef)dblTreeNode.getUserObject();
            commandDef.setExecAttr(null);
        }
    }

    private void addExecAttr(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        DblTreeNode dblTreeNode = (DblTreeNode)objectArray[0];
        String string = dblTreeNode.toString();
        if (dblTreeNode.getUserObject() instanceof Pathname) {
            Pathname pathname = (Pathname)dblTreeNode.getUserObject();
            ExecAttrObj execAttrObj = pathname.getExecAttr();
            if (execAttrObj == null) {
                execAttrObj = new ExecAttrObj(this.rightName);
                execAttrObj.setPolicy(this.policy);
                execAttrObj.setType(type);
                string = string.concat("/*");
                execAttrObj.setId(string);
                pathname.setExecAttr(execAttrObj);
            }
        } else {
            CommandDef commandDef = (CommandDef)dblTreeNode.getUserObject();
            ExecAttrObj execAttrObj = commandDef.getExecAttr();
            if (execAttrObj == null) {
                String string2 = commandDef.path;
                string2 = string2.concat("/");
                string = string2.concat(string);
                execAttrObj = new ExecAttrObj(this.rightName);
                execAttrObj.setPolicy(this.policy);
                execAttrObj.setType(type);
                execAttrObj.setId(string);
                commandDef.setExecAttr(execAttrObj);
            }
        }
    }

    private void handleDstNodeSelect(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = RightCmdProps.commandsBox.dstTree.getSelectionPath();
        if (treePath != null) {
            DblTreeNode dblTreeNode = (DblTreeNode)RightCmdProps.commandsBox.dstTree.getLastSelectedPathComponent();
            String string = dblTreeNode.toString();
            this.findField.setText(string);
            if (treePath.getPathCount() == 3) {
                this.isCmd = true;
                CommandDef commandDef = (CommandDef)dblTreeNode.getUserObject();
                this.selectExecAttr = commandDef.getExecAttr();
                String string2 = commandDef.path;
                string2 = string2.concat("/");
                this.selectDstNodeString = string = string2.concat(string);
                this.selectDstNode = dblTreeNode;
                this.setSecurityAttrBtn.setEnabled(true);
                this.updateCmdAttrDlg(true, this.selectDstNodeString, this.selectExecAttr);
            } else if (treePath.getPathCount() == 2) {
                Pathname pathname = (Pathname)dblTreeNode.getUserObject();
                this.selectExecAttr = pathname.getExecAttr();
                if (this.selectExecAttr == null) {
                    this.selectExecAttr = new ExecAttrObj(this.rightName);
                    this.selectExecAttr.setType(type);
                    this.selectExecAttr.setPolicy(this.policy);
                    string = string.concat("/*");
                    this.selectExecAttr.setId(string);
                    pathname.setExecAttr(this.selectExecAttr);
                }
                if (this.isExcluded(string)) {
                    this.setSecurityAttrBtn.setEnabled(false);
                    this.selectExecAttr.clearAttributes();
                    this.disposeCmdAttrDlg();
                } else {
                    this.isCmd = false;
                    pathname = (Pathname)dblTreeNode.getUserObject();
                    this.selectExecAttr = pathname.getExecAttr();
                    this.selectDstNodeString = string;
                    this.selectDstNode = dblTreeNode;
                    this.setSecurityAttrBtn.setEnabled(true);
                    this.updateCmdAttrDlg(false, this.selectDstNodeString, this.selectExecAttr);
                }
            } else {
                this.isCmd = true;
                CommandDef commandDef = (CommandDef)dblTreeNode.getUserObject();
                this.selectExecAttr = commandDef.getExecAttr();
                this.selectDstNodeString = string;
                this.selectDstNode = dblTreeNode;
                this.setSecurityAttrBtn.setEnabled(true);
                this.updateCmdAttrDlg(true, this.selectDstNodeString, this.selectExecAttr);
            }
        }
    }

    private void updateCmdAttrDlg(boolean bl, String string, ExecAttrObj execAttrObj) {
        if (this.cmdAttrDlg == null) {
            return;
        }
        this.cmdAttrDlg.updateDlg(bl, string, execAttrObj);
    }

    private void handleSrcNodeSelect(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = RightCmdProps.commandsBox.srcTree.getSelectionPath();
        if (treePath != null) {
            this.setSecurityAttrBtn.setEnabled(false);
            this.disposeCmdAttrDlg();
            DblTreeNode dblTreeNode = (DblTreeNode)RightCmdProps.commandsBox.srcTree.getLastSelectedPathComponent();
            this.findField.setText(dblTreeNode.toString());
        }
    }

    private void setSecurityAttributes() {
        if (this.cmdAttrDlg == null) {
            this.cmdAttrDlg = new RightCmdAttrDlg(this.theApp, (Dialog)this.rightCmdProps.getTopLevelAncestor(), this);
            this.cmdAttrDlg.show();
        }
        if (this.isCmd) {
            CommandDef commandDef = (CommandDef)this.selectDstNode.getUserObject();
            this.selectExecAttr = commandDef.getExecAttr();
        } else {
            Pathname pathname = (Pathname)this.selectDstNode.getUserObject();
            this.selectExecAttr = pathname.getExecAttr();
        }
        this.cmdAttrDlg.updateDlg(this.isCmd, this.selectDstNodeString, this.selectExecAttr);
    }

    public void updateCmdExecAttr(ExecAttrObj execAttrObj) {
        if (this.selectDstNode.getUserObject() instanceof Pathname) {
            Pathname pathname = (Pathname)this.selectDstNode.getUserObject();
            pathname.setExecAttr(execAttrObj);
        } else {
            CommandDef commandDef = (CommandDef)this.selectDstNode.getUserObject();
            commandDef.setExecAttr(execAttrObj);
        }
    }

    private void disposeCmdAttrDlg() {
        if (this.cmdAttrDlg != null) {
            this.cmdAttrDlg.disposeDlg();
            this.cmdAttrDlg = null;
        }
    }

    public void setCmdAttrNull() {
        this.cmdAttrDlg = null;
    }

    private void addDirectory() {
        RightAddDirDlg rightAddDirDlg = new RightAddDirDlg(this.theApp, this.theApp.getFrame(), this);
        rightAddDirDlg.show();
    }

    private boolean isExcluded(String string) {
        Enumeration enumeration = this.srcRoot.children();
        while (enumeration.hasMoreElements()) {
            DblTreeNode dblTreeNode = (DblTreeNode)enumeration.nextElement();
            if (string.compareTo(dblTreeNode.toString()) != 0) continue;
            return true;
        }
        return false;
    }

    private void setUpButton(JButton jButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jButton.setText(this.actionString.getString());
        jButton.setMnemonic(this.actionString.getMnemonic());
    }

    public ArrayList getDiffTypeExecAttrs() {
        return this.saveDiffTypeExecAttrs;
    }

    public RightObj updateRightCmdProps(RightObj rightObj) {
        ExecAttrObj execAttrObj;
        CommandDef commandDef;
        ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
        if (this.srcRoot.getChildCount() == 0) {
            commandDef = (CommandDef)this.dstRoot.getUserObject();
            execAttrObj = commandDef.getExecAttr();
            this.rightName = rightObj.getRightName();
            execAttrObj.setProfName(this.rightName);
            arrayList.add(execAttrObj);
        } else {
            Enumeration enumeration = this.dstRoot.children();
            while (enumeration.hasMoreElements()) {
                DblTreeNode dblTreeNode = (DblTreeNode)enumeration.nextElement();
                Pathname pathname = (Pathname)dblTreeNode.getUserObject();
                execAttrObj = pathname.getExecAttr();
                if (execAttrObj != null && !this.isExcluded(pathname.toString()) && !execAttrObj.attrSet.isEmpty()) {
                    arrayList.add(execAttrObj);
                    continue;
                }
                Enumeration enumeration2 = dblTreeNode.children();
                while (enumeration2.hasMoreElements()) {
                    DblTreeNode dblTreeNode2 = (DblTreeNode)enumeration2.nextElement();
                    commandDef = (CommandDef)dblTreeNode2.getUserObject();
                    execAttrObj = commandDef.getExecAttr();
                    arrayList.add(execAttrObj);
                }
            }
        }
        if (this.isNew) {
            this.rightName = rightObj.getRightName();
            int n = 0;
            while (n < arrayList.size()) {
                execAttrObj = (ExecAttrObj)arrayList.get(n);
                execAttrObj.setProfName(this.rightName);
                ++n;
            }
        }
        rightObj.setExecAttrs(arrayList);
        return rightObj;
    }
}

