/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JListEditor;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AssignRoleDlg
extends AdminDialog {
    private JComboBox roleCombo;
    private JListEditor addDelPanel;
    private GenInfoPanel infoPanel;
    private JPanel blankPanel;
    private JButton propOKBtn;
    private JButton propCancelBtn;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private Vector roleNamesVector;
    private String[] roleNamesArray;
    private Vector roleVector;
    private boolean isEmptyList;
    private boolean isRoleInThisScope = true;
    private boolean canDisplay = true;
    private Boolean applyInProgress = new Boolean(false);
    ServiceWrapper userMgr;

    public AssignRoleDlg(VUserMgr vUserMgr, Frame frame) {
        super(frame, "", false);
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.userMgr = vUserMgr.getUserMgr();
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"assign_role_title"));
        this.infoPanel = this.getInfoPanel();
        this.propOKBtn = this.getOKBtn();
        this.propOKBtn.addActionListener(new OKCancelButtonListener());
        this.propOKBtn.setEnabled(false);
        if (vUserMgr.getUserMgr().hasRoleMgrAssignAuth() || vUserMgr.getUserMgr().hasRoleMgrDelegateAuth()) {
            this.propOKBtn.setEnabled(true);
        }
        this.propCancelBtn = this.getCancelBtn();
        this.propCancelBtn.addActionListener(new OKCancelButtonListener());
        this.blankPanel = this.getRightPanel();
        this.blankPanel.add(this.createGui());
        this.pack();
        Vector vector = new Vector(4 + this.roleCombo.getItemCount());
        vUserMgr.addHelpListener(this.roleCombo, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rassign_role"));
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rassign_add");
        UMgrContextHelpListener uMgrContextHelpListener2 = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rassign_del");
        this.addDelPanel.setFocusListeners((FocusListener)((Object)uMgrContextHelpListener), (FocusListener)((Object)uMgrContextHelpListener2), (FocusListener)((Object)uMgrContextHelpListener), (FocusListener)((Object)uMgrContextHelpListener2), null, null);
        this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rassign")), true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        if (!this.isRoleInThisScope) {
            ErrorDialog errorDialog = new ErrorDialog(vUserMgr.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_role_scope"));
            this.canDisplay = false;
        }
    }

    public boolean canDisplayDialog() {
        return this.canDisplay;
    }

    private JPanel createGui() {
        int n = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "role_label");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.initRoleCombo();
        jLabel.setLabelFor(this.roleCombo);
        Constraints.constrain((Container)jPanel, (Component)this.roleCombo, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(jLabel2, "role_assign_users");
        Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        ++n;
        this.addDelPanel = new JListEditor(new Vector(), false);
        this.addDelPanel.setColumns(15);
        this.addDelPanel.setVisibleRows(8);
        this.addDelPanel.setUpAddShortcut();
        jLabel2.setLabelFor((Component)this.addDelPanel);
        Constraints.constrain((Container)jPanel, (Component)this.addDelPanel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
        if (!this.isEmptyList) {
            this.populateListEditor(0);
        }
        return jPanel;
    }

    private void initRoleCombo() {
        this.roleVector = this.theApp.getAllRolesCache();
        if (this.roleVector == null) {
            try {
                this.roleVector = this.theApp.getUserMgr().getAllRoles();
                this.theApp.setAllRolesCache(this.roleVector);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        this.roleNamesVector = new Vector();
        if (this.roleVector == null || this.roleVector.isEmpty()) {
            this.isEmptyList = true;
        } else if (this.theApp.getUserMgr().hasRoleMgrAssignAuth()) {
            this.roleNamesArray = new String[this.roleVector.size()];
            Enumeration enumeration = this.roleVector.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                UserObj userObj = (UserObj)enumeration.nextElement();
                this.roleNamesArray[n] = userObj.getUserName();
                ++n;
            }
            this.isEmptyList = false;
        } else {
            String string = this.theApp.getAuthenticatedUser();
            if (this.theApp.isRoleAssumed()) {
                this.roleNamesArray = new String[1];
                this.roleNamesArray[0] = string;
                this.isRoleInThisScope = false;
                int n = 0;
                while (n < this.roleVector.size()) {
                    UserObj userObj = (UserObj)this.roleVector.elementAt(n);
                    String string2 = userObj.getUserName();
                    if (string.equals(string2)) {
                        this.isRoleInThisScope = true;
                        break;
                    }
                    ++n;
                }
            } else {
                this.roleNamesArray = this.theApp.getAdminRoleCache();
                if (this.roleNamesArray == null) {
                    try {
                        this.roleNamesArray = this.theApp.getUserMgr().getUserRoles(string);
                        this.theApp.setAdminRoleCache(this.roleNamesArray);
                    }
                    catch (AdminException adminException) {
                        // empty catch block
                    }
                    if (this.roleNamesArray == null || this.roleNamesArray.length < 1) {
                        this.isEmptyList = true;
                    } else {
                        this.isEmptyList = false;
                        Sort.sort((String[])this.roleNamesArray);
                    }
                }
            }
            if (!this.isEmptyList) {
                Vector<UserObj> vector = new Vector<UserObj>();
                int n = 0;
                while (n < this.roleNamesArray.length) {
                    int n2 = 0;
                    while (n2 < this.roleVector.size()) {
                        UserObj userObj = (UserObj)this.roleVector.elementAt(n2);
                        String string3 = userObj.getUserName();
                        if (this.roleNamesArray[n].equals(string3)) {
                            vector.addElement(userObj);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                this.roleVector = vector;
            }
        }
        if (this.isEmptyList) {
            this.roleNamesVector.addElement(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_none"));
            this.roleNamesArray = new String[1];
            this.roleNamesArray[0] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templ_none");
            this.propOKBtn.setEnabled(false);
        }
        this.roleCombo = new JComboBox<String>(this.roleNamesArray);
        if (!this.isEmptyList) {
            this.roleCombo.addActionListener(new RoleListActionListener());
        }
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private void populateListEditor(int n) {
        if (!this.isRoleInThisScope) {
            return;
        }
        UserObj userObj = (UserObj)this.roleVector.elementAt(n);
        try {
            userObj = this.theApp.getUserMgr().getFullAttributes(userObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        if (userAttrObj != null) {
            Vector vector = userAttrObj.getAttribute("members");
            if (vector == null) {
                vector = new Vector();
            }
            this.addDelPanel.setOutItems(vector);
        }
    }

    public void onEnterKey() {
    }

    static /* synthetic */ VUserMgr access$400(AssignRoleDlg assignRoleDlg) {
        return assignRoleDlg.theApp;
    }

    static /* synthetic */ JComboBox access$500(AssignRoleDlg assignRoleDlg) {
        return assignRoleDlg.roleCombo;
    }

    static /* synthetic */ Vector access$600(AssignRoleDlg assignRoleDlg) {
        return assignRoleDlg.roleVector;
    }

    static /* synthetic */ JListEditor access$700(AssignRoleDlg assignRoleDlg) {
        return assignRoleDlg.addDelPanel;
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AssignRoleDlg.this.propOKBtn) {
                Boolean bl = AssignRoleDlg.this.applyInProgress;
                synchronized (bl) {
                    if (AssignRoleDlg.this.applyInProgress.booleanValue()) {
                        return;
                    }
                    AssignRoleDlg.this.applyInProgress = Boolean.TRUE;
                }
                Thread thread = new Thread(this){
                    private final /* synthetic */ OKCancelButtonListener this$1;
                    {
                        this.this$1 = oKCancelButtonListener;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        AssignRoleDlg.access$400(OKCancelButtonListener.access$300(this.this$1)).waitOn();
                        int n = AssignRoleDlg.access$500(OKCancelButtonListener.access$300(this.this$1)).getSelectedIndex();
                        UserObj userObj = (UserObj)AssignRoleDlg.access$600(OKCancelButtonListener.access$300(this.this$1)).elementAt(n);
                        try {
                            userObj = AssignRoleDlg.access$400(OKCancelButtonListener.access$300(this.this$1)).getUserMgr().getFullAttributes(userObj);
                        }
                        catch (Exception exception) {
                            AssignRoleDlg.access$400(OKCancelButtonListener.access$300(this.this$1)).reportErrorException(exception);
                        }
                        UserObj userObj2 = (UserObj)userObj.clone();
                        UserAttrObj userAttrObj = userObj2.getSolAuthAttrs();
                        UserAttrObj userAttrObj2 = (UserAttrObj)userAttrObj.clone();
                        Vector vector = AssignRoleDlg.access$700(OKCancelButtonListener.access$300(this.this$1)).getOutItems();
                        if (userAttrObj2 == null) {
                            userAttrObj2 = new UserAttrObj();
                        }
                        userAttrObj2.setAttribute("members", vector);
                        userObj2.setSolAuthAttrs(userAttrObj2);
                        try {
                            object = OKCancelButtonListener.access$300((OKCancelButtonListener)this.this$1).userMgr.modifyUser(userObj2, userObj);
                        }
                        catch (AdminException adminException) {
                            AssignRoleDlg.access$400(OKCancelButtonListener.access$300(this.this$1)).reportErrorException((Exception)((Object)adminException));
                        }
                        OKCancelButtonListener.access$300(this.this$1).dispose();
                        object = AssignRoleDlg.access$200(OKCancelButtonListener.access$300(this.this$1));
                        synchronized (object) {
                            AssignRoleDlg.access$202(OKCancelButtonListener.access$300(this.this$1), Boolean.FALSE);
                        }
                        AssignRoleDlg.access$400(OKCancelButtonListener.access$300(this.this$1)).waitOff();
                    }
                };
                thread.start();
            } else {
                Boolean bl = AssignRoleDlg.this.applyInProgress;
                synchronized (bl) {
                    if (AssignRoleDlg.this.applyInProgress.booleanValue()) {
                        return;
                    }
                }
                AssignRoleDlg.this.dispose();
            }
        }

        static /* synthetic */ AssignRoleDlg access$300(OKCancelButtonListener oKCancelButtonListener) {
            return oKCancelButtonListener.AssignRoleDlg.this;
        }
    }

    class RoleListActionListener
    implements ActionListener {
        RoleListActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)object;
                int n = jComboBox.getSelectedIndex();
                AssignRoleDlg.this.populateListEditor(n);
            }
        }
    }
}

