/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.groups;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ContentEvent;
import com.sun.admin.usermgr.client.ContentListener;
import com.sun.admin.usermgr.client.UserActionsListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.groups.GroupContent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class UMgrGroupTBar
extends JToolBar
implements PropertyChangeListener {
    VUserMgr theApp;
    private ResourceBundle bundle;
    private JButton addGroupBtn;
    private JButton pasteBtn;
    private ContentListener contentListener;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);
    private GroupContent gContent;
    UserActionsListener buttonClickListener;
    private VConsoleProperties properties;
    private ImageIcon newGroupIcon;
    private ImageIcon pasteGroupIcon;
    private static String NEW_GROUP_TEXT;
    private static String PASTE_TEXT;
    private Insets textMargin = new Insets(0, 2, 0, 2);

    public UMgrGroupTBar(VUserMgr vUserMgr, GroupContent groupContent) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        NEW_GROUP_TEXT = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_addgroup");
        PASTE_TEXT = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_grouppaste");
        this.gContent = groupContent;
        this.buttonClickListener = new UserActionsListener(vUserMgr);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addGroupBtn = new JButton();
        this.setUpButton(this.addGroupBtn, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_addgroup"), "New");
        this.defaultBorder = this.addGroupBtn.getBorder();
        Constraints.constrain((Container)this, (Component)this.addGroupBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)5, (int)0, (int)0);
        this.pasteBtn = new JButton();
        this.setUpButton(this.pasteBtn, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_grouppaste"), "Paste");
        Constraints.constrain((Container)this, (Component)this.pasteBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)2, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                UMgrGroupTBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        groupContent.addContentListener(this.contentListener);
        this.newGroupIcon = vUserMgr.loadImageIcon("add_group_tlbr.gif", "");
        this.pasteGroupIcon = vUserMgr.loadImageIcon("paste_user.gif", "");
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void notifySelectionChange(int n) {
        this.properties = this.theApp.getProperties();
        if (n == 1) {
            this.properties.setProperty("vconsole.propertiesenabled", "true");
            this.pasteBtn.setEnabled(true);
        } else {
            this.properties.setProperty("vconsole.propertiesenabled", "false");
            this.pasteBtn.setEnabled(false);
        }
        this.properties.setProperty("vconsole.filterenabled", "true");
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        this.properties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        if (!this.theApp.getUserMgr().hasUserMgrWriteAuth()) {
            this.addGroupBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
            this.properties.setProperty("vconsole.deleteenabled", "false");
        }
    }

    private void setUpButton(JButton jButton, String string, String string2) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        this.setMargin(null);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.buttonClickListener);
    }

    public void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.addGroupBtn, NEW_GROUP_TEXT);
            this.installIcon(this.addGroupBtn, null);
            this.installString(this.pasteBtn, PASTE_TEXT);
            this.installIcon(this.pasteBtn, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.addGroupBtn, null);
            this.installIcon(this.addGroupBtn, this.newGroupIcon);
            this.installString(this.pasteBtn, null);
            this.installIcon(this.pasteBtn, this.pasteGroupIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.addGroupBtn, NEW_GROUP_TEXT);
            this.installIcon(this.addGroupBtn, this.newGroupIcon);
            this.installString(this.pasteBtn, PASTE_TEXT);
            this.installIcon(this.pasteBtn, this.pasteGroupIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            this.setMargin(null);
        }
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(this.theApp.getProperties().getProperty("vconsole.buttondisplay"));
        }
    }
}

