/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.groups;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.groups.GenProps;
import com.sun.admin.usermgr.client.groups.GroupContent;
import com.sun.admin.usermgr.client.groups.GroupProjProps;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GroupTabs
extends JTabbedPane {
    private GroupObj groupObj = null;
    private GenInfoPanel infoPanel;
    private GroupTabs tabPane;
    private Vector tabFocusListeners;
    private GenProps genProps;
    private GroupProjProps projProps;
    private boolean isGenVisited;
    private boolean isProjVisited;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private boolean isNew;
    private GroupContent groupContent;
    private Vector helpCache;

    public GroupTabs(VUserMgr vUserMgr, GroupObj groupObj, GenInfoPanel genInfoPanel, GroupContent groupContent, boolean bl) {
        this.theApp = vUserMgr;
        this.groupObj = groupObj;
        this.groupContent = groupContent;
        this.infoPanel = genInfoPanel;
        this.isNew = bl;
        this.bundle = vUserMgr.getResourceBundle();
        this.isGenVisited = true;
        this.isProjVisited = false;
        this.groupTabsInit();
        this.helpCache = new Vector(40);
    }

    private void groupTabsInit() {
        this.tabPane = this;
        this.setupGroupTabs();
    }

    private void setupGroupTabs() {
        this.genProps = new GenProps(this.theApp, this.groupObj, this.infoPanel, this.groupContent, this.isNew);
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"group_gen");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"group_proj");
        this.tabPane.addTab(string, this.genProps);
        if (!this.theApp.getUserMgr().isEqualScope("nisplus")) {
            this.projProps = new GroupProjProps(this.theApp, this.groupObj, this.infoPanel, this.isNew);
            this.tabPane.addTab(string2, this.projProps);
        }
        TabPaneFocusListener tabPaneFocusListener = new TabPaneFocusListener();
        this.tabPane.addFocusListener(tabPaneFocusListener);
        this.addChangeListener(new GroupTabsListener(tabPaneFocusListener));
        this.tabFocusListeners = new Vector();
        int n = 0;
        while (n < this.tabPane.getTabCount()) {
            UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)this.tabPane.getComponentAt(n);
            UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, uMgrPropsPanel.getHelpName());
            this.tabFocusListeners.addElement(uMgrContextHelpListener);
            ++n;
        }
    }

    public void updateGroup() throws Exception {
        block20: {
            boolean bl = true;
            GroupObj groupObj = this.groupObj;
            GroupObj groupObj2 = (GroupObj)groupObj.clone();
            if (this.isGenVisited) {
                if (this.genProps.isUpdateOK()) {
                    groupObj = this.genProps.updateGen(groupObj);
                } else {
                    bl = false;
                }
            }
            if (this.isProjVisited) {
                groupObj = this.projProps.updateProj(groupObj);
            }
            if (bl) {
                if (this.isNew) {
                    try {
                        this.theApp.getUserMgr().addGroup(groupObj);
                        this.theApp.setAllGroupsCache(null);
                        final Vector<GroupObj> vector = new Vector<GroupObj>(1);
                        vector.addElement(groupObj);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        GroupTabs.this.groupContent.appendToResultsPane(vector);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                            break block20;
                        }
                        this.groupContent.appendToResultsPane(vector);
                    }
                    catch (Exception exception) {
                        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), exception.getLocalizedMessage());
                    }
                } else {
                    if (!groupObj.equals(groupObj2)) {
                        GroupObj groupObj3 = this.theApp.getUserMgr().modifyGroup(groupObj, groupObj2);
                        if (!groupObj2.getGroupName().equals(groupObj3.getGroupName())) {
                            Content content = this.theApp.getTree().getCurrentContent();
                            final VScopeNode vScopeNode = content.getTreeNode();
                            Vector vector = content.getSelected();
                            VScopeNode vScopeNode2 = (VScopeNode)vector.elementAt(0);
                            vScopeNode2.setText(groupObj3.getGroupName());
                            vScopeNode2.setPayload((Object)groupObj3);
                            if (!SwingUtilities.isEventDispatchThread()) {
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)GroupTabs.this.theApp, "vconsole.updatescope", (Object)vScopeNode);
                                            GroupTabs.this.theApp.fireConsoleAction(vConsoleEvent);
                                        }
                                    });
                                }
                                catch (Exception exception) {}
                            } else {
                                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)vScopeNode);
                                this.theApp.fireConsoleAction(vConsoleEvent);
                            }
                        }
                    }
                }
            }
        }
    }

    class TabPaneFocusListener
    implements FocusListener {
        TabPaneFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            GroupTabs.this.tabPane.requestFocus();
            int n = GroupTabs.this.tabPane.getSelectedIndex();
            FocusListener focusListener = (FocusListener)GroupTabs.this.tabFocusListeners.elementAt(n);
            focusListener.focusGained(new FocusEvent(GroupTabs.this.tabPane, 1004));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class GroupTabsListener
    implements ChangeListener {
        private FocusListener focusListener;

        public GroupTabsListener(FocusListener focusListener) {
            this.focusListener = focusListener;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.focusListener.focusGained(new FocusEvent(GroupTabs.this.tabPane, 1004));
            try {
                UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)GroupTabs.this.tabPane.getSelectedComponent();
                if (uMgrPropsPanel == GroupTabs.this.genProps) {
                    GroupTabs.this.isGenVisited = true;
                } else if (uMgrPropsPanel == GroupTabs.this.projProps) {
                    GroupTabs.this.isProjVisited = true;
                }
            }
            catch (Exception exception) {
                new ErrorDialog(GroupTabs.this.theApp.getFrame(), exception.getLocalizedMessage());
            }
        }
    }
}

