/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.email;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.FilterPanel;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.email.AdminEmailDialog;
import com.sun.admin.usermgr.client.email.ConfDelEmailPanel;
import com.sun.admin.usermgr.client.email.UMgrEmailMenuBar;
import com.sun.admin.usermgr.client.email.UMgrEmailTBar;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.ServiceWrapper;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class EmailContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ListProperties listProperties;
    private ImageIcon smallEmailIcon;
    private ImageIcon largeEmailIcon;
    private UMgrEmailMenuBar emailMenuBar;
    private UMgrEmailTBar emailToolBar;
    private VFilter filterControl = null;
    private VUserMgr theApp;
    EmailContent emailContent;

    public EmailContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.emailContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.emailMenuBar = new UMgrEmailMenuBar(vUserMgr, this);
        this.emailToolBar = new UMgrEmailTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setMenuBar((JMenuBar)this.emailMenuBar);
        this.rootNode.setToolBar((JToolBar)this.emailToolBar);
        this.smallEmailIcon = vUserMgr.loadImageIcon("email_16.gif", "");
        this.largeEmailIcon = vUserMgr.loadImageIcon("email_32.gif", "");
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            vUserMgr.reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public UMgrEmailMenuBar getMenuBar() {
        return this.emailMenuBar;
    }

    public UMgrEmailTBar getToolBar() {
        return this.emailToolBar;
    }

    public void refresh() {
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    EmailContent.this.updateStatusBar();
                    EmailContent.this.showFilteredStatus();
                    EmailContent.this.theApp.waitOff();
                    return;
                }
                EmailContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                EmailContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    public void createProperties() {
        this.theApp.waitOn();
        AdminEmailDialog adminEmailDialog = new AdminEmailDialog(this.theApp, this.emailContent);
        adminEmailDialog.show();
        this.theApp.waitOff();
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        this.theApp.waitOn();
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        EmailAliasObj emailAliasObj = (EmailAliasObj)vScopeNode.getPayload();
        try {
            emailAliasObj = this.theApp.getUserMgr().getEmailAliasAttributes(emailAliasObj);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            return;
        }
        AdminEmailDialog adminEmailDialog = new AdminEmailDialog(this.theApp, this.emailContent, emailAliasObj);
        adminEmailDialog.show();
        this.theApp.waitOff();
    }

    public void deleteSelected() {
        ConfDelEmailPanel confDelEmailPanel = new ConfDelEmailPanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_email"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < vector.size()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(n);
                        EmailAliasObj emailAliasObj = (EmailAliasObj)vScopeNode.getPayload();
                        EmailContent.this.theApp.getUserMgr().deleteEmailAlias(emailAliasObj);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(this, emailAliasObj){
                                    private final /* synthetic */ EmailAliasObj val$eaObj;
                                    private final /* synthetic */ 2 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$eaObj = emailAliasObj;
                                    }

                                    public void run() {
                                        2.access$100(this.this$1).removeFromResultsPane(this.val$eaObj);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        } else {
                            EmailContent.this.removeFromResultsPane(emailAliasObj);
                        }
                    }
                    catch (Exception exception) {
                        EmailContent.this.theApp.reportErrorException(exception);
                    }
                    ++n;
                }
            }

            static /* synthetic */ EmailContent access$100(2 var0) {
                return var0.EmailContent.this;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelEmailPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public void renameSelected() {
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"email");
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"EmailListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public ListProperties getListProperties() {
        return this.listProperties;
    }

    public void setListProperties(ListProperties listProperties) {
        this.listProperties = listProperties;
    }

    public String[] getFilterAttributes() {
        String[] stringArray = new String[]{"filter_email_name"};
        return stringArray;
    }

    public Vector getFilters() {
        if (this.listProperties != null) {
            return this.listProperties.getFilters();
        }
        return null;
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public void setFilters(Vector vector) {
        try {
            if (this.listProperties != null) {
                this.listProperties.setFilters(vector);
            } else {
                this.listProperties = new ListProperties();
                this.listProperties.setFilters(vector);
            }
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    public VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new FilterControl();
        }
        return this.filterControl;
    }

    public void pasteUsers() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        EmailAliasObj emailAliasObj = (EmailAliasObj)vScopeNode.getPayload();
        if (emailAliasObj == null) {
            AdminCommonTools.CMN_HandleOutput((String)"&&&&&&& getEmailAliasObjFromName = null");
            return;
        }
        String string = emailAliasObj.getAliasName();
        if (string.equals(null)) {
            return;
        }
        EmailAliasObj emailAliasObj2 = (EmailAliasObj)emailAliasObj.clone();
        String string2 = emailAliasObj.getAliasExpansion();
        Transferable transferable = this.theApp.getClipBoard().getContents(this);
        String string3 = null;
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                string3 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack((int)1, (Exception)exception);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n) {
                String string4;
                if (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()) != "") {
                    string2 = string2.length() > 0 ? string2.concat("," + string4) : string2.concat(string4);
                }
                ++n2;
            }
            emailAliasObj2.setAliasExpansion(string2);
            try {
                this.theApp.getUserMgr().modifyEmailAlias(emailAliasObj2, emailAliasObj);
                AdminCommonTools.CMN_HandleOutput((String)("Email str = " + string2));
            }
            catch (Exception exception) {
                new ErrorDialog(this.theApp.getFrame(), exception.getLocalizedMessage());
            }
        }
    }

    public void appendToResultsPane(Vector vector) {
        EmailAliasObj emailAliasObj;
        String string = ResourceManager.getLocalizedTextFile((String)"html/email_aliases.html", this.theApp.getClass());
        int n = 0;
        while (n < vector.size()) {
            emailAliasObj = (EmailAliasObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.emailMenuBar.getPopupMenu(), this.smallEmailIcon, this.largeEmailIcon, emailAliasObj.getAliasName(), null, null, -1, (Object)emailAliasObj);
            vScopeNode.setHTMLText(string);
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(emailAliasObj);
            ++n;
        }
        emailAliasObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)emailAliasObj);
    }

    public void removeFromResultsPane(EmailAliasObj emailAliasObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            EmailAliasObj emailAliasObj2 = (EmailAliasObj)vScopeNode.getPayload();
            if (emailAliasObj2 == emailAliasObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setMenuBar((JMenuBar)this.emailMenuBar);
        this.rootNode.setToolBar((JToolBar)this.emailToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            this.userMgr = EmailContent.this.theApp.getUserMgr();
            this.appData = null;
        }

        public Vector listAll() throws AdminException {
            if (EmailContent.this.getListProperties() == null) {
                return new Vector();
            }
            Vector vector = new Vector();
            ListProperties listProperties = EmailContent.this.getListProperties();
            Vector vector2 = listProperties.getFilters();
            vector = !vector2.isEmpty() ? this.userMgr.getAllEmailAliases(EmailContent.this.getListProperties()) : this.userMgr.getAllEmailAliases();
            return vector;
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)EmailContent.this.bundle, (String)"email");
        }
    }

    private class FilterControl
    implements VFilter {
        private Vector helpCache = new Vector(12);
        private FilterPanel filterPanel = null;
        private Action filterAction = null;
        private VConsoleProperties properties = null;

        public boolean getFilterEnabled() {
            if (this.filterPanel != null) {
                this.filterPanel.setFilterItems(EmailContent.this.getFilters());
            }
            if (this.filterAction != null) {
                Vector vector = EmailContent.this.getFilters();
                int n = 0;
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    FilterItem filterItem = (FilterItem)vector.elementAt(n2);
                    n += filterItem.getValue().length();
                    ++n2;
                }
                this.filterAction.setEnabled(n > 0);
            }
            return false;
        }

        public Vector applyFilter(VScopeNode vScopeNode) {
            return null;
        }

        public void clearFilter() {
            this.filterPanel.setDefaultState();
            this.filterAction.setEnabled(false);
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            this.properties = vConsoleProperties;
        }

        public void setFilterEnabled(boolean bl) {
            EmailContent.this.setFilters(bl ? this.filterPanel.getFilterItems() : new Vector());
            EmailContent.this.refresh();
        }

        public void setOptionPane(VOptionPane vOptionPane) {
            if (vOptionPane == null) {
                return;
            }
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FilterControl this$1;
                {
                    this.this$1 = filterControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterControl.access$200(this.this$1).setEnabled(actionEvent.getID() > 0);
                }
            };
            GenInfoPanel genInfoPanel = new GenInfoPanel(vOptionPane);
            this.filterPanel = new FilterPanel(EmailContent.this.getFilterAttributes(), "com.sun.admin.usermgr.client.resources.Resources", this.helpCache, genInfoPanel, actionListener);
            this.filterPanel.setFilterItems(EmailContent.this.getFilters());
            vOptionPane.getContentPane().setLayout(new BorderLayout());
            vOptionPane.getContentPane().add((Component)this.filterPanel, "Center");
            vOptionPane.repaint();
        }

        public void setFilterAction(Action action) {
            this.filterAction = action;
        }

        public boolean getFindMode() {
            return false;
        }

        public void setFindMode(boolean bl) {
        }

        static /* synthetic */ Action access$200(FilterControl filterControl) {
            return filterControl.filterAction;
        }
    }
}

