/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.usermgr.client.AuthAttrModelEntry;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.AuthAttrCompare;
import com.sun.admin.usermgr.common.AuthAttrObj;
import com.sun.admin.usermgr.common.ExtAttrObj;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.UserAttrObj;
import java.util.Vector;

public class AuthAttrMgmt {
    public static final int ATTRMGMT_USER = 0;
    public static final int ATTRMGMT_PROFILE = 1;
    private VUserMgr theApp;
    private UserAttrObj adm_auth;
    private ExtAttrObj tgt_auth;
    private AuthAttrObj[] auth_list;
    private AuthAttrModelEntry[] auth_entries;
    private int tgt_type;
    private String tgt_name;

    public AuthAttrMgmt(VUserMgr vUserMgr, ExtAttrObj extAttrObj, int n, String string) throws AdminException {
        this.theApp = vUserMgr;
        this.tgt_auth = extAttrObj;
        this.tgt_type = n;
        this.tgt_name = string;
        this.auth_list = null;
        this.adm_auth = null;
    }

    public void readAuthInfo() throws AdminException {
        if (this.auth_list == null && this.theApp != null) {
            this.auth_list = this.theApp.getAuthListCache();
            if (this.auth_list == null) {
                try {
                    this.auth_list = this.theApp.getUserMgr().getAuthAttrList();
                }
                catch (AdminException adminException) {
                    System.out.println("Auth rights: unable to get auth list");
                    throw adminException;
                }
                this.theApp.setAuthListCache(this.auth_list);
            }
        }
        if (this.adm_auth == null && this.theApp != null) {
            String[] stringArray = this.theApp.getAdminAuthCache();
            String string = this.theApp.getAuthenticatedUser();
            if (stringArray == null) {
                try {
                    stringArray = this.theApp.getUserMgr().getUserAuths(string);
                }
                catch (AdminException adminException) {
                    System.out.println("Auth rights: cannot get admin rights");
                }
                this.theApp.setAdminAuthCache(stringArray);
            }
            this.adm_auth = new UserAttrObj(string);
            this.adm_auth.setAuthNames(stringArray);
        }
    }

    public AuthAttrModelEntry[] getAuthEntries() throws AdminException {
        Object object;
        if (this.auth_list == null) {
            this.readAuthInfo();
        }
        if (this.adm_auth == null) {
            this.readAuthInfo();
        }
        if (this.auth_list.length > 1) {
            object = new AuthAttrCompare();
            Sort.sort((Object[])this.auth_list, (Compare)object);
        }
        UserAttrObj userAttrObj = null;
        if (this.tgt_auth != null) {
            switch (this.tgt_type) {
                case 0: {
                    userAttrObj = (UserAttrObj)this.tgt_auth;
                    break;
                }
                case 1: {
                    userAttrObj = new UserAttrObj();
                    object = this.tgt_auth.getAttribute("auths");
                    if (object == null) break;
                    userAttrObj.setAttribute("auths", (Vector)object);
                    break;
                }
            }
        }
        String string = "";
        int n = this.auth_list.length;
        Vector<AuthAttrModelEntry> vector = new Vector<AuthAttrModelEntry>(n);
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.auth_list[n2].getAuthName();
            AuthAttrModelEntry authAttrModelEntry = new AuthAttrModelEntry(this.auth_list[n2]);
            if (string2.endsWith(".")) {
                string = string2;
                vector.addElement(authAttrModelEntry);
            } else {
                String string3;
                int n3 = string2.lastIndexOf(46);
                if (n3 > 0 && !(string3 = string2.substring(0, n3 + 1)).equals(string)) {
                    string = string3;
                    vector.addElement(new AuthAttrModelEntry(string, "", ""));
                }
                if (this.adm_auth != null && this.adm_auth.checkAuthGrant(string2)) {
                    authAttrModelEntry.setToBeGranted();
                }
                if (userAttrObj != null && userAttrObj.checkAuthName(string2)) {
                    authAttrModelEntry.grant();
                }
                vector.addElement(authAttrModelEntry);
            }
            ++n2;
        }
        AuthAttrModelEntry[] authAttrModelEntryArray = new AuthAttrModelEntry[vector.size()];
        vector.copyInto(authAttrModelEntryArray);
        return authAttrModelEntryArray;
    }

    public ExtAttrObj setAuthEntries(AuthAttrModelEntry[] authAttrModelEntryArray) throws AdminException {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        int n = 0;
        while (n < authAttrModelEntryArray.length) {
            String string = authAttrModelEntryArray[n].getName();
            if (string.endsWith(".")) {
                if (authAttrModelEntryArray[n].isGranted()) {
                    bl = false;
                    int n2 = 0;
                    while (n2 < n) {
                        if (authAttrModelEntryArray[n2].isGranted() && authAttrModelEntryArray[n].getName().startsWith(authAttrModelEntryArray[n2].getName())) {
                            authAttrModelEntryArray[n].revoke();
                            break;
                        }
                        ++n2;
                    }
                    if (authAttrModelEntryArray[n].isGranted()) {
                        vector.addElement(string.concat("*"));
                    }
                } else {
                    bl = true;
                }
            } else if (authAttrModelEntryArray[n].isGranted() && (bl || string.endsWith("grant"))) {
                vector.addElement(string);
            }
            ++n;
        }
        UserAttrObj userAttrObj = null;
        switch (this.tgt_type) {
            case 0: {
                UserAttrObj userAttrObj2 = null;
                userAttrObj2 = this.tgt_auth == null ? new UserAttrObj(this.tgt_name) : (UserAttrObj)((UserAttrObj)this.tgt_auth).clone();
                userAttrObj2.setAttribute("auths", vector);
                userAttrObj = userAttrObj2;
                break;
            }
            case 1: {
                ProfAttrObj profAttrObj = null;
                profAttrObj = this.tgt_auth == null ? new ProfAttrObj(this.tgt_name) : (ProfAttrObj)((ProfAttrObj)this.tgt_auth).clone();
                profAttrObj.setAttribute("auths", vector);
                userAttrObj = profAttrObj;
                break;
            }
        }
        return userAttrObj;
    }
}

