/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VConstraints;
import com.sun.management.viperimpl.util.FileChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextLogger {
    private LogScrollPane logScrollPane;
    protected JLabel logViewerCaption;
    protected JButton clearButton;
    protected JButton copyButton;
    protected JButton selectAllButton;
    protected JCheckBox loggingCheckBox;
    protected JTextField logFilename;
    protected JLabel logFileStatusLabel;
    protected JButton browseButton;
    private FileChooser fileChooser = null;
    private String loggerTitle;
    private String fileBrowserExtension;
    private String fileBrowserDescription;
    private String fileBrowserTitle;
    private String fileBrowserSelectButtonText;
    private int fileBrowserSelectButtonMnemonic;
    private static String selectedFilename;
    private boolean loggingOn = false;
    private Component parent;
    private Object[] buttonText;
    private Object[] buttonText2;
    private Object[] buttonText3;
    private String appendText;
    private String overwriteText;
    private String cancelText;
    private String tryagainText;
    private String selectanotherfileText;
    private String overwriteConfirm;
    private String cantWriteConfirm;
    private String invalidFileConfirm;
    private String fileNotFoundConfirm;
    private String cantWriteToFileConfirm;
    private String fileErrorTitle;

    public TextLogger(Component component, JPanel jPanel) {
        this.parent = component;
        this.appendText = ImplResourceManager.getString("APPEND_BUTTON");
        this.overwriteText = ImplResourceManager.getString("OVERWRITE_BUTTON");
        this.cancelText = ImplResourceManager.getString("CANCEL_BUTTON");
        this.tryagainText = ImplResourceManager.getString("TRY_AGAIN_BUTTON");
        this.selectanotherfileText = ImplResourceManager.getString("SELECT_ANOTHER_FILE_BUTTON");
        this.buttonText = new Object[3];
        this.buttonText[0] = this.appendText;
        this.buttonText[1] = this.overwriteText;
        this.buttonText[2] = this.cancelText;
        this.buttonText2 = new Object[2];
        this.buttonText2[0] = this.tryagainText;
        this.buttonText2[1] = this.cancelText;
        this.buttonText3 = new Object[3];
        this.buttonText3[0] = this.tryagainText;
        this.buttonText3[1] = this.selectanotherfileText;
        this.buttonText3[2] = this.cancelText;
        this.overwriteConfirm = ImplResourceManager.getString("OverwriteConfirm");
        this.cantWriteConfirm = ImplResourceManager.getString("CantwriteConfirm");
        this.invalidFileConfirm = ImplResourceManager.getString("InvalidfileConfirm");
        this.fileNotFoundConfirm = ImplResourceManager.getString("FilenotfoundConfirm");
        this.cantWriteToFileConfirm = ImplResourceManager.getString("CantwritetofileConfirm");
        this.fileErrorTitle = ImplResourceManager.getString("FileerrorTitle");
        this.logViewerCaption = new JLabel(this.loggerTitle);
        this.logScrollPane = new LogScrollPane();
        this.logScrollPane.setPreferredSize(new Dimension(400, 250));
        this.selectAllButton = new JButton();
        this.selectAllButton.setText(ImplResourceManager.getString("SELECTALL_BUTTON"));
        this.selectAllButton.setMnemonic(ImplResourceManager.getString("SELECTALL_BUTTON_mnemonic").charAt(0));
        this.selectAllButton.setMargin(new Insets(1, 4, 1, 4));
        this.selectAllButton.setEnabled(false);
        Dimension dimension = this.selectAllButton.getPreferredSize();
        this.selectAllButton.setPreferredSize(dimension);
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextLogger.this.logScrollPane.selectAll();
            }
        });
        this.copyButton = new JButton();
        this.copyButton.setText(ImplResourceManager.getString("COPY_BUTTON"));
        this.copyButton.setMnemonic(ImplResourceManager.getString("COPY_BUTTON_mnemonic").charAt(0));
        this.copyButton.setMargin(new Insets(1, 4, 1, 4));
        this.copyButton.setEnabled(false);
        dimension = this.copyButton.getPreferredSize();
        this.copyButton.setPreferredSize(dimension);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextLogger.this.logScrollPane.copy();
            }
        });
        this.clearButton = new JButton();
        this.clearButton.setText(ImplResourceManager.getString("CLEAR_BUTTON"));
        this.clearButton.setMnemonic(ImplResourceManager.getString("CLEAR_BUTTON_mnemonic").charAt(0));
        this.clearButton.setMargin(new Insets(1, 4, 1, 4));
        dimension = this.clearButton.getPreferredSize();
        this.clearButton.setPreferredSize(dimension);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextLogger.this.clearText();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)jPanel2, (Component)this.selectAllButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        VConstraints.constrain((Container)jPanel2, (Component)this.copyButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        VConstraints.constrain((Container)jPanel2, (Component)this.clearButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)jPanel3, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)0, (int)5, (int)0);
        separatorPanel separatorPanel2 = new separatorPanel();
        separatorPanel2.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.loggingCheckBox = new JCheckBox();
        this.loggingCheckBox.setMargin(new Insets(1, 1, 1, 1));
        this.loggingCheckBox.setText(ImplResourceManager.getString("LogtofileText"));
        this.loggingCheckBox.setMnemonic(ImplResourceManager.getString("LogtofileText_mnemonic").charAt(0));
        this.loggingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextLogger.this.loggingOn();
                if (TextLogger.this.loggingOn && !TextLogger.this.checkLogFile(TextLogger.this.logFilename.getText())) {
                    TextLogger.this.loggingCheckBox.setSelected(false);
                    TextLogger.this.loggingOn();
                }
            }
        });
        VConstraints.constrain((Container)jPanel4, (Component)this.loggingCheckBox, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.logFilename = new JTextField();
        this.logFilename.setText(ImplResourceManager.getString("DefaultFilename"));
        this.logFilename.setMargin(new Insets(2, 2, 2, 2));
        this.logFilename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextLogger.this.checkLogFile(TextLogger.this.logFilename.getText())) {
                    TextLogger.this.loggingCheckBox.setSelected(true);
                    TextLogger.this.loggingOn();
                } else {
                    TextLogger.this.loggingCheckBox.setSelected(false);
                    TextLogger.this.loggingOn();
                }
            }
        });
        VConstraints.constrain((Container)jPanel4, (Component)this.logFilename, (int)1, (int)0, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.logFileStatusLabel = new JLabel();
        this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
        VConstraints.constrain((Container)jPanel4, (Component)this.logFileStatusLabel, (int)0, (int)1, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.browseButton = new JButton();
        this.browseButton.setText(ImplResourceManager.getString("BROWSE_BUTTON"));
        this.browseButton.setMnemonic(ImplResourceManager.getString("BROWSE_BUTTON_mnemonic").charAt(0));
        this.browseButton.setMargin(new Insets(1, 4, 1, 4));
        Dimension dimension2 = this.browseButton.getPreferredSize();
        this.browseButton.setPreferredSize(dimension2);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextLogger.this.doShowFileBrowser();
            }
        });
        VConstraints.constrain((Container)jPanel4, (Component)this.browseButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)jPanel5, (Component)jPanel3, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        VConstraints.constrain((Container)jPanel5, (Component)separatorPanel2, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        VConstraints.constrain((Container)jPanel5, (Component)jPanel4, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)5, (int)0, (int)0, (int)0);
        jPanel.add((Component)this.logViewerCaption, "North");
        jPanel.add((Component)this.logScrollPane, "Center");
        jPanel.add((Component)jPanel5, "South");
    }

    public void loggingOn() {
        if (this.getLogFile().equals("")) {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
            this.loggingCheckBox.setSelected(false);
            this.doShowFileBrowser();
        } else if (this.loggingCheckBox.isSelected()) {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("LoggingStatusLabel"));
            this.loggingOn = true;
        } else {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
            this.loggingOn = false;
        }
    }

    public void setText(String string) {
        this.clearText();
        this.appendText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendText(String string) {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            this.logScrollPane.writeText(string);
        }
        this.logToFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearText() {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            this.logScrollPane.writeText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            String string = this.logScrollPane.getText();
            return string;
        }
    }

    public void doShowFileBrowser() {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
            this.fileChooser.addExtension(this.fileBrowserExtension);
            this.fileChooser.setDescription(this.fileBrowserDescription);
            this.fileChooser.setTitle(this.fileBrowserTitle);
            this.fileChooser.setApproveButtonText(this.fileBrowserSelectButtonText);
            this.fileChooser.setApproveButtonMnemonic(this.fileBrowserSelectButtonMnemonic);
        }
        if ((n = this.fileChooser.showDialog(this.parent, null)) == 0 && this.fileChooser.getSelectedFile() != null && this.fileChooser.getSelectedFile().getName() != null) {
            String string = this.fileChooser.getCurrentDirectory() + "/" + this.fileChooser.getSelectedFile().getName();
            if (this.checkLogFile(string)) {
                this.loggingCheckBox.setSelected(true);
                this.loggingOn();
            } else {
                this.loggingCheckBox.setSelected(false);
                this.loggingOn();
            }
        }
    }

    public void setLoggerTitle(String string) {
        this.loggerTitle = string;
        this.logViewerCaption.setText(this.loggerTitle);
    }

    public void setFileBrowserExtension(String string) {
        this.fileBrowserExtension = string;
    }

    public void setFileBrowserDescription(String string) {
        this.fileBrowserDescription = string;
    }

    public void setFileBrowserTitle(String string) {
        this.fileBrowserTitle = string;
    }

    public void setFileBrowserSelectButton(String string, int n) {
        this.fileBrowserSelectButtonText = string;
        this.fileBrowserSelectButtonMnemonic = n;
    }

    public void setDefaultFileName(String string) {
        this.setLogFile(string);
    }

    public void setLogFile(String string) {
        this.logFilename.setText(string);
        selectedFilename = string;
    }

    public String getLogFile() {
        return this.logFilename.getText();
    }

    public boolean checkLogFile(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            int n = JOptionPane.showOptionDialog(this.parent, string + "\n" + this.overwriteConfirm, this.fileErrorTitle, 1, 3, null, this.buttonText, this.buttonText[0]);
            if (n == 0) {
                bl = true;
            } else if (n == 1) {
                file.delete();
                bl = true;
            } else {
                bl = n == 2 ? false : false;
            }
        } else if (file.exists() && !file.isFile()) {
            int n = JOptionPane.showOptionDialog(this.parent, string + "\n" + this.invalidFileConfirm, this.fileErrorTitle, 0, 3, null, this.buttonText2, this.buttonText2[0]);
            if (n == 0) {
                bl = false;
                this.checkLogFile(string);
            } else {
                bl = n == 1 ? false : false;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.setLogFile(string);
        }
        return bl;
    }

    private void logToFile(String string) {
        block5: {
            if (this.loggingOn && selectedFilename != null && !selectedFilename.equals("")) {
                try {
                    FileWriter fileWriter = new FileWriter(selectedFilename, true);
                    fileWriter.write(string);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (Exception exception) {
                    int n = JOptionPane.showOptionDialog(this.parent, selectedFilename + "\n" + this.cantWriteToFileConfirm, this.fileErrorTitle, 1, 3, null, this.buttonText3, this.buttonText3[0]);
                    if (n == 0) {
                        this.logToFile(string);
                    }
                    if (n == 1) {
                        this.loggingCheckBox.setSelected(false);
                        this.doShowFileBrowser();
                    }
                    if (n != 2) break block5;
                    this.loggingCheckBox.setSelected(false);
                }
            }
        }
    }

    private class LogScrollPane
    extends JScrollPane {
        private JTextArea logPane = new JTextArea();
        private String textLog = "";

        public LogScrollPane() {
            super(20, 30);
            this.logPane.setEditable(false);
            this.setViewportView(this.logPane);
            this.logPane.addCaretListener(new CaretListener(this){
                private final /* synthetic */ LogScrollPane this$1;
                {
                    this.this$1 = logScrollPane;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    String string = LogScrollPane.access$300(this.this$1).getSelectedText();
                    if (string != null && string.length() > 0) {
                        LogScrollPane.access$400((LogScrollPane)this.this$1).copyButton.setEnabled(true);
                    } else {
                        LogScrollPane.access$400((LogScrollPane)this.this$1).copyButton.setEnabled(false);
                    }
                }
            });
        }

        public JScrollBar createVerticalScrollBar() {
            return new LogScrollBar(1);
        }

        public void writeText(String string) {
            this.textLog = string != null && string.length() > 0 ? this.textLog + string : "";
            this.logPane.setText(this.textLog);
            TextLogger.this.selectAllButton.setEnabled(this.textLog.length() != 0);
        }

        public String getText() {
            return this.logPane.getText();
        }

        public void selectAll() {
            this.logPane.selectAll();
        }

        public void copy() {
            this.logPane.copy();
        }

        static /* synthetic */ JTextArea access$300(LogScrollPane logScrollPane) {
            return logScrollPane.logPane;
        }

        static /* synthetic */ TextLogger access$400(LogScrollPane logScrollPane) {
            return logScrollPane.TextLogger.this;
        }

        private class LogScrollBar
        extends JScrollBar {
            private int lastMax = 0;

            public LogScrollBar(int n) {
                super(n);
            }

            public void setValues(int n, int n2, int n3, int n4) {
                super.setValues(n, n2, n3, n4);
                if (n4 != this.lastMax) {
                    this.setValue(n4);
                    this.lastMax = n4;
                }
            }
        }
    }

    private class separatorPanel
    extends JPanel {
        private separatorPanel() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(ResourceManager.sunBlue);
            Dimension dimension = this.getSize();
            graphics.drawLine(4, dimension.height - 1, dimension.width - 4, dimension.height - 1);
        }
    }
}

