/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityFactory;
import com.sun.management.viperimpl.services.authentication.client.DigestClientSecurityContext;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public class DigestClientSecurityFactory
implements ClientSecurityFactory {
    private DigestAuthFlavor initDaf;
    private DigestClientSecurityContext initCsc;

    public void init(Properties properties) throws AuthenticationException {
        Provider provider;
        DigestAuthFlavor digestAuthFlavor = new DigestAuthFlavor();
        String string = "SUN";
        if (properties != null) {
            String string2 = properties.getProperty("auth.digest.provider");
            if (string2 != null) {
                string = string2;
            }
            if ((string2 = properties.getProperty("auth.digest.digest.algo")) != null) {
                digestAuthFlavor.setDigestAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.sign.algo")) != null) {
                digestAuthFlavor.setSignatureAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.key.algo")) != null) {
                digestAuthFlavor.setKeyGenerationAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.key.strength")) != null) {
                int n = 0;
                try {
                    n = new Integer(string2);
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n > 0) {
                    digestAuthFlavor.setKeyStrength(n);
                }
            }
        }
        if ((provider = Security.getProvider(string)) == (Provider)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Security provider not installed: " + string), null);
            throw new AuthenticationException("Security provider not installed: ", (Object)string);
        }
        DigestSecurityUtil.initialize(provider, digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor.getKeyStrength());
        this.initDaf = digestAuthFlavor;
        this.initCsc = new DigestClientSecurityContext(digestAuthFlavor);
    }

    public AuthenticationFlavor getAuthFlavor() throws AuthenticationException {
        AuthenticationFlavor authenticationFlavor = null;
        if (this.initDaf != null) {
            authenticationFlavor = this.initDaf.newCopy();
        }
        return authenticationFlavor;
    }

    public ClientSecurityContext getClientSecurityContext() throws AuthenticationException {
        ClientSecurityContext clientSecurityContext = null;
        if (this.initCsc != null) {
            clientSecurityContext = this.initCsc.newCopy();
        }
        return clientSecurityContext;
    }
}

