/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.Crypt;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestAuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestMessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.util.SMCRMISocketFactory;

public class DigestClientSecurityContext
extends ClientSecurityContext {
    private byte[] serverkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private boolean integrity = false;
    private static boolean ssl_enabled = true;
    private static String is_ssl = null;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestClientSecurityContext(DigestAuthFlavor digestAuthFlavor) throws AuthenticationException {
        super(digestAuthFlavor);
        if (is_ssl == null && !(is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes")).equals("yes")) {
            ssl_enabled = false;
        }
    }

    public RequestSecurityToken generateRequestToken() throws AuthenticationException {
        AuthenticationPrincipal authenticationPrincipal = this.getAuthPrincipal();
        if (authenticationPrincipal == (AuthenticationPrincipal)null || this.getUserPassword() == (String)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Missing user name or password in client security context", null);
            throw new AuthenticationException("EXSS_NUI");
        }
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken(this.getAuthFlavor(), authenticationPrincipal);
        this.setAuthState(1);
        this.setSecurityToken(requestSecurityToken);
        return requestSecurityToken;
    }

    public AuthenticatorSecurityToken verifyResponseToken(ResponseSecurityToken responseSecurityToken) throws AuthenticationException {
        byte[] byArray;
        byte[] byArray2;
        DigestResponseSecurityToken digestResponseSecurityToken = null;
        try {
            digestResponseSecurityToken = (DigestResponseSecurityToken)responseSecurityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_BRT");
        }
        long l = digestResponseSecurityToken.getSecurityId();
        this.setSecurityId(l);
        this.serverchg = digestResponseSecurityToken.getChallenge();
        this.salt = digestResponseSecurityToken.getPasswordSalt();
        this.serverkey = digestResponseSecurityToken.getServerKey();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying server response...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Id=" + l), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.serverchg)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   salt=" + this.toHex(this.salt)), null);
        String string = this.getUserPassword();
        byte[] byArray3 = string.getBytes();
        this.hashpswd = null;
        boolean bl = SMCRMISocketFactory.isServerSecure(this.svrHost);
        if (!bl) {
            if (string != (String)null) {
                Crypt crypt = new Crypt();
                this.hashpswd = crypt.crypt(byArray3, this.salt);
            }
            if (this.hashpswd == null) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Cannot generate encrypted password", null);
                throw new AuthenticationException("EXSS_BUP");
            }
            this.sessionkey = DigestSecurityUtil.getSessionKey();
            byte[] byArray4 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
            byArray2 = DigestSecurityUtil.encryptPassword(byArray4, byArray3);
            byArray = DigestSecurityUtil.encryptDigest(this.sessionkey, byArray4);
        } else {
            if (!ssl_enabled) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Cannot connect to SSL-Enabled server with SSL disabled", null);
                throw new AuthenticationException("Cannot connect to SSL-Enabled server with SSL disabled");
            }
            this.hashpswd = AuthenticationUtil.hashPassword(new String(byArray3)).getBytes();
            this.sessionkey = DigestSecurityUtil.getSessionKey();
            byArray2 = byArray3;
            byArray = this.sessionkey;
        }
        byte[] byArray5 = new byte[32];
        DigestSecurityUtil.getRandomBytes(byArray5);
        byte[] byArray6 = DigestSecurityUtil.generateDigest(byArray2, byArray5, byArray3);
        this.clientchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.clientchg);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Generating client authenticator...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   digest=" + this.toHex(byArray2)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   auth=" + this.toHex(byArray6)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.clientchg)), null);
        DigestAuthenticatorSecurityToken digestAuthenticatorSecurityToken = new DigestAuthenticatorSecurityToken(l);
        digestAuthenticatorSecurityToken.setMessageDigest(byArray2);
        digestAuthenticatorSecurityToken.setAuthenticatorDigest(byArray6);
        digestAuthenticatorSecurityToken.setSessionDigest(byArray);
        digestAuthenticatorSecurityToken.setChallenge(this.clientchg);
        digestAuthenticatorSecurityToken.setClientKey(byArray5);
        this.setAuthState(3);
        return digestAuthenticatorSecurityToken;
    }

    public void verifyConfirmToken(ConfirmSecurityToken confirmSecurityToken) throws AuthenticationException {
        long l;
        DigestConfirmSecurityToken digestConfirmSecurityToken;
        try {
            digestConfirmSecurityToken = (DigestConfirmSecurityToken)confirmSecurityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_BCT");
        }
        byte[] byArray = digestConfirmSecurityToken.getResultMessage().getBytes();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying confirm...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Result=" + digestConfirmSecurityToken.getResultMessage()), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   digest=" + this.toHex(digestConfirmSecurityToken.getMessageDigest())), null);
        byte[] byArray2 = DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, byArray);
        if (!DigestSecurityUtil.compareDigests(byArray2, digestConfirmSecurityToken.getMessageDigest())) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Confirmation digests differ", null);
            throw new AuthenticationLoginException();
        }
        if (digestConfirmSecurityToken.isIntegrityRequired()) {
            this.integrity = true;
        }
        if ((l = confirmSecurityToken.getHeartbeatPeriod()) > 0L) {
            l /= 2L;
        }
        this.setHeartbeatPeriod(l);
        this.setAuthState(4);
        this.setSecurityToken(confirmSecurityToken);
    }

    public MessageSecurityToken generateMessageToken(Object[] objectArray) throws AuthenticationException {
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_VBA");
        }
        long l = this.getSecurityId();
        DigestMessageSecurityToken digestMessageSecurityToken = new DigestMessageSecurityToken(l);
        byte[] byArray = this.serverchg;
        if (this.isIntegrityRequired() && objectArray != null && objectArray.length > 0) {
            byArray = DigestSecurityUtil.generateDigest(objectArray);
        }
        byte[] byArray2 = DigestSecurityUtil.encryptDigest(byArray, this.sessionkey);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("Generating message authenticator: digest=" + this.toHex(byArray)), null);
        digestMessageSecurityToken.setDigest(byArray2);
        return digestMessageSecurityToken;
    }

    public void verifyMessageToken(MessageSecurityToken messageSecurityToken, Object object) throws AuthenticationException {
        byte[] byArray;
        byte[] byArray2;
        DigestMessageSecurityToken digestMessageSecurityToken;
        try {
            digestMessageSecurityToken = (DigestMessageSecurityToken)messageSecurityToken;
        }
        catch (Exception exception) {
            throw new AuthenticationException("EXSS_BVT");
        }
        byte[] byArray3 = this.serverchg;
        if (this.isIntegrityRequired() && object != null) {
            Object[] objectArray = new Object[]{object};
            byArray3 = DigestSecurityUtil.generateDigest(objectArray);
        }
        if ((byArray2 = DigestSecurityUtil.encryptDigest(byArray = digestMessageSecurityToken.getDigest(), this.sessionkey)) == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying message return...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   server digest=" + this.toHex(byArray3)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client digest=" + this.toHex(byArray2)), null);
        if (!DigestSecurityUtil.compareDigests(byArray3, byArray2)) {
            throw new AuthenticationMessageException();
        }
    }

    public byte[] encryptPassword(String string) throws AuthenticationException {
        int n;
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_NAX", (Object)"encryptPassword");
        }
        if (string == null || (n = string.trim().length()) == 0 || n > 16) {
            throw new AuthenticationException("EXSS_BUP");
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        byArray2 = DigestSecurityUtil.encryptPassword(byArray2, byArray);
        return byArray2;
    }

    public ClientSecurityContext newCopy() throws AuthenticationException {
        DigestClientSecurityContext digestClientSecurityContext = new DigestClientSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(digestClientSecurityContext);
        digestClientSecurityContext.setServerKey(this.serverkey);
        digestClientSecurityContext.setServerChallenge(this.serverchg);
        digestClientSecurityContext.setClientChallenge(this.clientchg);
        digestClientSecurityContext.setPasswordHash(this.hashpswd);
        digestClientSecurityContext.setPasswordSalt(this.salt);
        if (this.integrity) {
            digestClientSecurityContext.setIntegrity();
        }
        return digestClientSecurityContext;
    }

    public void setServerKey(byte[] byArray) {
        this.serverkey = byArray;
    }

    public void setServerChallenge(byte[] byArray) {
        if (byArray != null) {
            this.serverchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.serverchg, 0, byArray.length);
        } else {
            this.serverchg = null;
        }
    }

    public void setClientChallenge(byte[] byArray) {
        if (byArray != null) {
            this.clientchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.clientchg, 0, byArray.length);
        } else {
            this.clientchg = null;
        }
    }

    public void setPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.hashpswd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.hashpswd, 0, byArray.length);
        } else {
            this.hashpswd = null;
        }
    }

    public void setPasswordSalt(byte[] byArray) {
        if (byArray != null) {
            this.salt = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
        } else {
            this.salt = null;
        }
    }

    public byte[] getServerKey() {
        return this.serverkey;
    }

    public boolean isIntegrityRequired() {
        return this.integrity;
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

