/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.BaseConsoleManager;
import com.sun.management.viperimpl.console.ManagedCredentials;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.ToolPayload;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.editor.SMCEditor;
import com.sun.management.viperimpl.console.gui.AdvancedLoginChooser;
import com.sun.management.viperimpl.console.gui.ComboToolBoxChooser;
import com.sun.management.viperimpl.console.gui.GUIPrivilegeManager;
import com.sun.management.viperimpl.console.gui.LocalToolBoxChooser;
import com.sun.management.viperimpl.console.gui.LoginChooser;
import com.sun.management.viperimpl.console.gui.LoginFailed;
import com.sun.management.viperimpl.console.gui.RoleChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class GUIConsoleManager
extends BaseConsoleManager {
    protected ToolBoxChooser openChooser = null;
    protected ToolBoxChooser saveChooser = null;
    protected LoginChooser login = null;
    protected AdvancedLoginChooser advLogin = null;
    protected RoleChooser roleLogin = null;
    protected LoginFailed loginFailed = null;
    protected Component parentComp = null;
    protected boolean initParent = false;
    protected Vector cancelSet = null;
    protected SMCEditor toolBoxEditor = null;
    protected VConsoleActionListener chooserListener = null;
    protected static ImageIcon warnIcon = null;
    protected static ImageIcon errIcon = null;
    protected static ImageIcon smallToolIcon = null;
    protected static ImageIcon largeToolIcon = null;
    protected static WindowCommandSetter cmdSetter = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public GUIConsoleManager() {
        BaseConsoleManager.toolContext = "TC_APPLICATION_GUI";
        this.chooserListener = new VConsoleActionListener(){

            public void consoleAction(VConsoleEvent vConsoleEvent) {
                GUIConsoleManager.super.notifyListeners(vConsoleEvent);
            }
        };
        if (warnIcon == null) {
            try {
                warnIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Warn16.gif", this.getClass());
                errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
                smallToolIcon = ConsoleUtility.loadImageIcon((String)"images/Tool_NotLoaded16.gif", this.getClass());
                largeToolIcon = ConsoleUtility.loadImageIcon((String)"images/Tool_NotLoaded32.gif", this.getClass());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (BaseConsoleManager.loadMessage == null) {
            BaseConsoleManager.loadMessage = new MessageFormat(ImplResourceManager.getString("Loading {0} Tool..."));
        }
    }

    protected void initComboTBChooser() {
        ComboToolBoxChooser comboToolBoxChooser = new ComboToolBoxChooser();
        comboToolBoxChooser.addConsoleActionListener(this.chooserListener);
        this.openChooser = comboToolBoxChooser;
        this.openChooser.setProperties(this.properties);
        comboToolBoxChooser.seedRemoteServer(this.initialHostName);
    }

    protected void initLocalTBChooser() {
        LocalToolBoxChooser localToolBoxChooser = new LocalToolBoxChooser();
        localToolBoxChooser.addConsoleActionListener(this.chooserListener);
        this.saveChooser = localToolBoxChooser;
        this.saveChooser.setProperties(this.properties);
    }

    protected void initLoginChooser() {
        this.login = new LoginChooser();
        this.login.addConsoleActionListener(this.chooserListener);
    }

    protected void initLoginFailed() {
        this.loginFailed = new LoginFailed();
        this.loginFailed.addConsoleActionListener(this.chooserListener);
    }

    protected void initAdvancedLoginChooser() {
        this.advLogin = new AdvancedLoginChooser();
        this.advLogin.addConsoleActionListener(this.chooserListener);
    }

    protected void initRoleChooser() {
        this.roleLogin = new RoleChooser();
        this.roleLogin.addConsoleActionListener(this.chooserListener);
    }

    protected void initParent() {
        try {
            Object object;
            String string = this.properties.getProperty("vconsole.dialogtype");
            if (string == null || string.equals("vconsole.frame")) {
                object = (JFrame)this.properties.getPropertyObject("vconsole.frame");
                this.parentComp = object;
                if (object == null) {
                    object = new JFrame();
                }
            } else if (string.equals("vconsole.internalframe")) {
                // empty if block
            }
            object = new GUIPrivilegeManager();
            ((GUIPrivilegeManager)object).init(this.parentComp, this.trusted);
            this.privilegeMgr = object;
            super.setPrivilegeManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initParent = true;
    }

    protected void showBusyState(boolean bl) {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.parentComp instanceof VContainer) {
            VContainer vContainer = (VContainer)this.parentComp;
            vContainer.showBusyState(bl);
        }
    }

    protected void showTemporaryBusyState() {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.parentComp instanceof VContainer) {
            VContainer vContainer = (VContainer)this.parentComp;
            vContainer.showTemporaryBusyState();
        }
    }

    public int saveConsole() {
        try {
            if (this.currentConfig == null) {
                return 1;
            }
            VConfigurationInfo vConfigurationInfo = this.currentConfig.getInfo();
            URL uRL = vConfigurationInfo.getURL();
            File file = new File(uRL.getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.currentConfig.write(fileOutputStream);
            fileOutputStream.close();
            this.configHasChanged = false;
            return 0;
        }
        catch (Throwable throwable) {
            Debug.trace((String)"GUI Console Manager", (int)Debug.WARNING, (String)"Unable to save console, trying save as...", (Throwable)throwable);
            return this.saveConsoleAs();
        }
    }

    public int saveConsoleAs() {
        if (!this.initParent) {
            this.initParent();
        }
        try {
            int n;
            if (this.currentConfig == null) {
                return 1;
            }
            if (this.saveChooser == null) {
                this.initLocalTBChooser();
            }
            if ((n = this.saveChooser.showSaveDialog(this.parentComp)) == -1) {
                return 0;
            }
            URL uRL = this.saveChooser.getToolBoxURL();
            File file = new File(uRL.getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.currentConfig.write(fileOutputStream);
            fileOutputStream.close();
            this.configHasChanged = false;
            return 0;
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this.parentComp, ImplResourceManager.getString("Could not save toolbox to the specified location."), ImplResourceManager.getString("Save As Failed"), 0);
            Debug.trace((String)"GUI Console Manager", (int)Debug.ERROR, (String)"Unable to save console as...", (Throwable)throwable);
            return this.saveConsoleAs();
        }
    }

    public void editConsole() {
        Debug.trace((String)"GUI Console Manager", (int)Debug.INFORMATION, (String)"Editing not launchable from console", null);
    }

    protected String promptUserForTool(String string) {
        return null;
    }

    protected URL promptUserForToolbox() {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.openChooser == null) {
            this.initComboTBChooser();
        } else {
            this.openChooser.refreshDisplay();
        }
        this.properties.setProperty("vconsole.working", "false");
        this.showBusyState(true);
        int n = this.openChooser.showOpenDialog(this.parentComp);
        this.showBusyState(false);
        this.properties.setProperty("vconsole.working", "true");
        if (n == -1) {
            return null;
        }
        return this.openChooser.getToolBoxURL();
    }

    protected ManagedCredentials promptUserForAuthInfo(String string, int n, String string2, boolean bl) {
        String string3;
        if (!this.initParent) {
            this.initParent();
        }
        boolean bl2 = (string3 = this.properties.getProperty("vconsole.loginmode")) != null && string3.equals("vconsole.advanced");
        String string4 = string;
        if (n != 898) {
            string4 = string4 + ":" + n;
        }
        int n2 = 1;
        if (bl2) {
            if (this.advLogin == null) {
                this.initAdvancedLoginChooser();
            }
            n2 = this.advLogin.showLoginDialog(this.parentComp, string4, bl);
        } else {
            if (this.login == null) {
                this.initLoginChooser();
            }
            n2 = this.login.showLoginDialog(this.parentComp, string4, bl);
        }
        if (n2 == 1) {
            return null;
        }
        ManagedCredentials managedCredentials = null;
        managedCredentials = bl2 ? new ManagedCredentials(string, n, this.advLogin.getUserName(), this.advLogin.getPassword(), this.advLogin.getRoleName(), this.advLogin.getRolePassword(), this.advLogin.shouldAssumeRole()) : new ManagedCredentials(string, n, this.login.getUserName(), this.login.getPassword(), null, null, true);
        return managedCredentials;
    }

    protected boolean promptUserToRetryLogin(String string, boolean bl) {
        return true;
    }

    protected ManagedCredentials promptUserForRoleInfo(ManagedCredentials managedCredentials, String string, VIdentity[] vIdentityArray, boolean bl) {
        if (!this.initParent) {
            this.initParent();
        }
        String string2 = managedCredentials.getHostName() + ":" + managedCredentials.getPort();
        int n = 1;
        if (this.roleLogin == null) {
            this.initRoleChooser();
        }
        if ((n = this.roleLogin.showRoleDialog(this.parentComp, string2, managedCredentials.getName(), vIdentityArray, bl)) == 2) {
            return null;
        }
        if (n == 1) {
            managedCredentials.setShouldAssumeRole(false);
            return managedCredentials;
        }
        managedCredentials = new ManagedCredentials(managedCredentials.getHostName(), managedCredentials.getPort(), managedCredentials.getName(), managedCredentials.getCredential(), this.roleLogin.getRoleName(), this.roleLogin.getRolePassword(), true);
        return managedCredentials;
    }

    protected void unexpectedException(String string, VConfigurationNode vConfigurationNode, VScopeNode vScopeNode, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = new VScopeNode();
            vScopeNode2.setSmallIcon(errIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("UnexpectedException"));
            if (vConfigurationNode instanceof ToolNode) {
                vScopeNode2.setText(((ToolNode)vConfigurationNode).getClassName());
            } else {
                vScopeNode2.setText(vConfigurationNode.getName());
            }
            string2 = vScopeNode2.getDescription();
            vScopeNode.add((MutableTreeNode)vScopeNode2);
        }
        if (BaseConsoleManager.unknownError == null) {
            BaseConsoleManager.unknownError = new MessageFormat(ImplResourceManager.getString("UnknownError"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Unknown Error"), BaseConsoleManager.unknownError.format(new Object[]{string}), string2, throwable, vScopeNode2));
    }

    protected void noServerFound(String string, String string2, ToolNode toolNode, VScopeNode vScopeNode, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string3 = null;
        if (vScopeNode != null) {
            vScopeNode2 = new VScopeNode();
            vScopeNode2.setSmallIcon(errIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("NoServerFound"));
            vScopeNode2.setText(string);
            string3 = vScopeNode2.getDescription();
            vScopeNode.add((MutableTreeNode)vScopeNode2);
        }
        if (BaseConsoleManager.hostNotFound == null) {
            BaseConsoleManager.hostNotFound = new MessageFormat(ImplResourceManager.getString("HostNotFound"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Host Not Found"), BaseConsoleManager.hostNotFound.format(new Object[]{string2}), string3, throwable, vScopeNode2));
    }

    protected void noServerRunningOnHost(String string, ToolNode toolNode, VScopeNode vScopeNode, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = new VScopeNode();
            vScopeNode2.setSmallIcon(errIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("NoServerOnHost"));
            vScopeNode2.setText(toolNode.getClassName());
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string2 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.serverNotRunning == null) {
            BaseConsoleManager.serverNotRunning = new MessageFormat(ImplResourceManager.getString("ServerNotRunning"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Server Not Running"), BaseConsoleManager.serverNotRunning.format(new Object[]{string}), string2, throwable, vScopeNode2));
    }

    protected void toolNotFoundOnServer(String string, ToolNode toolNode, VScopeNode vScopeNode, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = new VScopeNode();
            vScopeNode2.setSmallIcon(warnIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("ToolNotFound"));
            vScopeNode2.setText(toolNode.getClassName());
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string2 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.toolNotFound == null) {
            BaseConsoleManager.toolNotFound = new MessageFormat(ImplResourceManager.getString("UnknownTool"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Tool Not Found"), BaseConsoleManager.toolNotFound.format(new Object[]{string}), string2, throwable, vScopeNode2));
    }

    protected void toolDoesNotHaveLocalizedInfo(String string, ToolNode toolNode, ToolInfo toolInfo, VScopeNode vScopeNode, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = new VScopeNode();
            vScopeNode2.setSmallIcon(errIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("NoLocalizedInfo"));
            vScopeNode2.setText(toolNode.getClassName());
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string2 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.locInfoNotFound == null) {
            BaseConsoleManager.locInfoNotFound = new MessageFormat(ImplResourceManager.getString("NoInfo"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Missing Information"), BaseConsoleManager.locInfoNotFound.format(new Object[]{string}), string2, throwable, vScopeNode2));
    }

    protected void invalidScopeForTool(ToolNode toolNode, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode, String string, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = ManagerUtility.createScopeNodeFor(vLocalizedInfo, toolNode, null);
            vScopeNode2.setSmallIcon(warnIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("InvalidScope"));
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string2 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.invalidScope == null) {
            BaseConsoleManager.invalidScope = new MessageFormat(ImplResourceManager.getString("BadScope"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Invalid Domain"), BaseConsoleManager.invalidScope.format(new Object[]{string}), string2, throwable, vScopeNode2));
    }

    protected void toolDoesNotSupportScope(String string, ToolNode toolNode, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode, AdminMgmtScope adminMgmtScope, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string2 = null;
        if (vScopeNode != null) {
            vScopeNode2 = ManagerUtility.createScopeNodeFor(vLocalizedInfo, toolNode, null);
            vScopeNode2.setSmallIcon(warnIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("UnsupportedScope"));
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string2 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.unsupportedScope == null) {
            BaseConsoleManager.unsupportedScope = new MessageFormat(ImplResourceManager.getString("ScopeNotSupported"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Domain Not Supported"), BaseConsoleManager.unsupportedScope.format(new Object[]{adminMgmtScope.toDirectoryTableURL(), string}), string2, throwable, vScopeNode2));
    }

    protected void toolDoesNotSupportContext(String string, ToolNode toolNode, VLocalizedInfo vLocalizedInfo, VScopeNode vScopeNode, String string2, Throwable throwable) {
        VScopeNode vScopeNode2 = null;
        String string3 = null;
        if (vScopeNode != null) {
            vScopeNode2 = ManagerUtility.createScopeNodeFor(vLocalizedInfo, toolNode, null);
            vScopeNode2.setSmallIcon(warnIcon);
            vScopeNode2.setLargeIcon(largeToolIcon);
            vScopeNode2.setDescription(ImplResourceManager.getString("UnsupportedContext"));
            vScopeNode.add((MutableTreeNode)vScopeNode2);
            string3 = vScopeNode2.getDescription();
        }
        if (BaseConsoleManager.unsupportedContext == null) {
            BaseConsoleManager.unsupportedContext = new MessageFormat(ImplResourceManager.getString("ContextNotSupported"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Context Not Supported"), BaseConsoleManager.unsupportedContext.format(new Object[]{BaseConsoleManager.toolContext, string}), string3, throwable, vScopeNode2));
    }

    protected void authenticationFailedForTool(String string, VScopeNode vScopeNode, Throwable throwable) {
        ToolPayload toolPayload = (ToolPayload)vScopeNode.getPayload();
        ToolNode toolNode = toolPayload.getToolNode();
        vScopeNode.setSmallIcon(warnIcon);
        vScopeNode.setDescription(ImplResourceManager.getString("AuthenticationFailed"));
        if (BaseConsoleManager.failedAuthentication == null) {
            BaseConsoleManager.failedAuthentication = new MessageFormat(ImplResourceManager.getString("FailedAuthentication"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Authentication Failed"), BaseConsoleManager.failedAuthentication.format(new Object[]{string}), vScopeNode.getDescription(), throwable, vScopeNode));
        vScopeNode.setResultPane(null);
        vScopeNode.setPayload(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)vScopeNode));
    }

    protected void userCanceledAuthenticationForTool(String string, VScopeNode vScopeNode) {
        if (BaseConsoleManager.canceledAuthentication == null) {
            BaseConsoleManager.canceledAuthentication = new MessageFormat(ImplResourceManager.getString("AuthCancelled"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Authentication Cancelled"), BaseConsoleManager.canceledAuthentication.format(new Object[]{string}), vScopeNode.getDescription(), null, vScopeNode));
        vScopeNode.setResultPane(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)vScopeNode));
    }

    protected void toolInitializationFailed(String string, VScopeNode vScopeNode, Throwable throwable) {
        ToolPayload toolPayload = (ToolPayload)vScopeNode.getPayload();
        ToolNode toolNode = toolPayload.getToolNode();
        vScopeNode.setSmallIcon(warnIcon);
        vScopeNode.setDescription(ImplResourceManager.getString("Initialization Failed"));
        if (BaseConsoleManager.failedInitialization == null) {
            BaseConsoleManager.failedInitialization = new MessageFormat(ImplResourceManager.getString("FailedInitialization"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Initialization Failed"), BaseConsoleManager.failedInitialization.format(new Object[]{vScopeNode.getText()}), vScopeNode.getDescription(), throwable, vScopeNode));
        vScopeNode.setResultPane(null);
        vScopeNode.setPayload(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)vScopeNode));
    }

    protected VScopeNode addToolStubToParent(ToolNode toolNode, VScopeNode vScopeNode, VLocalizedInfo vLocalizedInfo) {
        if (toolNode == null || vScopeNode == null || vLocalizedInfo == null) {
            return null;
        }
        String string = vLocalizedInfo.getName();
        if (toolNode.getName() != null) {
            string = toolNode.getName();
        }
        VBusyPanel vBusyPanel = new VBusyPanel(BaseConsoleManager.loadMessage.format(new Object[]{string}));
        VScopeNode vScopeNode2 = ManagerUtility.createScopeNodeFor(vLocalizedInfo, toolNode, (Component)vBusyPanel);
        if (!toolNode.getTreeDisplay()) {
            vScopeNode2.setResultPane(null);
        }
        try {
            ManagerUtility.addChildToParent(toolNode, vScopeNode, vScopeNode2);
        }
        catch (Throwable throwable) {
            this.unexpectedException(toolNode.getClassName(), toolNode, vScopeNode, throwable);
            return null;
        }
        return vScopeNode2;
    }

    protected void loadToolForStub(VScopeNode vScopeNode, boolean bl) {
        if (vScopeNode == null) {
            super.loadToolForStub(vScopeNode, bl);
            return;
        }
        if (vScopeNode.getResultPane() != null) {
            super.loadToolForStub(vScopeNode, bl);
            return;
        }
        VBusyPanel vBusyPanel = new VBusyPanel(BaseConsoleManager.loadMessage.format(new Object[]{vScopeNode.getText()}));
        vScopeNode.setResultPane((Component)vBusyPanel);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)vScopeNode));
        super.loadToolForStub(vScopeNode, bl);
    }

    protected VScopeNode addToolToParent(ToolNode toolNode, Tool tool, VScopeNode vScopeNode, VScopeNode vScopeNode2) {
        if (toolNode == null || tool == null || vScopeNode == null) {
            return null;
        }
        VScopeNode vScopeNode3 = tool.getScopeNode();
        if (vScopeNode3 != null) {
            try {
                if (toolNode.getName() != null) {
                    vScopeNode3.setText(toolNode.getName());
                }
                if (toolNode.getDescription() != null) {
                    vScopeNode3.setDescription(toolNode.getDescription());
                }
                if (toolNode.getSmallIcon() != null) {
                    vScopeNode3.setSmallIcon(new ImageIcon(toolNode.getSmallIcon()));
                }
                if (toolNode.getLargeIcon() != null) {
                    vScopeNode3.setLargeIcon(new ImageIcon(toolNode.getLargeIcon()));
                }
                ManagerUtility.setBackgroundImage(toolNode, vScopeNode3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = 0;
            if (vScopeNode2 != null) {
                vScopeNode = (VScopeNode)vScopeNode2.getParent();
                n = vScopeNode.getIndex((TreeNode)vScopeNode2);
                vScopeNode.remove((MutableTreeNode)vScopeNode2);
            }
            vScopeNode.insert((MutableTreeNode)vScopeNode3, n);
        } else {
            vScopeNode3 = vScopeNode2;
            vScopeNode3.setPayload(null);
            if (tool instanceof Component) {
                vScopeNode3.setResultPane((Component)tool);
            } else {
                vScopeNode3.setResultPane(null);
                vScopeNode3.setSmallIcon(warnIcon);
                Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)("The tool: " + vScopeNode3.getText() + "did not provide its own model node" + " and none could be created for it."), null);
            }
        }
        return vScopeNode3;
    }

    protected void loadOnlineHelpForTool(Tool tool, ToolInfo toolInfo) {
        if (tool == null || toolInfo == null) {
            return;
        }
        try {
            String string = toolInfo.getHelpBaseName();
            if (string != null && !string.equals("null")) {
                Locale locale = ResourceManager.currentLocale;
                URL uRL = HelpSet.findHelpSet((ClassLoader)tool.getClass().getClassLoader(), (String)string, (Locale)locale);
                Debug.trace((String)"ConsoleManager", (int)Debug.INFORMATION, (String)("Best HelpSet for Tool: " + tool.getClass().toString() + " for Locale: " + locale.toString() + " found to be: " + uRL.toString()), null);
                HelpSet helpSet = new HelpSet(tool.getClass().getClassLoader(), uRL);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.addhelpset", (Object)helpSet);
                this.notifyListeners(vConsoleEvent);
            }
        }
        catch (Throwable throwable) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"Could not load tool's helpset", (Throwable)throwable);
        }
    }

    protected void establishWindowCommand(String string) {
        if (!this.initParent) {
            this.initParent();
        }
        try {
            if (cmdSetter == null) {
                cmdSetter = new WindowCommandSetter();
            }
            cmdSetter.setCommand(string);
        }
        catch (Throwable throwable) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"Problem setting window command.", (Throwable)throwable);
        }
    }

    protected void warnUserOfFailedToolbox(String string, Throwable throwable) {
        if (string == null) {
            return;
        }
        if (BaseConsoleManager.tbLoadFailed == null) {
            BaseConsoleManager.tbLoadFailed = new MessageFormat(ImplResourceManager.getString("Toolbox: {0} could not be loaded."));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Toolbox Load Failure"), BaseConsoleManager.tbLoadFailed.format(new Object[]{string}), ImplResourceManager.getString("ToolboxFailure"), throwable, null));
        System.err.println("Open Toolbox: " + string + " failed");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WindowCommandSetter
    implements PrivilegedAction {
        protected String cmd = null;

        WindowCommandSetter() {
        }

        public Object run() {
            try {
                Class<?> clazz = Class.forName("com.sun.dt.Xsession");
                Method method = clazz.getMethod("WMcommand", class$java$lang$Object == null ? (class$java$lang$Object = GUIConsoleManager.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = GUIConsoleManager.class$("java.lang.String")) : class$java$lang$String);
                method.invoke(null, GUIConsoleManager.this.parentComp, this.cmd);
                Debug.trace((String)"Console Manager", (int)Debug.INFORMATION, (String)("CDE Command Set: " + this.cmd), null);
            }
            catch (Throwable throwable) {
                Debug.trace((String)"Console Manager", (int)Debug.WARNING, (String)"Could not set CDE window command", (Throwable)throwable);
            }
            return this.cmd;
        }

        public void setCommand(String string) {
            this.cmd = string;
        }
    }
}

