/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_MessageLog
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String LOGSVC_WRITE_RIGHT = "solaris.admin.logsvc.write";
    public static final String LOGSVC_PURGE_RIGHT = "solaris.admin.logsvc.purge";
    public static final String LOGSVC_READ_RIGHT = "solaris.admin.logsvc.read";
    public static final String LOG_CCN = "CreationClassName";
    public static final String LOG_NAME = "Name";
    public static final String LOG_CAPABILITIES = "Capabilities";
    public static final String LOG_CAPABILITY_DESC = "CapabilitiesDescriptions";
    public static final String LOG_MAXSIZE = "MaxLogSize";
    public static final String LOG_HDRSIZE = "SizeOfHeader";
    public static final String LOG_HDRFORMAT = "HeaderFormat";
    public static final String LOG_MAXRECSIZE = "MaxRecordSize";
    public static final String LOG_RECHDRSIZE = "SizeOfRecordHeader";
    public static final String LOG_RECHDRFORMAT = "RecordHeaderFormat";
    public static final String LOG_MAXREC = "MaxNumberOfRecords";
    public static final String LOG_NUMREC = "CurrentNumberOfRecords";
    public static final String LOG_OVERWRITEPOLICY = "OverwritePolicy";
    public static final String LOG_OTHERPOLICYDESC = "OtherPolicyDescription";
    public static final String LOG_TIMEOUTDATED = "TimeWhenOutdated";
    public static final String LOG_PERCENTFULL = "PercentageNearFull";
    public static final String LOG_LASTCHANGE = "LastChange";
    public static final String LOG_TIMEOFLASTCHANGE = "TimeOfLastChange";
    public static final String LOG_RECORDCHANGED = "RecordLastChanged";
    public static final String LOG_ISFROZEN = "IsFrozen";
    public static final String LOG_CHARACTERSET = "CharacterSet";
    public static final String LOG_DESC = "Description";
    public static final String LOG_INSTALLDATE = "InstallDate";
    public static final String LOG_CAPTION = "Caption";
    public static final String LOG_STATUS = "Status";
    public static final String SOLARIS_LOG_TYPE = "Type";
    public static final String SOLARIS_LOG_VERSION = "Version";
    private static final String[] SYSLOG_CAPABILITIES = new String[]{"8"};
    private static final String[] SYSLOG_DESC = new String[]{"Supports variable length records"};
    private static final String[] WBEMLOG_CAPABILITIES = new String[]{"2", "4", "5", "6", "8"};
    private static final String[] WBEMLOG_DESC = new String[]{"Supports writing of records", "Supports variable length records", "Allows traversal in chronological and reverse chronological order", "FreezeLog supported, but once a log is frozen, it cannot be *thawed*(?)", "ClearLog supported except on the active log in which case it is treated like a backup. ClearLog in the case of a historical log implies deletion of the log.", "Variable length records supported"};
    private LogService logsvc = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Logging Service");
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        String string = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(LOG_NAME)) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return this.getCIMInstance(cIMClass, string, bl, bl2, bl3, stringArray);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        String[] stringArray;
        String[] stringArray2;
        Vector<CIMObjectPath> vector;
        block9: {
            if (this.logsvc == null) {
                try {
                    this.logsvc = LogService.getInstance();
                }
                catch (AdminLogException adminLogException) {
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
                }
            }
            vector = new Vector<CIMObjectPath>();
            stringArray2 = null;
            stringArray = null;
            try {
                stringArray2 = this.logsvc.listLogFiles();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
            try {
                stringArray = this.logsvc.listSyslogFiles();
            }
            catch (AdminLogException adminLogException) {
                if (stringArray2 != null) break block9;
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        int n = 0;
        while (stringArray2 != null && stringArray2.length > 0 && n < stringArray2.length) {
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath3.addKey(LOG_NAME, new CIMValue((Object)stringArray2[n]));
            cIMObjectPath3.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
            vector.addElement(cIMObjectPath3);
            ++n;
        }
        int n2 = 0;
        while (stringArray != null && stringArray.length > 0 && n2 < stringArray.length) {
            cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey(LOG_NAME, new CIMValue((Object)stringArray[n2]));
            cIMObjectPath2.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
            vector.addElement(cIMObjectPath2);
            ++n2;
        }
        cIMObjectPath2 = new CIMObjectPath[vector.size()];
        vector.toArray((T[])cIMObjectPath2);
        return cIMObjectPath2;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance;
        String[] stringArray2;
        String[] stringArray3;
        Vector<CIMInstance> vector;
        block9: {
            if (this.logsvc == null) {
                try {
                    this.logsvc = LogService.getInstance();
                }
                catch (AdminLogException adminLogException) {
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
                }
            }
            vector = new Vector<CIMInstance>();
            stringArray3 = null;
            stringArray2 = null;
            try {
                stringArray3 = this.logsvc.listLogFiles();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
            try {
                stringArray2 = this.logsvc.listSyslogFiles();
            }
            catch (AdminLogException adminLogException) {
                if (stringArray3 != null) break block9;
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        int n = 0;
        while (stringArray3 != null && stringArray3.length > 0 && n < stringArray3.length) {
            CIMInstance cIMInstance2 = this.getCIMInstance(cIMClass, stringArray3[n], bl, bl2, bl3, stringArray);
            vector.addElement(cIMInstance2.filterProperties(stringArray, bl2, bl3));
            ++n;
        }
        int n2 = 0;
        while (stringArray2 != null && stringArray2.length > 0 && n2 < stringArray2.length) {
            cIMInstance = this.getCIMInstance(cIMClass, stringArray2[n2], bl, bl2, bl3, stringArray);
            vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            ++n2;
        }
        cIMInstance = new CIMInstance[vector.size()];
        vector.toArray((T[])cIMInstance);
        return cIMInstance;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(LOG_NAME)) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.clearLog(string);
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            cIMInstanceArray = (CIMInstance[])wQLParser.querySpecification();
            SelectList selectList = cIMInstanceArray.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)cIMInstanceArray.getFromClause();
            QueryExp queryExp = cIMInstanceArray.getWhereClause();
            CIMInstance[] cIMInstanceArray2 = null;
            cIMInstanceArray2 = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
            int n = 0;
            while (cIMInstanceArray2 != null && n < cIMInstanceArray2.length) {
                if (queryExp == null || queryExp.apply((CIMElement)cIMInstanceArray2[n])) {
                    vector.addElement(selectList.apply((CIMElement)cIMInstanceArray2[n]));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        CIMValue cIMValue = null;
        String string2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(LOG_NAME)) continue;
                string2 = (String)cIMProperty.getValue().getValue();
            }
        }
        if (string.equalsIgnoreCase("ClearLog")) {
            this.provUtil.checkRights(LOGSVC_PURGE_RIGHT, cIMObjectPath);
            if (string2 == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.clearLog(string2));
        }
        if (string.equalsIgnoreCase("PositionToFirstRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("PositionAtRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("GetRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("DeleteRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("WriteRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("CancelIteration")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("FreezeLog")) {
            this.provUtil.checkRights(LOGSVC_PURGE_RIGHT, cIMObjectPath);
            if (string2 == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.freezeLog(string2));
        }
        if (string.equalsIgnoreCase("FlagRecordForOverwrite")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (string.equalsIgnoreCase("ListRecordsInLog")) {
            cIMValue = this.getList(cIMObjectPath, vector, vector2);
            return cIMValue;
        }
        if (string.equalsIgnoreCase("GetLogSize")) {
            this.provUtil.checkAuthenticated();
            if (string2 == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.getLogFileSize(string2, vector2));
        }
        if (string.equalsIgnoreCase("GetSyslogSwitch")) {
            this.provUtil.checkAuthenticated();
            return new CIMValue((Object)this.getSyslogSwitch(vector2));
        }
        if (string.equalsIgnoreCase("GetLogDirectory")) {
            this.provUtil.checkAuthenticated();
            return new CIMValue((Object)this.getLogFileDir(vector2));
        }
        throw new CIMException("NO_SUCH_METHOD");
    }

    public Integer clearLog(String string) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        try {
            String string2 = this.logsvc.getLogType(string);
            if (string2.equalsIgnoreCase("Syslog")) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            this.logsvc.clearLog(string);
            return new Integer(0);
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
    }

    public Integer freezeLog(String string) throws CIMException {
        String string2 = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
                string2 = this.logsvc.getCurrentLogFileName();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        if (string2.equalsIgnoreCase(string)) {
            return this.clearLog(string);
        }
        return null;
    }

    public Long getLogFileSize(String string, Vector vector) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        Long l = null;
        try {
            l = new Long(this.logsvc.getLogFileSize(string));
            vector.addElement(new CIMValue((Object)l));
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        return l;
    }

    public Integer getSyslogSwitch(Vector vector) throws CIMException {
        String string;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        if ((string = this.logsvc.getSyslogSwitch()) != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public Integer getLogFileDir(Vector vector) throws CIMException {
        String string;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        if ((string = this.logsvc.getLogFileDir()) != null) {
            vector.addElement(new CIMValue((Object)string));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    private CIMValue getList(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2) throws CIMException {
        int n;
        Object object;
        Object object2;
        String string = null;
        String[] stringArray = null;
        CIMValue cIMValue = null;
        String string2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CIMProperty)enumeration.nextElement();
            if (!object2.getName().equalsIgnoreCase(LOG_NAME)) continue;
            string2 = (String)object2.getValue().getValue();
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (vector != null && vector.size() > 0) {
            try {
                cIMValue = (CIMValue)vector.elementAt(0);
                string = (String)cIMValue.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        object2 = null;
        Vector<String> vector3 = new Vector<String>();
        try {
            object2 = this.logsvc.getLogType(string2);
            if (((String)object2).equalsIgnoreCase("Syslog")) {
                stringArray = this.logsvc.getSyslogRecords(string2);
                int n2 = 0;
                while (stringArray != null && n2 < stringArray.length) {
                    vector3.addElement(stringArray[n2]);
                    ++n2;
                }
                CIMDataType cIMDataType = new CIMDataType(22);
                CIMValue cIMValue2 = new CIMValue(vector3, cIMDataType);
                vector2.addElement(cIMValue2);
                vector2.addElement(new CIMValue((Object)"Syslog", new CIMDataType(8)));
                CIMValue cIMValue3 = new CIMValue((Object)new Integer(0));
                return cIMValue3;
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        Vector vector4 = null;
        try {
            long l;
            if (string != null) {
                object = new LogFilter(string);
                ((LogFilter)object).setFileName(null);
                n = 0;
                l = 0L;
                n = (int)((long)n + this.logsvc.getNumRecords(string2));
                vector4 = this.logsvc.getList(n, (Filterable)object, l, string2);
            } else {
                object = new LogFilter();
                n = 0;
                l = 0L;
                n = (int)((long)n + this.logsvc.getNumRecords(string2));
                vector4 = this.logsvc.getList(n, (Filterable)object, l, string2);
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        if (vector4 != null && vector4.size() > 0) {
            object = vector4.elements();
            n = 0;
            while (object.hasMoreElements()) {
                LogRecord logRecord = (LogRecord)object.nextElement();
                vector3.addElement(logRecord.formatRecord());
                ++n;
            }
            CIMDataType cIMDataType = new CIMDataType(22);
            CIMValue cIMValue4 = new CIMValue(vector3, cIMDataType);
            vector2.addElement(cIMValue4);
            vector2.addElement(new CIMValue((Object)"WBEM Log", new CIMDataType(8)));
        }
        object = new CIMValue((Object)new Integer(0));
        return object;
    }

    private CIMInstance getCIMInstance(CIMClass cIMClass, String string, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException adminLogException) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
            }
        }
        String string2 = null;
        String string3 = null;
        CIMInstance cIMInstance = cIMClass.newInstance();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        String string4 = "";
        String string5 = "";
        long l4 = 0L;
        int n = 0;
        long l5 = 0L;
        long l6 = 0L;
        String string6 = null;
        Date date = null;
        Date date2 = null;
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        Vector<String> vector2 = new Vector<String>();
        String string7 = "";
        UnsignedInt16 unsignedInt16 = new UnsignedInt16("0");
        boolean bl4 = false;
        UnsignedInt16 unsignedInt162 = new UnsignedInt16("0");
        try {
            string2 = this.logsvc.getLogType(string);
            string3 = this.logsvc.getLogVersion(string);
            l = this.logsvc.getMaxLogFileSize(string);
            l2 = this.logsvc.getLogHeaderSize(string);
            l3 = this.logsvc.getRecordHeaderSize(string);
            string4 = this.logsvc.getLogHeaderFormat(string);
            string5 = this.logsvc.getRecordHeaderFormat(string);
            l4 = this.logsvc.getNumRecords(string);
            n = this.logsvc.getLogPercentageFull(string);
            l5 = this.logsvc.getTimeOfLastChange(string);
            date = new Date(l5);
            string6 = this.logsvc.getCurrentLogFileName();
            l6 = this.logsvc.getStartDate(string);
            if (l6 > 0L) {
                date2 = new Date(l6);
            }
        }
        catch (AdminLogException adminLogException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)adminLogException.getLocalizedMessage());
        }
        cIMInstance.setProperty(SOLARIS_LOG_VERSION, new CIMValue((Object)string3));
        cIMInstance.setProperty(SOLARIS_LOG_TYPE, new CIMValue((Object)string2));
        if (bl) {
            return cIMInstance;
        }
        cIMInstance.setProperty(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        cIMInstance.setProperty(LOG_NAME, new CIMValue((Object)string));
        if (string2.equalsIgnoreCase("Syslog")) {
            int n2 = 0;
            while (n2 < SYSLOG_CAPABILITIES.length) {
                vector.addElement(new UnsignedInt16(SYSLOG_CAPABILITIES[n2]));
                vector2.addElement(SYSLOG_DESC[n2]);
                ++n2;
            }
            bl4 = false;
            unsignedInt162 = new UnsignedInt16("2");
        } else if (string2.equalsIgnoreCase("WBEM Log")) {
            unsignedInt16 = new UnsignedInt16("1");
            string7 = "The current log is backed up and a new log is created in its place. The log file gets deleted if the total number of logs exceeds the maximum specified through the log service properties file";
            bl4 = !string6.equalsIgnoreCase(string);
            int n3 = 0;
            while (n3 < WBEMLOG_CAPABILITIES.length) {
                vector.addElement(new UnsignedInt16(WBEMLOG_CAPABILITIES[n3]));
                vector2.addElement(WBEMLOG_DESC[n3]);
                ++n3;
            }
        }
        cIMInstance.setProperty(LOG_CAPABILITIES, new CIMValue(vector));
        cIMInstance.setProperty(LOG_CAPABILITY_DESC, new CIMValue(vector2));
        cIMInstance.setProperty(LOG_MAXSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(l))));
        cIMInstance.setProperty(LOG_HDRSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(l2))));
        cIMInstance.setProperty(LOG_HDRFORMAT, new CIMValue((Object)string4));
        cIMInstance.setProperty(LOG_MAXRECSIZE, new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty(LOG_RECHDRSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(l3))));
        cIMInstance.setProperty(LOG_RECHDRFORMAT, new CIMValue((Object)string5));
        cIMInstance.setProperty(LOG_MAXREC, new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty(LOG_NUMREC, new CIMValue((Object)new UnsignedInt64(Long.toString(l4))));
        cIMInstance.setProperty(LOG_OVERWRITEPOLICY, new CIMValue((Object)unsignedInt16));
        cIMInstance.setProperty(LOG_OTHERPOLICYDESC, new CIMValue((Object)string7));
        cIMInstance.setProperty(LOG_TIMEOUTDATED, new CIMValue((Object)new CIMDateTime(new Date(0L))));
        cIMInstance.setProperty(LOG_PERCENTFULL, new CIMValue((Object)new UnsignedInt8(Integer.toString(n))));
        cIMInstance.setProperty(LOG_LASTCHANGE, new CIMValue((Object)new UnsignedInt8("1")));
        cIMInstance.setProperty(LOG_TIMEOFLASTCHANGE, new CIMValue((Object)new CIMDateTime(date)));
        cIMInstance.setProperty(LOG_RECORDCHANGED, new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty(LOG_ISFROZEN, new CIMValue((Object)new Boolean(bl4)));
        cIMInstance.setProperty(LOG_CHARACTERSET, new CIMValue((Object)unsignedInt162));
        if (date2 != null) {
            cIMInstance.setProperty(LOG_INSTALLDATE, new CIMValue((Object)new CIMDateTime(date2)));
        }
        cIMInstance.setProperty(LOG_STATUS, new CIMValue((Object)"Unknown"));
        cIMInstance.setProperty(LOG_CAPTION, new CIMValue((Object)"Message Log File"));
        cIMInstance.setProperty(LOG_DESC, new CIMValue((Object)("File containing " + string2 + " records")));
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }
}

