/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.util.Debug;

public class AuthenticationLibrary {
    public static final String AUTHENTICATION_LIBRARY = "passauthen";
    private static boolean library_loaded = false;

    private static native int loginauthen(String var0, String var1, String var2);

    private static native String[] getrolenames(String var0);

    private static native String[] userinfo(String var0);

    private static native String processowner();

    private static native void setupAuditLogin(String var0, String var1);

    private static native void auditLoginSuccess(String var0, String var1, long var2);

    private static native void auditLoginFailure(String var0, String var1, int var2);

    private static native void auditLoginMaxtrys();

    public static synchronized int doPamAuthentication(String string, String string2, String string3) throws AuthenticationException {
        int n = -1;
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        if (string == null || string.trim().length() == 0) {
            return n;
        }
        if (string3 == null) {
            return n;
        }
        n = AuthenticationLibrary.loginauthen(string, string2, string3);
        return n;
    }

    public static synchronized String getName(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 0);
    }

    public static synchronized String getPassword(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 1);
    }

    public static synchronized String getUid(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 2);
    }

    public static synchronized String getGid(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 3);
    }

    public static synchronized String getDesc(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 4);
    }

    public static synchronized String getHomedir(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 5);
    }

    public static synchronized String getShell(String string) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(string, 6);
    }

    public static synchronized String getProcessOwnerName() throws AuthenticationException {
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            return AuthenticationLibrary.processowner();
        }
        catch (Exception exception) {
            throw new AuthenticationException("Cannot retrieve current process euid.", exception);
        }
    }

    public static String[] getRoleNames(String string) throws AuthenticationException {
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            return AuthenticationLibrary.getrolenames(string);
        }
        catch (Exception exception) {
            throw new AuthenticationException("Cannot retrieve role list.", exception);
        }
    }

    private static String getUserData(String string, int n) throws AuthenticationException {
        String string2 = null;
        String[] stringArray = null;
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            stringArray = AuthenticationLibrary.userinfo(string);
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray != null && stringArray.length > 6) {
            string2 = stringArray[n];
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void auditLogin(String string, String string2, int n, long l) throws AuthenticationException {
        if (string == null || string2 == null) {
            return;
        }
        if (!library_loaded) throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        Debug.trace((String)"AuthenticationLibrary", (int)Debug.INFORMATION, (String)("login auditing setup for user " + string2 + " from host " + string + " with session " + l), null);
        AuthenticationLibrary.auditSetupForLogin(string, string2);
        if (n == 0) {
            Debug.trace((String)"AuthenticationLibrary", (int)Debug.INFORMATION, (String)"auditing login success", null);
            AuthenticationLibrary.auditLoginSuccess(string, string2, l);
            return;
        } else if (n == -1 || n == -2) {
            Debug.trace((String)"AuthenticationLibrary", (int)Debug.INFORMATION, (String)"auditing login failure", null);
            AuthenticationLibrary.auditLoginFailure(string, string2, n);
            return;
        } else {
            if (n != -3) throw new AuthenticationException("InvalidAuditCode");
            Debug.trace((String)"AuthenticationLibrary", (int)Debug.INFORMATION, (String)"auditing retry limit exceeded", null);
            AuthenticationLibrary.auditLoginMaxtrys();
        }
    }

    public static void auditSetupForLogin(String string, String string2) throws AuthenticationException {
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        AuthenticationLibrary.setupAuditLogin(string, string2);
    }

    static {
        try {
            System.loadLibrary(AUTHENTICATION_LIBRARY);
            library_loaded = true;
        }
        catch (Throwable throwable) {
            Debug.trace((String)"AuthenticationLibrary:Authentication Service", (int)Debug.ERROR, (String)("Unable to load shared library: " + throwable.getMessage()), null);
        }
    }
}

