/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.rmic2;

import com.sun.management.viperimpl.rmic2.Generator;
import com.sun.management.viperimpl.rmic2.Names;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.RMIConstants;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.javac.SourceClass;

public class Main
implements RMIConstants {
    String classPathString;
    File destDir;
    int flags;
    long tm;
    Vector v;
    boolean nowrite;
    String props;
    boolean keepGenerated;
    int stubVersion;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public Main(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }

    private void error(String string) {
        this.output(Main.getText(string));
    }

    private void error(String string, String string2) {
        this.output(Main.getText(string, string2));
    }

    private void error(String string, String string2, String string3) {
        this.output(Main.getText(string, string2, string3));
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }

    public synchronized boolean compile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.v.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseArgs(String[] stringArray) {
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.v = new Vector();
        this.nowrite = false;
        this.props = null;
        this.keepGenerated = false;
        this.stubVersion = 2;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-g")) {
                this.flags &= 0xFFFFBFFF;
                this.flags |= 0x3000;
            } else if (stringArray[n].equals("-O")) {
                this.flags &= 0xFFFFEFFF;
                this.flags &= 0xFFFFDFFF;
                this.flags |= 0x4020;
            } else if (stringArray[n].equals("-nowarn")) {
                this.flags &= 0xFFFFFFFB;
            } else if (stringArray[n].equals("-debug")) {
                this.flags |= 2;
            } else if (stringArray[n].equals("-depend")) {
                this.flags |= 0x20;
            } else if (stringArray[n].equals("-verbose")) {
                this.flags |= 1;
            } else if (stringArray[n].equals("-nowrite")) {
                this.nowrite = true;
            } else if (stringArray[n].equals("-keep") || stringArray[n].equals("-keepgenerated")) {
                this.keepGenerated = true;
            } else {
                if (stringArray[n].equals("-show")) {
                    this.error("rmic.option.unsupported", "-show");
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("-classpath")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-classpath");
                        this.usage();
                        return false;
                    }
                    if (this.classPathString != null) {
                        this.error("rmic.option.already.seen", "-classpath");
                        this.usage();
                        return false;
                    }
                    this.classPathString = stringArray[++n];
                } else if (stringArray[n].equals("-d")) {
                    if (n + 1 >= stringArray.length) {
                        this.error("rmic.option.requires.argument", "-d");
                        this.usage();
                        return false;
                    }
                    if (this.destDir != null) {
                        this.error("rmic.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    this.destDir = new File(stringArray[++n]);
                    if (!this.destDir.exists()) {
                        this.error("rmic.no.such.directory", this.destDir.getPath());
                        this.usage();
                        return false;
                    }
                } else if (stringArray[n].equals("-v1.1")) {
                    this.stubVersion = 1;
                } else if (stringArray[n].equals("-vcompat")) {
                    this.stubVersion = 2;
                } else if (stringArray[n].equals("-v1.2")) {
                    this.stubVersion = 3;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        this.error("rmic.no.such.option", stringArray[n]);
                        this.usage();
                        return false;
                    }
                    this.v.addElement(stringArray[n]);
                }
            }
            ++n;
        }
        return true;
    }

    public boolean doCompile() {
        Object object;
        int n;
        BatchEnvironment batchEnvironment;
        block50: {
            ClassPath classPath = this.classPathString != null ? new ClassPath(this.classPathString) : new ClassPath();
            batchEnvironment = new BatchEnvironment(this.out, classPath, null);
            batchEnvironment.flags |= this.flags;
            switch (this.stubVersion) {
                case 1: 
                case 2: {
                    batchEnvironment.majorVersion = (short)48;
                    batchEnvironment.minorVersion = 0;
                    break;
                }
                default: {
                    batchEnvironment.majorVersion = (short)45;
                    batchEnvironment.minorVersion = (short)3;
                }
            }
            String string = Main.getText("rmic.no.memory");
            String string2 = Main.getText("rmic.stack.overflow");
            try {
                String[] stringArray;
                boolean bl;
                ClassDefinition classDefinition;
                n = this.v.size() - 1;
                while (n >= 0) {
                    object = Identifier.lookup((String)((String)this.v.elementAt(n)));
                    object = batchEnvironment.resolvePackageQualifiedName((Identifier)object);
                    object = Names.mangleClass((Identifier)object);
                    ClassDeclaration classDeclaration = batchEnvironment.getClassDeclaration((Identifier)object);
                    try {
                        classDefinition = classDeclaration.getClassDefinition((Environment)batchEnvironment);
                        Generator.generate(batchEnvironment, classDefinition, this.destDir, this.stubVersion);
                    }
                    catch (ClassNotFound classNotFound) {
                        batchEnvironment.error(0L, "rmic.class.not.found", object);
                    }
                    --n;
                }
                object = new ByteArrayOutputStream(4096);
                classDefinition = new Vector();
                do {
                    bl = true;
                    batchEnvironment.flushErrors();
                    Enumeration enumeration = batchEnvironment.getClasses();
                    block22: while (enumeration.hasMoreElements()) {
                        stringArray = (String[])enumeration.nextElement();
                        switch (stringArray.getStatus()) {
                            case 0: {
                                if (!batchEnvironment.dependencies()) continue block22;
                            }
                            case 3: {
                                bl = false;
                                batchEnvironment.loadDefinition((ClassDeclaration)stringArray);
                                if (stringArray.getStatus() != 4) continue block22;
                            }
                            case 4: {
                                if (stringArray.getClassDefinition().isInsideLocal()) continue block22;
                                bl = false;
                                SourceClass sourceClass = (SourceClass)stringArray.getClassDefinition((Environment)batchEnvironment);
                                sourceClass.check((Environment)batchEnvironment);
                                stringArray.setDefinition((ClassDefinition)sourceClass, 5);
                            }
                            case 5: {
                                Object object2;
                                File file;
                                SourceClass sourceClass = (SourceClass)stringArray.getClassDefinition((Environment)batchEnvironment);
                                if (sourceClass.getError()) {
                                    stringArray.setDefinition((ClassDefinition)sourceClass, 6);
                                    break;
                                }
                                bl = false;
                                ((ByteArrayOutputStream)object).reset();
                                sourceClass.compile((OutputStream)object);
                                stringArray.setDefinition((ClassDefinition)sourceClass, 6);
                                sourceClass.cleanup((Environment)batchEnvironment);
                                if (sourceClass.getError() || this.nowrite) continue block22;
                                String string3 = stringArray.getName().getQualifier().toString().replace('.', File.separatorChar);
                                String string4 = stringArray.getName().getFlatName().toString().replace('.', '$') + ".class";
                                if (this.destDir != null) {
                                    if (string3.length() > 0) {
                                        file = new File(this.destDir, string3);
                                        if (!file.exists()) {
                                            file.mkdirs();
                                        }
                                        file = new File(file, string4);
                                    } else {
                                        file = new File(this.destDir, string4);
                                    }
                                } else {
                                    object2 = (ClassFile)sourceClass.getSource();
                                    if (object2.isZipped()) {
                                        batchEnvironment.error(0L, "cant.write", (Object)object2.getPath());
                                        break;
                                    }
                                    file = new File(object2.getPath());
                                    file = new File(file.getParent(), string4);
                                }
                                try {
                                    object2 = new FileOutputStream(file.getPath());
                                    ((ByteArrayOutputStream)object).writeTo((OutputStream)object2);
                                    ((FileOutputStream)object2).close();
                                    if (batchEnvironment.verbose()) {
                                        this.output(Main.getText("rmic.wrote", file.getPath()));
                                    }
                                    if (!string4.endsWith("_Container.class")) continue block22;
                                    classDefinition.addElement(stringArray.getName().toString());
                                    break;
                                }
                                catch (IOException iOException) {
                                    batchEnvironment.error(0L, "cant.write", (Object)file.getPath());
                                }
                            }
                        }
                    }
                } while (!bl);
                if (classDefinition.size() > 0) {
                    int n2 = classDefinition.size();
                    if (this.keepGenerated) {
                        ++n2;
                    }
                    if (this.stubVersion == 3) {
                        ++n2;
                    }
                    if (this.classPathString != null) {
                        n2 += 2;
                    }
                    if (this.destDir != null) {
                        n2 += 2;
                    }
                    stringArray = new String[n2];
                    n2 = 0;
                    if (this.keepGenerated) {
                        stringArray[n2++] = "-keepgenerated";
                    }
                    if (this.stubVersion == 3) {
                        stringArray[n2++] = "-v1.2";
                    }
                    if (this.classPathString != null) {
                        stringArray[n2++] = "-classpath";
                        stringArray[n2++] = this.classPathString;
                    }
                    if (this.destDir != null) {
                        stringArray[n2++] = "-d";
                        stringArray[n2++] = this.destDir.getName();
                    }
                    int n3 = 0;
                    while (n3 < classDefinition.size()) {
                        stringArray[n2 + n3] = (String)classDefinition.elementAt(n3);
                        ++n3;
                    }
                    new sun.rmi.rmic.Main((OutputStream)System.out, "rmic").compile(stringArray);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                batchEnvironment.output(string);
                return false;
            }
            catch (StackOverflowError stackOverflowError) {
                batchEnvironment.output(string2);
                return false;
            }
            catch (Error error) {
                if (batchEnvironment.nerrors == 0 || batchEnvironment.dump()) {
                    error.printStackTrace();
                    batchEnvironment.error(0L, "fatal.error");
                }
            }
            catch (Exception exception) {
                if (batchEnvironment.nerrors != 0 && !batchEnvironment.dump()) break block50;
                exception.printStackTrace();
                batchEnvironment.error(0L, "fatal.exception");
            }
        }
        batchEnvironment.flushErrors();
        n = 1;
        if (batchEnvironment.nerrors > 0) {
            object = "";
            object = batchEnvironment.nerrors > 1 ? Main.getText("rmic.errors", batchEnvironment.nerrors) : Main.getText("rmic.1error");
            if (batchEnvironment.nwarnings > 0) {
                object = batchEnvironment.nwarnings > 1 ? (String)object + ", " + Main.getText("rmic.warnings", batchEnvironment.nwarnings) : (String)object + ", " + Main.getText("rmic.1warning");
            }
            this.output((String)object);
            n = 0;
        } else if (batchEnvironment.nwarnings > 0) {
            if (batchEnvironment.nwarnings > 1) {
                this.output(Main.getText("rmic.warnings", batchEnvironment.nwarnings));
            } else {
                this.output(Main.getText("rmic.1warning"));
            }
        }
        try {
            if (!this.keepGenerated) {
                batchEnvironment.deleteGeneratedFiles();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        batchEnvironment.shutdown();
        if (batchEnvironment.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        return n != 0;
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, "rmic");
        System.exit(main.compile(stringArray) ? 0 : 1);
    }

    public static String getString(String string) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmic");
            resourcesInitialized = true;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("fatal: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    public static String getText(String string) {
        String string2 = Main.getString(string);
        if (string2 == null) {
            string2 = "no text found: \"" + string + "\"";
        }
        return string2;
    }

    public static String getText(String string, int n) {
        return Main.getText(string, Integer.toString(n), null, null);
    }

    public static String getText(String string, String string2) {
        return Main.getText(string, string2, null, null);
    }

    public static String getText(String string, String string2, String string3) {
        return Main.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        String string5 = Main.getString(string);
        if (string5 == null) {
            string5 = "no text found: key = \"{0}\", arguments = \"{1}\", \"{2}\", \"{3}\"";
        }
        Object[] objectArray = new String[]{string2 != null ? string2.toString() : "null", string3 != null ? string3.toString() : "null", string4 != null ? string4.toString() : "null"};
        return MessageFormat.format(string5, objectArray);
    }
}

