/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class CIMInstance
extends CIMElement
implements Serializable {
    static final long serialVersionUID = 200L;
    private String className = new String("");
    private String alias = "";
    private Vector qualifiers = new Vector();
    private Vector properties = new Vector();
    private Vector allproperties = new Vector();
    private Vector keyproperties;

    public CIMInstance() {
        super("");
    }

    public CIMInstance(String string) {
        super(string);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = new String(string);
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Vector vector) {
        this.qualifiers = vector;
    }

    public Vector getProperties() {
        return this.properties;
    }

    private void addProperty(CIMProperty cIMProperty) {
        if (cIMProperty.getOverridingProperty() == null) {
            this.properties.addElement(cIMProperty);
        }
        this.allproperties.addElement(cIMProperty);
    }

    public void setProperties(Vector vector) {
        if (vector == null || vector.size() == 0) {
            this.properties = null;
            this.allproperties = null;
        }
        this.properties = new Vector();
        this.allproperties = new Vector();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.addProperty((CIMProperty)vector.elementAt(n2));
            ++n2;
        }
    }

    public CIMProperty getProperty(String string, String string2) {
        if (this.allproperties == null || string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return this.getProperty(string);
        }
        int n = this.allproperties.size();
        int n2 = 0;
        while (n2 < n) {
            CIMProperty cIMProperty = (CIMProperty)this.allproperties.elementAt(n2);
            if (cIMProperty.getName().equalsIgnoreCase(string) && cIMProperty.getOriginClass().equalsIgnoreCase(string2)) {
                if (cIMProperty.getOverridingProperty() != null) {
                    return this.getProperty(cIMProperty.getOverridingProperty());
                }
                return cIMProperty;
            }
            ++n2;
        }
        return null;
    }

    public CIMProperty getProperty(String string) {
        if (this.allproperties == null || string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = null;
        try {
            stringTokenizer = new StringTokenizer(string, ".");
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = (String)stringTokenizer.nextElement();
        String string3 = null;
        try {
            string3 = (String)stringTokenizer.nextElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            CIMProperty cIMProperty = this.intgetProperty(string2);
            if (cIMProperty != null) {
                while (true) {
                    CIMInstance cIMInstance = null;
                    try {
                        cIMInstance = (CIMInstance)cIMProperty.getValue().getValue();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return null;
                    }
                    cIMProperty = cIMInstance.getProperty(string3);
                    if (!stringTokenizer.hasMoreElements()) break;
                    string3 = (String)stringTokenizer.nextElement();
                }
                return cIMProperty;
            }
            return this.getProperty(string3, string2);
        }
        return this.intgetProperty(string2);
    }

    private CIMProperty intgetProperty(String string) {
        int n = this.allproperties.indexOf(new CIMProperty(string));
        if (n < 0) {
            return null;
        }
        CIMProperty cIMProperty = (CIMProperty)this.allproperties.elementAt(n);
        if (cIMProperty.getOverridingProperty() != null) {
            return this.getProperty(cIMProperty.getOverridingProperty());
        }
        return cIMProperty;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = new String(string);
    }

    public String getName() {
        String string = this.className.toLowerCase();
        Enumeration enumeration = this.properties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.isKey() || cIMProperty.getOverridingProperty() != null) continue;
            CIMValue cIMValue = cIMProperty.getValue();
            string = cIMValue == null ? string.concat(":" + cIMProperty.getOriginClass().toLowerCase() + "." + cIMProperty.getName().toLowerCase() + "=null") : string.concat(":" + cIMProperty.getOriginClass().toLowerCase() + "." + cIMProperty.getName().toLowerCase() + "=" + this.toString(cIMValue));
        }
        return string;
    }

    private String toString(CIMValue cIMValue) {
        String string = "null";
        Object object = cIMValue.getValue();
        if (object != null) {
            if (cIMValue.isArrayValue()) {
                throw new IllegalArgumentException(object.toString());
            }
            String string2 = "";
            if (new CIMDataType(8).equals(cIMValue.getType())) {
                string2 = "\"";
            }
            string = string2 + this.values(object) + string2;
        }
        return string;
    }

    private String values(Object object) {
        if (object instanceof CIMObjectPath) {
            return this.toString((CIMObjectPath)object);
        }
        if (object instanceof CIMDateTime) {
            return this.toString((CIMDateTime)object);
        }
        if (object instanceof CIMInstance) {
            throw new IllegalArgumentException(object.toString());
        }
        return object.toString();
    }

    private String toString(CIMDateTime cIMDateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
        Calendar calendar = cIMDateTime.getCalendar();
        TimeZone timeZone = calendar.getTimeZone();
        if (cIMDateTime.isInterval()) {
            return simpleDateFormat.format(calendar.getTime()) + ":000";
        }
        int n = calendar.get(15) + calendar.get(16);
        double d = (double)n * 0.001 / 60.0;
        return simpleDateFormat.format(calendar.getTime()) + (int)d;
    }

    private String toString(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        String string = cIMObjectPath.getNameSpace();
        String string2 = cIMObjectPath.getObjectName();
        if (vector == null || vector.size() == 0) {
            if (string2 != null && string2.length() != 0) {
                return string + "\\" + string2;
            }
            return string;
        }
        String string3 = "";
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (cIMProperty == null) continue;
            String string4 = cIMProperty.getOriginClass();
            string3 = string4 != null && string4.length() != 0 ? string3 + string4 + "." + cIMProperty.getName() : string3 + cIMProperty.getName();
            string3 = string3 + "=" + this.toString(cIMProperty.getValue()) + ":";
            ++n;
        }
        if (n > 0) {
            return string + "\\" + string2 + ":" + string3.substring(0, string3.lastIndexOf(":"));
        }
        return string + "\\" + string2;
    }

    public Vector getKeyValuePairs() {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Enumeration enumeration = this.properties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.isKey() || cIMProperty.getOverridingProperty() != null) continue;
            CIMProperty cIMProperty2 = new CIMProperty(cIMProperty.getName(), cIMProperty.getValue());
            cIMProperty2.setOriginClass(cIMProperty.getOriginClass());
            cIMProperty2.setType(cIMProperty.getType());
            cIMProperty2.setSize(cIMProperty.getSize());
            vector.addElement(cIMProperty2);
        }
        return vector;
    }

    public void updatePropertyValues(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            CIMProperty cIMProperty2 = this.getProperty(cIMProperty.getName(), cIMProperty.getOriginClass());
            if (cIMProperty2 == null) {
                throw new IllegalArgumentException(cIMProperty.getName());
            }
            cIMProperty2.setValue(cIMProperty.getValue());
        }
    }

    public void updatePropertyValue(CIMProperty cIMProperty) {
        CIMProperty cIMProperty2 = this.getProperty(cIMProperty.getName(), cIMProperty.getOriginClass());
        if (cIMProperty2 == null) {
            throw new IllegalArgumentException(cIMProperty.getOriginClass() + "." + cIMProperty.getName());
        }
        cIMProperty2.setValue(cIMProperty.getValue());
    }

    public void setProperty(String string, CIMValue cIMValue) {
        CIMProperty cIMProperty = this.getProperty(string);
        if (cIMProperty == null) {
            throw new IllegalArgumentException(string);
        }
        cIMProperty.setValue(cIMValue);
    }

    public CIMInstance localElements() {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.className = this.className;
        cIMInstance.qualifiers = this.qualifiers;
        if (this.properties == null) {
            cIMInstance.setProperties(null);
        } else {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Enumeration enumeration = this.properties.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getOriginClass().equalsIgnoreCase(this.className)) continue;
                vector.addElement(cIMProperty);
            }
            cIMInstance.setProperties(vector);
        }
        return cIMInstance;
    }

    public CIMInstance localElements(List list) {
        Object object;
        if (list == null) {
            return this;
        }
        Iterator iterator = list.iterator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashMap.put(((String)object).toLowerCase(), "");
        }
        object = new CIMInstance();
        ((CIMInstance)object).className = this.className;
        ((CIMInstance)object).qualifiers = this.qualifiers;
        if (this.allproperties == null) {
            ((CIMInstance)object).setProperties(null);
        } else {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Enumeration enumeration = this.allproperties.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (hashMap.get(cIMProperty.getOriginClass().toLowerCase()) == null) continue;
                vector.addElement(cIMProperty);
            }
            ((CIMInstance)object).setProperties(vector);
        }
        return object;
    }

    public CIMInstance filterProperties(String[] stringArray, boolean bl, boolean bl2) {
        CIMInstance cIMInstance = new CIMInstance();
        Vector<Object> vector = null;
        if (stringArray == null || this.allproperties == null || this.allproperties.size() == 0) {
            if (this.allproperties != null) {
                vector = new Vector<Object>();
                Enumeration enumeration = this.allproperties.elements();
                while (enumeration.hasMoreElements()) {
                    CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                    vector.addElement(cIMProperty.clone(bl, bl2));
                }
            } else {
                vector = null;
            }
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            vector = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                String string;
                CIMProperty cIMProperty = this.getProperty(stringArray[n]);
                if (cIMProperty != null && hashMap.get(string = cIMProperty.getOriginClass() + "." + cIMProperty.getName()) == null) {
                    hashMap.put(string, string);
                    vector.addElement(cIMProperty.clone(bl, bl2));
                }
                ++n;
            }
        }
        cIMInstance.className = this.className;
        cIMInstance.setProperties(vector);
        if (bl) {
            cIMInstance.qualifiers = this.qualifiers;
        }
        return cIMInstance;
    }

    public String toXml() {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        String string = "";
        return this.toXml(cIMObjectPath, string);
    }

    public String toXml(CIMObjectPath cIMObjectPath) {
        String string = "";
        return this.toXml(cIMObjectPath, string);
    }

    public String toXml(CIMObjectPath cIMObjectPath, String string) {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this, cIMObjectPath, string);
    }
}

