/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.aliases;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.aliases.EmailAliasObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisAliasesTable {
    private String table = "aliases";
    private String fileType = new String("File");
    private String scope;
    private String emptyString = new String("");
    private static String aliasCol = "alias";
    private static String expansionCol = "expansion";
    private static final String DEV_NULL = "/dev/null";
    private int aliasColNum = 0;
    private int expansionColNum = 0;

    public SolarisAliasesTable(String string) {
        this.scope = string;
    }

    private DirectoryTable createAliasesTable() throws DirectoryTableException {
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        directoryTable.create(this.table);
        return directoryTable;
    }

    private DirectoryTable openAliasesTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            this.aliasColNum = tableDefinitions.getColumnNumber(aliasCol);
            this.expansionColNum = tableDefinitions.getColumnNumber(expansionCol);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void closeAliasesTable(DirectoryTable directoryTable) {
        directoryTable.close();
        this.aliasColNum = 0;
        this.expansionColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllAliasRows() throws DirectoryTableException {
        Vector<EmailAliasObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = this.openAliasesTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) {
                    Vector<EmailAliasObj> vector2 = vector = new Vector<EmailAliasObj>();
                    Object var9_9 = null;
                    if (directoryTable == null) return vector2;
                    this.closeAliasesTable(directoryTable);
                    return vector2;
                }
                n = directoryRow.getNumberOfRows();
                vector = new Vector(n);
                vector.setSize(n);
                int n2 = 1;
                while (n2 <= n) {
                    EmailAliasObj emailAliasObj = new EmailAliasObj();
                    emailAliasObj.setAliasName(directoryRow.getColumn(this.aliasColNum, n2));
                    emailAliasObj.setAliasExpansion(directoryRow.getColumn(this.expansionColNum, n2));
                    String string = emailAliasObj.getAliasName();
                    string = string.trim();
                    if (string != null && !string.equals("")) {
                        vector.setElementAt(emailAliasObj, n2 - 1);
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var9_11 = null;
                if (directoryTable == null) return vector;
                this.closeAliasesTable(directoryTable);
                return vector;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (directoryTable == null) throw throwable;
            this.closeAliasesTable(directoryTable);
            throw throwable;
        }
        Object var9_10 = null;
        if (directoryTable == null) return vector;
        this.closeAliasesTable(directoryTable);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllAliasRows(ProviderDirectoryFilter providerDirectoryFilter) throws Exception {
        Vector<EmailAliasObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = this.openAliasesTable();
        DirectoryFilter directoryFilter = null;
        if (providerDirectoryFilter != null) {
            try {
                directoryFilter = providerDirectoryFilter.getDirectoryFilter(directoryTable);
            }
            catch (Exception exception) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            try {
                DirectoryRow directoryRow = null;
                directoryRow = directoryFilter != null ? directoryTable.getAll((SearchTemplate)directoryFilter) : directoryTable.getAll();
                if (directoryRow == null) {
                    Vector<EmailAliasObj> vector2 = vector = new Vector<EmailAliasObj>();
                    Object var11_12 = null;
                    if (directoryTable == null) return vector2;
                    this.closeAliasesTable(directoryTable);
                    return vector2;
                }
                n = directoryRow.getNumberOfRows();
                vector = new Vector(n);
                vector.setSize(n);
                int n2 = 1;
                while (n2 <= n) {
                    EmailAliasObj emailAliasObj = new EmailAliasObj();
                    emailAliasObj.setAliasName(directoryRow.getColumn(this.aliasColNum, n2));
                    emailAliasObj.setAliasExpansion(directoryRow.getColumn(this.expansionColNum, n2));
                    String string = emailAliasObj.getAliasName();
                    string = string.trim();
                    if (string != null && !string.equals("")) {
                        vector.setElementAt(emailAliasObj, n2 - 1);
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (directoryTable == null) throw throwable;
            this.closeAliasesTable(directoryTable);
            throw throwable;
        }
        Object var11_13 = null;
        if (directoryTable == null) return vector;
        this.closeAliasesTable(directoryTable);
        return vector;
    }

    public EmailAliasObj getEmailRow(String string) throws Exception {
        DirectoryTable directoryTable = null;
        EmailAliasObj emailAliasObj = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        if (string == null || string.equals("")) {
            return emailAliasObj;
        }
        emailAliasObj = new EmailAliasObj();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.aliasColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new UserMgrNameNotFoundException(null);
                }
                emailAliasObj.setAliasName(directoryRow.getColumn(this.aliasColNum));
                emailAliasObj.setAliasExpansion(directoryRow.getColumn(this.expansionColNum));
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var7_7 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
            throw throwable;
        }
        return emailAliasObj;
    }

    public void addEmailRow(EmailAliasObj emailAliasObj) throws Exception {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.aliasColNum, emailAliasObj.getAliasName());
                if (emailAliasObj.getAliasExpansion() != null && !emailAliasObj.getAliasExpansion().equals("")) {
                    directoryRow.putColumn(this.expansionColNum, emailAliasObj.getAliasExpansion());
                } else {
                    directoryRow.putColumn(this.expansionColNum, DEV_NULL);
                }
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowSizeException directoryTableRowSizeException) {
                throw directoryTableRowSizeException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var7_6 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
            throw throwable;
        }
    }

    public void modifyEmailRow(EmailAliasObj emailAliasObj, String string) throws Exception {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        try {
            try {
                EmailAliasObj emailAliasObj2;
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                EmailAliasObj emailAliasObj3 = new EmailAliasObj();
                if (string != null) {
                    directoryRow.putColumn(this.aliasColNum, string);
                } else {
                    directoryRow.putColumn(this.aliasColNum, emailAliasObj.getAliasName());
                }
                if (!string.equals(emailAliasObj.getAliasName())) {
                    try {
                        emailAliasObj2 = this.getEmailRow(emailAliasObj.getAliasName());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        throw new DirectoryTableRowNotUniqueException();
                    }
                }
                if ((directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow)) == null) {
                    throw new UserMgrNameNotFoundException(null);
                }
                try {
                    directoryTable = this.openAliasesTable();
                }
                catch (DirectoryTableException directoryTableException) {
                    this.createAliasesTable();
                    directoryTable = this.openAliasesTable();
                }
                emailAliasObj2 = directoryTable.getRowInstance();
                emailAliasObj3.debugPrint();
                emailAliasObj2.putColumn(this.aliasColNum, emailAliasObj.getAliasName());
                if (emailAliasObj.getAliasExpansion() != null && !emailAliasObj.getAliasExpansion().equals("")) {
                    emailAliasObj2.putColumn(this.expansionColNum, emailAliasObj.getAliasExpansion());
                } else {
                    emailAliasObj2.putColumn(this.expansionColNum, DEV_NULL);
                }
                directoryTable.modifyRow(directoryRow, (DirectoryRow)emailAliasObj2);
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var9_13 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
            throw throwable;
        }
    }

    public void deleteEmailRow(EmailAliasObj emailAliasObj) throws Exception {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            return;
        }
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.aliasColNum, emailAliasObj.getAliasName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new UserMgrNameNotFoundException(null);
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableException directoryTableException) {
                if (directoryTable != null) {
                    this.closeAliasesTable(directoryTable);
                }
                throw directoryTableException;
            }
            catch (Exception exception) {
                if (directoryTable != null) {
                    this.closeAliasesTable(directoryTable);
                }
                throw exception;
            }
            Object var6_6 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (directoryTable != null) {
                this.closeAliasesTable(directoryTable);
            }
            throw throwable;
        }
    }

    public static String[] parseMembersIntoArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isAliasesMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisAliasesTable.parseMembersIntoArray(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

