/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSInstaller;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public abstract class SunOSRmtT4InstallerPrtl
extends SunOSInstaller {
    private static final String FIRMWARE_IMAGE_DIRECTORY = "/var/sadm/swimages/";
    private static final String EXPECTED_PREFIX_MESSAGE = "Installation of <";
    private static final String FIRMWARE_REPOSITORY_PROMPT = "Please Enter Patch Location Pathname";
    private static final String NETRC_DIRECTORY_PROMPT = "Enter Your Home Directory Path";
    private static final String FTP_USER_PROMPT = "Enter ftp user";
    private static final String FTP_PASSWORD_PROMPT = "Enter ftp password";
    private static final String LOGIN_INCORRECT_MSG = "Login failed";
    private static final String CLEANING_UP_MSG = "Cleaning Up Temporary Files...";
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    protected static final String CR = "\r";
    protected static final String NL = "\n";
    protected static final String COMMAND_LINE_PROMPT = ">";
    protected static final int ONE_SECOND = 1000;
    protected static final int FIVE_SECONDS = 5000;
    protected static final int TEN_SECONDS = 10000;
    protected static final int TWENTY_SECONDS = 20000;
    protected static final int THIRTY_SECONDS = 30000;
    protected static final int ONE_MINUTE = 60000;
    protected static final int TWO_MINUTES = 120000;
    protected static final int FIVE_MINUTES = 300000;
    protected static final int TEN_MINUTES = 600000;
    protected static final int TWENTY_MINUTES = 1200000;
    protected static final int THIRTY_MINUTES = 1800000;
    protected static final int RETRY_LIMIT = 100;
    private CommandSession commandSession = null;
    private Host host = null;
    protected PatchProProperties properties = null;

    public SunOSRmtT4InstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
        this.host = manipulator.getHost();
    }

    protected String getPassword(String string) throws IOException {
        String string2 = null;
        String string3 = this.instParms.getConfigDirectoryPath() + "/." + string + PASSWORD_FILE_SUFFIX;
        File file = new File(string3);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Password file for \"" + string + "\" is not accessible");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        string2 = bufferedReader.readLine();
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SoftwarePackage installFirmwarePackage(File file) throws InteractiveSessionException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.properties.getProperty("SunOS.command.install.package", "/usr/sbin/pkgadd -d");
        string3 = this.activePatch.getPatchID().getPatchID();
        string4 = string + " " + file + "/" + string3 + " " + "all";
        if (this.debug) {
            System.out.println("Install command string: " + string4);
        }
        try {
            try {
                SoftwarePackage softwarePackage;
                int n;
                String string5;
                this.commandSession = new CommandSession();
                this.commandSession.expect("[y,n,?,q]", "y\n");
                this.commandSession.start(string4);
                this.commandSession.expectRemove("[y,n,?,q]");
                this.commandSession.stop();
                if (this.commandSession.getReturnValue() != 0) {
                    this.log.println(this, 2, "Unable to install the package that delivers the controller, loop card, L10N and web page files.");
                    throw new Exception("pkgadd exit code: " + this.commandSession.getReturnValue() + "\n\nSession output:\n" + this.commandSession.getAllSessionMessages());
                }
                String string6 = "";
                int n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(this.commandSession.getAllSessionMessages(), NL);
                String string7 = EXPECTED_PREFIX_MESSAGE;
                while (stringTokenizer.hasMoreElements()) {
                    string5 = stringTokenizer.nextToken();
                    if (!string5.startsWith(string7)) continue;
                    n = string7.length();
                    n2 = string5.indexOf(62, string7.length() - 1);
                    String string8 = string5.substring(n, n2);
                    string6 = (n2 = string8.indexOf(46)) == -1 ? string8 : string8.substring(0, n2);
                    break;
                }
                String string9 = "";
                string5 = "";
                stringTokenizer = null;
                n = 0;
                n2 = 0;
                stringTokenizer = new StringTokenizer(this.commandSession.getAllSessionMessages(), NL);
                string7 = EXPECTED_PREFIX_MESSAGE + string6;
                while (stringTokenizer.hasMoreElements()) {
                    string5 = stringTokenizer.nextToken();
                    if (!string5.startsWith(string7)) continue;
                    n2 = string5.indexOf(62, string7.length());
                    if (n2 == string7.length()) {
                        string9 = "1";
                        break;
                    }
                    n = string7.length() + 1;
                    string9 = string5.substring(n, n2);
                    break;
                }
                string2 = file + "/" + string3 + "/" + string6 + "/" + "pkginfo";
                SoftwarePackage softwarePackage2 = softwarePackage = new SoftwarePackage(string6, string9, new File(string2));
                Object var17_17 = null;
                if (this.commandSession == null) return softwarePackage2;
                this.commandSession.cleanup();
                return softwarePackage2;
            }
            catch (Exception exception) {
                this.commandSession.stop();
                this.log.println(this, 2, "Problem encountered installing the package that delivers controller related files.");
                this.incrementProgress(3.0);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (this.commandSession == null) throw throwable;
            this.commandSession.cleanup();
            throw throwable;
        }
    }

    protected void uploadFirmwareImages(String string) throws InteractiveSessionException {
        CommandSession commandSession = null;
        try {
            try {
                int n = 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.uploaddata.storagearray.limit", "1800")));
                string4 = this.properties.getProperty("patchpro.userid", "root");
                string5 = this.getPassword(string);
                string3 = this.activePatch.getPatchID().getPatchID();
                string2 = FIRMWARE_IMAGE_DIRECTORY + string3;
                commandSession = new CommandSession();
                commandSession.start("/sbin/sh " + string2 + "/6120.sh");
                if (!commandSession.expectedResponse(string + NL, FIRMWARE_REPOSITORY_PROMPT, 10000)) {
                    commandSession.cleanup();
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the firmware " + "repository was not detected.");
                    throw new Exception("Expected : \"Please Enter Patch Location Pathname\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(string2 + NL, NETRC_DIRECTORY_PROMPT, 20000)) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for specifying the directory " + "where the .netrc file is to be created was not detected.");
                    throw new Exception("Expected : \"Enter Your Home Directory Path\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(NL, FTP_USER_PROMPT, 5000)) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the FTP username was not detected.");
                    throw new Exception("Expected : \"Enter ftp user\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(string4 + NL, FTP_PASSWORD_PROMPT, 5000)) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the FTP password was not detected.");
                    throw new Exception("Expected : \"Enter ftp password\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (commandSession.expectedResponse(string5 + NL, LOGIN_INCORRECT_MSG, 5000)) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                    throw new Exception("Expected : \"Login failed\" message was detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (commandSession.getAllSessionMessages().indexOf("Login incorrect") != -1 || commandSession.getAllSessionMessages().indexOf(LOGIN_INCORRECT_MSG) != -1) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                    throw new Exception("\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.waitfor(CLEANING_UP_MSG, n)) {
                    this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The time reserved for the upload process " + "has elapsed.");
                    throw new Exception("Expected : FTP \"Cleaning Up Temporary Files...\" message was never detected\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                Object var9_9 = null;
                if (commandSession != null) {
                    commandSession.cleanup();
                }
            }
            catch (Exception exception) {
                this.incrementProgress(2.0);
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (commandSession != null) {
                commandSession.cleanup();
            }
            throw throwable;
        }
    }

    protected String getLine(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, NL);
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.indexOf(string) == -1) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    protected int convertToMilliseconds(int n) {
        return n * 1000;
    }

    protected int convertStringToInteger(String string) {
        return new Integer(string);
    }

    protected void waitForEstablishedConnection(String string, String string2, String string3) throws Exception {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        TelnetSession telnetSession = null;
        telnetSession = new TelnetSession();
        telnetSession.connect(string, string2, string3);
        n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.reconnect.controller.maxattempts", "100")));
        while (true) {
            try {
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                if (telnetSession.expectedResponse("port list\r", "offline", 5000)) {
                    bl = true;
                    telnetSession.disconnect();
                    telnetSession = null;
                    throw new Exception("The controller is not online.");
                }
                this.log.println(this, 7, "All controllers are ONLINE");
                telnetSession.disconnect();
                telnetSession = null;
            }
            catch (Exception exception) {
                if (bl) {
                    throw new Exception(exception.getMessage() + "\nSession:\n" + telnetSession.getAllSessionMessages());
                }
                if (telnetSession != null) {
                    telnetSession.disconnect();
                    telnetSession = null;
                }
                System.gc();
                this.log.println(this, 7, "Number of attempts to connect to master controller is " + ++n2);
                Thread.sleep(10000L);
                if (n2 < n) continue;
            }
            break;
        }
        if (n2 >= n) {
            throw new Exception("The amount of time reserved to reboot the storage array has expired.\nSession:\n" + telnetSession.getAllSessionMessages());
        }
    }
}

