/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.CertificateStore;
import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class SMCCertificateStore
implements CertificateStore {
    private static String _filename = null;
    private static char[] _storepass = null;
    private KeyStore _deploymentcerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            if (this._deploymentcerts == null) {
                this._deploymentcerts = KeyStore.getInstance("JKS");
                this._deploymentcerts.load(null, null);
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_filename);
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        SMCCertificateStore.this._deploymentcerts.load(bufferedInputStream, _storepass);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            exception.printStackTrace();
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    SMCCertificateStore.this._deploymentcerts.store(bufferedOutputStream, _storepass);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            exception.printStackTrace();
        }
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentcerts.getCertificate(string = "deploymentcert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._deploymentcerts.setCertificateEntry(string, certificate);
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        String string = this._deploymentcerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentcerts.deleteEntry(string);
        }
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        String string = null;
        string = this._deploymentcerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._deploymentcerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._deploymentcerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    public KeyStore getKeyStore() {
        return this._deploymentcerts;
    }

    static {
        _filename = SMCSSLConfig.getUserCertificateFile();
        _storepass = SMCSSLConfig.getUserCertificatePswd();
    }
}

