/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.tz;

import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.tz.TzObject;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class TzTable {
    private String table = new String("/etc/TIMEZONE");
    private String keyCol = "key";
    private String valCol = "value";
    private int keyColNum = 0;
    private int valColNum = 0;

    public void TzTable() {
    }

    private DirectoryTable openTimezoneTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
        tableDefinitions.loadTableDefinitions("pkginfo");
        tableDefinitions.setMappedTableName(this.table);
        this.keyColNum = tableDefinitions.getColumnNumber(this.keyCol);
        this.valColNum = tableDefinitions.getColumnNumber(this.valCol);
        try {
            directoryTable.open(tableDefinitions);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(tableDefinitions);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    public void addTimezoneEntry(TzObject tzObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = tzObject.getKey();
        String string2 = tzObject.getValue();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            throw new DBTableException("EXM_ADD_INV", this.table);
        }
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, tzObject);
            if (directoryRow != null) {
                TzObject tzObject2 = this.makeTimezoneObject(directoryRow);
                directoryTable.close();
                if (tzObject2.equals(tzObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            directoryRow = this.makeRow(directoryTable, tzObject);
            if (directoryRow != null) {
                directoryTable.addRow(directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void deleteTimezoneEntry(TzObject tzObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = tzObject.getKey();
        String string2 = tzObject.getValue();
        if (string == null || string.trim().length() == 0) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, tzObject);
            if (directoryRow == null) {
                directoryTable.close();
                return;
            }
            directoryTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void modifyTimezoneEntry(TzObject tzObject, TzObject tzObject2) throws DBTableException, DirectoryTableException {
        this.deleteTimezoneEntry(tzObject);
        this.addTimezoneEntry(tzObject2);
    }

    public String getTimezoneValue(String string) throws DirectoryTableException {
        String string2 = string;
        String string3 = null;
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(this.keyColNum, string2);
            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow2 != null) {
                string3 = directoryRow2.getColumn(this.valColNum);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return string3;
    }

    public void setTimezoneValue(String string, String string2) throws DirectoryTableException, DBTableException {
        String string3 = null;
        TzObject tzObject = null;
        string3 = this.getTimezoneValue(string);
        tzObject = this.makeTimezoneObject(string, string3);
        TzObject tzObject2 = null;
        tzObject2 = this.makeTimezoneObject(string, string2);
        this.modifyTimezoneEntry(tzObject, tzObject2);
    }

    public Vector list() throws DirectoryTableException {
        Vector<TzObject> vector = new Vector<TzObject>();
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                vector.addElement(this.makeTimezoneObject(directoryRow));
                directoryRow = directoryTable.getNextRow();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return vector;
    }

    public TzObject getTimezoneEntry(TzObject tzObject) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        TzObject tzObject2 = null;
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, tzObject);
            if (directoryRow != null) {
                tzObject2 = this.makeTimezoneObject(directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return tzObject2;
    }

    public TzObject getTimezoneEntry(String string) throws DirectoryTableException {
        TzObject tzObject = new TzObject(string, null);
        return this.getTimezoneEntry(tzObject);
    }

    private DirectoryRow checkTimezoneEntry(DirectoryTable directoryTable, TzObject tzObject) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        String string = tzObject.getKey();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        directoryRow = directoryTable.getRowInstance();
        directoryRow.putColumn(this.keyColNum, string);
        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
        return directoryRow;
    }

    private TzObject makeTimezoneObject(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.keyColNum);
        String string2 = directoryRow.getColumn(this.valColNum);
        TzObject tzObject = new TzObject(string, string2);
        return tzObject;
    }

    private TzObject makeTimezoneObject(String string, String string2) throws DirectoryTableException {
        String string3 = string;
        String string4 = string2;
        TzObject tzObject = new TzObject(string3, string4);
        return tzObject;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, TzObject tzObject) throws DirectoryTableException {
        String string;
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String string2 = tzObject.getKey();
        if (string2 != null && string2.trim().length() != 0) {
            directoryRow.putColumn(this.keyColNum, string2);
        }
        if ((string = tzObject.getValue()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.valColNum, string);
        }
        return directoryRow;
    }
}

