/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.CrontabEntries;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.zip.Adler32;

public class NameFilter
implements SearchTemplate {
    private static String GENERATED_NAME_PREFIX = "job_";
    private static int CONVERT_RADIX = 16;
    long checksumToMatch = 0L;
    String name = null;
    boolean useChecksum = false;

    public NameFilter(String string) {
        if (NameFilter.isGeneratedName(string)) {
            this.checksumToMatch = Long.parseLong(NameFilter.stripPrefix(string), CONVERT_RADIX);
            this.useChecksum = true;
        } else {
            this.name = string;
            this.useChecksum = false;
        }
    }

    public boolean matchRow(DirectoryRow directoryRow, TableDefinitions tableDefinitions) throws DirectoryTableException {
        return this.matchRow(directoryRow, 1, tableDefinitions);
    }

    public boolean matchRow(DirectoryRow directoryRow, int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n2 = tableDefinitions.getColumnNumber("comment");
        if (this.useChecksum) {
            int n3 = directoryRow.getNumberOfColumns();
            Adler32 adler32 = new Adler32();
            int n4 = 1;
            while (n4 <= n3) {
                if (n4 != n2) {
                    byte[] byArray = directoryRow.getColumn(n4, n).getBytes();
                    adler32.update(byArray);
                }
                ++n4;
            }
            return adler32.getValue() == this.checksumToMatch;
        }
        return directoryRow.getColumn(n2, n).equals(this.name);
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefinitions) throws DirectoryTableException {
        return null;
    }

    public static String generateUniqueName(CrontabEntries crontabEntries, int n) {
        long l = 0L;
        Adler32 adler32 = new Adler32();
        byte[] byArray = null;
        byArray = crontabEntries.getMinutes(n).getBytes();
        adler32.update(byArray);
        byArray = crontabEntries.getHours(n).getBytes();
        adler32.update(byArray);
        byArray = crontabEntries.getDaysOfTheMonth(n).getBytes();
        adler32.update(byArray);
        byArray = crontabEntries.getMonths(n).getBytes();
        adler32.update(byArray);
        byArray = crontabEntries.getDaysOfTheWeek(n).getBytes();
        adler32.update(byArray);
        byArray = crontabEntries.getCommand(n).getBytes();
        adler32.update(byArray);
        return GENERATED_NAME_PREFIX + Long.toString(adler32.getValue(), CONVERT_RADIX);
    }

    protected static boolean isGeneratedName(String string) {
        return string.startsWith(GENERATED_NAME_PREFIX);
    }

    protected static String stripPrefix(String string) {
        return string.substring(GENERATED_NAME_PREFIX.length());
    }
}

