/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.console.gui.PrivilegeDialog;
import java.awt.Component;
import java.io.FileDescriptor;
import java.net.URL;
import java.security.CodeSource;
import java.util.LinkedList;

public final class GUIPrivilegeManager
implements PrivilegeManager {
    protected Component compParent = null;
    protected boolean trustedMode = false;
    protected LinkedList grantSet = null;
    protected LinkedList denySet = null;
    protected PrivilegeDialog dialog = new PrivilegeDialog();

    void init(Component component, boolean bl) {
        this.compParent = component;
        this.trustedMode = bl;
    }

    boolean checkGrantSet(URL uRL) {
        if (this.grantSet == null) {
            return false;
        }
        if (uRL == null) {
            return this.grantSet.contains(null);
        }
        return this.grantSet.contains(uRL.toString());
    }

    void checkDenySet(URL uRL) {
        if (this.denySet == null) {
            return;
        }
        if (uRL == null && this.denySet.contains(null)) {
            throw new SecurityException();
        }
        if (this.denySet.contains(uRL.toString())) {
            throw new SecurityException();
        }
    }

    protected synchronized void showPrivilegeDialog(CodeSource codeSource, int n, Object[] objectArray) {
        URL uRL = null;
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (this.checkGrantSet(uRL)) {
            return;
        }
        this.checkDenySet(uRL);
        int n2 = this.dialog.showDialog(this.compParent, codeSource, n, objectArray);
        if (n2 == 1) {
            if (this.grantSet == null) {
                this.grantSet = new LinkedList();
            }
            if (uRL == null) {
                this.grantSet.add(null);
            } else {
                this.grantSet.add(uRL.toString());
            }
        } else {
            if (n2 == 3) {
                if (this.denySet == null) {
                    this.denySet = new LinkedList();
                }
                if (uRL == null) {
                    this.denySet.add(null);
                } else {
                    this.denySet.add(uRL.toString());
                }
                throw new SecurityException();
            }
            if (n2 == 2) {
                throw new SecurityException();
            }
        }
    }

    public void checkReadPrivilege(FileDescriptor fileDescriptor, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{fileDescriptor});
    }

    public void checkReadPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{string});
    }

    public void checkReadPrivilege(String string, Object object, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 0, new Object[]{string, object});
    }

    public void checkWritePrivilege(FileDescriptor fileDescriptor, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 1, new Object[]{fileDescriptor});
    }

    public void checkWritePrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 1, new Object[]{string});
    }

    public void checkDeletePrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 2, new Object[]{string});
    }

    public void checkExecPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 3, new Object[]{string});
    }

    public void checkLinkPrivilege(String string, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.showPrivilegeDialog(codeSource, 4, new Object[]{string});
    }
}

