/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;

public final class CodeSourcePolicy
extends Policy {
    private InheritableThreadLocal failedCodeSource = new InheritableThreadLocal();
    private Policy realPolicy;

    public CodeSourcePolicy(Policy policy) {
        this.realPolicy = policy != null ? policy : Policy.getPolicy();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this.realPolicy.getPermissions(codeSource);
        return new SpyPermissionCollection(permissionCollection, codeSource);
    }

    public void refresh() {
        this.realPolicy.refresh();
    }

    CodeSource getFailedCodeSource() {
        return (CodeSource)this.failedCodeSource.get();
    }

    private class SpyPermissionCollection
    extends PermissionCollection {
        CodeSource codesource;
        PermissionCollection realPC;

        public SpyPermissionCollection(PermissionCollection permissionCollection, CodeSource codeSource) {
            this.realPC = permissionCollection;
            this.codesource = codeSource;
        }

        public void add(Permission permission) {
            this.realPC.add(permission);
        }

        public Enumeration elements() {
            return this.realPC.elements();
        }

        public boolean implies(Permission permission) {
            boolean bl = this.realPC.implies(permission);
            if (!bl) {
                CodeSourcePolicy.this.failedCodeSource.set(this.codesource);
            }
            return bl;
        }
    }
}

