/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.client;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.ExternalClientProvider;
import com.sun.management.viper.InfrastructureException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceContext;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ServiceProxy;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationInfo;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContextImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfrastructureImpl;
import com.sun.management.viperimpl.UserInfo;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.Viper;
import com.sun.management.viperimpl.client.ToolAgentManager;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.client.AuthenticationClient;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class ViperClient
implements ToolInfrastructure,
AuthenticationRequest {
    public final int SMC_BEAN_COMPONENT = 0;
    public final int SMC_EXE_COMPONENT = 1;
    private static final String PN_VIPER_HOME = "viper.home";
    private static final String REMOTE_REGISTRY_VIPER = "/remoteregistry/_viper/_vstub";
    private static final String Default_Home = "/usr/sadm/lib/smc";
    public static final int DEFAULT_PORT = 898;
    private String viperHome = null;
    private VIdentity userID = null;
    private AuthenticationInfo authInfo = null;
    private ClientSecurityContext context = null;
    private VCallerImpl callerID = null;
    private ToolAgentManager saManager = null;
    private Viper viper = null;
    private ClassLoader codeLoader = null;
    private int codebasePort = 898;
    Hashtable loadedTools = new Hashtable();
    Hashtable loadedServices = new Hashtable();
    Hashtable loadedXCProviders = new Hashtable();

    public ViperClient(String string, int n) throws VException, RemoteException {
        this.configureViperHome();
        this.viper = this.lookupServer(string, n);
        this.codeLoader = this.getCodeLoader(this.viper);
    }

    public ViperClient(AuthenticationInfo authenticationInfo) throws VException, RemoteException {
        this.configureViperHome();
        if (authenticationInfo == null) {
            String[] stringArray = new String[]{"null"};
            throw new VException("InvalidParameter", stringArray);
        }
        this.login(authenticationInfo);
    }

    public void logout() {
        try {
            SecurityToken securityToken;
            Object[] objectArray;
            String string;
            Enumeration enumeration = this.loadedTools.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)this.loadedTools.get(enumeration.nextElement());
                objectArray = new Object[]{string};
                securityToken = this.getMessageToken(objectArray);
                this.viper.derefTool(string, securityToken);
            }
            enumeration = this.loadedServices.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)this.loadedServices.get(enumeration.nextElement());
                objectArray = new Object[]{string};
                securityToken = this.getMessageToken(objectArray);
                this.viper.derefService(string, securityToken);
            }
        }
        catch (Exception exception) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"deref bean exception during logout", (Throwable)exception);
        }
        try {
            AuthenticationClient.close(this, this.context);
        }
        catch (AuthenticationException authenticationException) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"close authentication session failed", (Throwable)authenticationException);
        }
        this.context = null;
        this.authInfo = null;
        this.userID = null;
        this.callerID = null;
        this.saManager = null;
        this.loadedTools.clear();
        this.loadedServices.clear();
    }

    protected void finalize() throws Throwable {
        if (this.context != null) {
            this.logout();
        }
    }

    private void configureViperHome() {
        try {
            this.viperHome = System.getProperty(PN_VIPER_HOME);
            if (this.viperHome == null) {
                this.viperHome = Default_Home;
                System.setProperty(PN_VIPER_HOME, this.viperHome);
            }
        }
        catch (Exception exception) {
            Debug.trace((String)"ViperClient", (int)Debug.WARNING, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void login(AuthenticationInfo authenticationInfo) throws VException, RemoteException {
        if (authenticationInfo == null) {
            String[] stringArray = new String[]{"null AuthenticationInfo"};
            throw new AuthenticationException("InvalidParameter", (Object)stringArray);
        }
        this.codebasePort = authenticationInfo.getPort();
        if (this.codebasePort <= 0) {
            this.codebasePort = 898;
        }
        String string = authenticationInfo.getHostName();
        try {
            string = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            throw new VException("IP resolution of host " + string + "failed");
        }
        this.viper = this.lookupServer(string, this.codebasePort);
        this.codeLoader = this.getCodeLoader(this.viper);
        if (!this.authenticateUser(authenticationInfo)) {
            String[] stringArray = new String[]{authenticationInfo.getName()};
            throw new AuthenticationException("UserLoginFailed", (Object)stringArray);
        }
        if (!this.authenticateRole(authenticationInfo)) {
            String[] stringArray = new String[]{authenticationInfo.getRoleName()};
            throw new AuthenticationException("RoleLoginFailed", (Object)stringArray);
        }
        this.authInfo = this.cloneAuthInfo(authenticationInfo);
        this.saManager = new ToolAgentManager(this);
    }

    public void assumeRole(AuthenticationInfo authenticationInfo) throws VException, RemoteException {
        if (!this.authenticateRole(authenticationInfo)) {
            throw new AuthenticationLoginException("null");
        }
        this.authInfo = new UserInfo(this.authInfo.getHostName(), this.authInfo.getPort(), this.authInfo.getName(), this.authInfo.getCredential(), authenticationInfo.getRoleName(), authenticationInfo.getRoleCredential());
    }

    private Viper lookupServer(String string, int n) throws InfrastructureException, RemoteException {
        String string2;
        Viper viper;
        String[] stringArray;
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException("null host name");
        }
        try {
            object2 = new URL("http://" + string + ":" + n + REMOTE_REGISTRY_VIPER);
            object = ((URL)object2).openConnection();
            stringArray = new ObjectInputStream(new BufferedInputStream(((URLConnection)object).getInputStream()));
            viper = (Viper)stringArray.readObject();
            if (viper == null) {
                throw new NullPointerException("Server RMI reference is null");
            }
            string2 = viper.getViperImplVersion();
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{string + ":" + n};
            throw new RemoteException(exception.getMessage());
        }
        object2 = string2.substring(0, string2.indexOf(46));
        object = Integer.toString(1);
        if (!((String)object).equals(object2)) {
            stringArray = new String[]{string2};
            throw new InfrastructureException("VersionIncompatible", stringArray);
        }
        return viper;
    }

    private boolean authenticateUser(AuthenticationInfo authenticationInfo) throws VException {
        if (authenticationInfo == null) {
            return false;
        }
        ClientSecurityContext clientSecurityContext = AuthenticationClient.getSecurityContext();
        String string = authenticationInfo.getHostName();
        AuthenticationPrincipal authenticationPrincipal = new AuthenticationPrincipal(0, authenticationInfo.getName(), null);
        authenticationPrincipal.setHostName(string);
        clientSecurityContext.setServerHostName(string);
        clientSecurityContext.setAuthPrincipal(authenticationPrincipal);
        clientSecurityContext.setUserPassword(authenticationInfo.getCredential());
        if (this.authenticateIdentity(clientSecurityContext)) {
            this.userID = this.convertToVId(authenticationPrincipal);
            try {
                this.callerID = this.viper.getCallerImpl(this.getMessageToken());
            }
            catch (RemoteException remoteException) {
                throw new VException("RMI_ERR: " + remoteException.getMessage());
            }
            return true;
        }
        return false;
    }

    private ClassLoader getCodeLoader(Viper viper) throws VException {
        try {
            URL uRL = viper.getCodebase();
            Class<?> clazz = RMIClassLoader.loadClass(uRL, "NullClass");
            return clazz.getClassLoader();
        }
        catch (Throwable throwable) {
            throw new VException("Could not create remote code loader.");
        }
    }

    private boolean authenticateRole(AuthenticationInfo authenticationInfo) throws VException, RemoteException {
        if (authenticationInfo == null || this.userID == null) {
            return false;
        }
        if (authenticationInfo.getRoleName() == null || authenticationInfo.getRoleName().length() == 0) {
            return true;
        }
        ClientSecurityContext clientSecurityContext = AuthenticationClient.getSecurityContext();
        AuthenticationPrincipal authenticationPrincipal = new AuthenticationPrincipal(0, this.authInfo != null ? this.authInfo.getName() : authenticationInfo.getName(), authenticationInfo.getRoleName());
        String string = this.authInfo != null ? this.authInfo.getHostName() : authenticationInfo.getHostName();
        authenticationPrincipal.setHostName(string);
        clientSecurityContext.setServerHostName(string);
        clientSecurityContext.setAuthPrincipal(authenticationPrincipal);
        clientSecurityContext.setUserPassword(authenticationInfo.getRoleCredential());
        if (this.authenticateIdentity(clientSecurityContext)) {
            this.userID = this.convertToVId(authenticationPrincipal);
            this.callerID = this.viper.getCallerImpl(this.getMessageToken());
            return true;
        }
        return false;
    }

    private boolean authenticateIdentity(ClientSecurityContext clientSecurityContext) throws VException {
        try {
            AuthenticationClient.authenticate(this, clientSecurityContext);
        }
        catch (AuthenticationLoginException authenticationLoginException) {
            throw authenticationLoginException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Exception exception) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"unexpected exception from authenticate()", (Throwable)exception);
            throw new VException("Unable to authenticate:" + exception.toString());
        }
        if (this.context != null) {
            try {
                AuthenticationClient.close(this, this.context);
            }
            catch (AuthenticationException authenticationException) {
                Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"closing client context", (Throwable)authenticationException);
            }
        }
        this.context = clientSecurityContext;
        return true;
    }

    public SecurityToken authRequest(String string, SecurityToken securityToken) throws AuthenticationException {
        SecurityToken securityToken2 = null;
        try {
            securityToken2 = this.viper.authRequest(string, securityToken);
        }
        catch (RemoteException remoteException) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("Remote exception in authentication request: type=" + string + ", exception=" + remoteException.getMessage()), (Throwable)remoteException);
            throw new AuthenticationException("Remote exception in authentication request", (Exception)remoteException);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (VException vException) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("Unexpected exception in authentication request: type=" + string + ", exception=" + vException.getMessage()), (Throwable)vException);
            throw new AuthenticationException("Unexpected exception in authentication request", (Exception)((Object)vException));
        }
        return securityToken2;
    }

    private SecurityToken getMessageToken() throws VException {
        return this.getMessageToken(null);
    }

    SecurityToken getMessageToken(Object[] objectArray) throws VException {
        if (this.context == null) {
            throw new InfrastructureException("NoSecureSession");
        }
        return this.context.generateMessageToken(objectArray);
    }

    public Service getServiceByName(String string) throws VException {
        Object[] objectArray;
        Object object;
        String string2;
        block13: {
            if (string == null) {
                String[] stringArray = new String[]{"null"};
                throw new BeanNotFoundException("ServiceNotFound", (Object)stringArray);
            }
            string2 = null;
            object = null;
            try {
                objectArray = new Object[]{string};
                SecurityToken securityToken = this.getMessageToken(objectArray);
                ServiceInfoImpl[] serviceInfoImplArray = this.viper.getServiceInfoImpl(string, securityToken);
                if (serviceInfoImplArray == null || serviceInfoImplArray.length == 0) {
                    String[] stringArray = new String[]{string};
                    throw new BeanNotFoundException("ServiceNotFound", (Object)stringArray);
                }
                int n = 0;
                while (n < serviceInfoImplArray.length) {
                    block12: {
                        object = null;
                        string2 = serviceInfoImplArray[n].getClassName();
                        objectArray[0] = string2;
                        securityToken = this.getMessageToken(objectArray);
                        try {
                            Object object2;
                            if (serviceInfoImplArray[n].getImplType() == 1) {
                                object2 = this.viper.getServiceObject(string2, securityToken);
                                if (object2 == null) break block12;
                                ((ServiceAgent)object2).setContext(this.saManager);
                                object = object2;
                                break;
                            }
                            if (serviceInfoImplArray[n].isSingleton()) {
                                object2 = this.loadedServices.keys();
                                while (object2.hasMoreElements()) {
                                    Service service = (Service)object2.nextElement();
                                    if (!this.loadedServices.get(service).equals(string2)) continue;
                                    object = service;
                                    break;
                                }
                                if (object != null) break block13;
                            }
                            if ((object2 = (ServiceProxy)Beans.instantiate(this.codeLoader, string2)) == null) break block12;
                            object2.setContext((ServiceContext)new ServiceContextImpl(null, serviceInfoImplArray[n].getProperties(), this.callerID));
                            object2.init((ToolInfrastructure)new ToolInfrastructureImpl(this));
                            object2.start();
                            object = (Service)object2;
                            this.viper.refServiceProxy(string2, securityToken);
                            break;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof RemoteException) {
                                throw (RemoteException)throwable;
                            }
                            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("exception in getServiceByName: " + throwable.getMessage()), null);
                        }
                    }
                    ++n;
                }
            }
            catch (RemoteException remoteException) {
                throw new VException("RMI_ERR: " + remoteException.getMessage());
            }
        }
        if (object == null) {
            objectArray = new String[]{string};
            throw new BeanNotFoundException("ServiceNotFound", (Object)objectArray);
        }
        this.loadedServices.put(object, string2);
        return object;
    }

    public void releaseService(Service service) throws VException {
        if (service != null) {
            Object object;
            if (service instanceof ServiceProxy) {
                try {
                    object = (ServiceProxy)service;
                    object.stop();
                    object.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((object = (String)this.loadedServices.remove(service)) != null) {
                try {
                    Object[] objectArray = new Object[]{object};
                    SecurityToken securityToken = this.getMessageToken(objectArray);
                    this.viper.derefService((String)object, securityToken);
                }
                catch (RemoteException remoteException) {
                    throw new VException("RMI_ERR: " + remoteException.getMessage());
                }
            }
        }
    }

    public Tool getToolByName(String string) throws VException {
        Object[] objectArray = new Object[]{string};
        SecurityToken securityToken = this.getMessageToken(objectArray);
        try {
            Tool tool = (Tool)Beans.instantiate(this.codeLoader, string);
            this.viper.refTool(string, securityToken);
            this.loadedTools.put(tool, string);
            return tool;
        }
        catch (VException vException) {
            throw vException;
        }
        catch (Exception exception) {
            throw new VException("UnexpectedException", exception);
        }
        catch (Throwable throwable) {
            throw new VException(throwable.getMessage());
        }
    }

    public void releaseTool(Tool tool) throws VException {
        String string;
        if (tool != null && (string = (String)this.loadedTools.remove(tool)) != null) {
            try {
                Object[] objectArray = new Object[]{string};
                SecurityToken securityToken = this.getMessageToken(objectArray);
                this.viper.derefTool(string, securityToken);
            }
            catch (RemoteException remoteException) {
                throw new VException("RMI_ERR: " + remoteException.getMessage());
            }
        }
    }

    public ToolInfo getToolInfo(String string) throws VException {
        try {
            return this.viper.getToolInfoImpl(string);
        }
        catch (RemoteException remoteException) {
            throw new InfrastructureException("RMI_ERR: " + remoteException.getMessage());
        }
    }

    public ServiceInfo getServiceInfo(String string) throws VException {
        Object[] objectArray = new Object[]{string};
        SecurityToken securityToken = this.getMessageToken(objectArray);
        try {
            return this.viper.getServiceInfoImpl(string, securityToken)[0];
        }
        catch (RemoteException remoteException) {
            throw new InfrastructureException("RMI_ERR: " + remoteException.getMessage());
        }
    }

    public VIdentity getIdentity() {
        return this.userID;
    }

    public Object getExternalClient(String string, Object[] objectArray) throws Exception {
        ExternalClientProvider externalClientProvider = (ExternalClientProvider)this.loadedXCProviders.get(string);
        if (externalClientProvider == null) {
            Object[] objectArray2 = new Object[]{string};
            SecurityToken securityToken = this.getMessageToken(objectArray2);
            ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = this.viper.getExternalClientProviderInfoImpl(string, securityToken);
            if (externalClientProviderInfoImplArray == null) {
                String[] stringArray = new String[]{string};
                throw new InfrastructureException("XCProviderNotFound", stringArray);
            }
            String string2 = null;
            String string3 = "";
            int n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                externalClientProvider = null;
                try {
                    string2 = externalClientProviderInfoImplArray[n].getClassName();
                    externalClientProvider = (ExternalClientProvider)Beans.instantiate(this.codeLoader, string2);
                    if (externalClientProvider != null) {
                        break;
                    }
                }
                catch (Throwable throwable) {
                    string3 = string3 + "\n" + string2 + ": " + throwable.getLocalizedMessage();
                }
                ++n;
            }
            if (externalClientProvider != null) {
                String[] stringArray = externalClientProviderInfoImplArray[n].getClientTypes();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.loadedXCProviders.put(stringArray[n2], externalClientProvider);
                    ++n2;
                }
            } else {
                String[] stringArray = new String[]{string, string3};
                throw new InfrastructureException("XCProviderLoadError", stringArray);
            }
        }
        return externalClientProvider.getExternalClient(string, this.authInfo.getHostName(), this.authInfo.getName(), this.authInfo.getCredential(), this.authInfo.getRoleName(), this.authInfo.getRoleCredential(), objectArray);
    }

    public void releaseExternalClient(String string, Object[] objectArray) throws Exception {
        ExternalClientProvider externalClientProvider = (ExternalClientProvider)this.loadedXCProviders.get(string);
        if (externalClientProvider == null) {
            Object[] objectArray2 = new Object[]{string};
            SecurityToken securityToken = this.getMessageToken(objectArray2);
            ExternalClientProviderInfoImpl[] externalClientProviderInfoImplArray = this.viper.getExternalClientProviderInfoImpl(string, securityToken);
            if (externalClientProviderInfoImplArray == null) {
                String[] stringArray = new String[]{string};
                throw new InfrastructureException("XCProviderNotFound", stringArray);
            }
            String string2 = null;
            String string3 = "";
            int n = 0;
            while (n < externalClientProviderInfoImplArray.length) {
                externalClientProvider = null;
                try {
                    string2 = externalClientProviderInfoImplArray[n].getClassName();
                    externalClientProvider = (ExternalClientProvider)Beans.instantiate(this.codeLoader, string2);
                    if (externalClientProvider != null) {
                        break;
                    }
                }
                catch (Throwable throwable) {
                    string3 = string3 + "\n" + string2 + ": " + throwable.getLocalizedMessage();
                }
                ++n;
            }
            if (externalClientProvider != null) {
                String[] stringArray = externalClientProviderInfoImplArray[n].getClientTypes();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.loadedXCProviders.put(stringArray[n2], externalClientProvider);
                    ++n2;
                }
            } else {
                String[] stringArray = new String[]{string, string3};
                throw new InfrastructureException("XCProviderLoadError", stringArray);
            }
        }
        externalClientProvider.closeExternalClient(objectArray);
    }

    public Process execConsole(int n, String string, String string2, String string3, AdminMgmtScope adminMgmtScope, Properties properties, String string4) throws VException {
        Object object;
        String string5;
        Object object2;
        if (n != 0) {
            throw new VException("UnsupportedConsoleType");
        }
        String string6 = System.getProperty(PN_VIPER_HOME);
        String string7 = string6 + "/bin/smc -t --trust";
        string7 = string7 + " --hostname " + (string == null || string.trim().length() == 0 ? this.authInfo.getHostName() + ":" + this.authInfo.getPort() : string.trim());
        string7 = string7 + " --username " + this.authInfo.getName();
        if (this.authInfo.getRoleName() != null && this.authInfo.getRoleName().trim().length() > 0) {
            string7 = string7 + " --rolename " + this.authInfo.getRoleName();
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new VException("NullToolforVTerm");
        }
        string7 = string7 + " --tool " + string3;
        if (adminMgmtScope != null) {
            string7 = string7 + " --domain " + adminMgmtScope.toDirectoryTableURL();
        }
        if (string2 != null && string2.trim().length() > 0) {
            string7 = string7 + " --toolbox " + string2;
        }
        if (properties != null && (object2 = properties.propertyNames()) != null) {
            while (object2.hasMoreElements()) {
                string5 = (String)object2.nextElement();
                object = properties.getProperty(string5);
                if ((string5 + (String)object).indexOf(34) >= 0) {
                    InvalidParameterException invalidParameterException = new InvalidParameterException("no quotes are allowed in property key or value");
                    throw new VException("VTermExecErr", (Exception)invalidParameterException);
                }
                string7 = string7 + " -J-D\"" + string5 + "\"=\"" + (String)object + "\"";
            }
        }
        if (string4 != null) {
            string7 = string7 + " -- " + string4;
        }
        Debug.trace((String)"ViperClient", (int)Debug.INFORMATION, (String)("execConsole command: " + string7), null);
        object2 = null;
        try {
            string5 = string7;
            object2 = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Runtime.getRuntime().exec(string5);
                }
            });
            object = ((Process)object2).getOutputStream();
            ((OutputStream)object).write((this.authInfo.getCredential() + "\n").getBytes());
            if (this.authInfo.getRoleName() != null && this.authInfo.getRoleName().trim().length() > 0) {
                ((OutputStream)object).write((this.authInfo.getRoleCredential() + "\n").getBytes());
            }
            if (string4 == null || string4.trim().length() == 0) {
                ((OutputStream)object).write("\n".getBytes());
            }
            ((OutputStream)object).flush();
            return object2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new VException("VTermExecErr", privilegedActionException.getException());
        }
        catch (Exception exception) {
            if (object2 != null) {
                ((Process)object2).destroy();
            }
            throw new VException("VTermExecErr", exception);
        }
    }

    public VLocalizedInfo getLocalizedInfo(String string, Locale locale) throws VException {
        String string2;
        String string3;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        ImageIcon imageIcon = null;
        ImageIcon imageIcon2 = null;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale, this.codeLoader);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            throw new VException("ResourceNotFound", stringArray);
        }
        try {
            string4 = resourceBundle.getString("BEANNAME");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string5 = resourceBundle.getString("DESCRIPTION");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string6 = resourceBundle.getString("VERSION");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string7 = resourceBundle.getString("VENDOR");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = resourceBundle.getString("LARGEICON");
            if (string3 != null) {
                string2 = this.getResourcePath(string, string3);
                imageIcon = ConsoleUtility.loadImageIcon((URL)this.codeLoader.getResource(string2), (String)"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = resourceBundle.getString("SMALLICON");
            if (string3 != null) {
                string2 = this.getResourcePath(string, string3);
                imageIcon2 = ConsoleUtility.loadImageIcon((URL)this.codeLoader.getResource(string2), (String)"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new VLocalizedInfo(string4, string5, string7, string6, imageIcon, imageIcon2);
    }

    private String getResourcePath(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        while (n >= 0 && string2.startsWith("../")) {
            string2 = string2.substring(3);
            string = string.substring(0, n);
            n = string.lastIndexOf(46);
        }
        return string.substring(0, n + 1).replace('.', '/') + string2;
    }

    public void stopServer() throws RemoteException {
        try {
            SecurityToken securityToken = this.getMessageToken();
            this.viper.stopServer(securityToken);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector getToolInfoList() throws VException, RemoteException {
        return this.viper.getToolInfoImplList();
    }

    public Vector getServiceInfoList() throws VException, RemoteException {
        SecurityToken securityToken = this.getMessageToken();
        return this.viper.getServiceInfoImplList(securityToken);
    }

    public String getHostName() {
        if (this.userID == null) {
            return null;
        }
        return this.userID.getAuthenHost();
    }

    public int getPort() {
        return this.codebasePort;
    }

    public VIdentity[] getRoles() {
        AuthenticationPrincipal[] authenticationPrincipalArray = this.context.getRoleList();
        if (authenticationPrincipalArray == null) {
            return null;
        }
        VIdentity[] vIdentityArray = new VIdentity[authenticationPrincipalArray.length];
        int n = 0;
        while (n < authenticationPrincipalArray.length) {
            vIdentityArray[n] = this.convertToVId(authenticationPrincipalArray[n]);
            ++n;
        }
        return vIdentityArray;
    }

    private VIdentity convertToVId(AuthenticationPrincipal authenticationPrincipal) {
        VIdentity vIdentity = authenticationPrincipal.getRoleName() == null ? new VIdentity(authenticationPrincipal.getUserName(), authenticationPrincipal.getUserDesc(), authenticationPrincipal.getUserName(), authenticationPrincipal.getUserDesc(), authenticationPrincipal.getHostName()) : new VIdentity(authenticationPrincipal.getRoleName(), authenticationPrincipal.getRoleDesc(), authenticationPrincipal.getUserName(), authenticationPrincipal.getUserDesc(), authenticationPrincipal.getHostName());
        return vIdentity;
    }

    private AuthenticationInfo cloneAuthInfo(AuthenticationInfo authenticationInfo) {
        return new UserInfo(authenticationInfo.getHostName(), authenticationInfo.getPort(), authenticationInfo.getName(), authenticationInfo.getCredential(), authenticationInfo.getRoleName(), authenticationInfo.getRoleCredential());
    }
}

