/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.InvokeMethodDialog;
import com.sun.wbem.apps.cimworkshop.QualifierWindow;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.Util;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class CIMMethodsPanel
extends JScrollPane
implements MouseListener,
ActionListener {
    private DefaultListModel listModel;
    private JList methodsList;
    private boolean dataChanged = false;
    protected JPopupMenu popupMenu;
    protected JMenuItem mnuInvokeMethod;
    protected CIMClient cimClient;
    protected boolean newElement;
    protected boolean isInstance = false;
    protected CIMElement cimElement;

    public CIMMethodsPanel() {
        this(false);
    }

    public CIMMethodsPanel(boolean bl) {
        this.newElement = bl;
        this.listModel = new DefaultListModel(){

            public Object getElementAt(int n) {
                CIMMethod cIMMethod = (CIMMethod)super.getElementAt(n);
                return cIMMethod.toString();
            }
        };
        this.methodsList = new JList(this.listModel);
        this.methodsList.getSelectionModel().setSelectionMode(0);
        this.methodsList.setBackground(this.getBackground());
        this.methodsList.addMouseListener(this);
        this.setViewportView(this.methodsList);
        this.popupMenu = new JPopupMenu();
        ActionString actionString = new ActionString("LBL_QUALIFIERS");
        ActionString actionString2 = new ActionString("MNU_INVOKE_METHOD");
        JMenuItem jMenuItem = this.popupMenu.add(new JMenuItem(actionString.getString()));
        jMenuItem.setActionCommand("QUALIFIERS");
        jMenuItem.addActionListener(this);
        this.mnuInvokeMethod = new JMenuItem(actionString2.getString());
        this.mnuInvokeMethod.setActionCommand("INVOKE_METHOD");
        this.mnuInvokeMethod.addActionListener(this);
        this.mnuInvokeMethod.setEnabled(CIMClientObject.userHasWritePermission());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("QUALIFIERS")) {
            this.showQualifiers();
        } else if (string.equals("INVOKE_METHOD")) {
            this.invokeMethod();
        }
    }

    public void showQualifiers() {
        int n = this.methodsList.getMinSelectionIndex();
        CIMMethod cIMMethod = (CIMMethod)this.listModel.elementAt(n);
        QualifierWindow qualifierWindow = new QualifierWindow(Util.getFrame(this), this.cimClient, (CIMElement)cIMMethod, this.newElement);
    }

    public void populateList(CIMClient cIMClient, CIMElement cIMElement) {
        this.cimClient = cIMClient;
        Vector vector = new Vector();
        Util.setWaitCursor(this);
        this.cimElement = cIMElement;
        this.listModel.removeAllElements();
        if (cIMElement != null) {
            CIMMethod cIMMethod;
            if (cIMElement instanceof CIMInstance) {
                if (this.popupMenu.getComponentIndex(this.mnuInvokeMethod) == -1) {
                    this.popupMenu.add(this.mnuInvokeMethod);
                }
                this.isInstance = true;
                try {
                    cIMMethod = new CIMObjectPath(((CIMInstance)cIMElement).getClassName());
                    CIMClass cIMClass = this.cimClient.getClass((CIMObjectPath)cIMMethod, false, true, true, null);
                    vector = cIMClass.getMethods();
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            } else if (cIMElement instanceof CIMClass) {
                vector = ((CIMClass)cIMElement).getMethods();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                cIMMethod = (CIMMethod)enumeration.nextElement();
                this.listModel.addElement(cIMMethod);
            }
        }
        if (this.listModel.size() > 0) {
            this.methodsList.setSelectedIndex(0);
        }
        Util.setDefaultCursor(this);
    }

    public void invokeMethod() {
        Util.setWaitCursor(this);
        CIMMethod cIMMethod = (CIMMethod)this.listModel.elementAt(this.methodsList.getSelectedIndex());
        CIMObjectPath cIMObjectPath = new CIMObjectPath(((CIMInstance)this.cimElement).getClassName());
        cIMObjectPath.setKeys(((CIMInstance)this.cimElement).getKeyValuePairs());
        InvokeMethodDialog invokeMethodDialog = new InvokeMethodDialog(Util.getFrame(this), cIMMethod, cIMObjectPath);
        Util.setDefaultCursor(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        } else if (mouseEvent.getClickCount() <= 1 || this.isInstance) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public CIMMethod getSelectedMethod() {
        int n = this.methodsList.getSelectedIndex();
        if (n >= 0) {
            return (CIMMethod)this.listModel.elementAt(n);
        }
        return null;
    }

    public boolean isSelectionEmpty() {
        return this.methodsList.isSelectionEmpty();
    }

    protected void showPopupMenu(Point point) {
        int n = this.methodsList.locationToIndex(point);
        if (n == -1) {
            return;
        }
        this.methodsList.setSelectedIndex(n);
        Point point2 = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - point2.x + 10, point.y - point2.y);
    }
}

