/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.wbem.client.adapter.http.transport.Header;
import javax.wbem.client.adapter.http.transport.HttpClientManager;
import javax.wbem.client.adapter.http.transport.HttpClientSocketFactory;
import javax.wbem.client.adapter.http.transport.HttpParseException;
import javax.wbem.client.adapter.http.transport.MessageReader;
import javax.wbem.client.adapter.http.transport.MessageWriter;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.client.adapter.http.transport.Request;
import javax.wbem.client.adapter.http.transport.ServerInfo;
import javax.wbem.client.adapter.http.transport.StartLine;
import javax.wbem.client.adapter.http.transport.TimedConnection;

public class HttpClientConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final String clientString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + (class$javax$wbem$client$adapter$http$transport$HttpClientConnection == null ? (class$javax$wbem$client$adapter$http$transport$HttpClientConnection = HttpClientConnection.class$("javax.wbem.client.adapter.http.transport.HttpClientConnection")) : class$javax$wbem$client$adapter$http$transport$HttpClientConnection).getName();
        }
    });
    private static final int DIRECT = 0;
    private static final int PROXIED = 1;
    private static final int TUNNELED = 2;
    private static final int IDLE = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private int mode;
    private int state = 0;
    private Object stateLock = new Object();
    private ServerInfo targetInfo;
    private ServerInfo proxyInfo;
    private HttpClientManager manager;
    private Socket sock;
    private OutputStream out;
    private InputStream in;
    private boolean useMPost = false;
    private boolean chunkingDisabled = false;
    static /* synthetic */ Class class$javax$wbem$client$adapter$http$transport$HttpClientConnection;

    public HttpClientConnection(String string, int n, HttpClientSocketFactory httpClientSocketFactory, boolean bl) throws IOException {
        this.useMPost = bl;
        this.manager = new HttpClientManager();
        this.mode = 0;
        this.targetInfo = this.manager.getServerInfo(string, n);
        this.setupConnection(httpClientSocketFactory);
    }

    public HttpClientConnection(String string, int n, HttpClientSocketFactory httpClientSocketFactory, boolean bl, boolean bl2) throws IOException {
        this.useMPost = bl;
        this.chunkingDisabled = !bl2;
        this.manager = new HttpClientManager();
        this.mode = 0;
        this.targetInfo = this.manager.getServerInfo(string, n);
        this.setupConnection(httpClientSocketFactory);
    }

    public HttpClientConnection(String string, int n, String string2, int n2, boolean bl, HttpClientSocketFactory httpClientSocketFactory, HttpClientManager httpClientManager) throws IOException {
        this.manager = httpClientManager;
        this.mode = bl ? 2 : 1;
        this.targetInfo = httpClientManager.getServerInfo(string, n);
        this.proxyInfo = httpClientManager.getServerInfo(string2, n2);
        this.setupConnection(httpClientSocketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() throws IOException {
        this.markBusy();
        this.fetchServerInfo();
        try {
            boolean bl = this.ping(false);
            Object var3_2 = null;
            this.markIdle();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.markIdle();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest(String string) throws IOException {
        OutboundRequestImpl outboundRequestImpl = null;
        this.markBusy();
        this.fetchServerInfo();
        try {
            OutboundRequestImpl outboundRequestImpl2 = outboundRequestImpl = new OutboundRequestImpl(string);
            Object var5_4 = null;
            if (outboundRequestImpl == null) {
                this.markIdle();
            }
            return outboundRequestImpl2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (outboundRequestImpl != null) break block3;
                this.markIdle();
            }
            throw throwable;
        }
    }

    protected void idle() {
    }

    public Socket getSocket() {
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean bl) {
        Object object = this.stateLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.state != 2) break block5;
                    boolean bl2 = true;
                    return bl2;
                }
                if (bl || this.state != 1) break block6;
                boolean bl3 = false;
                return bl3;
            }
            this.state = 2;
        }
        this.disconnect();
        return true;
    }

    private void fetchServerInfo() {
        ServerInfo serverInfo = this.manager.getServerInfo(this.targetInfo.host, this.targetInfo.port);
        if (serverInfo.timestamp > this.targetInfo.timestamp) {
            this.targetInfo = serverInfo;
        }
        if (this.mode != 0) {
            serverInfo = this.manager.getServerInfo(this.proxyInfo.host, this.proxyInfo.port);
            if (serverInfo.timestamp > this.proxyInfo.timestamp) {
                this.proxyInfo = serverInfo;
            }
        }
    }

    private void flushServerInfo() {
        this.manager.cacheServerInfo(this.targetInfo);
        if (this.mode != 0) {
            this.manager.cacheServerInfo(this.proxyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBusy() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new IOException("connection closed");
            }
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            this.state = 0;
        }
        this.idle();
    }

    private void setupConnection(HttpClientSocketFactory httpClientSocketFactory) throws IOException {
        try {
            int n = 0;
            while (n < 4) {
                if (this.sock == null) {
                    this.connect(httpClientSocketFactory);
                }
                if (this.mode == 1 && this.proxyInfo.timestamp == -1L) {
                    this.requestProxyOptions();
                } else if (this.targetInfo.timestamp == -1L) {
                    this.ping(true);
                } else {
                    return;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.disconnect();
        throw new ConnectException("failed to establish HTTP connection");
    }

    private void connect(HttpClientSocketFactory httpClientSocketFactory) throws IOException {
        this.disconnect();
        int n = 0;
        while (n < 2) {
            if (this.sock == null) {
                ServerInfo serverInfo = this.mode == 0 ? this.targetInfo : this.proxyInfo;
                this.sock = httpClientSocketFactory.createSocket(serverInfo.host, serverInfo.port);
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.in = new BufferedInputStream(this.sock.getInputStream());
            }
            if (this.mode != 2) {
                return;
            }
            if (this.requestProxyConnect()) {
                this.sock = httpClientSocketFactory.createTunnelSocket(this.sock);
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.in = new BufferedInputStream(this.sock.getInputStream());
                return;
            }
            ++n;
        }
    }

    private void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
            this.out = null;
            this.in = null;
        }
    }

    private boolean ping(boolean bl) throws IOException {
        StartLine startLine = this.createPostLine(null);
        Header header = this.createPostHeader(startLine);
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(startLine);
        messageWriter.writeHeader(header);
        messageWriter.flush();
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<CIM DTDVERSION=\"2.0\" CIMVERSION=\"2.0\">\n</CIM\n>";
        messageWriter.writeContent(string.getBytes(), 0, string.length());
        messageWriter.writeTrailer(null);
        MessageReader messageReader = new MessageReader(this.in, false);
        StartLine startLine2 = messageReader.readStartLine();
        Header header2 = messageReader.readHeader();
        header2.merge(messageReader.readTrailer());
        this.analyzePostResponse(startLine2, header2);
        if (!HttpClientConnection.supportsPersist(startLine2, header2)) {
            if (bl) {
                this.disconnect();
            } else {
                this.shutdown(true);
            }
        }
        return startLine2.status / 100 == 2;
    }

    private boolean requestProxyOptions() throws IOException {
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(new StartLine(1, 1, "OPTIONS", "*"));
        messageWriter.writeHeader(this.createProxyHeader());
        messageWriter.writeTrailer(null);
        MessageReader messageReader = new MessageReader(this.in, false);
        StartLine startLine = messageReader.readStartLine();
        Header header = messageReader.readHeader();
        header.merge(messageReader.readTrailer());
        this.analyzeProxyResponse(startLine, header);
        if (!HttpClientConnection.supportsPersist(startLine, header)) {
            this.disconnect();
        }
        return startLine.status / 100 == 2;
    }

    private boolean requestProxyConnect() throws IOException {
        StartLine startLine = new StartLine(1, 1, "CONNECT", this.targetInfo.host + ":" + this.targetInfo.port);
        Header header = this.createProxyHeader();
        String string = this.proxyInfo.getAuthString("http", startLine.method, startLine.uri);
        if (string != null) {
            header.setField("Proxy-Authorization", string);
        }
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(startLine);
        messageWriter.writeHeader(header);
        messageWriter.writeTrailer(null);
        MessageReader messageReader = new MessageReader(this.in, true);
        StartLine startLine2 = messageReader.readStartLine();
        Header header2 = messageReader.readHeader();
        header2.merge(messageReader.readTrailer());
        this.analyzeProxyResponse(startLine2, header2);
        if (startLine2.status / 100 == 2) {
            return true;
        }
        if (!HttpClientConnection.supportsPersist(startLine2, header2)) {
            this.disconnect();
        }
        return false;
    }

    private StartLine createPostLine(String string) {
        String string2 = this.useMPost ? "M-POST" : "POST";
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = "/";
        }
        String string4 = this.mode == 1 ? "http://" + this.targetInfo.host + ":" + this.targetInfo.port + string3 : string3;
        return new StartLine(1, 1, string2, string4);
    }

    private Header createBaseHeader() {
        Header header = new Header();
        long l = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(l));
        header.setField("User-Agent", clientString);
        return header;
    }

    private Header createProxyHeader() {
        Header header = this.createBaseHeader();
        header.setField("Host", this.proxyInfo.host + ":" + this.proxyInfo.port);
        return header;
    }

    private Header createPostHeader(StartLine startLine) {
        Header header = this.createBaseHeader();
        header.setField("Host", this.targetInfo.host + ":" + this.targetInfo.port);
        header.setField("Connection", "Keep-Alive");
        String string = this.targetInfo.getAuthString("http", startLine.method, startLine.uri);
        if (string != null) {
            header.setField("Authorization", string);
        }
        if (this.mode == 1 && (string = this.proxyInfo.getAuthString("http", startLine.method, startLine.uri)) != null) {
            header.setField("Proxy-Authorization", string);
        }
        return header;
    }

    private void analyzePostResponse(StartLine startLine, Header header) {
        long l = System.currentTimeMillis();
        String string = header.getField("WWW-Authenticate");
        if (string != null) {
            try {
                this.targetInfo.setAuthInfo(string);
            }
            catch (HttpParseException httpParseException) {
                // empty catch block
            }
            this.targetInfo.timestamp = l;
        } else {
            string = header.getField("Authentication-Info");
            if (string != null) {
                try {
                    this.targetInfo.updateAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
                this.targetInfo.timestamp = l;
            }
        }
        if (this.mode != 0) {
            string = header.getField("Proxy-Authenticate");
            if (string != null) {
                try {
                    this.proxyInfo.setAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
                this.proxyInfo.timestamp = l;
            } else {
                string = header.getField("Proxy-Authentication-Info");
                if (string != null) {
                    try {
                        this.proxyInfo.updateAuthInfo(string);
                    }
                    catch (HttpParseException httpParseException) {
                        // empty catch block
                    }
                    this.proxyInfo.timestamp = l;
                }
            }
        }
        if (this.mode != 1) {
            this.targetInfo.major = startLine.major;
            this.targetInfo.minor = startLine.minor;
            this.targetInfo.timestamp = l;
        } else {
            if (startLine.status == 407) {
                this.proxyInfo.major = startLine.major;
                this.proxyInfo.minor = startLine.minor;
            }
            this.proxyInfo.timestamp = l;
        }
        if (startLine.status / 100 == 2) {
            this.targetInfo.timestamp = l;
        }
        this.flushServerInfo();
    }

    private void analyzeProxyResponse(StartLine startLine, Header header) {
        this.proxyInfo.major = startLine.major;
        this.proxyInfo.minor = startLine.minor;
        this.proxyInfo.timestamp = System.currentTimeMillis();
        String string = header.getField("Proxy-Authenticate");
        if (string != null) {
            try {
                this.proxyInfo.setAuthInfo(string);
            }
            catch (HttpParseException httpParseException) {}
        } else {
            string = header.getField("Proxy-Authentication-Info");
            if (string != null) {
                try {
                    this.proxyInfo.updateAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
            }
        }
        this.flushServerInfo();
    }

    public boolean supportsChunking() {
        if (this.chunkingDisabled) {
            return false;
        }
        ServerInfo serverInfo = this.mode == 1 ? this.proxyInfo : this.targetInfo;
        return StartLine.compareVersions(serverInfo.major, serverInfo.minor, 1, 1) >= 0;
    }

    private static boolean supportsPersist(StartLine startLine, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class OutboundRequestImpl
    extends Request
    implements OutboundRequest {
        private MessageWriter writer;
        private MessageReader reader;
        private StartLine inLine;
        private Header inHeader;
        private boolean persist = false;
        private Header outHeader;
        private StartLine outLine;

        OutboundRequestImpl(String string) throws IOException {
            this.writer = new MessageWriter(HttpClientConnection.this.out, HttpClientConnection.this.supportsChunking());
            this.reader = new MessageReader(HttpClientConnection.this.in, false);
            this.outLine = HttpClientConnection.this.createPostLine(string);
            this.outHeader = HttpClientConnection.this.createPostHeader(this.outLine);
            this.outHeader.setField("Content-Type", "text/xml;charset=UTF-8");
            this.outHeader.setField("Accept", "text/xml, application/xml");
        }

        public int getResponseCode() {
            return this.inLine.status;
        }

        public void addHeaderField(String string, String string2) {
            this.outHeader.setField(string, string2);
        }

        public void endWriteHeader() throws IOException {
            this.writer.writeStartLine(this.outLine);
            this.writer.writeHeader(this.outHeader);
        }

        public OutputStream getRequestOutputStream() {
            return this.getOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.getInputStream();
        }

        public void dumpOutHeader() throws IOException {
            this.outLine.write(System.out);
            this.outHeader.write(System.out);
        }

        public void dumpInHeader() throws IOException {
            this.inLine.write(System.out);
            this.inHeader.write(System.out);
        }

        void startOutput() throws IOException {
        }

        void write(byte[] byArray, int n, int n2) throws IOException {
            this.writer.writeContent(byArray, n, n2);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            this.inLine = this.reader.readStartLine();
            this.inHeader = this.reader.readHeader();
            return this.inLine.status / 100 == 2;
        }

        int read(byte[] byArray, int n, int n2) throws IOException {
            return this.reader.readContent(byArray, n, n2);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            this.inHeader.merge(this.reader.readTrailer());
            HttpClientConnection.this.analyzePostResponse(this.inLine, this.inHeader);
            this.persist = HttpClientConnection.supportsPersist(this.inLine, this.inHeader);
        }

        void done(boolean bl) {
            if (bl || !this.persist) {
                HttpClientConnection.this.shutdown(true);
            } else {
                HttpClientConnection.this.markIdle();
            }
        }
    }
}

