/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.PatchBundleInstaller;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class GroupPatchBundleInstaller
implements InstallPatchListener {
    public static boolean nowInstalling = false;
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchProProperties associateProperties;
    private PatchBundleInstaller patchInstaller;
    private File installDirectory;
    private File backoutDirectory;
    private Enumeration associateHosts;
    private Host primaryHost;
    private Host associateHost;
    private PatchPro model;
    private boolean debug = false;

    public GroupPatchBundleInstaller(PatchPro patchPro) {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.model = patchPro;
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public void install(Host host) throws InstallFailedException {
        if (nowInstalling) {
            throw new InstallFailedException("Already Running");
        }
        nowInstalling = true;
        this.hostCount = this.hostsRemaining = host.getAssociateCount() + 1;
        try {
            try {
                PatchList patchList;
                if (!host.getSessionData().getIgnoreStatus()) {
                    patchList = host.getSessionData().getPatchesRequired();
                    this.installDirectory = new File(this.properties.getProperty("patchpro.download.directory"));
                    this.backoutDirectory = new File(this.properties.getProperty("patchpro.backout.directory"));
                    if (this.debug) {
                        this.log.println(this, 7, "# of patches to Install is " + patchList.size());
                        this.log.println(this, 7, "installDirectory is " + this.installDirectory);
                        this.log.println(this, 7, "backoutDirectory is " + this.backoutDirectory);
                    }
                    this.patchInstaller = new PatchBundleInstaller();
                    this.patchInstaller.addListener(this);
                    this.patchInstaller.initialize(host);
                    this.patchInstaller.install(host, patchList, this.installDirectory, this.backoutDirectory, this.model);
                    this.patchInstaller.removeListener(this);
                }
                this.associateHosts = host.getAssociates();
                while (this.associateHosts.hasMoreElements()) {
                    this.associateHost = (Host)this.associateHosts.nextElement();
                    if (this.associateHost.getSessionData().getIgnoreStatus()) continue;
                    patchList = this.associateHost.getSessionData().getPatchesRequired();
                    this.properties = this.properties.getHostSpecificProperties(this.associateHost);
                    this.installDirectory = new File(this.properties.getProperty("patchpro.download.directory", "/var/sadm/spool"));
                    this.backoutDirectory = new File(this.properties.getProperty("patchpro.backout.directory"));
                    this.patchInstaller = new PatchBundleInstaller();
                    this.patchInstaller.addListener(this);
                    this.patchInstaller.initialize(this.associateHost);
                    this.patchInstaller.install(host, this.associateHost, patchList, this.installDirectory, this.backoutDirectory, this.model);
                    this.patchInstaller.removeListener(this);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 2, "GroupPatchBundleInstaller: Internal error. Unknown Error");
                this.log.printStackTrace(this, 2, exception);
                nowInstalling = false;
                throw new InstallFailedException(exception.getMessage());
            }
            Object var4_4 = null;
            this.patchInstaller.removeListener(this);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.patchInstaller.removeListener(this);
            throw throwable;
        }
        nowInstalling = false;
    }

    public Percentage percentComplete() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPatchProgress(InstallPatchEvent installPatchEvent) {
        int n = installPatchEvent == null ? 100 : ((PatchBundleInstaller)installPatchEvent.getSource()).installProgress().getPercentage();
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        this.dispatchProgressEvent(new InstallPatchEvent(this));
    }

    public void installPatchDone(InstallPatchEvent installPatchEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new InstallPatchEvent(this));
        }
    }

    public void installPatchFailed(InstallPatchEvent installPatchEvent) {
        this.dispatchFailedEvent(installPatchEvent);
    }

    private void dispatchProgressEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchProgress(installPatchEvent);
        }
    }

    private void dispatchDoneEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchDone(installPatchEvent);
        }
    }

    private void dispatchFailedEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchFailed(installPatchEvent);
        }
    }
}

