/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSInstaller;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.TelnetSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class SunOSRmtT3OSImageInstaller
extends SunOSInstaller {
    private boolean loopCardImageApplied = false;
    private String controllerImage = null;
    private String loopCardImage = null;
    private String level2Image = null;
    private static final String CR = "\r";
    private static final String NL = "\n";
    private static final String FIRMWARE_IMAGE_DIRECTORY = "/var/sadm/swimages/";
    private static final String EXPECTED_PREFIX_MESSAGE = "Installation of <SUNWt3fw";
    private static final String FIRMWARE_REPOSITORY_PROMPT = "Please Enter Patch Location Pathname";
    private static final String NETRC_DIRECTORY_PROMPT = "Enter Your Home Directory Path";
    private static final String FTP_USER_PROMPT = "Enter ftp user";
    private static final String FTP_PASSWORD_PROMPT = "Enter ftp password";
    private static final String LOGIN_INCORRECT_MSG = "Login incorrect";
    private static final String CLEANING_UP_MSG = "Cleaning Up Temporary Files...";
    private static final String COMMAND_LINE_PROMPT = ">";
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    private CommandSession commandSession = null;
    private LineParser lp = new LineParser();
    private static final int RETRY_LIMIT = 60;
    private static final int ONE_SECOND = 1000;
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    private static final int TWENTY_SECONDS = 20000;
    private static final int THIRTY_SECONDS = 30000;
    private static final int ONE_MINUTE = 60000;
    private static final int TWO_MINUTES = 120000;
    private static final int TEN_MINUTES = 600000;
    private static final int TWENTY_MINUTES = 1200000;
    private static final int THIRTY_MINUTES = 1800000;

    public SunOSRmtT3OSImageInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    public void install() {
        File file;
        this.initializeProgress(0.0, 5.0);
        try {
            file = this.extractPatch();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.issueFail(new PatchInstallFailedException(57));
            return;
        }
        this.incrementProgress(1.0);
        try {
            if (this.debug) {
                System.out.println("Install command procedure for T3 single brick at " + this.manipulator.getHost().getAddress());
                this.incrementProgress(3.0);
            } else {
                this.installFirmwarePackage(file);
                this.incrementProgress(1.0);
                this.uploadFirmwareImages(this.manipulator.getHost().getAddress());
                this.incrementProgress(1.0);
                this.applyLoopCardFirmwareImages(this.manipulator.getHost().getAddress());
                this.incrementProgress(1.0);
                this.applyControllerFirmwareImages(this.manipulator.getHost().getAddress());
            }
        }
        catch (InteractiveSessionException interactiveSessionException) {
            this.log.printStackTrace(this, 2, interactiveSessionException);
            this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
        }
        this.incrementProgress(1.0);
    }

    private void installFirmwarePackage(File file) throws InteractiveSessionException {
        Properties properties = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.properties.getProperty("SunOS.command.install.package", "/usr/sbin/pkgadd -d");
        string3 = this.activePatch.getPatchID().getPatchID();
        string4 = string + " " + file + "/" + string3 + " " + "all";
        if (this.debug) {
            System.out.println("Install command string: " + string4);
        }
        try {
            try {
                this.commandSession = new CommandSession();
                this.commandSession.start(string4);
                this.commandSession.stop();
                if (this.commandSession.getReturnValue() != 0) {
                    throw new Exception("pkgadd exit code: " + this.commandSession.getReturnValue() + "\n\nSession output:\n" + this.commandSession.getAllSessionMessages());
                }
                StringTokenizer stringTokenizer = new StringTokenizer(this.commandSession.getAllSessionMessages(), NL);
                String string5 = "";
                String string6 = EXPECTED_PREFIX_MESSAGE;
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string7 = stringTokenizer.nextToken();
                    if (!string7.startsWith(string6)) continue;
                    n = string7.indexOf(62, string6.length());
                    if (n == string6.length()) {
                        string5 = "1";
                        break;
                    }
                    int n2 = string6.length() + 1;
                    string5 = string7.substring(n2, n);
                    break;
                }
                string2 = file + "/" + string3 + "/" + "SUNWt3fw" + "/" + "pkginfo";
                SoftwarePackage softwarePackage = new SoftwarePackage("SUNWt3fw", string5, new File(string2));
                properties = softwarePackage.getPkginfo();
                this.manipulator.getHost().addSoftwarePackage(softwarePackage);
                this.setControllerImage(properties.getProperty("SUNW_CONTROLLER_NAME", null));
                this.setLoopCardImage(properties.getProperty("SUNW_LOOPCARD_NAME", null));
                this.setLevel2Image(properties.getProperty("SUNW_LEVEL2_NAME", null));
            }
            catch (Exception exception) {
                this.commandSession.stop();
                this.log.println(this, 2, "Problem encountered installing SUNWt3fw package.");
                this.incrementProgress(3.0);
                throw new InteractiveSessionException(exception.getMessage());
            }
            Object var15_15 = null;
            if (this.commandSession != null) {
                this.commandSession.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (this.commandSession != null) {
                this.commandSession.cleanup();
            }
            throw throwable;
        }
    }

    private void uploadFirmwareImages(String string) throws InteractiveSessionException {
        CommandSession commandSession = null;
        try {
            try {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                string4 = this.properties.getProperty("patchpro.userid", "root");
                string5 = this.getPassword(string);
                string3 = this.activePatch.getPatchID().getPatchID();
                string2 = FIRMWARE_IMAGE_DIRECTORY + string3;
                commandSession = new CommandSession();
                commandSession.start(string2 + "/t3.sh");
                if (!commandSession.expectedResponse(string + NL, FIRMWARE_REPOSITORY_PROMPT, 10000)) {
                    commandSession.cleanup();
                    throw new Exception("Expected : \"Please Enter Patch Location Pathname\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(string2 + NL, NETRC_DIRECTORY_PROMPT, 20000)) {
                    throw new Exception("Expected : \"Enter Your Home Directory Path\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(NL, FTP_USER_PROMPT, 5000)) {
                    throw new Exception("Expected : \"Enter ftp user\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.expectedResponse(string4 + NL, FTP_PASSWORD_PROMPT, 5000)) {
                    throw new Exception("Expected : \"Enter ftp password\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (commandSession.expectedResponse(string5 + NL, LOGIN_INCORRECT_MSG, 5000)) {
                    throw new Exception("Expected : \"Login incorrect\" message was not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                if (!commandSession.waitfor(CLEANING_UP_MSG, 1200000)) {
                    throw new Exception("Expected : FTP \"Cleaning Up Temporary Files...\" message was never detected\n\nSession output:\n" + commandSession.getAllSessionMessages());
                }
                Object var8_8 = null;
                if (commandSession != null) {
                    commandSession.cleanup();
                }
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.incrementProgress(2.0);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (commandSession != null) {
                commandSession.cleanup();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyLoopCardFirmwareImages(String string) throws InteractiveSessionException {
        if (this.getLoopCardImage() == null) return;
        String string2 = null;
        String string3 = null;
        TelnetSession telnetSession = null;
        try {
            try {
                string2 = this.properties.getProperty("patchpro.userid", "root");
                string3 = this.getPassword(string);
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                telnetSession.send("lpc version\r", 5000);
                if (!telnetSession.expectedResponse("lpc download u1l1 " + this.getLoopCardImage() + CR, COMMAND_LINE_PROMPT, 600000)) {
                    throw new Exception("Expected : \">\" pattern not detected for u1l1\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (!telnetSession.expectedResponse("lpc download u1l2 " + this.getLoopCardImage() + CR, COMMAND_LINE_PROMPT, 600000)) {
                    throw new Exception("Expected : \">\" pattern not detected for u1l2\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                Object var7_5 = null;
                if (telnetSession == null) return;
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.incrementProgress(1.0);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (telnetSession == null) throw throwable;
            telnetSession.disconnect();
            throw throwable;
        }
        telnetSession.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyControllerFirmwareImages(String string) throws InteractiveSessionException {
        String string2 = null;
        String string3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        boolean bl = false;
        if (this.getControllerImage() == null) {
            if (this.getLevel2Image() == null) return;
        }
        TelnetSession telnetSession = null;
        try {
            try {
                string2 = this.properties.getProperty("patchpro.userid", "root");
                string3 = this.getPassword(string);
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                telnetSession.send("set bootmode auto\r", 10000);
                telnetSession.send("cd /\r", 1000);
                if (this.getControllerImage() != null) {
                    if (!telnetSession.expectedResponse("ls\r", this.getControllerImage(), 5000)) {
                        telnetSession.disconnect();
                        throw new Exception(this.getControllerImage() + " image was not found");
                    }
                    telnetSession.send("boot -i " + this.getControllerImage() + CR, 30000);
                }
                if (this.getLevel2Image() != null) {
                    if (!telnetSession.expectedResponse("ls\r", this.getLevel2Image(), 5000)) {
                        telnetSession.disconnect();
                        throw new Exception(this.getLevel2Image() + " image was not found");
                    }
                    telnetSession.send("ep download " + this.getLevel2Image() + CR, 30000);
                }
                telnetSession.send("reset -y\r", 60000);
                telnetSession.disconnect();
                telnetSession = null;
                int n = 0;
                while (true) {
                    try {
                        telnetSession = new TelnetSession();
                        telnetSession.connect(string, string2, string3);
                        if (telnetSession.expectedResponse("port list\r", "offline", 5000)) {
                            bl = true;
                            telnetSession.disconnect();
                            telnetSession = null;
                            throw new Exception("The controller is not online.");
                        }
                        this.log.println(this, 7, "All controllers are ONLINE");
                        telnetSession.disconnect();
                    }
                    catch (Exception exception) {
                        if (bl) {
                            throw new Exception(exception.getMessage());
                        }
                        if (telnetSession != null) {
                            telnetSession.disconnect();
                            telnetSession = null;
                        }
                        System.gc();
                        this.log.println(this, 7, "Number of attempts to connect to master controller is " + ++n);
                        Thread.sleep(10000L);
                        if (n < 60) continue;
                    }
                    break;
                }
                Object var13_13 = null;
                if (telnetSession == null) return;
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (telnetSession == null) throw throwable;
            telnetSession.disconnect();
            throw throwable;
        }
        telnetSession.disconnect();
    }

    private String getPassword(String string) throws IOException {
        String string2 = null;
        String string3 = this.instParms.getConfigDirectoryPath() + "/." + string + PASSWORD_FILE_SUFFIX;
        File file = new File(string3);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Password file for \"" + string + "\" is not accessible");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        string2 = bufferedReader.readLine();
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    private void setControllerImage(String string) {
        this.controllerImage = string;
    }

    private String getControllerImage() {
        return this.controllerImage;
    }

    private void setLoopCardImage(String string) {
        this.loopCardImage = string;
    }

    private String getLoopCardImage() {
        return this.loopCardImage;
    }

    private void setLevel2Image(String string) {
        this.level2Image = string;
    }

    private String getLevel2Image() {
        return this.level2Image;
    }
}

