/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Question;
import com.sun.patchpro.util.QuestionList;
import com.sun.patchpro.util.QuestionTrueFalse;
import com.sun.patchpro.util.RenderInteractionSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RenderInteractionSetImpl
implements RenderInteractionSet {
    private InteractionSet interactionSet = null;
    private PatchProLog log;
    boolean done = false;
    BufferedReader br;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private LocalizedMessages msgcat = new LocalizedMessages(this.properties.getLocale());

    public RenderInteractionSetImpl() {
        this.log = PatchProLog.getInstance();
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        this.br = new BufferedReader(inputStreamReader);
    }

    public void render(InteractionSet interactionSet) {
        this.interactionSet = interactionSet;
        int n = 0;
        while (n < 24) {
            System.out.println("");
            ++n;
        }
        while (this.interactionSet.hasMoreInteractions()) {
            try {
                Interaction interaction = this.interactionSet.nextInteraction();
                if (!interaction.isAQuestion()) {
                    this.renderInteraction(interaction);
                    continue;
                }
                if (((Question)interaction).isAQuestionTrueFalse()) {
                    this.renderQuestionTrueFalse((QuestionTrueFalse)interaction);
                    continue;
                }
                if (((Question)interaction).isAQuestionList()) {
                    this.renderQuestionList((QuestionList)interaction);
                    continue;
                }
                this.log.println(this, 4, "Unsupported interaction type: ignoring.  " + interaction.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
    }

    public InteractionSet getInteractionSet() {
        return this.interactionSet;
    }

    private void renderInteraction(Interaction interaction) {
        System.out.println(interaction.getMessage());
    }

    private void renderQuestionTrueFalse(QuestionTrueFalse questionTrueFalse) {
        try {
            System.out.println(questionTrueFalse.getMessage() + " [y/n] : ");
            String string = this.br.readLine();
            if (string.compareTo("y") == 0 || string.compareTo("yes") == 0) {
                questionTrueFalse.setAnswer(true);
            } else if (string.compareTo("n") == 0 || string.compareTo("no") == 0) {
                questionTrueFalse.setAnswer(false);
            } else {
                System.out.println(this.msgcat.getMessage("tryAgain", "Error: try again."));
            }
        }
        catch (IOException iOException) {
            System.err.println(this.msgcat.getMessage("syntaxError", "Syntax error in expression."));
            System.exit(1);
        }
    }

    private void renderQuestionList(QuestionList questionList) {
        int n = 0;
        boolean bl = false;
        String string = "0";
        try {
            System.out.println(questionList.getMessage() + "\n\n");
            String[] stringArray = questionList.getChoices();
            int n2 = 1;
            while (n2 <= stringArray.length) {
                int n3 = n2;
                int n4 = n2 + 9;
                int n5 = n3;
                while (n5 <= n4) {
                    if (n2 <= stringArray.length) {
                        System.out.println(n5 + "   " + stringArray[n2 - 1]);
                        ++n2;
                    } else {
                        n5 = n2 + 11;
                    }
                    ++n5;
                }
                if (n2 <= stringArray.length) {
                    System.out.println(this.msgcat.getMessage("rememberChoices", "Remember the choices that you wish to select later."));
                    System.out.println(this.msgcat.getMessage("continueDisplay", "Press 'Return' to continue list display."));
                    String string2 = this.br.readLine();
                }
                n3 = n2--;
                ++n2;
            }
            System.out.println(this.msgcat.getMessage("choicesLength", "Choices length = ") + stringArray.length);
            System.out.println("");
            System.out.println(this.msgcat.getMessage("enterChoices", "Enter your choices seperated by a space") + "1 - " + stringArray.length);
            System.out.println(this.msgcat.getMessage("selectAll", "Enter '*' to select all"));
            System.out.println("Press 'Return' for no selections");
            int n6 = stringArray.length;
            while (!bl) {
                try {
                    String string3 = this.br.readLine();
                    System.out.println("Selections are " + string3);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    int n7 = stringTokenizer.countTokens();
                    if (n7 > 0) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.equals("*")) {
                            n7 = n6;
                            string4 = "1";
                            string = "*";
                        } else {
                            n7 = stringTokenizer.countTokens() + 1;
                        }
                        int n8 = Integer.parseInt(string4);
                        int n9 = 1;
                        while (n9 <= n7) {
                            questionList.setSelection(--n8);
                            int n10 = n8 + 1;
                            if (string.equals("*")) {
                                if (n9 != n7) {
                                    n8 = n9 + 1;
                                } else {
                                    string = "0";
                                }
                            } else if (n9 != n7) {
                                n8 = Integer.parseInt(stringTokenizer.nextToken());
                            }
                            ++n9;
                        }
                    } else {
                        System.out.println("No selections made for thislist.");
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("Invalid choice. Retry with valid choices");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid choice. Retry with valid choices");
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Syntax error in expression");
                    System.exit(1);
                }
                bl = true;
            }
            n = questionList.getTotalSelections();
            System.out.println("Total selections made by the user are " + n);
        }
        catch (Exception exception) {
            System.err.println("Exception occured: " + exception.getMessage());
            System.exit(1);
        }
    }
}

