/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.fsmgr.client.WBEMClient.FsMgrMountClient;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.patchmgr.client.PropertyInfo;
import com.sun.admin.patchmgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.admin.patchmgr.common.InstallPatchesByPolicyResults;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.admin.patchmgr.common.PatchPropertiesConfig;
import com.sun.admin.patchmgr.common.RemoteFileData;
import com.sun.admin.patchmgr.common.SpooledPatchUtil;
import com.sun.admin.patchmgr.common.SunOSInfo;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMRepositoryException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class PatchMgrClient {
    private CIMClient cc = null;
    private static final String SOLARIS_PATCH = "Solaris_Patch";
    private static final String SOLARIS_PACKAGE = "Solaris_Package";
    private static final String SOLARIS_SUN_OS = "Solaris_OperatingSystem";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String SOLARIS_DIR = "Solaris_Directory";
    private static final String SOLARIS_PATCHCSA = "Solaris_PatchConfigSchema";
    private static final String SOLARIS_PATCHCONFIG = "Solaris_PatchConfig";
    private static final String NAME = "Name";
    private static final String OBSOLETES = "Obsoletes";
    private static final String REQUIRES = "Requires";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PACKAGES = "Packages";
    private static final String PATCH_DIR_NAME = "PatchDirectoryName";
    private static final String PATCH_BACKOUT_DIR = "BackoutDirectory";
    private static final String DESCRIPTION = "Description";
    private static final String TARGET_OS = "TargetOperatingSystem";
    private static final String INSTALL_DATE = "InstallDate";
    private static final String RELEASE_DATE = "ReleaseDate";
    private static final String ARCH = "Architecture";
    private static final String PATCH_SOLARIS_REL = "PatchSolarisRelease";
    private static final String PATCH_SUNOS_REL = "PatchSunOSRelease";
    private static final String BACK_UP_FILES = "BackUpFiles";
    private static final String DEFAULT = "Default";
    private static final String PUBLIC = "Public";
    private static final String SECRET = "Secret";
    private static final String VALUE = "Value";
    private static final String VERSION = "Version";
    private static final String VERSION_12 = "1.2";
    private static final String VERSION_13 = "1.3";
    private static final String VERSION_14 = "1.4";
    private static final String SUM_REC = "SingleUserRecommended";
    private static final String SUM_REQ = "SingleUserRequired";
    private static final String REB_AFT = "RebootAfter";
    private static final String REB_IMM = "RebootImmediate";
    private static final String REC_AFT = "ReconfigAfter";
    private static final String REC_IMM = "ReconfigImmediate";
    private static final String GETSPOOLEDPATCHINFO = "GetSpooledPatchInfo";
    private static final String GETSPOOLEDPATCHREADME = "GetSpooledPatchReadme";
    private static final String ASSESS_NEEDED_PATCHES = "AssessNeededPatches";
    private static final String ANALYZE = "Analyze";
    private static final String DOWNLOAD_PATCHES = "DownloadPatches";
    private static final String DOWNLOAD_PATCHES_IN_JAR_FORMAT = "DownloadPatchesInJarFormat";
    private static final String INSTALL_PATCHES_BY_POLICY = "InstallPatchesByPolicy";
    private static final String RESOLVE = "Resolve";
    private static final String ORDER_PATCHES = "OrderPatches";
    private static final String ISA_TYPE_PROP = "ISAType";
    private static final String OS_VERSION = "Version";
    private static final String OTHER_VERSION_DESC = "OtherVersionDescription";
    private static final String EMPTY_STR = "";
    public static final String DEFAULT_MNT_POINT = "/patch_spool";
    private static final boolean TRUE = true;
    private static final boolean FALSE = false;

    public void init(CIMClient cIMClient) throws AdminException {
        this.cc = cIMClient;
    }

    public PropertyInfo[] getPropertyInfos(String[] stringArray) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCHCSA, VERSION_12);
        try {
            Properties properties = this.getPatchConfig();
            Hashtable hashtable = this.getPatchConfigSchema();
            Vector<PropertyInfo> vector = new Vector<PropertyInfo>();
            if (stringArray == null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    CIMInstance cIMInstance = (CIMInstance)hashtable.get(string);
                    vector.add(this.newPropertyInfo(string, properties.getProperty(string), cIMInstance));
                }
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    CIMInstance cIMInstance = (CIMInstance)hashtable.get(string);
                    if (cIMInstance == null) {
                        vector.add(null);
                    } else {
                        vector.add(this.newPropertyInfo(string, properties.getProperty(string), cIMInstance));
                    }
                    ++n;
                }
            }
            return vector.toArray(new PropertyInfo[0]);
        }
        catch (CIMException cIMException) {
            throw this.mapException("EXM_PROPERTIES_GET", null, (Exception)((Object)cIMException));
        }
    }

    private PropertyInfo newPropertyInfo(String string, String string2, CIMInstance cIMInstance) {
        return new PropertyInfo(string, string2, PatchMgrClient.getCIMString(cIMInstance, DEFAULT), PatchMgrClient.getCIMBool(cIMInstance, PUBLIC), PatchMgrClient.getCIMBool(cIMInstance, SECRET), PatchMgrClient.getCIMString(cIMInstance, DESCRIPTION));
    }

    private Properties getPatchConfig() throws CIMException {
        Properties properties = new Properties();
        Enumeration enumeration = this.cc.enumerateInstances(new CIMObjectPath(SOLARIS_PATCHCONFIG), true, false);
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            String string = PatchMgrClient.getCIMString(cIMInstance, NAME);
            String string2 = PatchMgrClient.getCIMString(cIMInstance, VALUE);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    private Hashtable getPatchConfigSchema() throws CIMException {
        Hashtable<String, CIMInstance> hashtable = new Hashtable<String, CIMInstance>();
        Enumeration enumeration = this.cc.enumerateInstances(new CIMObjectPath(SOLARIS_PATCHCSA), true, false);
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            String string = PatchMgrClient.getCIMString(cIMInstance, NAME);
            hashtable.put(string, cIMInstance);
        }
        return hashtable;
    }

    private static String getCIMString(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
        if (cIMValue == null) {
            return null;
        }
        return (String)cIMValue.getValue();
    }

    private static boolean getCIMBool(CIMInstance cIMInstance, String string) {
        Boolean bl = (Boolean)cIMInstance.getProperty(string).getValue().getValue();
        return bl;
    }

    public String getProperty(String string) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCHCSA, VERSION_12);
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCHCONFIG);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.getInstance(cIMObjectPath);
            if (cIMInstance != null) {
                return PatchMgrClient.getCIMString(cIMInstance, VALUE);
            }
            cIMObjectPath = new CIMObjectPath(SOLARIS_PATCHCSA);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
            cIMInstance = this.cc.getInstance(cIMObjectPath);
            return PatchMgrClient.getCIMString(cIMInstance, DEFAULT);
        }
        catch (CIMException cIMException) {
            throw this.mapException("EXM_PROPERTIES_GET", null, (Exception)((Object)cIMException));
        }
    }

    private CIMInstance getInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            return this.cc.getInstance(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                return null;
            }
            throw cIMException;
        }
    }

    public void setProperties(String[] stringArray) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCHCSA, VERSION_12);
        try {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf("=");
                String string = stringArray[n].substring(0, n2);
                String string2 = stringArray[n].substring(n2 + 1);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCHCONFIG);
                cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
                this.cc.deleteInstance(cIMObjectPath);
                CIMInstance cIMInstance = new CIMInstance();
                cIMInstance.setClassName(SOLARIS_PATCHCONFIG);
                Vector<CIMProperty> vector = new Vector<CIMProperty>();
                vector.add(new CIMProperty(NAME, new CIMValue((Object)string)));
                vector.add(new CIMProperty(VALUE, new CIMValue((Object)string2)));
                cIMInstance.setProperties(vector);
                this.cc.createInstance(cIMObjectPath, cIMInstance);
                ++n;
            }
        }
        catch (CIMException cIMException) {
            throw this.mapException("EXM_PROPERTY_SET", null, (Exception)((Object)cIMException));
        }
    }

    public void unsetProperties(String[] stringArray) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCHCSA, VERSION_12);
        try {
            int n = 0;
            while (n < stringArray.length) {
                CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCHCONFIG);
                cIMObjectPath.addKey(NAME, new CIMValue((Object)stringArray[n]));
                this.cc.deleteInstance(cIMObjectPath);
                ++n;
            }
        }
        catch (CIMException cIMException) {
            throw this.mapException("EXM_PROPERTY_UNSET", null, (Exception)((Object)cIMException));
        }
    }

    public Vector getPatchList() throws AdminException {
        Vector<PatchMgrObj> vector = new Vector<PatchMgrObj>();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            CIMInstance cIMInstance = null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    PatchMgrObj patchMgrObj = this.setPatchObj(cIMInstance);
                    vector.addElement(patchMgrObj);
                }
            }
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PATCH_READALL", null, exception);
        }
        if (vector == null || vector.size() == 0) {
            vector = new Vector(0);
        }
        return vector;
    }

    public Hashtable getPackageList() throws AdminException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PACKAGE);
            Enumeration enumeration = this.cc.enumerateInstanceNames(cIMObjectPath);
            Object var4_5 = null;
            String string = null;
            CIMObjectPath cIMObjectPath2 = null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    Enumeration enumeration2 = cIMObjectPath2.getKeys().elements();
                    while (enumeration2.hasMoreElements()) {
                        CIMProperty cIMProperty = (CIMProperty)enumeration2.nextElement();
                        if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                        string = (String)cIMProperty.getValue().getValue();
                        break;
                    }
                    hashtable.put(string, string);
                }
            }
            return hashtable;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PACKAGE_READALL", null, exception);
        }
    }

    public PatchMgrObj getPatchData(String string) throws AdminException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, false, false, false, null);
            if (cIMInstance != null) {
                PatchMgrObj patchMgrObj = this.setPatchObj(cIMInstance);
                return patchMgrObj;
            }
            return null;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PATCH_READ", new String[]{string}, exception);
        }
    }

    public void applySinglePatch(PatchMgrObj patchMgrObj) throws AdminException {
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMProperty cIMProperty = null;
            cIMProperty = new CIMProperty(NAME);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getPatchName()));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(PATCH_DIR_NAME);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getPatchDirName()));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(PATCH_BACKOUT_DIR);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getBackoutDir()));
            vector.addElement(cIMProperty);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH, vector);
            CIMInstance cIMInstance = new CIMInstance();
            cIMInstance.setClassName(SOLARIS_PATCH);
            cIMInstance.setProperties(vector);
            this.cc.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (Exception exception) {
            String string = patchMgrObj.getPatchName();
            throw this.mapException("EXM_PATCH_ADD_FAILED", new String[]{string}, exception);
        }
    }

    public void removeSinglePatch(PatchMgrObj patchMgrObj) throws AdminException {
        block3: {
            try {
                CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
                cIMObjectPath.addKey(NAME, new CIMValue((Object)patchMgrObj.getPatchName()));
                this.cc.deleteInstance(cIMObjectPath);
            }
            catch (Exception exception) {
                String string = patchMgrObj.getPatchName();
                if (!(exception instanceof CIMProviderException)) break block3;
                String string2 = ((CIMException)((Object)exception)).getID();
                if (string2 != null && string2.equals("CIM_ERR_NOT_FOUND")) {
                    throw new ClientProxyException("EXM_PATCH_REMOVE_NOEXIST", string);
                }
                throw this.mapException("EXM_PATCH_REMOVE_FAILED", new String[]{string}, exception);
            }
        }
    }

    private void checkForExports(FsMgrMountClient fsMgrMountClient, String string) throws AdminException {
        String string2 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string3;
            if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != EMPTY_STR) {
                string2 = string3;
                break;
            }
            ++n2;
        }
        if (string2 != null || !string2.equals(EMPTY_STR)) {
            fsMgrMountClient.showExports(string2);
        }
    }

    public void mountPatchServer(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        try {
            this.checkForExports(fsMgrMountClient, string);
        }
        catch (AdminException adminException) {
            throw new ClientProxyException("EXM_MOUNT_FAILED", string);
        }
        fsMgrMountClient.makeDirectory(DEFAULT_MNT_POINT);
        FsMgrMount fsMgrMount = null;
        try {
            fsMgrMount = fsMgrMountClient.getMountEntry(string, DEFAULT_MNT_POINT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fsMgrMount == null) {
            fsMgrMount = new FsMgrMount(string, EMPTY_STR, DEFAULT_MNT_POINT, "NFS", EMPTY_STR, "no", EMPTY_STR);
            fsMgrMountClient.addMount(fsMgrMount);
        }
    }

    public void unmountPatchServer(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        String string2 = DEFAULT_MNT_POINT;
        try {
            this.checkForExports(fsMgrMountClient, string);
        }
        catch (AdminException adminException) {
            throw new ClientProxyException("EXM_UNMOUNT_FAILED", string2);
        }
        FsMgrMount fsMgrMount = null;
        try {
            fsMgrMount = fsMgrMountClient.getMountEntry(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fsMgrMount != null) {
            fsMgrMount = new FsMgrMount(string, EMPTY_STR, string2, "NFS", EMPTY_STR, EMPTY_STR, EMPTY_STR);
            fsMgrMountClient.removeMount(fsMgrMount);
        }
    }

    public Vector getSpooledPatchInfo(String string) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, GETSPOOLEDPATCHINFO, vector, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            Vector vector3 = (Vector)cIMValue.getValue();
            return vector3;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PATCH_SPOOL_READ", new String[]{string}, exception);
        }
    }

    public String getSpooledPatchReadme(String string, String string2) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector.addElement(new CIMValue((Object)string));
            vector.addElement(new CIMValue((Object)string2));
            this.cc.invokeMethod(cIMObjectPath, GETSPOOLEDPATCHREADME, vector, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            String string3 = (String)cIMValue.getValue();
            return string3;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PATCH_SPOOL_README", new String[]{string2, string}, exception);
        }
    }

    public SunOSInfo getSunOSRelease() throws AdminException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SUN_OS);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            CIMInstance cIMInstance = null;
            String string = null;
            String string2 = null;
            if (enumeration != null && (cIMInstance = (CIMInstance)enumeration.nextElement()) != null) {
                CIMProperty cIMProperty = cIMInstance.getProperty("Version");
                CIMValue cIMValue = cIMProperty.getValue();
                if (cIMValue != null) {
                    string = (String)cIMValue.getValue();
                }
                if ((cIMValue = (cIMProperty = cIMInstance.getProperty(OTHER_VERSION_DESC)).getValue()) != null) {
                    string2 = (String)cIMValue.getValue();
                }
                SunOSInfo sunOSInfo = new SunOSInfo(string, string2);
                return sunOSInfo;
            }
            return null;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_SUN_OS_VERSION", null, exception);
        }
    }

    public String getSystemArch() throws AdminException {
        try {
            CIMProperty cIMProperty;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_CS);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            String[] stringArray = new String[]{"sparc", "i386"};
            CIMInstance cIMInstance = null;
            String string = null;
            if (enumeration != null && (cIMInstance = (CIMInstance)enumeration.nextElement()) != null && (cIMValue = (cIMProperty = cIMInstance.getProperty(ISA_TYPE_PROP)).getValue()) != null) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                if (unsignedInt16.intValue() > 0) {
                    return stringArray[unsignedInt16.intValue() - 1];
                }
                return null;
            }
            return string;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_SYSTEM_ARCHITECTURE", null, exception);
        }
    }

    public Vector assessNeededPatches() throws AdminException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            this.cc.invokeMethod(cIMObjectPath, ASSESS_NEEDED_PATCHES, vector2, vector);
            CIMValue cIMValue = (CIMValue)vector.elementAt(0);
            Vector vector3 = (Vector)cIMValue.getValue();
            cIMValue = (CIMValue)vector.elementAt(1);
            Vector vector4 = (Vector)cIMValue.getValue();
            int n = 0;
            Vector<AssessedPatchData> vector5 = null;
            if (vector3 != null) {
                n = vector3.size();
                vector5 = new Vector<AssessedPatchData>(n);
                int n2 = 0;
                while (n2 < n) {
                    AssessedPatchData assessedPatchData = new AssessedPatchData((String)vector3.elementAt(n2), (String)vector4.elementAt(n2));
                    vector5.addElement(assessedPatchData);
                    ++n2;
                }
            }
            return vector5;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PAN_FAILED", null, exception);
        }
    }

    public Vector analyze(Vector vector) throws AdminException {
        try {
            Vector vector2 = new Vector();
            Vector<CIMValue> vector3 = new Vector<CIMValue>();
            vector3.addElement(new CIMValue((Object)vector));
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            this.cc.invokeMethod(cIMObjectPath, ANALYZE, vector3, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            Vector vector4 = this.getPatchIds((Vector)cIMValue.getValue());
            Vector vector5 = this.getSynopses((Vector)cIMValue.getValue());
            int n = 0;
            Vector<AssessedPatchData> vector6 = null;
            if (vector4 != null) {
                n = vector4.size();
                vector6 = new Vector<AssessedPatchData>(n);
                int n2 = 0;
                while (n2 < n) {
                    AssessedPatchData assessedPatchData = new AssessedPatchData((String)vector4.elementAt(n2), (String)vector5.elementAt(n2));
                    vector6.addElement(assessedPatchData);
                    ++n2;
                }
            }
            return vector6;
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PAN_FAILED", null, exception);
        }
    }

    public Vector resolvePatchList(Vector vector) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCH, VERSION_14);
        try {
            Vector vector2 = new Vector();
            Vector<CIMValue> vector3 = new Vector<CIMValue>();
            Vector vector4 = new Vector();
            vector3.addElement(new CIMValue(vector4));
            vector3.addElement(new CIMValue((Object)vector));
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            this.cc.invokeMethod(cIMObjectPath, RESOLVE, vector3, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            Vector vector5 = this.getPatchIds((Vector)cIMValue.getValue());
            Vector vector6 = this.getSynopses((Vector)cIMValue.getValue());
            Vector<AssessedPatchData> vector7 = new Vector<AssessedPatchData>();
            int n = vector5.size();
            int n2 = 0;
            while (n2 < n) {
                vector7.addElement(new AssessedPatchData((String)vector5.elementAt(n2), (String)vector6.elementAt(n2)));
                ++n2;
            }
            return vector7;
        }
        catch (CIMException cIMException) {
            throw this.mapException("EXM_RESOLVE_FAILED", null, (Exception)((Object)cIMException));
        }
    }

    public Vector orderPatches(Vector vector, String string) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCH, VERSION_14);
        try {
            Vector vector2 = new Vector();
            Vector<CIMValue> vector3 = new Vector<CIMValue>();
            vector3.addElement(new CIMValue((Object)vector));
            vector3.addElement(new CIMValue((Object)string));
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            this.cc.invokeMethod(cIMObjectPath, ORDER_PATCHES, vector3, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            return (Vector)cIMValue.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.mapException("EXM_ORDER_FAILED", null, exception);
        }
    }

    public DownloadPatchesResults downloadPatches(Vector vector, String string) throws AdminException {
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, DOWNLOAD_PATCHES, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            cIMValue = (CIMValue)vector3.elementAt(1);
            Vector vector5 = null;
            if (cIMValue != null) {
                vector5 = (Vector)cIMValue.getValue();
            }
            return new DownloadPatchesResults(vector, vector4, vector5);
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PDL_FAILED", null, exception);
        }
    }

    public DownloadPatchesResults downloadPatchesInJarFormat(Vector vector, String string) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCH, VERSION_13);
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, DOWNLOAD_PATCHES_IN_JAR_FORMAT, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            cIMValue = (CIMValue)vector3.elementAt(1);
            Vector vector5 = null;
            if (cIMValue != null) {
                vector5 = (Vector)cIMValue.getValue();
            }
            return new DownloadPatchesResults(vector, vector4, vector5);
        }
        catch (Exception exception) {
            throw this.mapException("EXM_PDL_FAILED", null, exception);
        }
    }

    public boolean isPatchProOnSystem() throws AdminException {
        throw new ClientProxyException("EXM_DEPRECATED_METHOD");
    }

    public RemoteFileData getDirInfo(String string) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DIR);
            vector.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, "getFile", vector, vector2);
            String string2 = (String)((CIMValue)vector2.elementAt(0)).getValue();
            String string3 = (String)((CIMValue)vector2.elementAt(1)).getValue();
            Boolean bl = (Boolean)((CIMValue)vector2.elementAt(2)).getValue();
            return new RemoteFileData(string2, string3, bl);
        }
        catch (Exception exception) {
            throw this.mapException("EXM_DIR_ACCESS", new String[]{string}, exception);
        }
    }

    public void createDirectory(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        fsMgrMountClient.makeDirectory(string);
    }

    private PatchMgrObj setPatchObj(CIMInstance cIMInstance) {
        Date date;
        Calendar calendar;
        PatchMgrObj patchMgrObj = new PatchMgrObj();
        CIMProperty cIMProperty = cIMInstance.getProperty(NAME);
        CIMValue cIMValue = cIMProperty.getValue();
        String string = EMPTY_STR;
        if (cIMValue != null) {
            string = (String)cIMValue.getValue();
        }
        if (string != null && string.trim().length() > 0) {
            patchMgrObj.setPatchName(string);
        }
        cIMProperty = cIMInstance.getProperty(OBSOLETES);
        cIMValue = cIMProperty.getValue();
        Vector vector = null;
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        if (vector != null && vector.size() > 0) {
            patchMgrObj.setObsoletes(vector);
        }
        cIMProperty = cIMInstance.getProperty(PACKAGES);
        cIMValue = cIMProperty.getValue();
        Vector vector2 = null;
        if (cIMValue != null) {
            vector2 = (Vector)cIMValue.getValue();
        }
        if (vector2 != null && vector2.size() > 0) {
            patchMgrObj.setPackages(vector2);
        }
        cIMProperty = cIMInstance.getProperty(REQUIRES);
        cIMValue = cIMProperty.getValue();
        Vector vector3 = null;
        if (cIMValue != null) {
            vector3 = (Vector)cIMValue.getValue();
        }
        if (vector3 != null && vector3.size() > 0) {
            patchMgrObj.setRequires(vector3);
        }
        cIMProperty = cIMInstance.getProperty(INCOMPATIBLES);
        cIMValue = cIMProperty.getValue();
        Vector vector4 = null;
        if (cIMValue != null) {
            vector4 = (Vector)cIMValue.getValue();
        }
        if (vector4 != null && vector4.size() > 0) {
            patchMgrObj.setIncompatibles(vector4);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_BACKOUT_DIR);
        cIMValue = cIMProperty.getValue();
        String string2 = null;
        if (cIMValue != null) {
            string2 = (String)cIMValue.getValue();
        }
        if (string2 != null && string2.length() > 0) {
            patchMgrObj.setBackoutDir(string2);
        }
        cIMProperty = cIMInstance.getProperty(DESCRIPTION);
        cIMValue = cIMProperty.getValue();
        String string3 = null;
        if (cIMValue != null) {
            string3 = (String)cIMValue.getValue();
        }
        if (string3 != null && string3.length() > 0) {
            patchMgrObj.setDescription(string3);
        }
        cIMProperty = cIMInstance.getProperty(INSTALL_DATE);
        cIMValue = cIMProperty.getValue();
        CIMDateTime cIMDateTime = null;
        if (cIMValue != null) {
            cIMDateTime = (CIMDateTime)cIMValue.getValue();
        }
        if (cIMDateTime != null) {
            calendar = cIMDateTime.getCalendar();
            date = calendar.getTime();
            patchMgrObj.setInstallDate(date);
        }
        cIMProperty = cIMInstance.getProperty(RELEASE_DATE);
        cIMValue = cIMProperty.getValue();
        CIMDateTime cIMDateTime2 = null;
        if (cIMValue != null) {
            cIMDateTime2 = (CIMDateTime)cIMValue.getValue();
        }
        if (cIMDateTime2 != null) {
            calendar = cIMDateTime2.getCalendar();
            date = calendar.getTime();
            patchMgrObj.setReleaseDate(date);
        }
        cIMProperty = cIMInstance.getProperty(ARCH);
        cIMValue = cIMProperty.getValue();
        String string4 = null;
        if (cIMValue != null) {
            string4 = (String)cIMValue.getValue();
        }
        if (string4 != null && string4.length() > 0) {
            patchMgrObj.setArchitecture(string4);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_SOLARIS_REL);
        cIMValue = cIMProperty.getValue();
        String string5 = null;
        if (cIMValue != null) {
            string5 = (String)cIMValue.getValue();
        }
        if (string5 != null && string5.length() > 0) {
            patchMgrObj.setSolRelease(string5);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_SUNOS_REL);
        cIMValue = cIMProperty.getValue();
        String string6 = null;
        if (cIMValue != null) {
            string6 = (String)cIMValue.getValue();
        }
        if (string6 != null && string6.length() > 0) {
            patchMgrObj.setSunOSRelease(string6);
        }
        if ((cIMValue = (cIMProperty = cIMInstance.getProperty(BACK_UP_FILES)).getValue()) != null) {
            patchMgrObj.setBackUpFiles((Boolean)cIMValue.getValue());
        }
        boolean bl = this.getBool(cIMInstance, SUM_REC);
        boolean bl2 = this.getBool(cIMInstance, SUM_REQ);
        boolean bl3 = this.getBool(cIMInstance, REB_AFT);
        boolean bl4 = this.getBool(cIMInstance, REB_IMM);
        boolean bl5 = this.getBool(cIMInstance, REC_AFT);
        boolean bl6 = this.getBool(cIMInstance, REC_IMM);
        PatchPropertiesConfig patchPropertiesConfig = new PatchPropertiesConfig(bl, bl2, bl3, bl4, bl5, bl6, false);
        patchMgrObj.setPatchPropertiesConfig(patchPropertiesConfig);
        return patchMgrObj;
    }

    private boolean getBool(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue != null) {
            return (Boolean)cIMValue.getValue();
        }
        return false;
    }

    private AdminException mapException(String string, String[] stringArray, Exception exception) {
        if (exception == null) {
            return null;
        }
        ClientProxyException clientProxyException = null;
        String string2 = exception.getLocalizedMessage();
        if (exception instanceof AdminException) {
            return (AdminException)((Object)exception);
        }
        if (exception instanceof CIMException) {
            String string3 = ((CIMException)((Object)exception)).getID();
            Object[] objectArray = ((CIMException)((Object)exception)).getParams();
            String string4 = EMPTY_STR;
            if (objectArray != null && objectArray.length != 0) {
                string4 = objectArray[0] instanceof String ? (String)objectArray[0] : objectArray[0].toString();
            }
            if (exception instanceof CIMTransportException) {
                clientProxyException = new ClientProxyException("EXM_TRANSPORT_ERR", string2);
            } else if (exception instanceof CIMSecurityException) {
                clientProxyException = new ClientProxyException("EXM_AUTH_SEC");
            } else if (exception instanceof CIMRepositoryException) {
                clientProxyException = new ClientProxyException("EXM_REPOSITORY_ERR", string2);
            } else if (exception instanceof CIMProviderException) {
                if (string3 == null || string3.trim().length() == 0) {
                    clientProxyException = new ClientProxyException("EXM_UNKW_PROVIDER_ERR");
                } else if (string3.equals("CIM_ERR_INVALID_PARAMETER")) {
                    clientProxyException = new ClientProxyException("EXM_CIM_INVALID_PARAM", string4);
                } else if (string3.equals("CIM_ERR_NOT_FOUND")) {
                    clientProxyException = new ClientProxyException("EXM_CIM_NOT_FOUND", string4);
                } else if (string3.equals("CIM_ERR_FAILED")) {
                    clientProxyException = new ClientProxyException("EXM_PROVIDER_ERR", string4);
                } else if (string3.equals("GENERAL_EXCEPTION")) {
                    if (string == null || string.equals(EMPTY_STR)) {
                        clientProxyException = new ClientProxyException(string4);
                    } else if (stringArray == null || stringArray.length == 0) {
                        clientProxyException = new ClientProxyException(string, string4);
                    } else {
                        String[] stringArray2 = new String[stringArray.length + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                        stringArray2[stringArray.length] = string4;
                        clientProxyException = new ClientProxyException(string, stringArray2);
                    }
                } else {
                    clientProxyException = string2 == null || string2.equals(EMPTY_STR) ? new ClientProxyException("EXM_UNKW_PROVIDER_ERR") : new ClientProxyException(string2);
                }
            } else {
                clientProxyException = string3.equals("CIM_ERR_INVALID_QUERY") ? new ClientProxyException("EXM_AUTH_QUERY") : (string3.equals("CIM_ERR_NOT_SUPPORTED") ? new ClientProxyException("EXM_OP_NOT_SUPPORTED") : (string3.equals("CIM_ERR_FAILED") ? new ClientProxyException("EXM_CIM_ERR", string4) : (string2 == null || string2.equals(EMPTY_STR) ? new ClientProxyException(exception.toString()) : new ClientProxyException(string2))));
            }
        } else {
            clientProxyException = string2 == null || string2.equals(EMPTY_STR) ? new ClientProxyException(exception.toString()) : new ClientProxyException(string2);
        }
        return clientProxyException;
    }

    private AdminException mapException(Exception exception) {
        return this.mapException(null, null, exception);
    }

    private void test() {
        boolean bl = false;
        while (!bl) {
            System.out.println("1 - List Patches");
            System.out.println("2 - Get Patch");
            System.out.println("3 - Apply a single Patch");
            System.out.println("4 - Remove a single Patch");
            System.out.println("5 - Mount Patch Server");
            System.out.println("6 - Unmount Patch Server");
            System.out.println("7 - Retrieve spooled patch id README file:");
            System.out.println("8 - Retrieve spooled patch info:");
            System.out.println("a - Get the system's arch type(ISA):");
            System.out.println("b - Get the system's SunOs Info, release/version:");
            System.out.println("c - Download Patches:");
            System.out.println("d - Assess the needed patches for your system:");
            System.out.println("e - Validate directory: ");
            System.out.println("q - To quit");
            System.out.println(EMPTY_STR);
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println(EMPTY_STR);
                if (c != '\u0002') continue;
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        this.testList();
                        break;
                    }
                    case '2': {
                        this.testGetPatch();
                        break;
                    }
                    case '3': {
                        this.testApplySinglePatch();
                        break;
                    }
                    case '4': {
                        this.testRemoveSinglePatch();
                        break;
                    }
                    case '5': {
                        this.testMountPatchServer();
                        break;
                    }
                    case '6': {
                        this.testUnmountPatchServer();
                        break;
                    }
                    case '7': {
                        this.testGetSpooledPatchReadme();
                        break;
                    }
                    case '8': {
                        this.testGetSpooledPatchInfo();
                        break;
                    }
                    case 'a': {
                        String string = this.getSystemArch();
                        System.out.println("Arch.: " + string);
                        break;
                    }
                    case 'b': {
                        SunOSInfo sunOSInfo = this.getSunOSRelease();
                        System.out.println(sunOSInfo.toString());
                        break;
                    }
                    case 'c': {
                        this.testDownloadPatches();
                        break;
                    }
                    case 'd': {
                        this.testAssessNeededPatches();
                        break;
                    }
                    case 'e': {
                        this.testGetDirInfo();
                        break;
                    }
                    case 'q': {
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println(EMPTY_STR);
        }
    }

    private String getKeyBoard(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return new String(EMPTY_STR);
        }
    }

    public InstallPatchesByPolicyResults installPatchesByPolicy(Vector vector, String string) throws AdminException {
        this.checkClassVersion(SOLARIS_PATCH, VERSION_13);
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, INSTALL_PATCHES_BY_POLICY, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            return new InstallPatchesByPolicyResults(vector4);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_INSTALL_FAILED", string2);
                }
                throw new ClientProxyException("EXM_INSTALL_FAILED_UNEXP");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    private Vector getPatchIds(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            String string3 = (String)enumeration.nextElement();
            int n = 0;
            n = string3.indexOf(61);
            if (n <= 0 || !(string2 = string3.substring(0, n)).endsWith(".id") || (string = string3.substring(n + 1)) == null) continue;
            vector2.addElement(string);
        }
        return vector2;
    }

    private Vector getSynopses(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            String string3 = (String)enumeration.nextElement();
            int n = 0;
            n = string3.indexOf(61);
            if (n <= 0 || !(string2 = string3.substring(0, n)).endsWith(".syn") || (string = string3.substring(n + 1)) == null) continue;
            vector2.addElement(string);
        }
        return vector2;
    }

    private void checkClassVersion(String string, String string2) throws PatchException {
        String[] stringArray;
        String[] stringArray2;
        String string3 = EMPTY_STR;
        try {
            stringArray2 = new CIMObjectPath(string);
            stringArray = this.cc.getClass((CIMObjectPath)stringArray2, true);
            CIMQualifier cIMQualifier = stringArray.getQualifier("Version");
            string3 = (String)cIMQualifier.getValue().getValue();
        }
        catch (CIMException cIMException) {
            throw new PatchException("EXM_PROVIDER_NO_CLASS", (Object)string2, string);
        }
        stringArray2 = string2.split("\\.");
        stringArray = string3.split("\\.");
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            int n2;
            int n3;
            try {
                n3 = Integer.parseInt(stringArray2[n]);
                n2 = n < stringArray.length ? Integer.parseInt(stringArray[n]) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PatchException("EXM_PROVIDER_BAD_VERSION", (Object)string2, string3);
            }
            if (n3 > n2) {
                bl = true;
                break;
            }
            if (n3 < n2) {
                if (n == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            throw new PatchException("EXM_PROVIDER_VERSION_MISMATCH", (Object)string2, (Object)string, string3);
        }
    }

    private void testList() throws AdminException {
        System.out.println("------ List Patches Begin -------\n");
        Vector vector = this.getPatchList();
        int n = 0;
        while (n < vector.size()) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)vector.elementAt(n);
            System.out.println(patchMgrObj.toString());
            ++n;
        }
        System.out.println("\n------ List Patches End -------\n");
    }

    private void testGetPatch() throws AdminException {
        System.out.println("------ Get Patch Begin -------\n");
        String string = this.getKeyBoard("Patch ID: ");
        PatchMgrObj patchMgrObj = this.getPatchData(string);
        if (patchMgrObj == null) {
            System.out.println("Patch not found");
        } else {
            System.out.println(patchMgrObj.toString());
        }
        System.out.println("\n------ Get Patch End -------\n");
    }

    private void testApplySinglePatch() throws AdminException {
        System.out.println("------ Apply Single Patch Begin -------\n");
        String string = null;
        Object var2_2 = null;
        String string2 = this.getKeyBoard("Do you need to mount the patch server?(y or n)");
        if (string2.equals("y")) {
            this.testMountPatchServer();
            string = DEFAULT_MNT_POINT;
        } else {
            string = this.getKeyBoard("Local Patch Directory: ");
        }
        String string3 = this.getKeyBoard("Enter a patch id: ");
        String string4 = this.getKeyBoard("Enter non-default backout directory: ");
        PatchMgrObj patchMgrObj = new PatchMgrObj();
        if (string3 != null && string3.trim().length() > 0) {
            patchMgrObj.setPatchName(string3);
        }
        if (string != null && string.trim().length() > 0) {
            patchMgrObj.setPatchDirName(string);
        }
        if (string4 != null && string4.trim().length() > 0) {
            patchMgrObj.setBackoutDir(string4);
        }
        this.applySinglePatch(patchMgrObj);
        if (string2.equals("y")) {
            this.testUnmountPatchServer();
        }
        System.out.println("\n------ Apply Single Patch End -------\n");
    }

    private void testRemoveSinglePatch() throws AdminException {
        System.out.println("------ Remove Single Patch Begin -------\n");
        String string = this.getKeyBoard("Patch ID: ");
        PatchMgrObj patchMgrObj = this.getPatchData(string);
        if (patchMgrObj == null) {
            System.out.println("Patch not found");
        } else {
            this.removeSinglePatch(patchMgrObj);
        }
        System.out.println("\n------ Remove Single Patch End -------\n");
    }

    private void testMountPatchServer() throws AdminException {
        System.out.println("------ Mount Patch Server -------\n");
        String string = null;
        String string2 = this.getKeyBoard("Remote host where patches reside: ");
        String string3 = this.getKeyBoard("The exported/shared Directory: ");
        string = string2 + ":" + string3;
        this.mountPatchServer(string);
        System.out.println("\n------ Mount Patch Server -------\n");
    }

    private void testUnmountPatchServer() throws AdminException {
        System.out.println("------ Unmount Patch Server -------\n");
        String string = null;
        String string2 = this.getKeyBoard("Remote host where patches reside: ");
        String string3 = this.getKeyBoard("The exported/shared Directory: ");
        string = string2 + ":" + string3;
        this.unmountPatchServer(string);
        System.out.println("\n------ Unmount Patch Server -------\n");
    }

    private void testGetSpooledPatchInfo() throws AdminException {
        System.out.println("------ GetSpooledPatchInfo Begin -------\n");
        String string = this.getKeyBoard("Spooled Patch Dir: ");
        Vector vector = this.getSpooledPatchInfo(string);
        int n = 0;
        while (vector != null && n < vector.size()) {
            System.out.println((String)vector.elementAt(n));
            ++n;
        }
        System.out.println();
        Hashtable hashtable = SpooledPatchUtil.getHashTable(vector);
        Vector vector2 = SpooledPatchUtil.getPatchIds(hashtable);
        n = 0;
        while (vector2 != null && n < vector2.size()) {
            System.out.println((String)vector2.elementAt(n));
            ++n;
        }
        System.out.println(EMPTY_STR);
        System.out.println("Number of Patches: " + n);
        System.out.println("\n------ GetSpooledPatchInfo End -------\n");
    }

    private void testGetSpooledPatchReadme() throws AdminException {
        System.out.println("------ GetSpooledPatchReadme Begin -------\n");
        String string = this.getKeyBoard("Spooled Patch Dir: ");
        String string2 = this.getKeyBoard("Patch Id: ");
        String string3 = this.getSpooledPatchReadme(string, string2);
        System.out.println();
        System.out.println(string3);
        System.out.println();
        System.out.println("\n------ GetSpooledPatchReadme End -------\n");
    }

    private void testGetDirInfo() throws AdminException {
        System.out.println("------ GetDirInfo Begin -------\n");
        String string = this.getKeyBoard("Enetr directory: ");
        RemoteFileData remoteFileData = this.getDirInfo(string);
        remoteFileData.print();
        System.out.println("\n------ GetDirInfo End -------\n");
    }

    private void testDownloadPatches() throws AdminException {
        System.out.println("------ Download Patches Begin -------\n");
        Vector<String> vector = new Vector<String>();
        String string = EMPTY_STR;
        int n = 0;
        while (true) {
            if ((string = this.getKeyBoard(++n + ") " + "Patch IDs list(type 'b' to break): ")).length() == 0) {
                --n;
                continue;
            }
            if (string.equals("b")) break;
            vector.addElement(string);
        }
        String string2 = this.getKeyBoard("Download Directory: ");
        this.downloadPatches(vector, string2);
        System.out.println();
        System.out.println();
        System.out.println("\n------ Download Patches End -------\n");
    }

    private void testAssessNeededPatches() throws AdminException {
        System.out.println("------  AssessNeededPatches Begin -------\n");
        Vector vector = this.assessNeededPatches();
        System.out.println();
        int n = 0;
        while (vector != null && n < vector.size()) {
            AssessedPatchData assessedPatchData = (AssessedPatchData)vector.elementAt(n);
            System.out.println(assessedPatchData.toString());
            ++n;
        }
        System.out.println();
        System.out.println("\n------ AssessNeededPatches End -------\n");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length != 3) {
            string = "Usage: PatchMgrObjClient host username password";
            System.out.println();
            System.exit(1);
        }
        string = null;
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace(stringArray[0]);
            UserPrincipal userPrincipal = new UserPrincipal(stringArray[1]);
            PasswordCredential passwordCredential = new PasswordCredential(stringArray[2]);
            string = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
            PatchMgrClient patchMgrClient = new PatchMgrClient();
            patchMgrClient.init((CIMClient)string);
            patchMgrClient.test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            try {
                string.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

