/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.http;

import com.sun.wbem.cimom.CIMOMServer;
import com.sun.wbem.cimom.adapters.client.http.BASE64Decoder;
import com.sun.wbem.cimom.adapters.client.http.CharacterDecoder;
import com.sun.wbem.cimom.adapters.client.http.XmlResponder;
import com.sun.wbem.cimom.security.UserPasswordProvider;
import com.sun.xml.tree.XmlDocument;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.util.StringTokenizer;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpServerRequestHandler;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class CIMRequestHandler
extends HttpServerRequestHandler {
    private String servername;
    private CIMOMServer cimom = null;
    private PasswordAuthentication auth;
    private UserPasswordProvider upp = null;

    CIMRequestHandler(CIMOMServer cIMOMServer, String string) throws Exception {
        this.cimom = cIMOMServer;
        this.upp = this.getUserPasswordProvider();
    }

    public boolean checkAuthentication(InboundRequest inboundRequest) {
        String string = inboundRequest.getHeaderField("Authorization");
        if (string == null) {
            inboundRequest.setRespondHeaderField("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            try {
                XmlDocument xmlDocument = this.getXmlDocument(inboundRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        this.auth = this.verifyAuthentication(string);
        return this.auth != null;
    }

    public void addResponseHeaderFields(InboundRequest inboundRequest) {
        inboundRequest.setRespondHeaderField("CIMOperation", "MethodResponse");
    }

    public void handleRequest(InboundRequest inboundRequest) {
        try {
            XmlDocument xmlDocument = this.getXmlDocument(inboundRequest);
            xmlDocument = this.rpc(xmlDocument, this.auth);
            DataOutputStream dataOutputStream = new DataOutputStream(inboundRequest.getResponseOutputStream());
            xmlDocument.write((OutputStream)dataOutputStream);
        }
        catch (SAXException sAXException) {
            DataOutputStream dataOutputStream = new DataOutputStream(inboundRequest.getResponseOutputStream());
            sAXException.printStackTrace();
            Exception exception = sAXException.getException();
            String string = "Parse Error with Request:\n";
            if (exception == null) {
                exception = sAXException;
            }
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                string = string + "** URI: " + sAXParseException.getSystemId() + "\n";
                string = string + "** Line: " + sAXParseException.getLineNumber() + "\n";
            }
            this.do500Error(dataOutputStream, "XML Parsing error: <b>" + string + "</b>");
            System.out.println(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private UserPasswordProvider getUserPasswordProvider() throws Exception {
        UserPasswordProvider userPasswordProvider = null;
        try {
            Class<?> clazz = Class.forName(System.getProperty("com.sun.wbem.cimom.pswdprov"));
            userPasswordProvider = (UserPasswordProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.trace1((String)"Http: error getting password provider", (Throwable)exception);
            throw exception;
        }
        return userPasswordProvider;
    }

    private PasswordAuthentication verifyAuthentication(String string) {
        Object object;
        PasswordAuthentication passwordAuthentication = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            object = new StringTokenizer(string);
            try {
                string2 = ((StringTokenizer)object).nextToken();
                string3 = ((StringTokenizer)object).nextToken();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null && string3 != null && string2.equalsIgnoreCase("Basic")) {
            byte[] byArray;
            object = new BASE64Decoder();
            try {
                byArray = ((CharacterDecoder)object).decodeBuffer(string3);
            }
            catch (Exception exception) {
                byArray = new byte[]{};
            }
            int n = byArray.length;
            char[] cArray = new char[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                cArray[n3] = (char)byArray[n3];
                if (cArray[n3] == ':') {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 > 0) {
                String string4 = new String(cArray, 0, n2);
                int n4 = n - n2 - 1;
                char[] cArray2 = new char[n4];
                int n5 = 0;
                while (n5 < n4) {
                    cArray2[n5] = cArray[++n2];
                    ++n5;
                }
                String string5 = new String(cArray2);
                if (this.upp != null) {
                    try {
                        if (this.upp.authenticateUser(string4, string5)) {
                            passwordAuthentication = new PasswordAuthentication(string4, cArray2);
                            Debug.trace1((String)("Http: client authenticated: " + string4));
                        }
                    }
                    catch (Exception exception) {
                        passwordAuthentication = null;
                    }
                    if (passwordAuthentication == null) {
                        Debug.trace1((String)("Http: invalid credentials: " + string4));
                    }
                }
            }
        }
        if (passwordAuthentication == null) {
            Debug.trace1((String)"Http: invalid authentication");
        }
        return passwordAuthentication;
    }

    private String getRealm() {
        String string = "wbem@" + this.servername;
        return string;
    }

    private XmlDocument rpc(XmlDocument xmlDocument, PasswordAuthentication passwordAuthentication) {
        XmlDocument xmlDocument2 = null;
        try {
            XmlResponder xmlResponder = new XmlResponder(this.cimom);
            xmlDocument2 = xmlResponder.getResponse(xmlDocument, passwordAuthentication);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return xmlDocument2;
    }
}

