/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.CIMOMLogService;
import com.sun.wbem.cimom.MofregClient;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.UnregHandler;
import com.sun.wbem.compiler.mofc.CIM_Mofc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

class Mofregistry {
    private static final String UNREGSUFFIX = ".unreg";
    String parentDir;
    String regDirParent;
    String unregDirParent;
    String failDirParent;
    String preRegDirParent;
    String preUnregDirParent;
    private static Mofregistry mofreg = null;
    private CIMOMImpl cimom;

    private Mofregistry(CIMOMImpl cIMOMImpl, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.parentDir = string;
        this.regDirParent = string + File.separatorChar + string2;
        this.unregDirParent = string + File.separatorChar + string3;
        this.failDirParent = string + File.separatorChar + string4;
        this.preRegDirParent = string + File.separatorChar + string5;
        this.preUnregDirParent = string + File.separatorChar + string6;
        File file = new File(this.failDirParent);
        file.mkdirs();
        file = new File(this.regDirParent);
        file.mkdirs();
        file = new File(this.unregDirParent);
        file.mkdirs();
        file = new File(this.preRegDirParent);
        file.mkdirs();
        file = new File(this.preUnregDirParent);
        file.mkdirs();
        this.cimom = cIMOMImpl;
    }

    static synchronized Mofregistry getMofregistry(CIMOMImpl cIMOMImpl, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (mofreg == null) {
            mofreg = new Mofregistry(cIMOMImpl, string, string2, string3, string4, string5, string6);
        }
        return mofreg;
    }

    void logException(Exception exception) {
        Debug.trace2((String)"Got a mofreg error", (Throwable)exception);
        CIMOMLogService cIMOMLogService = (CIMOMLogService)ServiceRegistry.getService("logservice");
        if (cIMOMLogService == null) {
            return;
        }
        try {
            cIMOMLogService.writeLog("Mofreg", "MOFREG_ERROR", "MOFREG_ERROR", null, exception.toString(), false, 2, 2, null);
        }
        catch (Exception exception2) {
            Debug.trace2((String)"logging error", (Throwable)exception2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doRegistry(File file) throws Exception {
        OutputStream outputStream;
        block10: {
            block9: {
                File[] fileArray = file.listFiles();
                if (fileArray.length == 0) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)(file + ".reg"));
                }
                outputStream = null;
                String string = file.getName();
                try {
                    try {
                        int n = 1;
                        String string2 = this.unregDirParent + File.separatorChar + string;
                        File file2 = new File(string2);
                        if (file2.exists()) {
                            Debug.trace2((String)(file2 + " already exists"));
                            String string3 = this.failDirParent + File.separatorChar + string + File.separatorChar + "reg";
                            File file3 = new File(string3);
                            Debug.trace3((String)("Cleaning up old backup if any " + string3));
                            this.recursiveDelete(file3);
                            file3.mkdirs();
                            file.renameTo(file3);
                            Object var12_16 = null;
                            if (outputStream == null) return;
                            break block9;
                        }
                        file2.mkdir();
                        String string4 = string2 + File.separatorChar + string;
                        outputStream = new FileOutputStream(string4 + UNREGSUFFIX);
                        Debug.trace3((String)("The input file is " + fileArray[0]));
                        Debug.trace3((String)("The output file is " + string4 + UNREGSUFFIX));
                        UnregHandler unregHandler = new UnregHandler(outputStream);
                        CIM_Mofc.parseMOF((String[])new String[]{"-v", fileArray[0].getPath()}, (int)n, (CIMOMHandle)new MofregClient(this.cimom, n, unregHandler));
                        unregHandler.outputUnreg();
                        outputStream.close();
                        Debug.trace3((String)("Cleaning up old backup if any " + string4));
                        File file4 = new File(string4);
                        this.recursiveDelete(file4);
                        file.renameTo(file4);
                        break block10;
                    }
                    catch (Exception exception) {
                        this.logException(exception);
                        String string5 = this.failDirParent + File.separatorChar + string + File.separatorChar + "reg";
                        File file5 = new File(string5);
                        Debug.trace3((String)("Cleaning up old backup if any " + string5));
                        this.recursiveDelete(file5);
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        File file6 = new File(this.unregDirParent + File.separatorChar + string);
                        Debug.trace3((String)("Recursively deleting unreg " + file6));
                        if (file6.exists()) {
                            this.recursiveDelete(file6);
                        }
                        file5.mkdirs();
                        file.renameTo(file5);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
            }
            outputStream.close();
            return;
        }
        Object var12_17 = null;
        if (outputStream == null) return;
        outputStream.close();
    }

    private void recursiveDelete(File file) {
        if (!file.isDirectory()) {
            Debug.trace3((String)("rec: Deleting file " + file));
            file.delete();
        } else {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.recursiveDelete(fileArray[n]);
                ++n;
            }
            Debug.trace3((String)("rec: Deleting dir " + file));
            file.delete();
        }
    }

    void doUnregistry(File file) throws Exception {
        File file2;
        String string = file.getName();
        String string2 = this.unregDirParent + File.separatorChar + string;
        File file3 = new File(string2);
        if (!file3.exists()) {
            Debug.trace2((String)(file + " not registered"));
            String string3 = this.failDirParent + File.separatorChar + string + File.separatorChar + "unreg";
            File file4 = new File(string3);
            Debug.trace3((String)("Cleaning up old backup if any " + string3));
            this.recursiveDelete(file4);
            file4.mkdirs();
            file.renameTo(file4);
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            String string4 = string2 + File.separatorChar + string + UNREGSUFFIX;
            file2 = new File(string4);
        } else {
            file2 = fileArray[0];
        }
        try {
            int n = 2;
            Debug.trace3((String)"Parsing testunreg.mof");
            CIM_Mofc.parseMOF((String[])new String[]{"-v", file2.getPath()}, (int)n, (CIMOMHandle)new MofregClient(this.cimom, n, null));
            Debug.trace3((String)("Cleaning up reg info for " + file3));
            this.recursiveDelete(file3);
            Debug.trace3((String)("Removing " + file));
            this.recursiveDelete(file);
        }
        catch (Exception exception) {
            this.logException(exception);
            String string5 = this.failDirParent + File.separatorChar + string + File.separatorChar + "unreg";
            Debug.trace3((String)("Failed - renaming to " + string5));
            File file5 = new File(string5);
            Debug.trace3((String)("Cleaning up old backup if any " + string5));
            this.recursiveDelete(file5);
            file5.mkdirs();
            file.renameTo(file5);
            Debug.trace3((String)("Cleaning up reg info for " + file3));
            this.recursiveDelete(file3);
            file2.renameTo(new File(string5 + file2.getName()));
        }
    }

    private List getSortedFileList(File file, File file2) {
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add(fileArray[n]);
            ++n;
        }
        if (file2 != null) {
            fileArray = file2.listFiles();
            int n2 = 0;
            while (n2 < fileArray.length) {
                arrayList.add(fileArray[n2]);
                ++n2;
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                long l;
                File file = (File)object;
                File file2 = (File)object2;
                long l2 = file.lastModified();
                if (l2 > (l = file2.lastModified())) {
                    return 1;
                }
                if (l2 < l) {
                    return -1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    synchronized void mofReg() throws Exception {
        Debug.trace3((String)("Looking for reg info in " + this.preRegDirParent + " and " + this.preUnregDirParent));
        File file = new File(this.preRegDirParent);
        File file2 = new File(this.preUnregDirParent);
        List list = this.getSortedFileList(file, file2);
        Iterator iterator = list.iterator();
        Debug.trace3((String)"Processing pre reg entries");
        while (iterator.hasNext()) {
            File file3 = (File)iterator.next();
            if (file3.getName().endsWith(UNREGSUFFIX)) {
                this.recursiveDelete(file3);
                continue;
            }
            if (file3.getParentFile().equals(file)) {
                Debug.trace3((String)("Handling preReg for " + file3));
                try {
                    this.doRegistry(file3);
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Registry " + file3 + " failed"), (Throwable)exception);
                    this.logException(exception);
                }
                continue;
            }
            Debug.trace3((String)("Handling preUnReg for " + file3));
            try {
                this.doUnregistry(file3);
            }
            catch (Exception exception) {
                Debug.trace1((String)("UnRegistry " + file3 + " failed"), (Throwable)exception);
                this.logException(exception);
            }
        }
        Debug.trace3((String)"Done Processing reg/unreg entries");
    }
}

