/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpledatabase;

import com.sun.database.simpledatabase.AccessMethod;
import com.sun.database.simpledatabase.AlreadyPopulatedException;
import com.sun.database.simpledatabase.DuplicateAlreadyStoredException;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.ObjectStore;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.database.util.HierarchicalField;
import java.util.Enumeration;

public abstract class SimpleDatabasePrtl
implements SimpleDatabase {
    protected AccessMethod[] keyTree;
    protected ObjectStore objectStore;
    protected HierarchicalField[] keyFields;
    protected String[] keyFieldStrings;

    public void transferContentsTo(SimpleDatabase simpleDatabase) throws DuplicateEntryException, IllegalAccessException {
        try {
            int n = 0;
            while (n < this.keyFieldStrings.length) {
                if (this.areDuplicatesAllowed(this.keyFieldStrings[n]) && !simpleDatabase.areDuplicatesAllowed(this.keyFieldStrings[n])) {
                    throw new DuplicateEntryException("This database permits duplicates but the target doesn't.");
                }
                ++n;
            }
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                simpleDatabase.addObject(enumeration.nextElement());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalAccessException("Classes in store do not match.");
        }
    }

    public void useAccessMethod(String string, AccessMethod accessMethod) throws NoSuchFieldException, AlreadyPopulatedException {
        boolean bl = false;
        int n = this.findMatchingKeyfield(string, this.keyFieldStrings);
        if (this.keyTree[n] != null) {
            bl = this.keyTree[n].areDuplicatesAllowed();
        }
        this.keyTree[n] = accessMethod;
        try {
            this.keyTree[n].allowDuplicates(bl);
        }
        catch (DuplicateAlreadyStoredException duplicateAlreadyStoredException) {
            throw new AlreadyPopulatedException(duplicateAlreadyStoredException.getMessage());
        }
    }

    public void flushDatabase() throws IllegalAccessException {
    }

    public void closeDatabase() {
    }

    public void allowDuplicates(int n, boolean bl) throws ArrayIndexOutOfBoundsException, DuplicateAlreadyStoredException {
        this.keyTree[n].allowDuplicates(bl);
    }

    public void allowDuplicates(String string, boolean bl) throws NoSuchFieldException, DuplicateAlreadyStoredException {
        this.allowDuplicates(this.findMatchingKeyfield(string, this.keyFieldStrings), bl);
    }

    public boolean areDuplicatesAllowed(String string) throws NoSuchFieldException {
        int n = this.findMatchingKeyfield(string, this.keyFieldStrings);
        return this.keyTree[n].areDuplicatesAllowed();
    }

    public String whatClass() {
        return this.objectStore.whatClass();
    }

    public String[] whatFields() {
        return this.keyFieldStrings;
    }

    protected int findMatchingKeyfield(String string, String[] stringArray) throws NoSuchFieldException {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].compareTo(string) == 0) break;
            ++n2;
        }
        if (n2 == n) {
            throw new NoSuchFieldException("findMatchingKeyfield: key string " + string + " matches no valid key index.");
        }
        return n2;
    }
}

