/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.memory;

import com.sun.database.simpledatabase.ObjectStorePrtl;
import com.sun.database.util.HierarchicalField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MemoryObjectStore
extends ObjectStorePrtl
implements Serializable {
    private static final String sccs_id = "1.6";
    static final int LOOKAHEADSIZE = 50;
    static final int UNAVAILABLE = -1;
    private Class classInStore;
    private Vector objectList;
    private int databaseSize = 0;
    private Enumeration objectElements;
    private int[] lookahead = new int[50];
    private int currentLookaheadRecord = -1;
    private int lastRecord = -1;
    private boolean lookaheadIsEmpty;
    private boolean lookaheadOverflow;

    public MemoryObjectStore(Class clazz) {
        this.classInStore = clazz;
        this.objectList = new Vector();
        this.lookaheadIsEmpty = true;
        this.lookaheadOverflow = false;
    }

    public void destroyObjectStore() throws IllegalAccessException {
        this.objectList = null;
        this.classInStore = null;
    }

    public String whatClass() {
        return this.classInStore.toString();
    }

    public Class getClassInStore() {
        return this.classInStore;
    }

    public int insertObject(Object object) throws IllegalAccessException {
        int n = this.reserveNextRecord();
        this.objectList.insertElementAt(object, n);
        ++this.databaseSize;
        return n;
    }

    public void removeObject(int n) {
        --this.databaseSize;
        this.objectList.setElementAt(null, n);
        this.addToLookahead(n);
    }

    public Object getObjectFieldValue(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.get(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public long getObjectFieldLong(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getLong(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return 0L;
        }
    }

    public int getObjectFieldInt(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getInt(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return 0;
        }
    }

    public short getObjectFieldShort(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getShort(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return 0;
        }
    }

    public boolean getObjectFieldBoolean(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getBoolean(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
    }

    public double getObjectFieldDouble(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getDouble(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return 0.0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return 0.0;
        }
    }

    public char getObjectFieldChar(HierarchicalField hierarchicalField, int n) {
        Object e = this.objectList.elementAt(n);
        try {
            return hierarchicalField.getChar(e);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return '\u0000';
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return '\u0000';
        }
    }

    public Object getObject(int n) throws ArrayIndexOutOfBoundsException {
        return this.objectList.elementAt(n);
    }

    public Enumeration elements() {
        if (this.objectList == null) {
            this.objectList = new Vector();
        }
        return this.objectList.elements();
    }

    public Object getFirstObject() throws NoSuchElementException {
        this.objectElements = this.objectList.elements();
        return this.objectElements.nextElement();
    }

    public Object getNextObject() throws NoSuchElementException {
        Object e;
        if (this.objectElements == null) {
            this.objectElements = this.objectList.elements();
        }
        try {
            e = this.objectElements.nextElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.objectElements = null;
            throw noSuchElementException;
        }
        return e;
    }

    public boolean hasMoreObjects() {
        boolean bl;
        if (this.objectElements == null) {
            this.objectElements = this.objectList.elements();
        }
        if (!(bl = this.objectElements.hasMoreElements())) {
            this.objectElements = null;
        }
        return bl;
    }

    private int reserveNextRecord() {
        int n = this.getNextRecord();
        this.markUnavailable();
        if (n > this.lastRecord) {
            this.lastRecord = n;
        }
        return n;
    }

    private int getNextRecord() {
        if (!this.lookaheadIsEmpty) {
            this.currentLookaheadRecord = 0;
            while (this.currentLookaheadRecord < 50) {
                if (this.lookahead[this.currentLookaheadRecord] != -1) {
                    if (this.currentLookaheadRecord != 49) break;
                    this.lookaheadIsEmpty = true;
                    break;
                }
                ++this.currentLookaheadRecord;
            }
            int n = this.lookahead[this.currentLookaheadRecord];
            return n;
        }
        return this.repopulateLookahead();
    }

    private void markUnavailable() {
        this.lookahead[this.currentLookaheadRecord] = -1;
    }

    private void markAvailable(int n) {
        this.lookahead[this.currentLookaheadRecord] = n;
    }

    private void addToLookahead(int n) {
        if (this.currentLookaheadRecord < 0) {
            this.lookaheadOverflow = true;
        } else {
            this.markAvailable(n);
            --this.currentLookaheadRecord;
            this.lookaheadIsEmpty = false;
        }
    }

    private int repopulateLookahead() {
        if (!this.lookaheadOverflow) {
            this.initializeLookahead();
        } else {
            this.exhaustiveFillLookahead();
        }
        return this.getNextRecord();
    }

    private void initializeLookahead() {
        int n = this.lastRecord + 1;
        int n2 = 0;
        while (n2 < 50) {
            this.lookahead[n2] = n++;
            ++n2;
        }
        this.lookaheadIsEmpty = false;
        this.lookaheadOverflow = false;
    }

    private void exhaustiveFillLookahead() {
        int n = 0;
        int n2 = 0;
        while (n2 < 50) {
            this.lookaheadOverflow = false;
            while (n < this.databaseSize) {
                this.lookaheadOverflow = true;
                if (this.getObject(n) == null) break;
            }
            this.lookahead[n2] = n++;
            ++n2;
        }
        this.lookaheadIsEmpty = false;
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

