/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.cli;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.patchmgr.cli.PatchMgrCli;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.admin.patchmgr.common.InstallPatchesByPolicyResults;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.admin.patchmgr.common.PatchHostData;
import java.util.Vector;

class Updater
extends Thread
implements Runnable {
    PatchMgrCli cli;
    PatchHostData host;
    DownloadPatchesResults dpr;
    InstallPatchesByPolicyResults ipr;
    String hostname;
    ServiceWrapper proxy;
    Vector patchList;
    AdminException thrown;
    boolean hadError = false;
    boolean nothingToDo = false;
    long start;
    long end;
    long elapsed;

    public Updater(PatchMgrCli patchMgrCli, PatchHostData patchHostData, Vector vector) {
        this.cli = patchMgrCli;
        this.host = patchHostData;
        this.patchList = vector;
    }

    public void init() throws AdminException {
        this.hostname = this.host.getPatchHost();
        this.proxy = this.cli.getMachineServiceWrapper(this.hostname);
        if (this.proxy == null) {
            throw new PatchException("EXM_CANT_CONNECT");
        }
    }

    public void run() {
        long l = System.currentTimeMillis();
        try {
            this.dpr = this.proxy.downloadPatchesInJarFormat(this.patchList, this.host.getPatchDir());
        }
        catch (AdminException adminException) {
            this.elapsed = System.currentTimeMillis() - l;
            this.thrown = adminException;
            this.hadError = true;
            return;
        }
        if (this.dpr.getPatchListClosure().isEmpty()) {
            this.nothingToDo = true;
            return;
        }
        try {
            this.ipr = this.proxy.installPatchesByPolicy(this.dpr.getPatchListClosure(), this.host.getPatchDir());
        }
        catch (AdminException adminException) {
            adminException.printStackTrace();
            this.elapsed = System.currentTimeMillis() - l;
            this.thrown = adminException;
            this.hadError = true;
            return;
        }
        Vector vector = this.ipr.getInstallationErrors();
        if (vector.size() != 0) {
            this.elapsed = System.currentTimeMillis() - l;
            this.hadError = true;
        }
        this.elapsed = System.currentTimeMillis() - l;
    }

    boolean getFailed() {
        return this.hadError;
    }

    boolean getNothingToDo() {
        return this.nothingToDo;
    }

    Exception getException() {
        return this.thrown;
    }

    long getElapsed() {
        return this.elapsed;
    }

    InstallPatchesByPolicyResults getInstallResults() {
        return this.ipr;
    }

    DownloadPatchesResults getDownloadResults() {
        return this.dpr;
    }
}

