/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.tz;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.tz.TzTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_SystemTimeZone
implements InstanceProvider,
Authorizable {
    protected static final String SOLARIS_TIMEZONE_WRITE_RIGHT = "solaris.compsys.write";
    private static final String HOST_ID = "HostId";
    private CIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "SystemTimeZone";
    String[] msg = new String[]{this.PROVIDER_NAME};
    TimeZone tz = TimeZone.getDefault();
    private static String tzkey = "TZ";
    private static String CLASS_NAME = "Solaris_ComputerSystem";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        this.prov_util = new ProviderUtility(cIMOMHandle, this.PROVIDER_NAME);
        try {
            if (this.tz.getID().equalsIgnoreCase("Custom")) {
                TzTable tzTable = new TzTable();
                String string = tzTable.getTimezoneValue(tzkey);
                TimeZone timeZone = TimeZone.getTimeZone(string);
                TimeZone.setDefault(timeZone);
                this.tz = TimeZone.getDefault();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8600", "LM_8601", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8602", "LM_8603", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Object object;
        try {
            this.prov_util.checkRights(SOLARIS_TIMEZONE_WRITE_RIGHT, cIMObjectPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("authorization failed");
        }
        this.checkCron(cIMObjectPath);
        this.checkProcess(cIMObjectPath);
        String string = null;
        CIMObjectPath cIMObjectPath2 = null;
        String string2 = "TZ";
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (object == null || !object.getName().equalsIgnoreCase("Setting")) continue;
            cIMObjectPath2 = (CIMObjectPath)object.getValue().getValue();
            break;
        }
        if (cIMObjectPath2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        object = cIMObjectPath2.getKeys().elements();
        while (object.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)object.nextElement();
            if (cIMProperty == null || !cIMProperty.getName().equalsIgnoreCase("StandardName")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean bl = false;
        try {
            TzTable tzTable = new TzTable();
            tzTable.setTimezoneValue(string2, string);
            this.tz = TimeZone.getTimeZone(string);
            TimeZone.setDefault(this.tz);
        }
        catch (DirectoryTableException directoryTableException) {
            bl = true;
        }
        catch (DBTableException dBTableException) {
            bl = true;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"setInstance of TimeZone Failed");
        }
        if (bl) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8610", "LM_8611", this.msg, "FAILURE", false, 0, 2);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath2.getObjectName(), cIMObjectPath2.getNameSpace());
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
            cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath4.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            try {
                cIMObjectPath5.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_FAILED", (Object)exception);
            }
            try {
                cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_FAILED", (Object)exception);
            }
            cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath4));
            cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            if (bl) {
                cIMInstance = cIMInstance.localElements();
            }
            return cIMInstance.filterProperties(stringArray, bl2, bl3);
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance of SystemTimeZone Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath2.getObjectName(), cIMObjectPath2.getNameSpace());
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
            cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath4.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMObjectPath5.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath4));
            cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            CIMInstance[] cIMInstanceArray = new CIMInstance[vector.size()];
            vector.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of SystemTimeZone Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
            CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath4.getObjectName(), cIMObjectPath4.getNameSpace());
            cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath5.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMObjectPath6.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            cIMObjectPath6.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            cIMObjectPath2.addKey("Element", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2.addKey("Setting", new CIMValue((Object)cIMObjectPath6));
            vector.addElement(cIMObjectPath2);
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[vector.size()];
            vector.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of SystemTimeZone Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    private void checkCron(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = "SELECT * ";
        String string2 = "FROM Solaris_ScheduledJob_Cron ";
        String string3 = "WHERE Command = '/usr/bin/rdate' ";
        String string4 = "OR Command = '/usr/sbin/rdate'";
        String string5 = string + string2 + string3 + string4;
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_ScheduledJob_Cron");
        cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
        Enumeration enumeration = this.cimomhandle.execQuery(cIMObjectPath2, string5, "WQL");
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            if (cIMInstance == null) continue;
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8612", "LM_8614", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    private void checkProcess(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = "SELECT * FROM Solaris_Process WHERE ExecutingCommand = '/usr/lib/inet/xntpd'";
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_Process");
        cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
        Enumeration enumeration = this.cimomhandle.execQuery(cIMObjectPath2, string, "WQL");
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            if (cIMInstance == null) continue;
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8612", "LM_8613", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }
}

