/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.util.HashMap;
import sun.rmi.runtime.Executor;

class TimedMap {
    private Executor executor;
    private long timeout;
    private HashMap map = new HashMap();
    private Queue evictQueue = new Queue();
    private boolean evictorActive = false;

    TimedMap(Executor executor, long l) {
        if (executor == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.executor = executor;
        this.timeout = l;
    }

    synchronized Object put(Object object, Object object2) {
        if (!this.evictorActive) {
            this.executor.execute((Runnable)new Evictor(), "TimedMap evictor");
            this.evictorActive = true;
        }
        long l = System.currentTimeMillis();
        Mapping mapping = new Mapping(object, object2, l + this.timeout);
        this.evictQueue.append(mapping);
        mapping = this.map.put(object, mapping);
        if (mapping == null) {
            return null;
        }
        this.evictQueue.remove(mapping);
        return mapping.value;
    }

    synchronized Object get(Object object) {
        Mapping mapping = (Mapping)this.map.get(object);
        if (mapping == null) {
            return null;
        }
        this.evictQueue.remove(mapping);
        mapping.expiry = System.currentTimeMillis() + this.timeout;
        this.evictQueue.append(mapping);
        return mapping.value;
    }

    synchronized Object remove(Object object) {
        Mapping mapping = (Mapping)this.map.remove(object);
        if (mapping == null) {
            return null;
        }
        this.evictQueue.remove(mapping);
        return mapping.value;
    }

    void evicted(Object object, Object object2) {
    }

    private static final class Queue {
        private Node head = new Node();
        private Node tail = new Node();

        Queue() {
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        Node getHead() {
            return this.head.next != this.tail ? this.head.next : null;
        }

        void remove(Node node) {
            if (node.owner != this) {
                throw new IllegalArgumentException();
            }
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = (node.next = null);
            node.owner = null;
        }

        void append(Node node) {
            if (node.owner != null) {
                throw new IllegalArgumentException();
            }
            node.owner = this;
            node.prev = this.tail.prev;
            node.next = this.tail;
            this.tail.prev.next = node;
            this.tail.prev = node;
        }

        static class Node {
            private Queue owner;
            private Node prev;
            private Node next;

            Node() {
            }
        }
    }

    private final class Evictor
    implements Runnable {
        private Evictor() {
        }

        public void run() {
            Mapping mapping;
            while ((mapping = this.nextEvicted()) != null) {
                TimedMap.this.evicted(mapping.key, mapping.value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Mapping nextEvicted() {
            TimedMap timedMap = TimedMap.this;
            synchronized (timedMap) {
                Mapping mapping;
                while ((mapping = (Mapping)TimedMap.this.evictQueue.getHead()) != null) {
                    long l = System.currentTimeMillis();
                    if (mapping.expiry <= l) {
                        TimedMap.this.evictQueue.remove(mapping);
                        TimedMap.this.map.remove(mapping.key);
                        return mapping;
                    }
                    try {
                        TimedMap.this.wait(mapping.expiry - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                TimedMap.this.evictorActive = false;
                return null;
            }
        }
    }

    private static final class Mapping
    extends Queue.Node {
        Object key;
        Object value;
        long expiry;

        Mapping(Object object, Object object2, long l) {
            this.key = object;
            this.value = object2;
            this.expiry = l;
        }
    }
}

