/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.CIMVersion;
import javax.wbem.client.BatchCIMClient;
import javax.wbem.client.BatchHandle;
import javax.wbem.client.BatchResult;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMClientFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.ClientSecurityFactory;
import javax.wbem.security.SunDigestClientSecurity;

public class CIMClient
implements CIMOMHandle {
    private String version;
    private CIMClientAPI api;
    private CIMNameSpace nameSpace;
    private CIMNameSpace hostNameSpace;
    protected Hashtable subIdListenerMap;
    private InetAddress host;
    private ClientSecurityContext csc = null;
    private static String protocol;
    private ThreadLocal tl = new ThreadLocal();
    private static final int DEBUG_OFF = 0;
    private boolean listenerset = false;
    public static final String WQL = "WQL";
    public static final String CIM_XML = "cim-xml";
    public static final String CIM_RMI = "cim-rmi";
    private boolean AUTHENTICATE = true;
    private ClientListener clientListener = new ClientListener();

    private CIMObjectPath combineObjectPath(CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) {
        String string;
        if (cIMObjectPath == null) {
            cIMObjectPath = new CIMObjectPath();
        }
        if ((string = cIMNameSpace.getNameSpace()) == null || string.length() == 0) {
            return cIMObjectPath;
        }
        String string2 = cIMObjectPath.getNameSpace();
        if (string2 == null) {
            return cIMObjectPath;
        }
        if (string2.charAt(0) == '\\') {
            return cIMObjectPath;
        }
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
        cIMObjectPath2.setNameSpace(string + "\\" + cIMObjectPath.getNameSpace());
        cIMObjectPath2.setObjectName(cIMObjectPath.getObjectName());
        cIMObjectPath2.setKeys(cIMObjectPath.getKeys());
        return cIMObjectPath2;
    }

    public CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws CIMException {
        this(cIMNameSpace, principal, object, null, 0);
    }

    public CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object, String string) throws CIMException {
        this(cIMNameSpace, principal, object, string, 0);
    }

    CIMClient(CIMNameSpace cIMNameSpace, Principal principal, Object object, String string, int n) throws CIMException {
        this.initTrace();
        this.setProtocol(string);
        this.version = CIMVersion.major + "";
        if (cIMNameSpace == null) {
            cIMNameSpace = new CIMNameSpace();
        }
        if (principal == null) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        String string2 = principal.getName();
        if (string2 == null || string2.trim().length() == 0) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        if (object == null) {
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        cIMNameSpace.setNameSpace("\\" + cIMNameSpace.getNameSpace());
        this.nameSpace = cIMNameSpace;
        if (this.nameSpace.getHostURL() != null) {
            this.hostNameSpace = new CIMNameSpace(this.nameSpace.getHostURL().toString());
            this.hostNameSpace.setNameSpace("\\");
        } else {
            this.hostNameSpace = new CIMNameSpace(this.nameSpace.getHost());
            this.hostNameSpace.setNameSpace("\\");
        }
        this.api = CIMClientFactory.getClientAPI(this.version, this.nameSpace, this.getProtocol(), n, this.clientListener);
        this.setProtocol(this.api.getProtocol());
        this.csc = ClientSecurityFactory.createClientSecurity(this.nameSpace, principal, object, null, this.getProtocol());
        this.api.initSecurityContext(this.version, this.csc);
    }

    public synchronized void createNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        this.api.createNameSpace(this.version, this.nameSpace, cIMNameSpace);
    }

    public synchronized void close() throws CIMException {
        String[] stringArray = new String[]{this.version, "close"};
        this.api.close(this.version);
    }

    public synchronized void deleteNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        this.api.deleteNameSpace(this.version, this.nameSpace, cIMNameSpace);
    }

    public synchronized void deleteClass(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteClass(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteInstance(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized void deleteQualifierType(CIMObjectPath cIMObjectPath) throws CIMException {
        this.api.deleteQualifierType(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumNameSpace(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.enumerateClasses(cIMObjectPath, false, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.enumerateClasses(cIMObjectPath, bl, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        return this.enumerateClasses(cIMObjectPath, bl, bl2, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        return this.enumerateClasses(cIMObjectPath, bl, bl2, bl3, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException {
        Vector vector = this.api.enumerateClasses(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, bl4);
        return vector.elements();
    }

    public Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.enumerateClassNames(cIMObjectPath, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Vector vector = this.api.enumerateClassNames(this.version, this.nameSpace, cIMObjectPath, bl);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath cIMObjectPath) throws CIMException {
        Vector vector = this.api.enumerateInstanceNames(this.version, this.nameSpace, cIMObjectPath);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.enumerateInstances(cIMObjectPath, true, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.enumerateInstances(cIMObjectPath, bl, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        return this.enumerateInstances(cIMObjectPath, bl, bl2, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        return this.enumerateInstances(cIMObjectPath, bl, bl2, bl3, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException {
        return this.enumerateInstances(cIMObjectPath, bl, bl2, bl3, bl4, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException {
        Vector vector = this.api.enumerateInstances(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, bl4, stringArray);
        return vector.elements();
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath cIMObjectPath) throws CIMException {
        Vector vector = this.api.enumQualifierTypes(this.version, this.nameSpace, cIMObjectPath);
        return vector.elements();
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.getClass(cIMObjectPath, true, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.getClass(cIMObjectPath, bl, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        return this.getClass(cIMObjectPath, bl, bl2, false, null);
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        return this.getClass(cIMObjectPath, bl, bl2, bl3, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        return this.api.getClass(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, stringArray);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.getInstance(cIMObjectPath, true, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        return this.getInstance(cIMObjectPath, bl, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        return this.getInstance(cIMObjectPath, bl, bl2, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3) throws CIMException {
        return this.getInstance(cIMObjectPath, bl, bl2, bl3, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        return this.api.getInstance(this.version, this.nameSpace, cIMObjectPath, bl, bl2, bl3, stringArray);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        return this.api.invokeMethod(this.version, this.nameSpace, cIMObjectPath, string, vector, vector2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) throws CIMException {
        return this.api.invokeMethod(this.version, this.nameSpace, cIMObjectPath, string, cIMArgumentArray, cIMArgumentArray2);
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.api.getQualifierType(this.version, this.nameSpace, cIMObjectPath);
    }

    public synchronized void createQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        this.api.createQualifierType(this.version, this.nameSpace, cIMObjectPath, cIMQualifierType);
    }

    public synchronized void setQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        this.api.setQualifierType(this.version, this.nameSpace, cIMObjectPath, cIMQualifierType);
    }

    public synchronized void createClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.api.createClass(this.version, this.nameSpace, cIMObjectPath, cIMClass);
    }

    public synchronized void setClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.api.setClass(this.version, this.nameSpace, cIMObjectPath, cIMClass);
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2 = this.api.createInstance(this.version, this.nameSpace, cIMObjectPath, cIMInstance);
        if (cIMObjectPath2 == null) {
            return null;
        }
        String string = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
        cIMObjectPath2.setNameSpace(string);
        return cIMObjectPath2;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.api.setInstance(this.version, this.nameSpace, cIMObjectPath, cIMInstance, true, null);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray) throws CIMException {
        this.api.setInstance(this.version, this.nameSpace, cIMObjectPath, cIMInstance, bl, stringArray);
    }

    public synchronized CIMValue getProperty(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        return this.api.getProperty(this.version, this.nameSpace, cIMObjectPath, string);
    }

    public synchronized void setProperty(CIMObjectPath cIMObjectPath, String string, CIMValue cIMValue) throws CIMException {
        this.api.setProperty(this.version, this.nameSpace, cIMObjectPath, string, cIMValue);
    }

    public synchronized void setProperty(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        this.setProperty(cIMObjectPath, string, null);
    }

    public String encryptData(String string) throws CIMException {
        if (string == null) {
            return null;
        }
        SunDigestClientSecurity sunDigestClientSecurity = null;
        try {
            sunDigestClientSecurity = (SunDigestClientSecurity)this.csc;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string2 = sunDigestClientSecurity.trans51Format(string);
        return "<" + string2 + ">";
    }

    public synchronized Enumeration execQuery(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null || string2.length() == 0) {
            string2 = WQL;
        }
        Vector vector = this.api.execQuery(this.version, this.nameSpace, cIMObjectPath, string, string2);
        return vector.elements();
    }

    public Enumeration associators(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.associators(cIMObjectPath, null, null, null, null, true, true, null);
    }

    public Enumeration associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector = this.api.associators(this.version, this.nameSpace, cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray);
        return vector.elements();
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.associatorNames(cIMObjectPath, null, null, null, null);
    }

    public Enumeration associatorNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws CIMException {
        Vector vector = this.api.associatorNames(this.version, this.nameSpace, cIMObjectPath, string, string2, string3, string4);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string5 = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string5);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration references(CIMObjectPath cIMObjectPath, String string, String string2, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector vector = this.api.references(this.version, this.nameSpace, cIMObjectPath, string, string2, bl, bl2, stringArray);
        return vector.elements();
    }

    public Enumeration references(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.references(cIMObjectPath, null, null, true, true, null);
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        Vector vector = this.api.referenceNames(this.version, this.nameSpace, cIMObjectPath, string, string2);
        Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            String string3 = CIMClient.stripNS(cIMObjectPath2.getNameSpace(), this.nameSpace.getNameSpace());
            cIMObjectPath2.setNameSpace(string3);
            vector2.addElement(cIMObjectPath2);
            ++n;
        }
        return vector2.elements();
    }

    public Enumeration referenceNames(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.referenceNames(cIMObjectPath, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMListener(CIMListener cIMListener) throws CIMException {
        if (protocol != null && !this.listenerset) {
            CIMClient cIMClient = this;
            synchronized (cIMClient) {
                if (!this.listenerset) {
                    this.api.setListener(this.version);
                    this.listenerset = true;
                }
            }
        }
        this.clientListener.addCIMListener(cIMListener);
    }

    public void removeCIMListener(CIMListener cIMListener) throws CIMException {
        this.clientListener.removeCIMListener(cIMListener);
    }

    public CIMInstance getIndicationHandler(CIMListener cIMListener) throws CIMException {
        return this.api.getIndicationHandler(cIMListener);
    }

    protected void finalize() {
    }

    private void initTrace() {
        String string = System.getProperty("wbem.debug.level");
        String string2 = System.getProperty("wbem.debug.device");
        if (string2 != null && string2.equalsIgnoreCase("file")) {
            string2 = "wbem_client";
        }
        Debug.traceOpen(string, string2);
        Debug.trace1("Starting CIMClient version 2.5.0 01/26/04:17:16");
    }

    private String getProtocol() {
        return protocol;
    }

    private void setProtocol(String string) {
        protocol = string;
    }

    static String stripNS(String string, String string2) {
        if ((string = string.toLowerCase()).startsWith(string2 = string2.toLowerCase())) {
            String string3 = string.substring(string2.length());
            if (string3.startsWith("\\")) {
                return string3.substring(1);
            }
            return string3;
        }
        return string;
    }

    public BatchResult performBatchOperations(BatchHandle batchHandle) throws CIMException {
        CIMOperation[] cIMOperationArray = null;
        try {
            cIMOperationArray = ((BatchCIMClient)batchHandle).getOperationList();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)exception);
        }
        if (cIMOperationArray != null && cIMOperationArray.length > 0) {
            int n = 0;
            while (n < cIMOperationArray.length) {
                cIMOperationArray[n].setNameSpace(this.getNameSpace());
                ++n;
            }
            Vector vector = this.api.performOperations(this.version, cIMOperationArray);
            if (vector == null || cIMOperationArray.length != vector.size()) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            Object[] objectArray = new Object[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                cIMOperationArray[n2].setResult(vector.elementAt(n2));
                objectArray[n2] = cIMOperationArray[n2].getResult();
                ++n2;
            }
            BatchResult batchResult = new BatchResult(objectArray);
            return batchResult;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    protected CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    private class ClientListener
    implements CIMListener {
        private List listenerList = new ArrayList();

        private ClientListener() {
        }

        public void addCIMListener(CIMListener cIMListener) {
            if (cIMListener == null) {
                return;
            }
            if (!this.listenerList.contains(cIMListener)) {
                this.listenerList.add(cIMListener);
            }
        }

        public void removeCIMListener(CIMListener cIMListener) {
            this.listenerList.remove(cIMListener);
        }

        public void indicationOccured(CIMEvent cIMEvent) {
            new IndicationDeliverer(cIMEvent).start();
        }

        private class IndicationDeliverer
        extends Thread {
            CIMEvent e;

            IndicationDeliverer(CIMEvent cIMEvent) {
                this.e = cIMEvent;
            }

            public void run() {
                ArrayList arrayList = new ArrayList(ClientListener.this.listenerList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    CIMListener cIMListener = (CIMListener)iterator.next();
                    cIMListener.indicationOccured(this.e);
                }
            }
        }
    }
}

